/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.initializations;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import nl.strohalm.cyclos.entities.customization.documents.Document;
import nl.strohalm.cyclos.entities.customization.documents.DocumentPage;
import nl.strohalm.cyclos.entities.customization.documents.DocumentQuery;
import nl.strohalm.cyclos.entities.customization.documents.DynamicDocument;
import nl.strohalm.cyclos.initializations.LocalInitialization;
import nl.strohalm.cyclos.services.customization.DocumentServiceLocal;
import nl.strohalm.cyclos.utils.CustomizationHelper;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DocumentInitialization
implements LocalInitialization {
    private static final Log LOG = LogFactory.getLog(DocumentInitialization.class);
    private DocumentServiceLocal documentService;
    private CustomizationHelper customizationHelper;

    @Override
    public String getName() {
        return "Documents";
    }

    @Override
    public void initialize() {
        DocumentQuery documentQuery = new DocumentQuery();
        documentQuery.setNatures(Collections.singleton(Document.Nature.DYNAMIC));
        documentQuery.fetch(DynamicDocument.Relationships.FORM_PAGE, DynamicDocument.Relationships.DOCUMENT_PAGE);
        List<Document> documents = this.documentService.search(documentQuery);
        for (Document document : documents) {
            DynamicDocument dynamicDocument = (DynamicDocument)document;
            if (dynamicDocument.isHasFormPage()) {
                File formFile = this.customizationHelper.formFile(dynamicDocument);
                DocumentPage formPage = dynamicDocument.getFormPage();
                try {
                    FileUtils.writeStringToFile((File)formFile, (String)formPage.getContents());
                }
                catch (IOException e) {
                    LOG.warn((Object)("Error handling document form file: " + formFile.getAbsolutePath()), (Throwable)e);
                }
            }
            File documentFile = this.customizationHelper.documentFile(dynamicDocument);
            DocumentPage documentPage = dynamicDocument.getDocumentPage();
            try {
                FileUtils.writeStringToFile((File)documentFile, (String)documentPage.getContents());
            }
            catch (IOException e) {
                LOG.warn((Object)("Error handling document page file: " + documentFile.getAbsolutePath()), (Throwable)e);
            }
        }
    }

    public void setCustomizationHelper(CustomizationHelper customizationHelper) {
        this.customizationHelper = customizationHelper;
    }

    public void setDocumentServiceLocal(DocumentServiceLocal documentService) {
        this.documentService = documentService;
    }
}

