/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.initializations;

import java.util.ArrayList;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.customization.images.Image;
import nl.strohalm.cyclos.initializations.LocalWebInitialization;
import nl.strohalm.cyclos.services.customization.ImageService;
import nl.strohalm.cyclos.utils.WebImageHelper;

public class ImageInitialization
implements LocalWebInitialization {
    private ImageService imageService;
    private WebImageHelper webImageHelper;

    @Override
    public String getName() {
        return "Images";
    }

    @Override
    public void initialize() {
        this.updateImages();
    }

    public void setImageService(ImageService imageService) {
        this.imageService = imageService;
    }

    public void setWebImageHelper(WebImageHelper webImageHelper) {
        this.webImageHelper = webImageHelper;
    }

    private void updateImages() {
        ArrayList<? extends Image> images = new ArrayList<Image>();
        images.addAll(this.imageService.listByNature(Image.Nature.SYSTEM));
        images.addAll(this.imageService.listByNature(Image.Nature.CUSTOM));
        images.addAll(this.imageService.listByNature(Image.Nature.STYLE));
        for (Image image : images) {
            this.webImageHelper.update(this.imageService.reload(image.getId(), new Relationship[0]));
        }
    }
}

