/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.scheduling;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.TimeZone;
import nl.strohalm.cyclos.entities.settings.LocalSettings;
import nl.strohalm.cyclos.scheduling.SchedulingHandler;
import nl.strohalm.cyclos.scheduling.tasks.ScheduledTask;

public class HourlyScheduledTasks
extends Thread {
    private static final DateFormat HOUR_FORMAT = new SimpleDateFormat("yyyy-MM-dd.HH");
    private final SchedulingHandler handler;
    private final Calendar time;

    public HourlyScheduledTasks(SchedulingHandler handler, Calendar time) {
        String applicationName = handler.getSettingsServiceLocal().getLocalSettings().getApplicationName();
        String hour = HOUR_FORMAT.format(time.getTime());
        this.setName(String.format("%s scheduled task runner for %s", applicationName, hour));
        this.handler = handler;
        this.time = time;
    }

    @Override
    public void run() {
        long initialTime = System.currentTimeMillis();
        Collection<String> tasks = this.getTasksToRun();
        this.handler.getTaskRunner().runScheduledTasks(this.time, tasks);
        this.handler.getLoggingHandler().logSchedulingTrace(this.time, System.currentTimeMillis() - initialTime);
        this.handler.runNextTasks();
    }

    private Collection<String> getTasksToRun() {
        boolean runDailyTasks = this.shouldRunDailyTasks();
        ArrayList<String> tasks = new ArrayList<String>();
        for (ScheduledTask task : this.handler.getTasks()) {
            boolean runTask = task.isEveryHour() || runDailyTasks;
            if (!runTask) continue;
            tasks.add(task.getName());
        }
        return tasks;
    }

    private boolean shouldRunDailyTasks() {
        LocalSettings localSettings = this.handler.getSettingsServiceLocal().getLocalSettings();
        TimeZone timeZone = localSettings.getTimeZone();
        SimpleDateFormat format = new SimpleDateFormat("HH");
        if (timeZone != null) {
            format.setTimeZone(timeZone);
        }
        boolean runExtraTasks = localSettings.getSchedulingHour() == Integer.parseInt(format.format(this.time.getTime()));
        return runExtraTasks;
    }
}

