/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.scheduling;

import java.util.List;
import nl.strohalm.cyclos.scheduling.polling.PollingTask;
import org.springframework.beans.factory.DisposableBean;

public class PollingTasksHandler
implements DisposableBean {
    private List<PollingTask> pollingTasks;

    public void destroy() throws Exception {
        if (this.pollingTasks != null) {
            for (PollingTask task : this.pollingTasks) {
                task.interrupt();
            }
        }
    }

    public <PT extends PollingTask> PT get(Class<PT> type) {
        for (PollingTask pt : this.pollingTasks) {
            if (!type.isInstance(pt)) continue;
            return (PT)pt;
        }
        return null;
    }

    public List<PollingTask> getPollingTasks() {
        return this.pollingTasks;
    }

    public void setPollingTasks(List<PollingTask> pollingTasks) {
        this.pollingTasks = pollingTasks;
    }

    public void start() {
        if (this.pollingTasks != null) {
            for (PollingTask task : this.pollingTasks) {
                task.start();
            }
        }
    }
}

