/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.scheduling;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentLinkedQueue;
import nl.strohalm.cyclos.entities.settings.LocalSettings;
import nl.strohalm.cyclos.entities.settings.events.LocalSettingsChangeListener;
import nl.strohalm.cyclos.entities.settings.events.LocalSettingsEvent;
import nl.strohalm.cyclos.scheduling.HourlyScheduledTasks;
import nl.strohalm.cyclos.scheduling.tasks.ScheduledTask;
import nl.strohalm.cyclos.services.settings.SettingsServiceLocal;
import nl.strohalm.cyclos.utils.logging.LoggingHandler;
import nl.strohalm.cyclos.utils.lucene.IndexHandler;
import nl.strohalm.cyclos.utils.tasks.TaskRunner;
import org.apache.commons.lang.time.DateUtils;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.transaction.support.TransactionTemplate;

public class SchedulingHandler
implements InitializingBean,
DisposableBean,
LocalSettingsChangeListener {
    private Timer timer;
    private SettingsServiceLocal settingsService;
    private LoggingHandler loggingHandler;
    private TransactionTemplate transactionTemplate;
    private IndexHandler indexHandler;
    private TaskRunner taskRunner;
    private Queue<HourlyScheduledTasks> queue;
    private Map<String, ScheduledTask> tasks;
    private Integer lastScheduledMinute;

    public void afterPropertiesSet() throws Exception {
        this.queue = new ConcurrentLinkedQueue<HourlyScheduledTasks>();
        this.settingsService.addListener(this);
    }

    public void destroy() throws Exception {
        this.shutdown();
        if (this.queue != null) {
            this.queue.clear();
            this.queue = null;
        }
    }

    public IndexHandler getIndexHandler() {
        return this.indexHandler;
    }

    public LoggingHandler getLoggingHandler() {
        return this.loggingHandler;
    }

    public SettingsServiceLocal getSettingsServiceLocal() {
        return this.settingsService;
    }

    public ScheduledTask getTask(String name) {
        return this.tasks.get(name);
    }

    public TaskRunner getTaskRunner() {
        return this.taskRunner;
    }

    public List<ScheduledTask> getTasks() {
        return new ArrayList<ScheduledTask>(this.tasks.values());
    }

    public TransactionTemplate getTransactionTemplate() {
        return this.transactionTemplate;
    }

    @Override
    public void onLocalSettingsUpdate(LocalSettingsEvent event) {
        this.updateTime();
    }

    public void runNextTasks() {
        HourlyScheduledTasks nextToRun = this.queue.poll();
        if (nextToRun != null) {
            nextToRun.start();
        }
    }

    public void setIndexHandler(IndexHandler indexHandler) {
        this.indexHandler = indexHandler;
    }

    public void setLoggingHandler(LoggingHandler loggingHandler) {
        this.loggingHandler = loggingHandler;
    }

    public void setSettingsServiceLocal(SettingsServiceLocal settingsService) {
        this.settingsService = settingsService;
    }

    public void setTaskRunner(TaskRunner taskRunner) {
        this.taskRunner = taskRunner;
    }

    public void setTasks(List<ScheduledTask> tasks) {
        this.tasks = new LinkedHashMap<String, ScheduledTask>(tasks.size());
        for (ScheduledTask task : tasks) {
            ScheduledTask old = this.tasks.put(task.getName(), task);
            if (old == null) continue;
            throw new IllegalStateException("Trying to add 2 tasks with the same name '" + task.getName() + "': " + old + " and " + task);
        }
    }

    public void setTransactionTemplate(TransactionTemplate transactionTemplate) {
        this.transactionTemplate = transactionTemplate;
    }

    public void start() {
        this.initializeTimer();
    }

    public synchronized void updateTime() {
        if (this.timer == null) {
            return;
        }
        LocalSettings localSettings = this.settingsService.getLocalSettings();
        if (this.lastScheduledMinute == null || this.lastScheduledMinute.intValue() != localSettings.getSchedulingMinute()) {
            this.shutdown();
            this.initializeTimer();
        }
    }

    private synchronized void initializeTimer() {
        LocalSettings localSettings = this.settingsService.getLocalSettings();
        this.timer = new Timer("Scheduled tasks handler for " + localSettings.getApplicationName());
        this.timer.scheduleAtFixedRate((TimerTask)new SchedulingTimerTask(), this.startsTaskAt(), 3600000L);
        this.lastScheduledMinute = localSettings.getSchedulingMinute();
    }

    private synchronized void shutdown() {
        if (this.timer != null) {
            this.timer.cancel();
            this.timer = null;
        }
    }

    private Date startsTaskAt() {
        LocalSettings localSettings = this.settingsService.getLocalSettings();
        Calendar startAt = Calendar.getInstance();
        startAt.add(11, 1);
        startAt.set(12, localSettings.getSchedulingMinute());
        startAt.set(13, 30);
        return startAt.getTime();
    }

    private class SchedulingTimerTask
    extends TimerTask {
        private SchedulingTimerTask() {
        }

        @Override
        public void run() {
            Calendar time = DateUtils.truncate((Calendar)Calendar.getInstance(), (int)11);
            HourlyScheduledTasks runner = new HourlyScheduledTasks(SchedulingHandler.this, time);
            if (SchedulingHandler.this.queue.isEmpty()) {
                runner.start();
            } else {
                SchedulingHandler.this.queue.offer(runner);
            }
        }
    }
}

