/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.scheduling.polling;

import nl.strohalm.cyclos.dao.accounts.AccountDAO;
import nl.strohalm.cyclos.entities.accounts.Account;
import nl.strohalm.cyclos.entities.accounts.MemberAccount;
import nl.strohalm.cyclos.entities.alerts.MemberAlert;
import nl.strohalm.cyclos.entities.members.Member;
import nl.strohalm.cyclos.scheduling.polling.PollingTask;
import nl.strohalm.cyclos.services.accounts.MemberAccountHandler;
import nl.strohalm.cyclos.services.alerts.AlertServiceLocal;
import nl.strohalm.cyclos.services.fetch.FetchServiceLocal;
import nl.strohalm.cyclos.utils.TransactionHelper;
import nl.strohalm.cyclos.utils.transaction.CurrentTransactionData;
import nl.strohalm.cyclos.utils.transaction.TransactionRollbackListener;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;

public class AccountActivationPollingTask
extends PollingTask {
    private AccountDAO accountDao;
    private FetchServiceLocal fetchService;
    private MemberAccountHandler memberAccountHandler;
    private AlertServiceLocal alertService;
    private TransactionHelper transactionHelper;

    private void handleFailure(final MemberAccount account) {
        this.transactionHelper.runInCurrentThread(new TransactionCallbackWithoutResult(){

            protected void doInTransactionWithoutResult(TransactionStatus status) {
                MemberAccount fetchedAccount = AccountActivationPollingTask.this.fetchService.fetch(account, MemberAccount.Relationships.MEMBER, Account.Relationships.TYPE);
                Member member = fetchedAccount.getMember();
                AccountActivationPollingTask.this.alertService.create(member, MemberAlert.Alerts.ACCOUNT_ACTIVATION_FAILED, fetchedAccount.getType().getName());
                fetchedAccount.setAction(null);
                AccountActivationPollingTask.this.accountDao.update(fetchedAccount);
            }
        });
    }

    private void performAction(MemberAccount account) {
        MemberAccount.Action action = account.getAction();
        switch (action) {
            case ACTIVATE: {
                this.memberAccountHandler.activate(account);
                break;
            }
            case REMOVE: {
                this.memberAccountHandler.deactivate(account, false);
                break;
            }
            default: {
                throw new IllegalStateException("Only MemberAccount.Action.ACTIVATE and REMOVE allowed");
            }
        }
    }

    @Override
    protected boolean runTask() {
        final MemberAccount account = this.accountDao.getNextPendingProcessing();
        if (account == null) {
            return false;
        }
        CurrentTransactionData.addTransactionRollbackListener(new TransactionRollbackListener(){

            @Override
            public void onTransactionRollback() {
                AccountActivationPollingTask.this.handleFailure(account);
            }
        });
        this.performAction(account);
        return true;
    }

    public void setAccountDao(AccountDAO accountDao) {
        this.accountDao = accountDao;
    }

    public void setAlertServiceLocal(AlertServiceLocal alertService) {
        this.alertService = alertService;
    }

    public void setFetchServiceLocal(FetchServiceLocal fetchService) {
        this.fetchService = fetchService;
    }

    public void setMemberAccountHandler(MemberAccountHandler memberAccountHandler) {
        this.memberAccountHandler = memberAccountHandler;
    }
}

