/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.scheduling.polling;

import java.util.Iterator;
import nl.strohalm.cyclos.dao.members.AdInterestDAO;
import nl.strohalm.cyclos.entities.ads.Ad;
import nl.strohalm.cyclos.entities.members.Member;
import nl.strohalm.cyclos.entities.members.messages.Message;
import nl.strohalm.cyclos.entities.settings.LocalSettings;
import nl.strohalm.cyclos.entities.settings.MessageSettings;
import nl.strohalm.cyclos.scheduling.polling.PollingTask;
import nl.strohalm.cyclos.services.ads.AdServiceLocal;
import nl.strohalm.cyclos.services.elements.MessageServiceLocal;
import nl.strohalm.cyclos.services.elements.SendMessageFromSystemDTO;
import nl.strohalm.cyclos.services.fetch.FetchServiceLocal;
import nl.strohalm.cyclos.services.settings.SettingsServiceLocal;
import nl.strohalm.cyclos.utils.CacheCleaner;
import nl.strohalm.cyclos.utils.DataIteratorHelper;
import nl.strohalm.cyclos.utils.MessageProcessingHelper;
import nl.strohalm.cyclos.utils.TransactionHelper;
import nl.strohalm.cyclos.utils.transaction.CurrentTransactionData;
import nl.strohalm.cyclos.utils.transaction.TransactionRollbackListener;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;

public class AdInterestsNotificationPollingTask
extends PollingTask {
    private FetchServiceLocal fetchService;
    private SettingsServiceLocal settingsService;
    private AdServiceLocal adService;
    private MessageServiceLocal messageService;
    private TransactionHelper transactionHelper;
    private AdInterestDAO adInterestDao;

    public void setAdInterestDao(AdInterestDAO adInterestDao) {
        this.adInterestDao = adInterestDao;
    }

    public void setAdServiceLocal(AdServiceLocal adService) {
        this.adService = adService;
    }

    public void setFetchServiceLocal(FetchServiceLocal fetchService) {
        this.fetchService = fetchService;
    }

    public void setMessageServiceLocal(MessageServiceLocal messageService) {
        this.messageService = messageService;
    }

    public void setSettingsServiceLocal(SettingsServiceLocal settingsService) {
        this.settingsService = settingsService;
    }

    public void setTransactionHelper(TransactionHelper transactionHelper) {
        this.transactionHelper = transactionHelper;
    }

    @Override
    protected boolean runTask() {
        final Ad ad = this.adService.getNextAdToNotify();
        if (ad == null) {
            return false;
        }
        CurrentTransactionData.addTransactionRollbackListener(new TransactionRollbackListener(){

            @Override
            public void onTransactionRollback() {
                AdInterestsNotificationPollingTask.this.transactionHelper.runInCurrentThread(new TransactionCallbackWithoutResult(){

                    protected void doInTransactionWithoutResult(TransactionStatus status) {
                        AdInterestsNotificationPollingTask.this.adService.markMembersNotified(ad);
                    }
                });
            }
        });
        this.notifyMembers(ad);
        this.adService.markMembersNotified(ad);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyMembers(Ad ad) {
        LocalSettings localSettings = this.settingsService.getLocalSettings();
        MessageSettings messageSettings = this.settingsService.getMessageSettings();
        String subject = MessageProcessingHelper.processVariables(messageSettings.getAdInterestSubject(), ad, localSettings);
        String body = MessageProcessingHelper.processVariables(messageSettings.getAdInterestMessage(), ad, localSettings);
        CacheCleaner cacheCleaner = new CacheCleaner(this.fetchService);
        Iterator<Member> iterator = this.adInterestDao.resolveMembersToNotify(ad);
        try {
            while (iterator.hasNext()) {
                Member member = iterator.next();
                SendMessageFromSystemDTO dto = new SendMessageFromSystemDTO();
                dto.setType(Message.Type.AD_INTEREST);
                dto.setToMember(member);
                dto.setSubject(subject);
                dto.setBody(body);
                dto.setEntity(ad);
                this.messageService.sendFromSystem(dto);
                cacheCleaner.clearCache();
            }
        }
        finally {
            DataIteratorHelper.close(iterator);
        }
    }
}

