/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.scheduling.polling;

import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.members.messages.Message;
import nl.strohalm.cyclos.scheduling.polling.PollingTask;
import nl.strohalm.cyclos.services.elements.MessageServiceLocal;
import nl.strohalm.cyclos.utils.TransactionHelper;
import nl.strohalm.cyclos.utils.transaction.CurrentTransactionData;
import nl.strohalm.cyclos.utils.transaction.TransactionRollbackListener;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;

public class BulkMessageSendingPollingTask
extends PollingTask {
    private MessageServiceLocal messageService;
    private TransactionHelper transactionHelper;

    public void setMessageServiceLocal(MessageServiceLocal messageService) {
        this.messageService = messageService;
    }

    public void setTransactionHelper(TransactionHelper transactionHelper) {
        this.transactionHelper = transactionHelper;
    }

    @Override
    protected boolean runTask() {
        final Message message = this.messageService.nextToSend();
        if (message == null) {
            return false;
        }
        CurrentTransactionData.addTransactionRollbackListener(new TransactionRollbackListener(){

            @Override
            public void onTransactionRollback() {
                BulkMessageSendingPollingTask.this.transactionHelper.runInCurrentThread(new TransactionCallbackWithoutResult(){

                    protected void doInTransactionWithoutResult(TransactionStatus arg0) {
                        Message msg = BulkMessageSendingPollingTask.this.messageService.load(message.getId(), new Relationship[0]);
                        msg.setEmailSent(true);
                    }
                });
            }
        });
        this.messageService.sendEmailIfNeeded(message);
        if (CurrentTransactionData.getMailError() != null) {
            return false;
        }
        message.setEmailSent(true);
        return true;
    }
}

