/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.scheduling.polling;

import java.math.BigDecimal;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.accounts.SystemAccountOwner;
import nl.strohalm.cyclos.entities.accounts.fees.account.AccountFee;
import nl.strohalm.cyclos.entities.accounts.fees.account.AccountFeeLog;
import nl.strohalm.cyclos.entities.accounts.fees.account.MemberAccountFeeLog;
import nl.strohalm.cyclos.entities.accounts.transactions.Invoice;
import nl.strohalm.cyclos.entities.accounts.transactions.Transfer;
import nl.strohalm.cyclos.entities.alerts.SystemAlert;
import nl.strohalm.cyclos.entities.members.Member;
import nl.strohalm.cyclos.entities.settings.LocalSettings;
import nl.strohalm.cyclos.scheduling.polling.PollingTask;
import nl.strohalm.cyclos.services.accountfees.AccountFeeServiceLocal;
import nl.strohalm.cyclos.services.alerts.AlertServiceLocal;
import nl.strohalm.cyclos.services.fetch.FetchServiceLocal;
import nl.strohalm.cyclos.services.settings.SettingsServiceLocal;
import nl.strohalm.cyclos.services.transactions.InvoiceServiceLocal;
import nl.strohalm.cyclos.services.transactions.PaymentServiceLocal;
import nl.strohalm.cyclos.services.transactions.TransferDTO;
import nl.strohalm.cyclos.services.transactions.exceptions.NotEnoughCreditsException;
import nl.strohalm.cyclos.utils.Amount;
import nl.strohalm.cyclos.utils.MessageProcessingHelper;
import nl.strohalm.cyclos.utils.Period;
import nl.strohalm.cyclos.utils.TransactionHelper;
import nl.strohalm.cyclos.utils.conversion.AmountConverter;
import nl.strohalm.cyclos.utils.conversion.CalendarConverter;
import nl.strohalm.cyclos.utils.conversion.UnitsConverter;
import nl.strohalm.cyclos.utils.logging.LoggingHandler;
import nl.strohalm.cyclos.utils.transaction.CurrentTransactionData;
import nl.strohalm.cyclos.utils.transaction.TransactionEndListener;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;

public class ChargeAccountFeePollingTask
extends PollingTask {
    private Long logBeingCharged;
    private LoggingHandler loggingHandler;
    private AccountFeeServiceLocal accountFeeService;
    private FetchServiceLocal fetchService;
    private AlertServiceLocal alertService;
    private InvoiceServiceLocal invoiceService;
    private PaymentServiceLocal paymentService;
    private SettingsServiceLocal settingsService;
    private TransactionHelper transactionHelper;

    public void setAccountFeeServiceLocal(AccountFeeServiceLocal accountFeeService) {
        this.accountFeeService = accountFeeService;
    }

    public void setAlertServiceLocal(AlertServiceLocal alertService) {
        this.alertService = alertService;
    }

    public void setFetchServiceLocal(FetchServiceLocal fetchService) {
        this.fetchService = fetchService;
    }

    public void setInvoiceServiceLocal(InvoiceServiceLocal invoiceService) {
        this.invoiceService = invoiceService;
    }

    public void setLoggingHandler(LoggingHandler loggingHandler) {
        this.loggingHandler = loggingHandler;
    }

    public void setPaymentServiceLocal(PaymentServiceLocal paymentService) {
        this.paymentService = paymentService;
    }

    public void setSettingsServiceLocal(SettingsServiceLocal settingsService) {
        this.settingsService = settingsService;
    }

    public void setTransactionHelper(TransactionHelper transactionHelper) {
        this.transactionHelper = transactionHelper;
    }

    @Override
    protected boolean runTask() {
        List<Member> toCharge;
        AccountFeeLog feeLog;
        if (this.logBeingCharged == null) {
            feeLog = this.accountFeeService.nextLogToCharge();
            Long l = this.logBeingCharged = feeLog == null ? null : feeLog.getId();
            if (this.logBeingCharged == null) {
                return false;
            }
            boolean firstTime = this.accountFeeService.prepareCharge(this.getFeeLog());
            if (firstTime) {
                this.alertService.create(SystemAlert.Alerts.ACCOUNT_FEE_RUNNING, feeLog.getAccountFee().getName());
            }
            this.loggingHandler.logAccountFeeStarted(this.getFeeLog());
        }
        if ((toCharge = this.accountFeeService.nextMembersToCharge(feeLog = this.getFeeLog())).isEmpty()) {
            feeLog.setFinishDate(Calendar.getInstance());
            feeLog.setRechargingFailed(false);
            this.accountFeeService.save(feeLog);
            this.loggingHandler.logAccountFeeFinished(feeLog);
            int errors = feeLog.getFailedMembers();
            if (errors == 0) {
                this.alertService.create(SystemAlert.Alerts.ACCOUNT_FEE_FINISHED, feeLog.getAccountFee().getName());
            } else {
                this.alertService.create(SystemAlert.Alerts.ACCOUNT_FEE_FINISHED_WITH_ERRORS, feeLog.getAccountFee().getName(), errors);
            }
            this.logBeingCharged = null;
        } else {
            this.charge(feeLog, toCharge);
        }
        return true;
    }

    private void charge(AccountFeeLog feeLog, List<Member> toCharge) {
        for (final Member member : toCharge) {
            BigDecimal amount = null;
            try {
                amount = this.accountFeeService.calculateAmount(feeLog, member);
                if (amount == null) {
                    this.accountFeeService.removeFromPending(feeLog, member);
                    feeLog.setTotalMembers(feeLog.getTotalMembers() - 1);
                    continue;
                }
                this.doCharge(feeLog, amount, member);
            }
            catch (Exception e) {
                final BigDecimal theAmount = amount;
                CurrentTransactionData.addTransactionEndListener(new TransactionEndListener(){

                    @Override
                    protected void onTransactionEnd(boolean commit) {
                        ChargeAccountFeePollingTask.this.transactionHelper.runInCurrentThread(new TransactionCallbackWithoutResult(){

                            protected void doInTransactionWithoutResult(TransactionStatus status) {
                                AccountFeeLog feeLog = ChargeAccountFeePollingTask.this.getFeeLog();
                                if (!feeLog.isRechargingFailed()) {
                                    feeLog.setFailedMembers(feeLog.getFailedMembers() + 1);
                                }
                                ChargeAccountFeePollingTask.this.accountFeeService.setChargingError(feeLog, member, theAmount);
                            }
                        });
                    }
                });
                return;
            }
        }
    }

    private MemberAccountFeeLog doCharge(AccountFeeLog feeLog, BigDecimal amount, Member member) {
        Transfer transfer = null;
        Invoice invoice = null;
        if (amount.compareTo(BigDecimal.ZERO) > 0) {
            AccountFee fee = feeLog.getAccountFee();
            if (fee.getPaymentDirection() == AccountFee.PaymentDirection.TO_SYSTEM) {
                if (fee.getInvoiceMode() == AccountFee.InvoiceMode.ALWAYS) {
                    invoice = this.sendInvoice(fee, feeLog, member, amount);
                } else {
                    try {
                        transfer = this.insertTransfer(fee, feeLog, member, amount);
                    }
                    catch (NotEnoughCreditsException e) {
                        invoice = this.sendInvoice(fee, feeLog, member, amount);
                    }
                }
            } else {
                transfer = this.insertTransfer(fee, feeLog, member, amount);
            }
        }
        MemberAccountFeeLog result = this.accountFeeService.setChargingSuccess(feeLog, member, amount, transfer, invoice);
        if (feeLog.isRechargingFailed()) {
            feeLog.setFailedMembers(feeLog.getFailedMembers() - 1);
        }
        return result;
    }

    private AccountFeeLog getFeeLog() {
        return this.accountFeeService.loadLog(this.logBeingCharged, new Relationship[0]);
    }

    private String getPaymentDescription(AccountFee fee, AccountFeeLog feeLog, Member member, BigDecimal amount) {
        LocalSettings localSettings = this.settingsService.getLocalSettings();
        AmountConverter amountConverter = localSettings.getAmountConverter();
        UnitsConverter unitsConverter = localSettings.getUnitsConverter(fee.getAccountType().getCurrency().getPattern());
        CalendarConverter dateConverter = localSettings.getRawDateConverter();
        HashMap<String, String> values = new HashMap<String, String>();
        Amount amountValue = feeLog.getAmountValue();
        if (amountValue.getType() == Amount.Type.PERCENTAGE) {
            values.put("fee_amount", amountConverter.toString(amountValue));
        } else {
            values.put("fee_amount", unitsConverter.toString(amountValue.getValue()));
        }
        values.put("free_base", unitsConverter.toString(fee.getFreeBase()));
        values.put("result", unitsConverter.toString(amount));
        Period period = feeLog.getPeriod();
        values.put("begin_date", dateConverter.toString(period == null ? null : period.getBegin()));
        values.put("end_date", dateConverter.toString(period == null ? null : period.getEnd()));
        fee = this.fetchService.fetch(fee, AccountFee.Relationships.TRANSFER_TYPE);
        return MessageProcessingHelper.processVariables(fee.getTransferType().getDescription(), values);
    }

    private Transfer insertTransfer(AccountFee fee, AccountFeeLog feeLog, Member member, BigDecimal amount) {
        TransferDTO dto = new TransferDTO();
        dto.setAutomatic(true);
        if (fee.getPaymentDirection() == AccountFee.PaymentDirection.TO_SYSTEM) {
            dto.setFromOwner(member);
            dto.setToOwner(SystemAccountOwner.instance());
            dto.setForced(fee.getChargeMode().isVolume() || fee.getInvoiceMode() == AccountFee.InvoiceMode.NEVER);
        } else {
            dto.setFromOwner(SystemAccountOwner.instance());
            dto.setToOwner(member);
        }
        dto.setAmount(amount);
        dto.setTransferType(fee.getTransferType());
        dto.setDescription(this.getPaymentDescription(fee, feeLog, member, amount));
        dto.setAccountFeeLog(feeLog);
        Transfer transfer = (Transfer)this.paymentService.insertWithNotification(dto);
        this.loggingHandler.logAccountFeePayment(transfer);
        return transfer;
    }

    private Invoice sendInvoice(AccountFee fee, AccountFeeLog feeLog, Member member, BigDecimal amount) {
        Invoice invoice = new Invoice();
        invoice.setFromMember(null);
        invoice.setFrom(SystemAccountOwner.instance());
        invoice.setTo(member);
        invoice.setAmount(amount);
        invoice.setTransferType(fee.getTransferType());
        invoice.setDescription(this.getPaymentDescription(fee, feeLog, member, amount));
        invoice.setAccountFeeLog(feeLog);
        invoice = this.invoiceService.sendAutomatically(invoice);
        this.loggingHandler.logAccountFeeInvoice(invoice);
        return invoice;
    }
}

