/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.scheduling.polling;

import java.util.Random;
import java.util.concurrent.Callable;
import nl.strohalm.cyclos.utils.tasks.TaskRunner;

public abstract class PollingTask
extends Thread {
    private int sleepSeconds;
    private String key;
    private TaskRunner taskRunner;

    public PollingTask() {
        this.setSleepSeconds(10);
        this.setKey(this.getClass().getSimpleName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void awake() {
        PollingTask pollingTask = this;
        synchronized (pollingTask) {
            this.notify();
        }
    }

    public String getKey() {
        return this.key;
    }

    public int getSleepSeconds() {
        return this.sleepSeconds;
    }

    public TaskRunner getTaskRunner() {
        return this.taskRunner;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void run() {
        try {
            int initialSleepSeconds = new Random().nextInt(this.sleepSeconds);
            Thread.sleep(initialSleepSeconds * 1000);
        }
        catch (InterruptedException e) {
            return;
        }
        while (true) {
            boolean runImmediately;
            if (runImmediately = this.taskRunner.runPollingTask(this.getKey(), new Callable<Boolean>(){

                @Override
                public Boolean call() throws Exception {
                    return PollingTask.this.runTask();
                }
            })) {
                continue;
            }
            PollingTask pollingTask = this;
            synchronized (pollingTask) {
                try {
                    this.wait(this.sleepSeconds * 1000);
                }
                catch (InterruptedException e) {
                    return;
                }
            }
        }
    }

    public void setKey(String key) {
        this.key = key;
        this.setName("Polling task: " + key);
    }

    public void setSleepSeconds(int sleepSeconds) {
        this.sleepSeconds = sleepSeconds;
    }

    public void setTaskRunner(TaskRunner taskRunner) {
        this.taskRunner = taskRunner;
    }

    protected abstract boolean runTask();
}

