/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.scheduling.polling;

import nl.strohalm.cyclos.entities.members.Member;
import nl.strohalm.cyclos.entities.sms.SmsMailing;
import nl.strohalm.cyclos.scheduling.polling.PollingTask;
import nl.strohalm.cyclos.services.elements.MessageServiceLocal;
import nl.strohalm.cyclos.services.elements.SendSmsDTO;
import nl.strohalm.cyclos.services.sms.SmsMailingServiceLocal;
import nl.strohalm.cyclos.utils.TransactionHelper;
import nl.strohalm.cyclos.utils.transaction.CurrentTransactionData;
import nl.strohalm.cyclos.utils.transaction.TransactionEndListener;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;

public class SmsMailingSendingPollingTask
extends PollingTask {
    private SmsMailingServiceLocal smsMailingService;
    private MessageServiceLocal messageService;
    private TransactionHelper transactionHelper;

    public void setMessageServiceLocal(MessageServiceLocal messageService) {
        this.messageService = messageService;
    }

    public void setSmsMailingServiceLocal(SmsMailingServiceLocal smsMailingService) {
        this.smsMailingService = smsMailingService;
    }

    public void setTransactionHelper(TransactionHelper transactionHelper) {
        this.transactionHelper = transactionHelper;
    }

    @Override
    protected boolean runTask() {
        final SmsMailing smsMailing = this.smsMailingService.nextToSend();
        if (smsMailing == null) {
            return false;
        }
        final Member member = this.smsMailingService.nextMemberToSend(smsMailing);
        if (member == null) {
            smsMailing.setFinished(true);
            return true;
        }
        CurrentTransactionData.addTransactionEndListener(new TransactionEndListener(){

            @Override
            protected void onTransactionEnd(boolean commit) {
                SmsMailingSendingPollingTask.this.transactionHelper.runInCurrentThread(new TransactionCallbackWithoutResult(){

                    protected void doInTransactionWithoutResult(TransactionStatus status) {
                        SmsMailingSendingPollingTask.this.smsMailingService.removeMemberFromPending(smsMailing, member);
                    }
                });
            }
        });
        SendSmsDTO sms = new SendSmsDTO();
        sms.setTargetMember(member);
        if (!smsMailing.isFree()) {
            sms.setChargedMember(member);
        }
        sms.setSmsMailing(smsMailing);
        sms.setText(smsMailing.getText());
        this.messageService.sendSms(sms);
        return true;
    }
}

