/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.scheduling.tasks;

import java.util.Calendar;
import nl.strohalm.cyclos.scheduling.tasks.ScheduledTask;
import nl.strohalm.cyclos.utils.logging.LoggingHandler;

public abstract class BaseScheduledTask
implements ScheduledTask {
    private final String name;
    private final boolean everyHour;
    private final boolean shouldRunInTransaction;
    private LoggingHandler loggingHandler;

    public BaseScheduledTask(String name, boolean everyHour) {
        this(name, everyHour, true);
    }

    public BaseScheduledTask(String name, boolean everyHour, boolean shouldRunInTransaction) {
        this.name = name;
        this.everyHour = everyHour;
        this.shouldRunInTransaction = shouldRunInTransaction;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isEveryHour() {
        return this.everyHour;
    }

    @Override
    public void run(Calendar time) {
        try {
            long start = System.currentTimeMillis();
            this.doRun(time);
            this.loggingHandler.logScheduledTaskTrace(this.getName(), time, System.currentTimeMillis() - start);
        }
        catch (Exception e) {
            this.loggingHandler.logScheduledTaskError(this.getName(), time, e);
        }
    }

    public void setLoggingHandler(LoggingHandler loggingHandler) {
        this.loggingHandler = loggingHandler;
    }

    @Override
    public boolean shouldRunInTransaction() {
        return this.shouldRunInTransaction;
    }

    protected abstract void doRun(Calendar var1);
}

