/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.services;

import java.io.Serializable;
import java.util.Arrays;
import java.util.HashSet;
import nl.strohalm.cyclos.access.Permission;
import nl.strohalm.cyclos.entities.Entity;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.exceptions.EntityNotFoundException;
import nl.strohalm.cyclos.exceptions.PermissionDeniedException;
import nl.strohalm.cyclos.services.ServiceSecurity;
import nl.strohalm.cyclos.services.fetch.FetchServiceLocal;
import nl.strohalm.cyclos.services.permissions.PermissionServiceLocal;
import nl.strohalm.cyclos.utils.access.LoggedUser;
import org.hibernate.ObjectNotFoundException;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.springframework.orm.hibernate3.SessionFactoryUtils;

public abstract class BaseServiceSecurity
implements ServiceSecurity {
    protected PermissionServiceLocal permissionService;
    protected FetchServiceLocal fetchService;
    private SessionFactory sessionFactory;

    public void setFetchServiceLocal(FetchServiceLocal fetchService) {
        this.fetchService = fetchService;
    }

    public final void setPermissionServiceLocal(PermissionServiceLocal permissionService) {
        this.permissionService = permissionService;
    }

    public final void setSessionFactory(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    protected Relationship[] addToFetch(Relationship[] fetch, Relationship ... toAdd) {
        HashSet<Relationship> relationships = new HashSet<Relationship>(Arrays.asList(fetch));
        relationships.addAll(Arrays.asList(toAdd));
        Relationship[] newFetch = relationships.toArray(new Relationship[relationships.size()]);
        return newFetch;
    }

    protected void checkHasUser() {
        if (!LoggedUser.hasUser()) {
            throw new PermissionDeniedException();
        }
    }

    protected void checkIsSystem() {
        if (!LoggedUser.isSystem()) {
            throw new PermissionDeniedException();
        }
    }

    protected PermissionServiceLocal getPermissionServiceLocal() {
        return this.permissionService;
    }

    protected Session getSession() {
        return SessionFactoryUtils.getSession((SessionFactory)this.sessionFactory, (boolean)true);
    }

    protected SessionFactory getSessionFactory() {
        return this.sessionFactory;
    }

    protected boolean hasPermission(Permission ... permissions) {
        return this.permissionService.hasPermission(permissions);
    }

    protected boolean hasPermissionFor(Permission permission, Entity ... required) {
        return this.permissionService.hasPermissionFor(permission, required);
    }

    protected <T extends Entity> T load(Class<T> type, Long id) {
        try {
            return (T)((Entity)this.getSession().load(type, (Serializable)id));
        }
        catch (ObjectNotFoundException e) {
            throw new EntityNotFoundException(type, id);
        }
    }
}

