/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.services.access;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import nl.strohalm.cyclos.access.AdminPermission;
import nl.strohalm.cyclos.access.BasicPermission;
import nl.strohalm.cyclos.access.BrokerPermission;
import nl.strohalm.cyclos.access.MemberPermission;
import nl.strohalm.cyclos.access.ModuleType;
import nl.strohalm.cyclos.access.OperatorPermission;
import nl.strohalm.cyclos.access.Permission;
import nl.strohalm.cyclos.access.PermissionCheck;
import nl.strohalm.cyclos.entities.Entity;
import nl.strohalm.cyclos.entities.groups.Group;
import nl.strohalm.cyclos.exceptions.PermissionDeniedException;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractPermissionCheck
implements PermissionCheck {
    private static final Log LOG = LogFactory.getLog(AbstractPermissionCheck.class);
    private static boolean trace = Boolean.getBoolean("cyclos.tracePermissionChecks");
    protected Map<Permission, RequiredValuesBean> requiredValuesMap;
    protected AdminPermission[] adminPermissions;
    protected BrokerPermission[] brokerPermissions;
    protected MemberPermission[] memberPermissions;
    protected OperatorPermission[] operatorPermissions;
    protected MemberPermission[] operatorMemberPermissions;
    protected BasicPermission[] basicPermissions;
    private boolean permissionChecked;
    private StackTraceElement[] stackTrace;

    public AbstractPermissionCheck() {
        if (trace) {
            this.stackTrace = Thread.currentThread().getStackTrace();
        }
    }

    @Override
    public PermissionCheck admin(AdminPermission ... permissions) {
        this.adminPermissions = this.adminPermissions == null ? permissions : ArrayUtils.addAll((Object[])this.adminPermissions, (Object[])permissions);
        return this;
    }

    @Override
    public PermissionCheck adminFor(AdminPermission permission, Entity ... entities) {
        this.checkMultivaluedPermission(permission, null);
        this.admin(permission);
        this.addRequiredValues(permission, permission, entities);
        return this;
    }

    @Override
    public PermissionCheck basic(BasicPermission ... permissions) {
        this.basicPermissions = this.basicPermissions == null ? permissions : ArrayUtils.addAll((Object[])this.basicPermissions, (Object[])permissions);
        return this;
    }

    @Override
    public PermissionCheck broker(BrokerPermission ... permissions) {
        this.brokerPermissions = this.brokerPermissions == null ? permissions : ArrayUtils.addAll((Object[])this.brokerPermissions, (Object[])permissions);
        return this;
    }

    @Override
    public PermissionCheck brokerFor(BrokerPermission permission, Entity ... entities) {
        this.checkMultivaluedPermission(permission, null);
        this.broker(permission);
        this.addRequiredValues(permission, permission, entities);
        return this;
    }

    @Override
    public void check() throws PermissionDeniedException {
        if (!this.hasPermission()) {
            throw new PermissionDeniedException();
        }
    }

    @Override
    public final boolean hasPermission() {
        this.permissionChecked = true;
        return this.doHasPermission();
    }

    @Override
    public PermissionCheck member(MemberPermission ... permissions) {
        this.memberPermissions = this.memberPermissions == null ? permissions : ArrayUtils.addAll((Object[])this.memberPermissions, (Object[])permissions);
        return this;
    }

    @Override
    public PermissionCheck memberFor(MemberPermission permission, Entity ... entities) {
        this.checkMultivaluedPermission(permission, null);
        this.member(permission);
        this.addRequiredValues(permission, permission, entities);
        return this;
    }

    @Override
    public PermissionCheck operator() {
        if (this.operatorPermissions == null) {
            this.operatorPermissions = new OperatorPermission[0];
        }
        return this;
    }

    @Override
    public PermissionCheck operator(MemberPermission ... permissions) {
        this.operatorMemberPermissions = this.operatorMemberPermissions == null ? permissions : ArrayUtils.addAll((Object[])this.operatorMemberPermissions, (Object[])permissions);
        return this;
    }

    @Override
    public PermissionCheck operator(OperatorPermission ... permissions) {
        this.operatorPermissions = this.operatorPermissions == null ? permissions : ArrayUtils.addAll((Object[])this.operatorPermissions, (Object[])permissions);
        return this;
    }

    @Override
    public PermissionCheck operatorFor(MemberPermission permission, Entity ... entities) {
        this.checkMultivaluedPermission(permission, null);
        this.operator(permission);
        this.addRequiredValues(permission, permission, entities);
        return this;
    }

    @Override
    public PermissionCheck operatorFor(OperatorPermission permission, Entity ... entities) {
        this.checkMultivaluedPermission(permission, null);
        this.operator(permission);
        this.addRequiredValues(permission, permission, entities);
        return this;
    }

    @Override
    public PermissionCheck operatorFor(OperatorPermission permission, MemberPermission parentPermission, Entity ... entities) {
        this.checkMultivaluedPermission(permission, parentPermission);
        this.operator(permission);
        this.addRequiredValues(permission, parentPermission, entities);
        return this;
    }

    protected abstract boolean doHasPermission();

    protected void finalize() throws Throwable {
        if (!this.permissionChecked) {
            if (this.stackTrace == null) {
                LOG.warn((Object)"PermissionCheck object created without actually checking permission. Did you forget a call to check() or hasPermission()? Set the -Dcyclos.tracePermissionChecks=true system argument to view where this permission object was created");
            } else {
                Exception ex = new Exception();
                ex.setStackTrace(this.stackTrace);
                LOG.warn((Object)"PermissionCheck object created without actually checking permission. Did you forget a call to check() or hasPermission()?", (Throwable)ex);
            }
        }
    }

    protected List<Permission> getPermissions(Group.Nature groupNature, ModuleType onlyOfType) {
        boolean initiallyEmpty;
        List<Permission> permissions = null;
        if (groupNature != null) {
            switch (groupNature) {
                case ADMIN: {
                    permissions = this.join(this.basicPermissions, this.adminPermissions);
                    break;
                }
                case BROKER: {
                    if (onlyOfType == ModuleType.MEMBER) {
                        permissions = this.join(this.basicPermissions, this.memberPermissions);
                        break;
                    }
                    permissions = this.join(this.basicPermissions, this.memberPermissions, this.brokerPermissions);
                    break;
                }
                case MEMBER: {
                    permissions = this.join(this.basicPermissions, this.memberPermissions);
                    break;
                }
                case OPERATOR: {
                    permissions = this.join(this.basicPermissions, this.operatorPermissions, this.operatorMemberPermissions);
                }
            }
        }
        boolean bl = initiallyEmpty = permissions != null && permissions.isEmpty();
        if (permissions != null && onlyOfType != null) {
            Iterator iterator = permissions.iterator();
            while (iterator.hasNext()) {
                Permission permission = (Permission)iterator.next();
                if (permission.getModule().getType() == onlyOfType) continue;
                iterator.remove();
            }
            if (permissions.isEmpty() && !initiallyEmpty) {
                permissions = null;
            }
        }
        return permissions;
    }

    private void addRequiredValues(Permission key, Permission multivaluedPermission, Entity ... entities) {
        if (this.requiredValuesMap == null) {
            this.requiredValuesMap = new HashMap<Permission, RequiredValuesBean>();
        } else if (this.requiredValuesMap.containsKey(key)) {
            throw new IllegalArgumentException(String.format("Permission (%1$s) already added to the allowed values map", key));
        }
        this.requiredValuesMap.put(key, new RequiredValuesBean(multivaluedPermission, entities));
    }

    private void checkMultivaluedPermission(Permission permission, MemberPermission parentPermission) {
        if (!(permission.relationship() != null || permission instanceof OperatorPermission && parentPermission != null && parentPermission.relationship() != null)) {
            throw new IllegalArgumentException(String.format("Invalid permission: %1$s.%2$s. The permission (or its parent if any) must has a relationship to allow ensuring entity membership", permission.getClass().getSimpleName(), permission));
        }
    }

    private List<Permission> join(Permission[] ... permissions) {
        ArrayList<Permission> result = new ArrayList<Permission>();
        boolean hasNonNull = false;
        for (Object[] objectArray : permissions) {
            if (objectArray == null) continue;
            hasNonNull = true;
            CollectionUtils.addAll(result, (Object[])objectArray);
        }
        if (!hasNonNull) {
            return null;
        }
        return result;
    }

    public static class RequiredValuesBean {
        private final Entity[] entities;
        private final Permission permission;

        public RequiredValuesBean(Permission permission, Entity[] entities) {
            this.permission = permission;
            this.entities = entities;
        }

        public Entity[] getEntities() {
            return this.entities;
        }

        public Permission getPermission() {
            return this.permission;
        }
    }
}

