/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.services.access;

import java.util.Collection;
import java.util.List;
import nl.strohalm.cyclos.entities.access.Channel;
import nl.strohalm.cyclos.entities.access.MemberUser;
import nl.strohalm.cyclos.entities.access.Session;
import nl.strohalm.cyclos.entities.access.SessionQuery;
import nl.strohalm.cyclos.entities.access.User;
import nl.strohalm.cyclos.entities.accounts.cards.Card;
import nl.strohalm.cyclos.entities.exceptions.UnexpectedEntityException;
import nl.strohalm.cyclos.entities.members.Member;
import nl.strohalm.cyclos.exceptions.PermissionDeniedException;
import nl.strohalm.cyclos.services.Service;
import nl.strohalm.cyclos.services.access.ChangeLoginPasswordDTO;
import nl.strohalm.cyclos.services.access.ChangePinDTO;
import nl.strohalm.cyclos.services.access.exceptions.AlreadyConnectedException;
import nl.strohalm.cyclos.services.access.exceptions.BlockedCredentialsException;
import nl.strohalm.cyclos.services.access.exceptions.CredentialsAlreadyUsedException;
import nl.strohalm.cyclos.services.access.exceptions.InactiveMemberException;
import nl.strohalm.cyclos.services.access.exceptions.InvalidCardException;
import nl.strohalm.cyclos.services.access.exceptions.InvalidCredentialsException;
import nl.strohalm.cyclos.services.access.exceptions.NotConnectedException;
import nl.strohalm.cyclos.services.access.exceptions.SessionAlreadyInUseException;
import nl.strohalm.cyclos.services.access.exceptions.UserNotFoundException;
import nl.strohalm.cyclos.services.elements.ResetTransactionPasswordDTO;
import nl.strohalm.cyclos.utils.validation.ValidationException;

public interface AccessService
extends Service {
    public boolean canChangeChannelsAccess(Member var1);

    public Member changeChannelsAccess(Member var1, Collection<Channel> var2, boolean var3);

    public User changePassword(ChangeLoginPasswordDTO var1) throws InvalidCredentialsException, BlockedCredentialsException, CredentialsAlreadyUsedException;

    public MemberUser changePin(ChangePinDTO var1) throws InvalidCredentialsException, BlockedCredentialsException, CredentialsAlreadyUsedException;

    public MemberUser checkCredentials(Channel var1, MemberUser var2, String var3, String var4, Member var5) throws InvalidCredentialsException, BlockedCredentialsException, InvalidCardException;

    public Session checkSession(String var1) throws NotConnectedException;

    public User checkTransactionPassword(String var1) throws InvalidCredentialsException, BlockedCredentialsException;

    public User disconnect(Session var1) throws NotConnectedException;

    public User disconnect(User var1) throws NotConnectedException;

    public String generateTransactionPassword() throws UnexpectedEntityException;

    public Collection<Channel> getChannelsEnabledForMember(Member var1);

    public User getLoggedUser(String var1) throws NotConnectedException;

    public boolean hasPasswordExpired();

    public boolean isCardSecurityCodeBlocked(Card var1);

    public boolean isChannelEnabledForMember(Channel var1, Member var2);

    public boolean isChannelEnabledForMember(String var1, Member var2);

    public boolean isLoggedIn(User var1);

    public boolean isLoginBlocked(User var1);

    public boolean isPinBlocked(MemberUser var1);

    public User login(User var1, String var2, String var3, boolean var4, String var5, String var6) throws UserNotFoundException, InvalidCredentialsException, BlockedCredentialsException, SessionAlreadyInUseException, AlreadyConnectedException;

    public User logout(String var1);

    public boolean notifyPermissionDeniedException();

    public User reenableLogin(User var1);

    public MemberUser resetPassword(MemberUser var1);

    public User resetTransactionPassword(ResetTransactionPasswordDTO var1);

    public List<Session> searchSessions(SessionQuery var1);

    public MemberUser unblockPin(MemberUser var1);

    public void validateChangePassword(ChangeLoginPasswordDTO var1) throws ValidationException;

    public void validateChangePin(ChangePinDTO var1) throws ValidationException;

    public User verifyLogin(String var1, String var2, String var3) throws UserNotFoundException, InactiveMemberException, PermissionDeniedException;
}

