/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.services.access;

import java.math.BigInteger;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Random;
import nl.strohalm.cyclos.access.AdminMemberPermission;
import nl.strohalm.cyclos.access.AdminSystemPermission;
import nl.strohalm.cyclos.access.BasicPermission;
import nl.strohalm.cyclos.access.BrokerPermission;
import nl.strohalm.cyclos.access.MemberPermission;
import nl.strohalm.cyclos.dao.access.LoginHistoryDAO;
import nl.strohalm.cyclos.dao.access.PasswordHistoryLogDAO;
import nl.strohalm.cyclos.dao.access.PermissionDeniedTraceDAO;
import nl.strohalm.cyclos.dao.access.SessionDAO;
import nl.strohalm.cyclos.dao.access.UserDAO;
import nl.strohalm.cyclos.dao.access.WrongCredentialAttemptsDAO;
import nl.strohalm.cyclos.dao.access.WrongUsernameAttemptsDAO;
import nl.strohalm.cyclos.dao.accounts.cards.CardDAO;
import nl.strohalm.cyclos.dao.members.ElementDAO;
import nl.strohalm.cyclos.entities.Entity;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.access.AdminUser;
import nl.strohalm.cyclos.entities.access.Channel;
import nl.strohalm.cyclos.entities.access.LoginHistoryLog;
import nl.strohalm.cyclos.entities.access.MemberUser;
import nl.strohalm.cyclos.entities.access.OperatorUser;
import nl.strohalm.cyclos.entities.access.PasswordHistoryLog;
import nl.strohalm.cyclos.entities.access.Session;
import nl.strohalm.cyclos.entities.access.SessionQuery;
import nl.strohalm.cyclos.entities.access.User;
import nl.strohalm.cyclos.entities.accounts.cards.Card;
import nl.strohalm.cyclos.entities.accounts.cards.CardType;
import nl.strohalm.cyclos.entities.alerts.MemberAlert;
import nl.strohalm.cyclos.entities.alerts.SystemAlert;
import nl.strohalm.cyclos.entities.customization.fields.CustomField;
import nl.strohalm.cyclos.entities.customization.fields.CustomFieldValue;
import nl.strohalm.cyclos.entities.exceptions.EntityNotFoundException;
import nl.strohalm.cyclos.entities.exceptions.UnexpectedEntityException;
import nl.strohalm.cyclos.entities.groups.AdminGroup;
import nl.strohalm.cyclos.entities.groups.BasicGroupSettings;
import nl.strohalm.cyclos.entities.groups.Group;
import nl.strohalm.cyclos.entities.groups.MemberGroup;
import nl.strohalm.cyclos.entities.groups.MemberGroupSettings;
import nl.strohalm.cyclos.entities.groups.OperatorGroup;
import nl.strohalm.cyclos.entities.members.Element;
import nl.strohalm.cyclos.entities.members.Member;
import nl.strohalm.cyclos.entities.members.Operator;
import nl.strohalm.cyclos.entities.services.ServiceClient;
import nl.strohalm.cyclos.entities.settings.AccessSettings;
import nl.strohalm.cyclos.entities.settings.LocalSettings;
import nl.strohalm.cyclos.exceptions.MailSendingException;
import nl.strohalm.cyclos.exceptions.PermissionDeniedException;
import nl.strohalm.cyclos.services.InitializingService;
import nl.strohalm.cyclos.services.access.AccessServiceLocal;
import nl.strohalm.cyclos.services.access.ChangeLoginPasswordDTO;
import nl.strohalm.cyclos.services.access.ChangePinDTO;
import nl.strohalm.cyclos.services.access.ChannelServiceLocal;
import nl.strohalm.cyclos.services.access.exceptions.AlreadyConnectedException;
import nl.strohalm.cyclos.services.access.exceptions.BlockedCredentialsException;
import nl.strohalm.cyclos.services.access.exceptions.CredentialsAlreadyUsedException;
import nl.strohalm.cyclos.services.access.exceptions.InactiveMemberException;
import nl.strohalm.cyclos.services.access.exceptions.InvalidCardException;
import nl.strohalm.cyclos.services.access.exceptions.InvalidCredentialsException;
import nl.strohalm.cyclos.services.access.exceptions.InvalidUserForChannelException;
import nl.strohalm.cyclos.services.access.exceptions.NotConnectedException;
import nl.strohalm.cyclos.services.access.exceptions.SessionAlreadyInUseException;
import nl.strohalm.cyclos.services.access.exceptions.SystemOfflineException;
import nl.strohalm.cyclos.services.access.exceptions.UserNotFoundException;
import nl.strohalm.cyclos.services.accounts.cards.CardServiceLocal;
import nl.strohalm.cyclos.services.alerts.AlertServiceLocal;
import nl.strohalm.cyclos.services.application.ApplicationServiceLocal;
import nl.strohalm.cyclos.services.elements.ElementServiceLocal;
import nl.strohalm.cyclos.services.elements.ResetTransactionPasswordDTO;
import nl.strohalm.cyclos.services.fetch.FetchServiceLocal;
import nl.strohalm.cyclos.services.permissions.PermissionServiceLocal;
import nl.strohalm.cyclos.services.settings.SettingsServiceLocal;
import nl.strohalm.cyclos.utils.CacheCleaner;
import nl.strohalm.cyclos.utils.DataIteratorHelper;
import nl.strohalm.cyclos.utils.EntityHelper;
import nl.strohalm.cyclos.utils.HashHandler;
import nl.strohalm.cyclos.utils.MailHandler;
import nl.strohalm.cyclos.utils.PropertyHelper;
import nl.strohalm.cyclos.utils.RangeConstraint;
import nl.strohalm.cyclos.utils.RelationshipHelper;
import nl.strohalm.cyclos.utils.StringHelper;
import nl.strohalm.cyclos.utils.TimePeriod;
import nl.strohalm.cyclos.utils.TransactionHelper;
import nl.strohalm.cyclos.utils.access.LoggedUser;
import nl.strohalm.cyclos.utils.logging.LoggingHandler;
import nl.strohalm.cyclos.utils.logging.TraceLogDTO;
import nl.strohalm.cyclos.utils.notifications.MemberNotificationHandler;
import nl.strohalm.cyclos.utils.query.IteratorList;
import nl.strohalm.cyclos.utils.transaction.CurrentTransactionData;
import nl.strohalm.cyclos.utils.transaction.TransactionEndListener;
import nl.strohalm.cyclos.utils.validation.GeneralValidation;
import nl.strohalm.cyclos.utils.validation.LengthValidation;
import nl.strohalm.cyclos.utils.validation.PropertyValidation;
import nl.strohalm.cyclos.utils.validation.RequiredError;
import nl.strohalm.cyclos.utils.validation.ValidationError;
import nl.strohalm.cyclos.utils.validation.ValidationException;
import nl.strohalm.cyclos.utils.validation.Validator;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.RandomStringUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;

public class AccessServiceImpl
implements AccessServiceLocal,
InitializingService {
    private static final String ALLOW_LOGIN_FOR_GROUPS_KEY = "cyclos.allowLoginForGroups";
    private static final String DISALLOW_LOGIN_FOR_GROUPS_KEY = "cyclos.disallowLoginForGroups";
    private static final Relationship FETCH = RelationshipHelper.nested(User.Relationships.ELEMENT, Element.Relationships.GROUP);
    private static final Log LOG = LogFactory.getLog(AccessServiceImpl.class);
    private AlertServiceLocal alertService;
    private FetchServiceLocal fetchService;
    private ElementServiceLocal elementService;
    private PermissionServiceLocal permissionService;
    private SettingsServiceLocal settingsService;
    private ElementDAO elementDao;
    private UserDAO userDao;
    private CardDAO cardDao;
    private SessionDAO sessionDao;
    private WrongCredentialAttemptsDAO wrongCredentialAttemptsDao;
    private WrongUsernameAttemptsDAO wrongUsernameAttemptsDao;
    private PermissionDeniedTraceDAO permissionDeniedTraceDao;
    private LoginHistoryDAO loginHistoryDao;
    private PasswordHistoryLogDAO passwordHistoryLogDao;
    private MailHandler mailHandler;
    private LoggingHandler loggingHandler;
    private HashHandler hashHandler;
    private ChannelServiceLocal channelService;
    private ApplicationServiceLocal applicationService;
    private CardServiceLocal cardService;
    private MemberNotificationHandler memberNotificationHandler;
    private Collection<Long> allowLoginForGroups;
    private Collection<Long> disallowLoginForGroups;
    private TransactionHelper transactionHelper;

    @Override
    public void addLoginPasswordValidation(Element element, Validator.Property property) {
        property.add(new LoginPasswordValidation(element));
    }

    @Override
    public void addPinValidation(Member member, Validator.Property property) {
        property.add(new PinValidation(member));
    }

    @Override
    public boolean canChangeChannelsAccess(Member member) {
        return this.permissionService.permission(member).admin(AdminMemberPermission.ACCESS_CHANGE_CHANNELS_ACCESS).broker(BrokerPermission.MEMBER_ACCESS_CHANGE_CHANNELS_ACCESS).member(MemberPermission.ACCESS_CHANGE_CHANNELS_ACCESS).hasPermission();
    }

    @Override
    public Member changeChannelsAccess(Member member, Collection<Channel> channels, boolean verifySmsChannel) {
        member = this.fetchService.fetch(member, Member.Relationships.CHANNELS);
        Channel smsChannel = this.channelService.getSmsChannel();
        if (verifySmsChannel && smsChannel != null && member.getChannels().contains(smsChannel)) {
            channels.add(smsChannel);
        }
        member.setChannels(channels);
        return this.elementDao.update(member);
    }

    @Override
    public void changeCredentials(MemberUser user, String newCredentials) throws CredentialsAlreadyUsedException {
        ServiceClient client = this.fetchService.fetch(LoggedUser.serviceClient(), RelationshipHelper.nested(ServiceClient.Relationships.CHANNEL, Channel.Relationships.PRINCIPALS));
        switch (client.getChannel().getCredentials()) {
            case LOGIN_PASSWORD: {
                this.changePassword(user, null, newCredentials, false);
                break;
            }
            case PIN: {
                this.changePin(user, newCredentials);
            }
        }
    }

    @Override
    public User changePassword(ChangeLoginPasswordDTO params) throws InvalidCredentialsException, BlockedCredentialsException, CredentialsAlreadyUsedException {
        boolean isExpired;
        this.validateChangePassword(params);
        Object loggedUser = LoggedUser.user();
        boolean myPassword = ((Entity)loggedUser).equals(params.getUser());
        if (myPassword && !(isExpired = this.hasPasswordExpired())) {
            Object loggedElement = LoggedUser.element();
            String member = null;
            if (LoggedUser.isOperator()) {
                Operator operator = (Operator)LoggedUser.element();
                member = operator.getMember().getUsername();
            }
            this.checkPassword(member, ((Element)loggedElement).getUsername(), params.getOldPassword(), LoggedUser.remoteAddress());
        }
        User user = this.fetchService.fetch(params.getUser(), RelationshipHelper.nested(User.Relationships.ELEMENT, Element.Relationships.GROUP));
        return this.changePassword(user, params.getNewPassword(), params.isForceChange());
    }

    @Override
    public MemberUser changePin(ChangePinDTO params) throws InvalidCredentialsException, BlockedCredentialsException, CredentialsAlreadyUsedException {
        this.validateChangePin(params);
        Object loggedUser = LoggedUser.user();
        boolean myPin = ((Entity)loggedUser).equals(params.getUser());
        if (myPin) {
            Member loggedMember = (Member)this.fetchService.fetch(((User)loggedUser).getElement(), Element.Relationships.GROUP);
            boolean usesTransactionPassword = loggedMember.getMemberGroup().getBasicSettings().getTransactionPassword().isUsed();
            if (usesTransactionPassword) {
                this.checkTransactionPassword(loggedMember.getUser(), params.getCredentials(), LoggedUser.remoteAddress());
            } else {
                this.checkPassword(loggedMember.getUser(), params.getCredentials(), LoggedUser.remoteAddress());
            }
        }
        MemberUser user = this.fetchService.fetch(params.getUser(), RelationshipHelper.nested(User.Relationships.ELEMENT, Element.Relationships.GROUP));
        return this.changePin(user, params.getNewPin());
    }

    @Override
    public MemberUser checkCredentials(Channel channel, MemberUser user, String credentials, String remoteAddress, Member relatedMember) {
        if (StringUtils.isEmpty((String)credentials)) {
            throw new InvalidCredentialsException(channel.getCredentials(), user);
        }
        channel = this.fetchService.fetch(channel, Channel.Relationships.PRINCIPALS);
        user = this.fetchService.fetch(user, new Relationship[0]);
        switch (channel.getCredentials()) {
            case LOGIN_PASSWORD: 
            case DEFAULT: {
                this.checkPassword(user, credentials, remoteAddress);
                break;
            }
            case PIN: {
                this.checkPin(user, credentials, channel.getInternalName(), relatedMember);
                break;
            }
            case TRANSACTION_PASSWORD: {
                this.checkTransactionPassword(user, credentials, remoteAddress);
                break;
            }
            case CARD_SECURITY_CODE: {
                Card card = this.cardService.getActiveCard(user.getMember());
                this.checkCardSecurityCode(card.getCardNumber(), credentials, channel.getInternalName());
            }
        }
        return user;
    }

    @Override
    public User checkPassword(String member, String username, String plainPassword, String remoteAddress) {
        User user = this.loadUser(member, username);
        return this.checkPassword(user, plainPassword, remoteAddress);
    }

    @Override
    public Session checkSession(String sessionId) throws NotConnectedException {
        try {
            Session session = this.sessionDao.load(sessionId, false);
            User user = session.getUser();
            final Long id = session.getId();
            final Calendar newExpiration = this.getSessionTimeout(user, session.isPosWeb()).add(Calendar.getInstance());
            CurrentTransactionData.addTransactionEndListener(new TransactionEndListener(){

                @Override
                protected void onTransactionEnd(boolean commit) {
                    AccessServiceImpl.this.updateSessionExpiration(id, newExpiration);
                }
            });
            return session;
        }
        catch (EntityNotFoundException e) {
            throw new NotConnectedException();
        }
    }

    @Override
    public User checkTransactionPassword(String transactionPassword) throws InvalidCredentialsException, BlockedCredentialsException {
        Object user = LoggedUser.user();
        return this.checkTransactionPassword((User)user, transactionPassword, LoggedUser.remoteAddress());
    }

    @Override
    public User disconnect(Session session) throws NotConnectedException {
        try {
            session = this.fetchService.fetch(session, RelationshipHelper.nested(Session.Relationships.USER, User.Relationships.ELEMENT));
        }
        catch (EntityNotFoundException e) {
            throw new NotConnectedException();
        }
        this.sessionDao.delete(session.getId());
        User user = session.getUser();
        if (!this.isLoggedIn(user)) {
            user.setLastLogin(Calendar.getInstance());
        }
        return user;
    }

    @Override
    public User disconnect(User user) {
        int sessions = this.sessionDao.delete(user);
        if (sessions > 0) {
            user.setLastLogin(Calendar.getInstance());
        }
        return this.fetchService.fetch(user, User.Relationships.ELEMENT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void disconnectAllButLogged() {
        Object loggedUser = LoggedUser.user();
        IteratorList<User> iterator = this.sessionDao.listLoggedUsers();
        try {
            CacheCleaner cacheCleaner = new CacheCleaner(this.fetchService);
            for (User user : iterator) {
                if (((Entity)loggedUser).equals(user)) continue;
                this.disconnect(user);
                cacheCleaner.clearCache();
            }
        }
        finally {
            DataIteratorHelper.close(iterator);
        }
    }

    @Override
    public String generatePassword(Group group) {
        if (group instanceof OperatorGroup) {
            group = this.fetchService.fetch(group, RelationshipHelper.nested(OperatorGroup.Relationships.MEMBER, Element.Relationships.GROUP));
        }
        Integer min = group.getBasicSettings().getPasswordLength().getMin();
        boolean onlyNumbers = this.settingsService.getAccessSettings().isNumericPassword();
        return RandomStringUtils.random((int)(min == null ? 4 : min), (!onlyNumbers ? 1 : 0) != 0, (boolean)true).toLowerCase();
    }

    @Override
    public String generateTransactionPassword() {
        Object user = LoggedUser.user();
        if (user instanceof OperatorUser) {
            Element element = ((User)user).getElement();
            element = this.fetchService.fetch(element, RelationshipHelper.nested(Operator.Relationships.MEMBER, Element.Relationships.GROUP));
        }
        if (!this.requestTransactionPassword((User)user)) {
            throw new UnexpectedEntityException();
        }
        String current = ((User)user).getTransactionPassword();
        if (current != null) {
            return null;
        }
        AccessSettings accessSettings = this.settingsService.getAccessSettings();
        String chars = accessSettings.getTransactionPasswordChars();
        Group group = ((User)user).getElement().getGroup();
        if (group instanceof OperatorGroup) {
            group = this.fetchService.fetch(group, RelationshipHelper.nested(OperatorGroup.Relationships.MEMBER, Element.Relationships.GROUP));
        }
        BasicGroupSettings basicSettings = group.getBasicSettings();
        int length = basicSettings.getTransactionPasswordLength();
        StringBuilder buffer = new StringBuilder(length);
        Random rnd = new Random();
        for (int i = 0; i < length; ++i) {
            buffer.append(chars.charAt(rnd.nextInt(chars.length())));
        }
        String transactionPassword = buffer.toString();
        ((User)user).setTransactionPassword(this.hashHandler.hash(((User)user).getSalt(), transactionPassword));
        ((User)user).setTransactionPasswordStatus(User.TransactionPasswordStatus.ACTIVE);
        user = (User)this.userDao.update(user);
        return transactionPassword;
    }

    @Override
    public Collection<Channel> getChannelsEnabledForMember(Member member) {
        member = this.fetchService.fetch(member, Element.Relationships.GROUP);
        return CollectionUtils.retainAll(member.getChannels(), member.getMemberGroup().getChannels());
    }

    @Override
    public User getLoggedUser(String sessionId) throws NotConnectedException {
        try {
            Session session = this.sessionDao.load(sessionId, false);
            return session.getUser();
        }
        catch (EntityNotFoundException e) {
            throw new NotConnectedException();
        }
    }

    @Override
    public boolean hasPasswordExpired() {
        Object group = LoggedUser.group();
        if (group instanceof OperatorGroup) {
            group = (Group)this.fetchService.fetch(group, RelationshipHelper.nested(OperatorGroup.Relationships.MEMBER, Element.Relationships.GROUP));
        }
        TimePeriod exp = ((Group)group).getBasicSettings().getPasswordExpiresAfter();
        Calendar passwordDate = ((User)LoggedUser.user()).getPasswordDate();
        if (passwordDate == null) {
            return true;
        }
        if (exp != null && exp.getNumber() > 0 && passwordDate != null) {
            Calendar expiresAt = exp.remove(Calendar.getInstance());
            return expiresAt.after(passwordDate);
        }
        return false;
    }

    @Override
    public void initializeService() {
        this.purgeTraces(Calendar.getInstance());
        this.purgeExpiredSessions();
    }

    @Override
    public boolean isCardSecurityCodeBlocked(Card card) {
        card = this.fetchService.reload(card, new Relationship[0]);
        return this.isBlocked(card.getCardSecurityCodeBlockedUntil());
    }

    @Override
    public boolean isChannelAllowedToBeEnabledForMember(Channel channel, Member member) {
        member = this.fetchService.fetch(member, Element.Relationships.GROUP, Member.Relationships.CHANNELS);
        switch (channel.getCredentials()) {
            case TRANSACTION_PASSWORD: {
                if (member.getMemberGroup().getBasicSettings().getTransactionPassword().isUsed()) break;
                LOG.warn((Object)("The member's group doesn't use transaction password,  member: " + member));
                return false;
            }
            case CARD_SECURITY_CODE: {
                if (member.getMemberGroup().getCardType() != null) break;
                LOG.warn((Object)("The member's group doesn't have a card type,  member: " + member));
                return false;
            }
        }
        return this.isChannelEnabledForGroup(channel, member.getMemberGroup());
    }

    @Override
    public boolean isChannelEnabledForMember(Channel channel, Member member) {
        return this.isChannelAllowedToBeEnabledForMember(channel, member = this.fetchService.fetch(member, Member.Relationships.CHANNELS)) && (channel.getInternalName().equals("web") || member.getChannels().contains(channel));
    }

    @Override
    public boolean isChannelEnabledForMember(String channelInternalName, Member member) {
        Channel channel = this.channelService.loadByInternalName(channelInternalName);
        return this.isChannelEnabledForMember(channel, member);
    }

    @Override
    public boolean isLoggedIn(User user) {
        return this.sessionDao.isLoggedIn(user);
    }

    @Override
    public boolean isLoginBlocked(User user) {
        user = this.fetchService.reload(user, new Relationship[0]);
        return this.isBlocked(user.getPasswordBlockedUntil());
    }

    @Override
    public boolean isObviousCredential(Element element, String credential) {
        String mailUser;
        String[] nameParts;
        if (element.isPersistent()) {
            element = this.fetchService.fetch(element, Element.Relationships.USER, Member.Relationships.CUSTOM_VALUES);
        }
        if (credential.equalsIgnoreCase(element.getUsername())) {
            return true;
        }
        for (String part : nameParts = StringUtils.split((String)element.getName(), (String)" .,/-\\")) {
            if (!credential.equalsIgnoreCase(part)) continue;
            return true;
        }
        String email = element.getEmail();
        if (StringUtils.isNotEmpty((String)email) && email.contains("@") && credential.equalsIgnoreCase(mailUser = StringUtils.split((String)email, (String)"@", (int)1)[0])) {
            return true;
        }
        Collection customValues = (Collection)PropertyHelper.get(element, "customValues");
        LocalSettings localSettings = this.settingsService.getLocalSettings();
        for (CustomFieldValue fieldValue : customValues) {
            CustomField.Type type = fieldValue.getField().getType();
            String stringValue = fieldValue.getStringValue();
            if (StringUtils.isEmpty((String)stringValue)) continue;
            switch (type) {
                case DATE: {
                    String unmasked = StringHelper.removeMask(localSettings.getDatePattern().getPattern(), stringValue);
                    if (!credential.equals(unmasked)) break;
                    return true;
                }
                case INTEGER: {
                    if (!credential.equals(stringValue)) break;
                    return true;
                }
                case STRING: {
                    if (!stringValue.contains(credential)) break;
                    return true;
                }
            }
        }
        if (credential.length() > 1) {
            HashSet<Integer> diffs = new HashSet<Integer>();
            int len = credential.length();
            for (int i = 1; i < len; ++i) {
                char current = credential.charAt(i);
                char previous = credential.charAt(i - 1);
                diffs.add(current - previous);
                if (diffs.size() > 1) break;
            }
            if (diffs.size() == 1) {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isPinBlocked(MemberUser user) {
        user = this.fetchService.reload(user, new Relationship[0]);
        return this.isBlocked(user.getPinBlockedUntil());
    }

    @Override
    public User login(User user, String plainCredentials, String channelName, boolean isPosWeb, String remoteAddress, String sessionId) throws UserNotFoundException, InvalidCredentialsException, BlockedCredentialsException, SessionAlreadyInUseException, AlreadyConnectedException {
        if (user == null) {
            throw new UnexpectedEntityException();
        }
        user = this.fetchService.fetch(user, RelationshipHelper.nested(User.Relationships.ELEMENT, Element.Relationships.GROUP));
        if (!this.applicationService.isOnline() && !this.permissionService.hasPermission(user.getElement().getGroup(), AdminSystemPermission.TASKS_ONLINE_STATE)) {
            throw new SystemOfflineException();
        }
        try {
            Session session = this.sessionDao.load(sessionId, false);
            if (session.getUser().equals(user) && remoteAddress.equals(session.getRemoteAddress()) && isPosWeb == session.isPosWeb()) {
                return session.getUser();
            }
            throw new SessionAlreadyInUseException(user.getUsername());
        }
        catch (EntityNotFoundException e) {
            AccessSettings accessSettings;
            Channel channel = this.channelService.loadByInternalName(channelName);
            boolean isMainWebChannel = "web".equals(channel.getInternalName());
            if (user instanceof MemberUser) {
                this.checkCredentials(channel, (MemberUser)user, plainCredentials, remoteAddress, null);
                if (!isMainWebChannel && !this.isChannelEnabledForMember(channelName, ((MemberUser)user).getMember())) {
                    throw new InvalidUserForChannelException(user.getUsername());
                }
            } else {
                if (channel != null && !isMainWebChannel) {
                    throw new PermissionDeniedException();
                }
                this.checkPassword(user, plainCredentials, remoteAddress);
            }
            if (!(accessSettings = this.settingsService.getAccessSettings()).isAllowMultipleLogins() && this.isLoggedIn(user)) {
                throw new AlreadyConnectedException();
            }
            this.permissionDeniedTraceDao.clear(user);
            Calendar now = Calendar.getInstance();
            Session session = new Session();
            session.setCreationDate(now);
            session.setExpirationDate(this.getSessionTimeout(user, isPosWeb).add(now));
            session.setUser(user);
            session.setIdentifier(sessionId);
            session.setRemoteAddress(remoteAddress);
            session.setPosWeb(isPosWeb);
            this.sessionDao.insert(session);
            LoginHistoryLog loginHistoryLog = new LoginHistoryLog();
            loginHistoryLog.setUser(user);
            loginHistoryLog.setDate(now);
            loginHistoryLog.setRemoteAddress(remoteAddress);
            this.loginHistoryDao.insert(loginHistoryLog);
            TraceLogDTO logParams = new TraceLogDTO();
            logParams.setUser(user);
            logParams.setSessionId(sessionId);
            logParams.setRemoteAddress(remoteAddress);
            this.loggingHandler.traceLogin(logParams);
            LoggedUser.init(user);
            return user;
        }
    }

    @Override
    public User logout(String sessionId) {
        try {
            Session session = this.sessionDao.load(sessionId, true);
            this.sessionDao.delete(session.getId());
            User user = session.getUser();
            user.setLastLogin(Calendar.getInstance());
            TraceLogDTO logParams = new TraceLogDTO();
            logParams.setUser(user);
            logParams.setSessionId(sessionId);
            logParams.setRemoteAddress(session.getRemoteAddress());
            this.loggingHandler.traceLogout(logParams);
            if (LoggedUser.hasUser() && user.equals(LoggedUser.user())) {
                LoggedUser.cleanup();
            }
            return user;
        }
        catch (EntityNotFoundException e) {
            return null;
        }
    }

    @Override
    public boolean notifyPermissionDeniedException() {
        if (!LoggedUser.hasUser()) {
            return false;
        }
        return this.transactionHelper.runInNewTransaction(new TransactionCallback<Boolean>(){

            public Boolean doInTransaction(TransactionStatus status) {
                User user = (User)AccessServiceImpl.this.fetchService.fetch(LoggedUser.user(), new Relationship[]{RelationshipHelper.nested(User.Relationships.ELEMENT, Element.Relationships.GROUP)});
                if (AccessServiceImpl.this.isBlocked(user.getPasswordBlockedUntil())) {
                    return true;
                }
                BasicGroupSettings basicSettings = user.getElement().getGroup().getBasicSettings();
                int maxTries = basicSettings.getMaxPasswordWrongTries();
                if (maxTries > 0) {
                    AccessServiceImpl.this.permissionDeniedTraceDao.record(user);
                    int tries = AccessServiceImpl.this.permissionDeniedTraceDao.count(AccessServiceImpl.this.wrongAttemptsLimit(), user);
                    if (tries == maxTries) {
                        if (user instanceof AdminUser) {
                            AccessServiceImpl.this.alertService.create(SystemAlert.Alerts.ADMIN_LOGIN_BLOCKED_BY_PERMISSION_DENIEDS, user.getUsername(), tries, LoggedUser.remoteAddress());
                        } else if (user instanceof MemberUser) {
                            AccessServiceImpl.this.alertService.create(((MemberUser)user).getMember(), MemberAlert.Alerts.LOGIN_BLOCKED_BY_PERMISSION_DENIEDS, tries, LoggedUser.remoteAddress());
                        }
                        Calendar mayLoginAt = basicSettings.getDeactivationAfterMaxPasswordTries().add(Calendar.getInstance());
                        user.setPasswordBlockedUntil(mayLoginAt);
                        AccessServiceImpl.this.permissionDeniedTraceDao.clear(user);
                        return true;
                    }
                }
                return false;
            }
        });
    }

    @Override
    public void purgeExpiredSessions() {
        this.sessionDao.purgeExpired();
    }

    @Override
    public void purgeTraces(Calendar time) {
        Calendar limit = (Calendar)time.clone();
        limit.add(5, -1);
        this.wrongCredentialAttemptsDao.clear(limit);
        this.wrongUsernameAttemptsDao.clear(limit);
        this.permissionDeniedTraceDao.clear(limit);
    }

    @Override
    public User reenableLogin(User user) {
        user = this.fetchService.fetch(user, new Relationship[0]);
        user.setPasswordBlockedUntil(null);
        this.wrongCredentialAttemptsDao.clear(user, Channel.Credentials.LOGIN_PASSWORD);
        return user;
    }

    @Override
    public MemberUser resetPassword(MemberUser user) throws MailSendingException {
        user = this.fetchService.fetch(user, FETCH);
        MemberGroup group = user.getMember().getMemberGroup();
        boolean sendPasswordByEmail = group.getMemberSettings().isSendPasswordByEmail();
        String newPassword = null;
        if (sendPasswordByEmail) {
            newPassword = this.generatePassword(group);
        }
        user.setPassword(this.hashHandler.hash(user.getSalt(), newPassword));
        user.setPasswordDate(null);
        this.userDao.update(user);
        if (sendPasswordByEmail) {
            this.mailHandler.sendResetPassword(user.getMember(), newPassword);
        }
        return user;
    }

    @Override
    public User resetTransactionPassword(ResetTransactionPasswordDTO dto) {
        User user = dto.getUser();
        user.setTransactionPassword(null);
        user.setTransactionPasswordStatus(dto.isAllowGeneration() ? User.TransactionPasswordStatus.PENDING : User.TransactionPasswordStatus.BLOCKED);
        return this.userDao.update(user);
    }

    @Override
    public List<Session> searchSessions(SessionQuery query) {
        return this.sessionDao.search(query);
    }

    public void setAlertServiceLocal(AlertServiceLocal alertService) {
        this.alertService = alertService;
    }

    public void setApplicationServiceLocal(ApplicationServiceLocal applicationService) {
        this.applicationService = applicationService;
    }

    public void setCardDao(CardDAO cardDao) {
        this.cardDao = cardDao;
    }

    public void setCardServiceLocal(CardServiceLocal cardService) {
        this.cardService = cardService;
    }

    public void setChannelServiceLocal(ChannelServiceLocal channelService) {
        this.channelService = channelService;
    }

    public void setCyclosProperties(Properties cyclosProperties) {
        try {
            this.allowLoginForGroups = EntityHelper.parseIds(cyclosProperties.getProperty(ALLOW_LOGIN_FOR_GROUPS_KEY));
        }
        catch (Exception e) {
            throw new IllegalStateException("Invalid value for cyclos.allowLoginForGroups in cyclos.properties", e);
        }
        try {
            this.disallowLoginForGroups = EntityHelper.parseIds(cyclosProperties.getProperty(DISALLOW_LOGIN_FOR_GROUPS_KEY));
        }
        catch (Exception e) {
            throw new IllegalStateException("Invalid value for cyclos.disallowLoginForGroups in cyclos.properties", e);
        }
    }

    public void setElementDao(ElementDAO elementDao) {
        this.elementDao = elementDao;
    }

    public void setElementServiceLocal(ElementServiceLocal elementService) {
        this.elementService = elementService;
    }

    public void setFetchServiceLocal(FetchServiceLocal fetchService) {
        this.fetchService = fetchService;
    }

    public void setHashHandler(HashHandler hashHandler) {
        this.hashHandler = hashHandler;
    }

    public void setLoggingHandler(LoggingHandler loggingHandler) {
        this.loggingHandler = loggingHandler;
    }

    public void setLoginHistoryDao(LoginHistoryDAO loginHistoryDao) {
        this.loginHistoryDao = loginHistoryDao;
    }

    public void setMailHandler(MailHandler mailHandler) {
        this.mailHandler = mailHandler;
    }

    public void setMemberNotificationHandler(MemberNotificationHandler memberNotificationHandler) {
        this.memberNotificationHandler = memberNotificationHandler;
    }

    public void setPasswordHistoryLogDao(PasswordHistoryLogDAO passwordHistoryLogDao) {
        this.passwordHistoryLogDao = passwordHistoryLogDao;
    }

    public void setPermissionDeniedTraceDao(PermissionDeniedTraceDAO permissionDeniedTraceDao) {
        this.permissionDeniedTraceDao = permissionDeniedTraceDao;
    }

    public void setPermissionServiceLocal(PermissionServiceLocal permissionService) {
        this.permissionService = permissionService;
    }

    public void setSessionDao(SessionDAO sessionDao) {
        this.sessionDao = sessionDao;
    }

    public void setSettingsServiceLocal(SettingsServiceLocal settingsService) {
        this.settingsService = settingsService;
    }

    public void setTransactionHelper(TransactionHelper transactionHelper) {
        this.transactionHelper = transactionHelper;
    }

    public void setUserDao(UserDAO userDao) {
        this.userDao = userDao;
    }

    public void setWrongCredentialAttemptsDao(WrongCredentialAttemptsDAO wrongCredentialAttemptsDao) {
        this.wrongCredentialAttemptsDao = wrongCredentialAttemptsDao;
    }

    public void setWrongUsernameAttemptsDao(WrongUsernameAttemptsDAO wrongUsernameAttemptsDao) {
        this.wrongUsernameAttemptsDao = wrongUsernameAttemptsDao;
    }

    @Override
    public Card unblockCardSecurityCode(BigInteger cardNumber) {
        Card card = this.cardDao.loadByNumber(cardNumber, new Relationship[0]);
        card.setCardSecurityCodeBlockedUntil(null);
        this.wrongCredentialAttemptsDao.clear(card);
        return card;
    }

    @Override
    public MemberUser unblockPin(MemberUser user) {
        user = this.fetchService.fetch(user, new Relationship[0]);
        user.setPinBlockedUntil(null);
        this.wrongCredentialAttemptsDao.clear(user, Channel.Credentials.PIN);
        return user;
    }

    @Override
    public void validateChangePassword(ChangeLoginPasswordDTO params) throws ValidationException {
        User user;
        Validator validator = new Validator("changePassword");
        validator.property("user").required();
        if (LoggedUser.hasUser() && ((Entity)LoggedUser.user()).equals(params.getUser()) && !this.hasPasswordExpired()) {
            validator.property("oldPassword").required();
        }
        if ((user = this.fetchService.fetch(params.getUser(), RelationshipHelper.nested(User.Relationships.ELEMENT, Element.Relationships.GROUP))) != null) {
            validator.property("newPassword").required().add(new LoginPasswordValidation(user.getElement()));
            validator.property("newPasswordConfirmation").required();
        }
        validator.general(new GeneralValidation(){
            private static final long serialVersionUID = -4110708889147050967L;

            @Override
            public ValidationError validate(Object object) {
                ChangeLoginPasswordDTO params = (ChangeLoginPasswordDTO)object;
                String newPassword = params.getNewPassword();
                String newPasswordConfirmation = params.getNewPasswordConfirmation();
                if (StringUtils.isNotEmpty((String)newPassword) && StringUtils.isNotEmpty((String)newPasswordConfirmation) && !newPassword.equals(newPasswordConfirmation)) {
                    return new ValidationError("errors.passwords", new Object[0]);
                }
                return null;
            }
        });
        validator.validate(params);
    }

    @Override
    public void validateChangePin(ChangePinDTO params) {
        if (params.getUser() == null) {
            throw new ValidationException("user", "changePin.user", new RequiredError(new Object[0]));
        }
        boolean myPin = ((Entity)LoggedUser.user()).equals(params.getUser());
        Validator validator = new Validator("changePin");
        if (myPin) {
            MemberGroup group = (MemberGroup)LoggedUser.group();
            boolean isTP = group.getBasicSettings().getTransactionPassword().isUsed();
            String key = isTP ? "channel.credentials.TRANSACTION_PASSWORD" : "channel.credentials.LOGIN_PASSWORD";
            validator.property("credentials").key(key).required();
        } else {
            validator.property("user").required();
        }
        MemberUser user = this.fetchService.fetch(params.getUser(), User.Relationships.ELEMENT);
        if (user != null) {
            validator.property("newPin").required().add(new PinValidation(user.getMember()));
            validator.property("newPinConfirmation").required();
        }
        validator.general(new GeneralValidation(){
            private static final long serialVersionUID = -4110708889147050967L;

            @Override
            public ValidationError validate(Object object) {
                ChangePinDTO params = (ChangePinDTO)object;
                String newPin = params.getNewPin();
                String newPinConfirmation = params.getNewPinConfirmation();
                if (StringUtils.isNotEmpty((String)newPin) && StringUtils.isNotEmpty((String)newPinConfirmation) && !newPin.equals(newPinConfirmation)) {
                    return new ValidationError("changePin.error.pinsAreNotEqual", new Object[0]);
                }
                return null;
            }
        });
        validator.validate(params);
    }

    public ValidationError validateLoginPassword(Element element, String loginPassword) {
        return new LoginPasswordValidation(element).validate(element.getUser(), "password", loginPassword);
    }

    @Override
    public User verifyLogin(String member, String username, String remoteAddress) throws UserNotFoundException, InactiveMemberException, PermissionDeniedException {
        try {
            User user = this.loadUser(member, username);
            Long groupId = user instanceof OperatorUser ? ((OperatorUser)user).getOperator().getMember().getGroup().getId() : user.getElement().getGroup().getId();
            if (!this.allowLoginForGroups.isEmpty() && !this.allowLoginForGroups.contains(groupId)) {
                throw new UserNotFoundException(username);
            }
            if (!this.disallowLoginForGroups.isEmpty() && this.disallowLoginForGroups.contains(groupId)) {
                throw new UserNotFoundException(username);
            }
            if (StringUtils.isEmpty((String)user.getPassword())) {
                throw new InactiveMemberException(username);
            }
            if (!this.permissionService.hasPermission(user.getElement().getGroup(), BasicPermission.BASIC_LOGIN)) {
                throw new PermissionDeniedException();
            }
            this.wrongUsernameAttemptsDao.clear(remoteAddress);
            return user;
        }
        catch (EntityNotFoundException e) {
            int wrongTries;
            this.wrongUsernameAttemptsDao.record(remoteAddress);
            int maxTries = this.settingsService.getAlertSettings().getAmountIncorrectLogin();
            if (maxTries > 0 && (wrongTries = this.wrongUsernameAttemptsDao.count(this.wrongAttemptsLimit(), remoteAddress)) == maxTries) {
                this.alertService.create(SystemAlert.Alerts.MAX_INCORRECT_LOGIN_ATTEMPTS, wrongTries, remoteAddress);
                this.wrongUsernameAttemptsDao.clear(remoteAddress);
            }
            throw new UserNotFoundException(username);
        }
    }

    @Override
    public Calendar wrongAttemptsLimit() {
        Calendar calendar = Calendar.getInstance();
        calendar.add(5, -1);
        return calendar;
    }

    private <U extends User> U changePassword(U user, String oldPassword, String plainNewPassword, boolean forceChange) {
        ValidationError validationResult = new LoginPasswordValidation((user = this.fetchService.reload(user, RelationshipHelper.nested(User.Relationships.ELEMENT, Element.Relationships.GROUP))).getElement()).validate(user, "password", plainNewPassword);
        if (validationResult != null) {
            throw new ValidationException("password", "channel.credentials.LOGIN_PASSWORD", validationResult);
        }
        String currentPassword = user.getPassword();
        String hashedOldPassword = this.hashHandler.hash(user.getSalt(), oldPassword);
        if (StringUtils.isNotEmpty((String)oldPassword) && !hashedOldPassword.equalsIgnoreCase(currentPassword)) {
            throw new InvalidCredentialsException(Channel.Credentials.LOGIN_PASSWORD, user);
        }
        String newPassword = this.hashHandler.hash(user.getSalt(), plainNewPassword);
        BasicGroupSettings.PasswordPolicy passwordPolicy = user.getElement().getGroup().getBasicSettings().getPasswordPolicy();
        if (passwordPolicy != BasicGroupSettings.PasswordPolicy.NONE && (StringUtils.trimToEmpty((String)currentPassword).equalsIgnoreCase(newPassword) || this.passwordHistoryLogDao.wasAlreadyUsed(user, PasswordHistoryLog.PasswordType.LOGIN, newPassword))) {
            throw new CredentialsAlreadyUsedException(Channel.Credentials.LOGIN_PASSWORD, user);
        }
        if (newPassword.equalsIgnoreCase(user.getTransactionPassword()) || user instanceof MemberUser && newPassword.equalsIgnoreCase(((MemberUser)user).getPin())) {
            throw new ValidationException("changePassword.error.sameAsTransactionPasswordOrPin", new Object[0]);
        }
        user.setPassword(newPassword);
        user.setPasswordDate(forceChange ? null : Calendar.getInstance());
        user = this.fetchService.fetch(this.userDao.update(user), FETCH);
        if (user instanceof OperatorUser) {
            Operator operator = ((OperatorUser)user).getOperator();
            Member member = this.fetchService.fetch(operator.getMember(), Element.Relationships.USER, Element.Relationships.GROUP);
            operator.setMember(member);
        }
        if (StringUtils.isNotEmpty((String)currentPassword)) {
            PasswordHistoryLog log = new PasswordHistoryLog();
            log.setDate(Calendar.getInstance());
            log.setUser(user);
            log.setType(PasswordHistoryLog.PasswordType.LOGIN);
            log.setPassword(currentPassword);
            this.passwordHistoryLogDao.insert(log);
        }
        return user;
    }

    private User changePassword(User user, String plainPassword, boolean forceChange) {
        String pin;
        ValidationError validationResult = new LoginPasswordValidation(user.getElement()).validate(user, "password", plainPassword);
        if (validationResult != null) {
            throw new ValidationException("password", "channel.credentials.LOGIN_PASSWORD", validationResult);
        }
        String password = this.hashHandler.hash(user.getSalt(), plainPassword);
        user = this.fetchService.fetch(user, RelationshipHelper.nested(User.Relationships.ELEMENT, Element.Relationships.GROUP));
        String currentPassword = user.getPassword();
        BasicGroupSettings.PasswordPolicy passwordPolicy = user.getElement().getGroup().getBasicSettings().getPasswordPolicy();
        if (passwordPolicy != null && passwordPolicy != BasicGroupSettings.PasswordPolicy.NONE && (StringUtils.trimToEmpty((String)currentPassword).equalsIgnoreCase(password) || this.passwordHistoryLogDao.wasAlreadyUsed(user, PasswordHistoryLog.PasswordType.LOGIN, password))) {
            throw new CredentialsAlreadyUsedException(Channel.Credentials.LOGIN_PASSWORD, user);
        }
        String string = pin = user instanceof MemberUser ? ((MemberUser)user).getPin() : null;
        if (password.equalsIgnoreCase(pin) || password.equalsIgnoreCase(user.getTransactionPassword())) {
            throw new ValidationException("changePassword.error.sameAsTransactionPasswordOrPin", new Object[0]);
        }
        user.setPassword(password);
        if (forceChange) {
            user.setPasswordDate(null);
        } else {
            user.setPasswordDate(Calendar.getInstance());
        }
        if (StringUtils.isNotEmpty((String)currentPassword)) {
            PasswordHistoryLog log = new PasswordHistoryLog();
            log.setDate(Calendar.getInstance());
            log.setUser(user);
            log.setType(PasswordHistoryLog.PasswordType.LOGIN);
            log.setPassword(currentPassword);
            this.passwordHistoryLogDao.insert(log);
        }
        user = this.userDao.update(user);
        return user;
    }

    private MemberUser changePin(MemberUser user, String plainPin) {
        ValidationError validationResult = new PinValidation(user.getMember()).validate(user, "pin", plainPin);
        if (validationResult != null) {
            throw new ValidationException("pin", "channel.credentials.PIN", validationResult);
        }
        String pin = this.hashHandler.hash(user.getSalt(), plainPin);
        user = this.fetchService.fetch(user, RelationshipHelper.nested(User.Relationships.ELEMENT, Element.Relationships.GROUP));
        String currentPin = user.getPin();
        BasicGroupSettings.PasswordPolicy passwordPolicy = user.getElement().getGroup().getBasicSettings().getPasswordPolicy();
        if (passwordPolicy != null && passwordPolicy != BasicGroupSettings.PasswordPolicy.NONE && (StringUtils.trimToEmpty((String)currentPin).equalsIgnoreCase(pin) || this.passwordHistoryLogDao.wasAlreadyUsed(user, PasswordHistoryLog.PasswordType.PIN, pin))) {
            throw new CredentialsAlreadyUsedException(Channel.Credentials.PIN, user);
        }
        if (pin.equalsIgnoreCase(user.getPassword()) || pin.equalsIgnoreCase(user.getTransactionPassword())) {
            throw new ValidationException("changePin.error.sameAsLoginOrTransactionPassword", new Object[0]);
        }
        user.setPin(pin);
        if (StringUtils.isNotEmpty((String)currentPin)) {
            PasswordHistoryLog log = new PasswordHistoryLog();
            log.setDate(Calendar.getInstance());
            log.setUser(user);
            log.setType(PasswordHistoryLog.PasswordType.PIN);
            log.setPassword(currentPin);
            this.passwordHistoryLogDao.insert(log);
        }
        return user;
    }

    private Card checkCardSecurityCode(BigInteger cardNumber, String securityCode, String channel) {
        String storedCode;
        Card card;
        try {
            card = this.cardService.loadByNumber(cardNumber, RelationshipHelper.nested(Card.Relationships.OWNER, Element.Relationships.USER), Card.Relationships.CARD_TYPE);
            if (card.getStatus() != Card.Status.ACTIVE) {
                throw new Exception();
            }
        }
        catch (Exception e) {
            throw new InvalidCardException();
        }
        User user = card.getOwner().getUser();
        if (this.isBlocked(card.getCardSecurityCodeBlockedUntil())) {
            throw new BlockedCredentialsException(Channel.Credentials.CARD_SECURITY_CODE, user);
        }
        if (!card.getCardType().isShowCardSecurityCode()) {
            securityCode = this.hashHandler.hash(user.getSalt(), securityCode);
        }
        if (StringUtils.isEmpty((String)(storedCode = card.getCardSecurityCode())) || !securityCode.equals(storedCode)) {
            CardType cardType = card.getCardType();
            int maxTries = cardType.getMaxSecurityCodeTries();
            this.wrongCredentialAttemptsDao.record(card);
            int wrongAttempts = this.wrongCredentialAttemptsDao.count(this.wrongAttemptsLimit(), card);
            if (wrongAttempts == maxTries) {
                this.memberNotificationHandler.blockedCredentialsNotification(user, Channel.Credentials.CARD_SECURITY_CODE);
                TimePeriod blockTime = cardType.getSecurityCodeBlockTime();
                card.setCardSecurityCodeBlockedUntil(blockTime.add(Calendar.getInstance()));
                this.wrongCredentialAttemptsDao.clear(card);
                throw new BlockedCredentialsException(Channel.Credentials.CARD_SECURITY_CODE, user);
            }
            throw new InvalidCredentialsException(Channel.Credentials.CARD_SECURITY_CODE, user);
        }
        this.wrongCredentialAttemptsDao.clear(card);
        return card;
    }

    private User checkPassword(User user, String plainPassword, String remoteAddress) {
        if (this.isBlocked((user = this.fetchService.fetch(user, RelationshipHelper.nested(User.Relationships.ELEMENT, Element.Relationships.GROUP))).getPasswordBlockedUntil())) {
            throw new BlockedCredentialsException(Channel.Credentials.LOGIN_PASSWORD, user);
        }
        String password = this.hashHandler.hash(user.getSalt(), plainPassword);
        String userPassword = user.getPassword();
        if (userPassword == null || !userPassword.equalsIgnoreCase(StringUtils.trimToNull((String)password))) {
            BasicGroupSettings basicSettings = user.getElement().getGroup().getBasicSettings();
            int maxTries = basicSettings.getMaxPasswordWrongTries();
            this.wrongCredentialAttemptsDao.record(user, Channel.Credentials.LOGIN_PASSWORD);
            int wrongAttempts = this.wrongCredentialAttemptsDao.count(this.wrongAttemptsLimit(), user, Channel.Credentials.LOGIN_PASSWORD);
            if (wrongAttempts == maxTries) {
                TimePeriod blockTime = basicSettings.getDeactivationAfterMaxPasswordTries();
                if (user instanceof AdminUser) {
                    this.alertService.create(SystemAlert.Alerts.ADMIN_LOGIN_BLOCKED_BY_TRIES, user.getUsername(), wrongAttempts, remoteAddress);
                } else if (user instanceof MemberUser) {
                    this.alertService.create(((MemberUser)user).getMember(), MemberAlert.Alerts.LOGIN_BLOCKED_BY_TRIES, wrongAttempts, remoteAddress);
                }
                this.memberNotificationHandler.blockedCredentialsNotification(user, Channel.Credentials.LOGIN_PASSWORD);
                user.setPasswordBlockedUntil(blockTime.add(Calendar.getInstance()));
                this.wrongCredentialAttemptsDao.clear(user, Channel.Credentials.LOGIN_PASSWORD);
                throw new BlockedCredentialsException(Channel.Credentials.LOGIN_PASSWORD, user);
            }
            throw new InvalidCredentialsException(Channel.Credentials.LOGIN_PASSWORD, user);
        }
        this.wrongCredentialAttemptsDao.clear(user, Channel.Credentials.LOGIN_PASSWORD);
        return user;
    }

    private MemberUser checkPin(MemberUser user, String plainPin, String channel, Member relatedMember) {
        if (this.isBlocked((user = this.fetchService.fetch(user, RelationshipHelper.nested(User.Relationships.ELEMENT, Element.Relationships.GROUP))).getPinBlockedUntil())) {
            throw new BlockedCredentialsException(Channel.Credentials.PIN, user);
        }
        Member member = user.getMember();
        String userPin = user.getPin();
        String pin = this.hashHandler.hash(user.getSalt(), plainPin);
        if (userPin == null || !userPin.equalsIgnoreCase(StringUtils.trimToNull((String)pin))) {
            MemberGroupSettings memberSettings = member.getMemberGroup().getMemberSettings();
            int maxTries = memberSettings.getMaxPinWrongTries();
            this.wrongCredentialAttemptsDao.record(user, Channel.Credentials.PIN);
            int wrongAttempts = this.wrongCredentialAttemptsDao.count(this.wrongAttemptsLimit(), user, Channel.Credentials.PIN);
            if (wrongAttempts == maxTries) {
                TimePeriod blockTime = memberSettings.getPinBlockTimeAfterMaxTries();
                String relatedUsername = relatedMember == null ? "" : relatedMember.getUsername();
                this.alertService.create(member, MemberAlert.Alerts.PIN_BLOCKED_BY_TRIES, maxTries, channel, relatedUsername);
                this.memberNotificationHandler.blockedCredentialsNotification(user, Channel.Credentials.PIN);
                user.setPinBlockedUntil(blockTime.add(Calendar.getInstance()));
                this.wrongCredentialAttemptsDao.clear(user, Channel.Credentials.PIN);
                throw new BlockedCredentialsException(Channel.Credentials.PIN, user);
            }
            throw new InvalidCredentialsException(Channel.Credentials.PIN, user);
        }
        this.wrongCredentialAttemptsDao.clear(user, Channel.Credentials.PIN);
        return user;
    }

    private User checkTransactionPassword(User user, String plainTransactionPassword, String remoteAddress) {
        if ((user = this.fetchService.fetch(user, RelationshipHelper.nested(User.Relationships.ELEMENT, Element.Relationships.GROUP))).getTransactionPasswordStatus().equals(User.TransactionPasswordStatus.BLOCKED)) {
            throw new BlockedCredentialsException(Channel.Credentials.TRANSACTION_PASSWORD, user);
        }
        String transactionPassword = this.hashHandler.hash(user.getSalt(), plainTransactionPassword == null ? null : plainTransactionPassword.toUpperCase());
        String userTransactionPassword = user.getTransactionPassword();
        if (userTransactionPassword == null || !userTransactionPassword.equalsIgnoreCase(transactionPassword)) {
            Group group = user.getElement().getGroup();
            BasicGroupSettings settings = group.getBasicSettings();
            int maxTries = settings.getMaxTransactionPasswordWrongTries();
            this.wrongCredentialAttemptsDao.record(user, Channel.Credentials.TRANSACTION_PASSWORD);
            int wrongAttempts = this.wrongCredentialAttemptsDao.count(this.wrongAttemptsLimit(), user, Channel.Credentials.TRANSACTION_PASSWORD);
            if (wrongAttempts == maxTries) {
                if (user instanceof AdminUser) {
                    this.alertService.create(SystemAlert.Alerts.ADMIN_TRANSACTION_PASSWORD_BLOCKED_BY_TRIES, user.getUsername(), wrongAttempts, remoteAddress);
                } else {
                    Member m = user instanceof MemberUser ? ((MemberUser)user).getMember() : ((OperatorUser)user).getOperator().getMember();
                    this.alertService.create(m, MemberAlert.Alerts.TRANSACTION_PASSWORD_BLOCKED_BY_TRIES, wrongAttempts, remoteAddress);
                    this.memberNotificationHandler.blockedCredentialsNotification(user, Channel.Credentials.TRANSACTION_PASSWORD);
                }
                ResetTransactionPasswordDTO dto = new ResetTransactionPasswordDTO();
                dto.setAllowGeneration(false);
                dto.setUser(user);
                this.resetTransactionPassword(dto);
                this.wrongCredentialAttemptsDao.clear(user, Channel.Credentials.TRANSACTION_PASSWORD);
                throw new BlockedCredentialsException(Channel.Credentials.TRANSACTION_PASSWORD, user);
            }
            throw new InvalidCredentialsException(Channel.Credentials.TRANSACTION_PASSWORD, user);
        }
        this.wrongCredentialAttemptsDao.clear(user, Channel.Credentials.TRANSACTION_PASSWORD);
        return user;
    }

    private TimePeriod getSessionTimeout(User user, boolean isPosWeb) {
        AccessSettings accessSettings = this.settingsService.getAccessSettings();
        TimePeriod sessionTimeout = isPosWeb ? accessSettings.getPoswebTimeout() : (user instanceof AdminUser ? accessSettings.getAdminTimeout() : accessSettings.getMemberTimeout());
        return sessionTimeout;
    }

    private boolean isBlocked(Calendar date) {
        return date != null && date.after(Calendar.getInstance());
    }

    private boolean isChannelEnabledForGroup(Channel channel, MemberGroup memberGroup) {
        memberGroup = this.fetchService.fetch(memberGroup, MemberGroup.Relationships.CHANNELS);
        return memberGroup.getChannels().contains(channel);
    }

    private User loadUser(String member, String username) {
        MemberUser memberUser;
        if (StringUtils.isEmpty((String)member)) {
            Object user = this.elementService.loadUser(username, FETCH);
            if (user instanceof OperatorUser) {
                throw new EntityNotFoundException(User.class);
            }
            return user;
        }
        Object loadedMember = this.elementService.loadUser(member, FETCH);
        try {
            memberUser = (MemberUser)loadedMember;
        }
        catch (ClassCastException e) {
            throw new EntityNotFoundException(MemberUser.class);
        }
        Member m = memberUser.getMember();
        OperatorUser user = this.elementService.loadOperatorUser(m, username, FETCH);
        user.getOperator().setMember(m);
        return user;
    }

    private boolean requestTransactionPassword(User user) {
        Group group = (user = this.fetchService.fetch(user, FETCH)).getElement().getGroup();
        if (group instanceof OperatorGroup) {
            group = this.fetchService.fetch(group, RelationshipHelper.nested(OperatorGroup.Relationships.MEMBER, Element.Relationships.GROUP));
        }
        BasicGroupSettings settings = group.getBasicSettings();
        return settings.getTransactionPassword().isUsed();
    }

    private ValidationError resolveValidationError(boolean loginPassword, boolean numeric, Element element, Object object, Object property, String credential) {
        AccessSettings accessSettings;
        String keyPrefix;
        RangeConstraint length;
        if (StringUtils.isEmpty((String)credential)) {
            return null;
        }
        Group group = this.fetchService.fetch(element.getGroup(), new Relationship[0]);
        BasicGroupSettings settings = group.getBasicSettings();
        if (loginPassword) {
            length = settings.getPasswordLength();
        } else {
            MemberGroup memberGroup = (MemberGroup)group;
            length = memberGroup.getMemberSettings().getPinLength();
        }
        ValidationError lengthResult = new LengthValidation(length).validate(object, property, credential);
        if (lengthResult != null) {
            return lengthResult;
        }
        String string = keyPrefix = loginPassword ? "changePassword.error." : "changePin.error.";
        if (numeric && !(group instanceof AdminGroup) && !StringUtils.isNumeric((String)credential)) {
            return new ValidationError(keyPrefix + "mustBeNumeric", new Object[0]);
        }
        if (loginPassword && !numeric && (accessSettings = this.settingsService.getAccessSettings()).isVirtualKeyboard() && StringHelper.hasSpecial(credential)) {
            return new ValidationError("changePassword.error.mustContainOnlyLettersOrNumbers", new Object[0]);
        }
        BasicGroupSettings.PasswordPolicy policy = settings.getPasswordPolicy();
        if (policy == null || policy == BasicGroupSettings.PasswordPolicy.NONE) {
            return null;
        }
        if (loginPassword && !numeric) {
            switch (policy) {
                case AVOID_OBVIOUS_LETTERS_NUMBERS: {
                    if (StringHelper.hasDigits(credential) && StringHelper.hasLetters(credential)) break;
                    return new ValidationError("changePassword.error.mustIncludeLettersNumbers", new Object[0]);
                }
                case AVOID_OBVIOUS_LETTERS_NUMBERS_SPECIAL: {
                    if (StringHelper.hasDigits(credential) && StringHelper.hasLetters(credential) && StringHelper.hasSpecial(credential)) break;
                    return new ValidationError("changePassword.error.mustIncludeLettersNumbersSpecial", new Object[0]);
                }
            }
        }
        if (this.isObviousCredential(element, credential)) {
            return new ValidationError(keyPrefix + "obvious", new Object[0]);
        }
        return null;
    }

    private void updateSessionExpiration(final Long id, final Calendar newExpiration) {
        this.transactionHelper.runAsync(new TransactionCallbackWithoutResult(){

            protected void doInTransactionWithoutResult(TransactionStatus status) {
                AccessServiceImpl.this.sessionDao.updateExpiration(id, newExpiration);
            }
        });
    }

    private final class PinValidation
    implements PropertyValidation {
        private final Member member;
        private static final long serialVersionUID = -4369049571487478881L;

        private PinValidation(Member member) {
            this.member = member;
        }

        @Override
        public ValidationError validate(Object object, Object property, Object value) {
            String loginPassword = (String)value;
            return AccessServiceImpl.this.resolveValidationError(false, true, this.member, object, property, loginPassword);
        }
    }

    private final class LoginPasswordValidation
    implements PropertyValidation {
        private final Element element;
        private static final long serialVersionUID = -4369049571487478881L;

        private LoginPasswordValidation(Element element) {
            this.element = element;
        }

        @Override
        public ValidationError validate(Object object, Object property, Object value) {
            String loginPassword = (String)value;
            AccessSettings accessSettings = AccessServiceImpl.this.settingsService.getAccessSettings();
            boolean numeric = accessSettings.isNumericPassword();
            return AccessServiceImpl.this.resolveValidationError(true, numeric, this.element, object, property, loginPassword);
        }
    }
}

