/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.services.access;

import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import nl.strohalm.cyclos.access.AdminAdminPermission;
import nl.strohalm.cyclos.access.AdminMemberPermission;
import nl.strohalm.cyclos.access.AdminSystemPermission;
import nl.strohalm.cyclos.access.BasicPermission;
import nl.strohalm.cyclos.access.BrokerPermission;
import nl.strohalm.cyclos.access.MemberPermission;
import nl.strohalm.cyclos.entities.Entity;
import nl.strohalm.cyclos.entities.access.Channel;
import nl.strohalm.cyclos.entities.access.MemberUser;
import nl.strohalm.cyclos.entities.access.Session;
import nl.strohalm.cyclos.entities.access.SessionQuery;
import nl.strohalm.cyclos.entities.access.User;
import nl.strohalm.cyclos.entities.accounts.cards.Card;
import nl.strohalm.cyclos.entities.exceptions.EntityNotFoundException;
import nl.strohalm.cyclos.entities.exceptions.UnexpectedEntityException;
import nl.strohalm.cyclos.entities.groups.Group;
import nl.strohalm.cyclos.entities.groups.GroupQuery;
import nl.strohalm.cyclos.entities.members.Element;
import nl.strohalm.cyclos.entities.members.Member;
import nl.strohalm.cyclos.entities.members.Operator;
import nl.strohalm.cyclos.exceptions.PermissionDeniedException;
import nl.strohalm.cyclos.services.BaseServiceSecurity;
import nl.strohalm.cyclos.services.access.AccessService;
import nl.strohalm.cyclos.services.access.AccessServiceLocal;
import nl.strohalm.cyclos.services.access.ChangeLoginPasswordDTO;
import nl.strohalm.cyclos.services.access.ChangePinDTO;
import nl.strohalm.cyclos.services.access.exceptions.BlockedCredentialsException;
import nl.strohalm.cyclos.services.access.exceptions.CredentialsAlreadyUsedException;
import nl.strohalm.cyclos.services.access.exceptions.InactiveMemberException;
import nl.strohalm.cyclos.services.access.exceptions.InvalidCardException;
import nl.strohalm.cyclos.services.access.exceptions.InvalidCredentialsException;
import nl.strohalm.cyclos.services.access.exceptions.NotConnectedException;
import nl.strohalm.cyclos.services.access.exceptions.SessionAlreadyInUseException;
import nl.strohalm.cyclos.services.access.exceptions.UserNotFoundException;
import nl.strohalm.cyclos.services.elements.ResetTransactionPasswordDTO;
import nl.strohalm.cyclos.services.groups.GroupServiceLocal;
import nl.strohalm.cyclos.utils.RelationshipHelper;
import nl.strohalm.cyclos.utils.access.LoggedUser;
import nl.strohalm.cyclos.utils.access.PermissionHelper;
import nl.strohalm.cyclos.utils.validation.ValidationException;
import org.apache.commons.collections.CollectionUtils;

public class AccessServiceSecurity
extends BaseServiceSecurity
implements AccessService {
    private AccessServiceLocal accessService;
    private GroupServiceLocal groupService;

    @Override
    public boolean canChangeChannelsAccess(Member member) {
        return this.accessService.canChangeChannelsAccess(member);
    }

    @Override
    public Member changeChannelsAccess(Member member, Collection<Channel> channels, boolean verifySmsChannel) {
        member = this.fetchService.fetch(member, Element.Relationships.GROUP);
        PermissionHelper.checkSelection(member.getMemberGroup().getChannels(), channels);
        if (!this.canChangeChannelsAccess(member)) {
            throw new PermissionDeniedException();
        }
        return this.accessService.changeChannelsAccess(member, channels, verifySmsChannel);
    }

    @Override
    public User changePassword(ChangeLoginPasswordDTO params) throws InvalidCredentialsException, BlockedCredentialsException, CredentialsAlreadyUsedException {
        this.checkChangePassword(params);
        return this.accessService.changePassword(params);
    }

    @Override
    public MemberUser changePin(ChangePinDTO params) throws InvalidCredentialsException, BlockedCredentialsException, CredentialsAlreadyUsedException {
        this.checkChangePin(params);
        return this.accessService.changePin(params);
    }

    @Override
    public MemberUser checkCredentials(Channel channel, MemberUser user, String credentials, String remoteAddress, Member relatedMember) throws InvalidCredentialsException, BlockedCredentialsException, InvalidCardException {
        return this.accessService.checkCredentials(channel, user, credentials, remoteAddress, relatedMember);
    }

    @Override
    public Session checkSession(String sessionId) throws NotConnectedException {
        return this.accessService.checkSession(sessionId);
    }

    @Override
    public User checkTransactionPassword(String transactionPassword) throws InvalidCredentialsException, BlockedCredentialsException {
        return this.accessService.checkTransactionPassword(transactionPassword);
    }

    @Override
    public User disconnect(Session session) throws NotConnectedException {
        try {
            session = this.fetchService.fetch(session, RelationshipHelper.nested(Session.Relationships.USER, User.Relationships.ELEMENT));
        }
        catch (EntityNotFoundException e) {
            throw new NotConnectedException();
        }
        Element element = session.getUser().getElement();
        this.checkDisconnect(element);
        this.accessService.disconnect(session);
        return session.getUser();
    }

    @Override
    public User disconnect(User user) throws NotConnectedException {
        user = this.fetchService.fetch(user, User.Relationships.ELEMENT);
        this.checkDisconnect(user.getElement());
        return this.accessService.disconnect(user);
    }

    @Override
    public String generateTransactionPassword() throws UnexpectedEntityException {
        return this.accessService.generateTransactionPassword();
    }

    @Override
    public Collection<Channel> getChannelsEnabledForMember(Member member) {
        this.permissionService.checkManages(member);
        return this.accessService.getChannelsEnabledForMember(member);
    }

    @Override
    public User getLoggedUser(String sessionId) throws NotConnectedException {
        User user = this.accessService.getLoggedUser(sessionId);
        this.permissionService.checkManages(user.getElement());
        return user;
    }

    @Override
    public boolean hasPasswordExpired() {
        return this.accessService.hasPasswordExpired();
    }

    @Override
    public boolean isCardSecurityCodeBlocked(Card card) {
        card = this.fetchService.fetch(card, Card.Relationships.OWNER);
        this.permissionService.permission(card.getOwner()).admin(AdminMemberPermission.CARDS_VIEW).broker(BrokerPermission.CARDS_VIEW).member(MemberPermission.CARDS_VIEW).check();
        return this.accessService.isCardSecurityCodeBlocked(card);
    }

    @Override
    public boolean isChannelEnabledForMember(Channel channel, Member member) {
        this.permissionService.checkRelatesTo(member);
        return this.accessService.isChannelEnabledForMember(channel, member);
    }

    @Override
    public boolean isChannelEnabledForMember(String channelInternalName, Member member) {
        this.permissionService.checkRelatesTo(member);
        return this.accessService.isChannelEnabledForMember(channelInternalName, member);
    }

    @Override
    public boolean isLoggedIn(User user) throws NotConnectedException {
        if (!this.permissionService.manages((user = this.fetchService.fetch(user, User.Relationships.ELEMENT)).getElement())) {
            return false;
        }
        return this.accessService.isLoggedIn(user);
    }

    @Override
    public boolean isLoginBlocked(User user) {
        if (!this.permissionService.manages((user = this.fetchService.fetch(user, User.Relationships.ELEMENT)).getElement())) {
            return false;
        }
        return this.accessService.isLoginBlocked(user);
    }

    @Override
    public boolean isPinBlocked(MemberUser user) {
        if (!this.permissionService.manages((user = this.fetchService.fetch(user, User.Relationships.ELEMENT)).getElement())) {
            return false;
        }
        return this.accessService.isPinBlocked(user);
    }

    @Override
    public User login(User user, String password, String channel, boolean isPosWeb, String remoteAddress, String sessionId) throws UserNotFoundException, InvalidCredentialsException, BlockedCredentialsException, SessionAlreadyInUseException {
        user = this.fetchService.fetch(user, RelationshipHelper.nested(User.Relationships.ELEMENT, Element.Relationships.GROUP));
        this.permissionService.permission(user.getElement().getGroup()).basic(BasicPermission.BASIC_LOGIN).check();
        return this.accessService.login(user, password, channel, isPosWeb, remoteAddress, sessionId);
    }

    @Override
    public User logout(String sessionId) {
        return this.accessService.logout(sessionId);
    }

    @Override
    public boolean notifyPermissionDeniedException() {
        return this.accessService.notifyPermissionDeniedException();
    }

    @Override
    public User reenableLogin(User user) {
        if ((user = this.fetchService.fetch(user, RelationshipHelper.nested(User.Relationships.ELEMENT, Element.Relationships.GROUP))).getElement().getGroup().isRemoved()) {
            throw new PermissionDeniedException();
        }
        this.permissionService.permission(user.getElement()).admin(AdminAdminPermission.ACCESS_ENABLE_LOGIN, AdminMemberPermission.ACCESS_ENABLE_LOGIN).member(MemberPermission.OPERATORS_MANAGE).check();
        return this.accessService.reenableLogin(user);
    }

    @Override
    public MemberUser resetPassword(MemberUser user) {
        user = this.fetchService.fetch(user, User.Relationships.ELEMENT);
        this.permissionService.permission(user.getElement()).admin(AdminMemberPermission.ACCESS_RESET_PASSWORD).broker(BrokerPermission.MEMBER_ACCESS_RESET_PASSWORD).check();
        return this.accessService.resetPassword(user);
    }

    @Override
    public User resetTransactionPassword(ResetTransactionPasswordDTO dto) {
        User user = this.fetchService.fetch(dto.getUser(), User.Relationships.ELEMENT);
        dto.setUser(user);
        this.permissionService.permission(user.getElement()).admin(AdminAdminPermission.ACCESS_TRANSACTION_PASSWORD, AdminMemberPermission.ACCESS_TRANSACTION_PASSWORD).broker(BrokerPermission.MEMBER_ACCESS_TRANSACTION_PASSWORD).member(MemberPermission.OPERATORS_MANAGE).check();
        return this.accessService.resetTransactionPassword(dto);
    }

    @Override
    public List<Session> searchSessions(SessionQuery query) {
        if (LoggedUser.isAdministrator()) {
            Collection<Group.Nature> natures = query.getNatures();
            if (CollectionUtils.isEmpty(natures)) {
                natures = EnumSet.allOf(Group.Nature.class);
            }
            if (!this.permissionService.hasPermission(AdminSystemPermission.STATUS_VIEW_CONNECTED_ADMINS)) {
                natures.remove((Object)Group.Nature.ADMIN);
            }
            if (!this.permissionService.hasPermission(AdminSystemPermission.STATUS_VIEW_CONNECTED_MEMBERS)) {
                natures.remove((Object)Group.Nature.MEMBER);
            }
            if (!this.permissionService.hasPermission(AdminSystemPermission.STATUS_VIEW_CONNECTED_BROKERS)) {
                natures.remove((Object)Group.Nature.BROKER);
            }
            if (!this.permissionService.hasPermission(AdminSystemPermission.STATUS_VIEW_CONNECTED_OPERATORS)) {
                natures.remove((Object)Group.Nature.OPERATOR);
            }
            if (natures.isEmpty()) {
                throw new PermissionDeniedException();
            }
            HashSet<Group> allowedGroups = new HashSet<Group>();
            allowedGroups.addAll(this.permissionService.getVisibleMemberGroups());
            if (natures.contains((Object)Group.Nature.ADMIN)) {
                GroupQuery admins = new GroupQuery();
                admins.setNatures(Group.Nature.ADMIN);
                allowedGroups.addAll(this.groupService.search(admins));
            }
            if (natures.contains((Object)Group.Nature.OPERATOR)) {
                GroupQuery operators = new GroupQuery();
                operators.setIgnoreManagedBy(true);
                operators.setNatures(Group.Nature.OPERATOR);
                allowedGroups.addAll(this.groupService.search(operators));
            }
            query.setGroups(PermissionHelper.checkSelection(allowedGroups, query.getGroups()));
        } else {
            this.permissionService.permission(query.getMember()).member(MemberPermission.OPERATORS_MANAGE).check();
        }
        return this.accessService.searchSessions(query);
    }

    public void setAccessServiceLocal(AccessServiceLocal accessService) {
        this.accessService = accessService;
    }

    public void setGroupServiceLocal(GroupServiceLocal groupService) {
        this.groupService = groupService;
    }

    @Override
    public MemberUser unblockPin(MemberUser user) {
        user = this.fetchService.fetch(user, User.Relationships.ELEMENT);
        this.permissionService.permission(user.getElement()).admin(AdminMemberPermission.ACCESS_UNBLOCK_PIN).broker(BrokerPermission.MEMBER_ACCESS_CHANGE_PIN).member(MemberPermission.ACCESS_UNBLOCK_PIN).check();
        return this.accessService.unblockPin(user);
    }

    @Override
    public void validateChangePassword(ChangeLoginPasswordDTO params) throws ValidationException {
        this.checkChangePassword(params);
        this.accessService.validateChangePassword(params);
    }

    @Override
    public void validateChangePin(ChangePinDTO params) throws ValidationException {
        this.checkChangePin(params);
        this.accessService.validateChangePin(params);
    }

    @Override
    public User verifyLogin(String member, String username, String remoteAddress) throws UserNotFoundException, InactiveMemberException, PermissionDeniedException {
        return this.accessService.verifyLogin(member, username, remoteAddress);
    }

    private void checkChangePassword(ChangeLoginPasswordDTO params) {
        User user = this.fetchService.fetch(params.getUser(), RelationshipHelper.nested(User.Relationships.ELEMENT, Element.Relationships.GROUP));
        params.setUser(user);
        if (((Entity)LoggedUser.user()).equals(user)) {
            return;
        }
        if (user.getElement().getGroup().isRemoved()) {
            throw new PermissionDeniedException();
        }
        this.permissionService.permission(user.getElement()).admin(AdminAdminPermission.ACCESS_CHANGE_PASSWORD, AdminMemberPermission.ACCESS_CHANGE_PASSWORD).broker(BrokerPermission.MEMBER_ACCESS_CHANGE_PASSWORD).member(MemberPermission.OPERATORS_MANAGE).check();
    }

    private void checkChangePin(ChangePinDTO params) {
        MemberUser user = this.fetchService.fetch(params.getUser(), User.Relationships.ELEMENT);
        params.setUser(user);
        this.permissionService.permission(user.getElement()).admin(AdminMemberPermission.ACCESS_CHANGE_PIN).broker(BrokerPermission.MEMBER_ACCESS_CHANGE_PIN).member(new MemberPermission[0]).check();
    }

    private void checkDisconnect(Element element) {
        if (LoggedUser.isAdministrator() && element instanceof Operator) {
            Operator operator = (Operator)element;
            this.permissionService.permission(operator.getMember()).admin(AdminMemberPermission.ACCESS_DISCONNECT_OPERATOR).check();
        } else {
            this.permissionService.permission(element).admin(AdminAdminPermission.ACCESS_DISCONNECT, AdminMemberPermission.ACCESS_DISCONNECT).member(MemberPermission.OPERATORS_MANAGE).check();
        }
    }
}

