/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.services.access;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import nl.strohalm.cyclos.dao.access.ChannelDAO;
import nl.strohalm.cyclos.dao.access.ChannelPrincipalDAO;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.access.Channel;
import nl.strohalm.cyclos.entities.access.ChannelPrincipal;
import nl.strohalm.cyclos.entities.access.PrincipalType;
import nl.strohalm.cyclos.entities.customization.fields.CustomField;
import nl.strohalm.cyclos.entities.customization.fields.MemberCustomField;
import nl.strohalm.cyclos.entities.exceptions.EntityNotFoundException;
import nl.strohalm.cyclos.services.InitializingService;
import nl.strohalm.cyclos.services.access.ChannelServiceLocal;
import nl.strohalm.cyclos.services.customization.MemberCustomFieldServiceLocal;
import nl.strohalm.cyclos.services.fetch.FetchServiceLocal;
import nl.strohalm.cyclos.services.settings.SettingsServiceLocal;
import nl.strohalm.cyclos.services.transactions.PaymentRequestHandler;
import nl.strohalm.cyclos.utils.CustomFieldHelper;
import nl.strohalm.cyclos.utils.cache.Cache;
import nl.strohalm.cyclos.utils.cache.CacheCallback;
import nl.strohalm.cyclos.utils.cache.CacheListener;
import nl.strohalm.cyclos.utils.cache.CacheManager;
import nl.strohalm.cyclos.utils.validation.InvalidError;
import nl.strohalm.cyclos.utils.validation.PropertyValidation;
import nl.strohalm.cyclos.utils.validation.RequiredError;
import nl.strohalm.cyclos.utils.validation.ValidationError;
import nl.strohalm.cyclos.utils.validation.ValidationException;
import nl.strohalm.cyclos.utils.validation.Validator;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.InitializingBean;

public class ChannelServiceImpl
implements ChannelServiceLocal,
InitializingBean,
InitializingService {
    private static final String ALL_KEY = "_ALL_";
    private FetchServiceLocal fetchService;
    private ChannelDAO channelDao;
    private ChannelPrincipalDAO channelPrincipalDao;
    private MemberCustomFieldServiceLocal memberCustomFieldService;
    private SettingsServiceLocal settingsService;
    private CacheManager cacheManager;
    private PaymentRequestHandler paymentRequestHandler;
    private CustomFieldHelper customFieldHelper;

    public void afterPropertiesSet() throws Exception {
        this.getCache().addListener(new CacheListener(){

            @Override
            public void onCacheCleared(Cache cache) {
                ChannelServiceImpl.this.paymentRequestHandler.invalidateCache();
            }

            @Override
            public void onValueAdded(Cache cache, Serializable key, Object value) {
                ChannelServiceImpl.this.paymentRequestHandler.invalidateCache();
            }

            @Override
            public void onValueRemoved(Cache cache, Serializable key, Object value) {
                ChannelServiceImpl.this.paymentRequestHandler.invalidateCache();
            }
        });
    }

    @Override
    public boolean allowsPaymentRequest(String channel) {
        return !this.isBuiltin(channel);
    }

    @Override
    public Set<Channel.Credentials> getPossibleCredentials(Channel channel) {
        String internalName = channel.getInternalName();
        if ("web".equals(internalName)) {
            return EnumSet.of(Channel.Credentials.DEFAULT);
        }
        if (Arrays.asList("wap1", "wap2", "webshop").contains(internalName)) {
            return EnumSet.of(Channel.Credentials.DEFAULT, Channel.Credentials.LOGIN_PASSWORD, Channel.Credentials.TRANSACTION_PASSWORD, Channel.Credentials.PIN);
        }
        if ("rest".equals(internalName)) {
            return EnumSet.of(Channel.Credentials.DEFAULT, Channel.Credentials.LOGIN_PASSWORD, Channel.Credentials.TRANSACTION_PASSWORD, Channel.Credentials.PIN, Channel.Credentials.CARD_SECURITY_CODE);
        }
        return EnumSet.of(Channel.Credentials.LOGIN_PASSWORD, Channel.Credentials.TRANSACTION_PASSWORD, Channel.Credentials.PIN, Channel.Credentials.CARD_SECURITY_CODE);
    }

    @Override
    public Channel getSmsChannel() {
        String name = this.settingsService.getLocalSettings().getSmsChannelName();
        return StringUtils.isEmpty((String)name) ? null : this.loadByInternalName(name);
    }

    @Override
    public void initializeService() {
        Locale locale = this.settingsService.getLocalSettings().getLocale();
        this.channelDao.importNewBuiltin(locale);
    }

    @Override
    public boolean isBuiltin(String channel) {
        try {
            return Channel.listBuiltin().contains(channel);
        }
        catch (RuntimeException e) {
            return false;
        }
    }

    @Override
    public List<Channel> list() {
        return (List)this.getCache().get((Serializable)((Object)ALL_KEY), new CacheCallback(){

            @Override
            public Object retrieve() {
                return ChannelServiceImpl.this.channelDao.listAll(Channel.Relationships.PRINCIPALS);
            }
        });
    }

    @Override
    public List<Channel> listBuiltin() {
        return this.filterChannels(true);
    }

    @Override
    public List<Channel> listExternal() {
        List<Channel> channels = this.list();
        channels.remove(this.loadByInternalName("web"));
        return channels;
    }

    @Override
    public List<Channel> listNonBuiltin() {
        return this.filterChannels(false);
    }

    @Override
    public List<Channel> listSupportingPaymentRequest() {
        ArrayList<Channel> channels = new ArrayList<Channel>();
        for (Channel channel : this.list()) {
            if (!channel.isPaymentRequestSupported()) continue;
            channels.add(channel);
        }
        return channels;
    }

    @Override
    public Channel load(final Long id) throws EntityNotFoundException {
        return (Channel)this.getCache().get(id, new CacheCallback(){

            @Override
            public Object retrieve() {
                Channel channel = (Channel)ChannelServiceImpl.this.channelDao.load(id, Channel.Relationships.PRINCIPALS);
                channel.setPrincipals(ChannelServiceImpl.this.fetchService.fetch(channel.getPrincipals(), new Relationship[]{ChannelPrincipal.Relationships.CUSTOM_FIELD}));
                return channel;
            }
        });
    }

    @Override
    public Collection<Channel> load(Long[] ids) {
        return this.channelDao.load(Arrays.asList(ids), new Relationship[0]);
    }

    @Override
    public Channel loadByInternalName(final String name) throws EntityNotFoundException {
        return (Channel)this.getCache().get((Serializable)((Object)name), new CacheCallback(){

            @Override
            public Object retrieve() {
                Channel channel = ChannelServiceImpl.this.channelDao.loadByInternalName(name, Channel.Relationships.PRINCIPALS);
                channel.setPrincipals(ChannelServiceImpl.this.fetchService.fetch(channel.getPrincipals(), new Relationship[]{ChannelPrincipal.Relationships.CUSTOM_FIELD}));
                return channel;
            }
        });
    }

    @Override
    public List<MemberCustomField> possibleCustomFieldsAsPrincipal() {
        List allMemberFields = this.memberCustomFieldService.list();
        ArrayList<MemberCustomField> possible = new ArrayList<MemberCustomField>();
        for (MemberCustomField field : allMemberFields) {
            if (field.getType() != CustomField.Type.STRING || !field.getValidation().isUnique()) continue;
            possible.add(field);
        }
        return possible;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int remove(Long ... ids) {
        try {
            int n = this.channelDao.delete(ids);
            return n;
        }
        finally {
            this.getCache().clear();
        }
    }

    @Override
    public PrincipalType resolvePrincipalType(String principalTypeString) {
        PrincipalType principalType;
        block3: {
            principalType = null;
            try {
                Channel.Principal principal = Channel.Principal.valueOf(principalTypeString);
                if (principal != Channel.Principal.CUSTOM_FIELD) {
                    principalType = new PrincipalType(principal);
                }
            }
            catch (Exception e) {
                List<MemberCustomField> possibleFields = this.possibleCustomFieldsAsPrincipal();
                MemberCustomField customField = this.customFieldHelper.findByInternalName(possibleFields, principalTypeString);
                if (customField == null) break block3;
                principalType = new PrincipalType(customField);
            }
        }
        return principalType;
    }

    @Override
    public PrincipalType resolvePrincipalType(String channelName, String principalTypeString) {
        Channel channel = this.loadByInternalName(channelName);
        PrincipalType principalType = this.resolvePrincipalType(principalTypeString);
        if (!channel.getPrincipalTypes().contains(principalType)) {
            principalType = channel.getDefaultPrincipalType();
        }
        return principalType == null ? Channel.DEFAULT_PRINCIPAL_TYPE : principalType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Channel save(Channel channel) {
        Set<Channel.Credentials> possibleCredentials;
        this.validate(channel);
        Collection<ChannelPrincipal> principals = channel.getPrincipals();
        boolean hasDefault = false;
        ChannelPrincipal user = null;
        for (ChannelPrincipal channelPrincipal : principals) {
            if (channelPrincipal.getPrincipal() == Channel.Principal.USER) {
                user = channelPrincipal;
            }
            if (!channelPrincipal.isDefault()) continue;
            hasDefault = true;
        }
        if (!hasDefault) {
            if (user != null) {
                user.setDefault(true);
            } else {
                principals.iterator().next().setDefault(true);
            }
        }
        if ("web".equals(channel.getInternalName()) && user == null) {
            user = new ChannelPrincipal();
            user.setChannel(channel);
            user.setPrincipal(Channel.Principal.USER);
            principals.add(user);
        }
        if (!(possibleCredentials = this.getPossibleCredentials(channel)).contains(channel.getCredentials())) {
            channel.setCredentials(possibleCredentials.iterator().next());
        }
        try {
            if (channel.isTransient()) {
                if (this.channelDao.existsChannel(channel.getInternalName())) throw new ValidationException("channel.internalNameAlreadyInUse", new Object[0]);
                channel = this.channelDao.insert(channel);
            } else {
                Channel current = (Channel)this.channelDao.load(channel.getId(), new Relationship[0]);
                String internalName = current.getInternalName();
                if (!this.allowsPaymentRequest(internalName)) {
                    channel.setPaymentRequestWebServiceUrl(null);
                }
                channel.setPrincipals(null);
                channel = this.channelDao.update(channel);
                this.channelPrincipalDao.deleteAllFrom(channel);
            }
            for (ChannelPrincipal channelPrincipal : principals) {
                this.channelPrincipalDao.insert(channelPrincipal);
            }
            return channel;
        }
        finally {
            this.getCache().clear();
        }
    }

    public void setCacheManager(CacheManager cacheManager) {
        this.cacheManager = cacheManager;
    }

    public void setChannelDao(ChannelDAO channelDao) {
        this.channelDao = channelDao;
    }

    public void setChannelPrincipalDao(ChannelPrincipalDAO channelPrincipalDao) {
        this.channelPrincipalDao = channelPrincipalDao;
    }

    public void setCustomFieldHelper(CustomFieldHelper customFieldHelper) {
        this.customFieldHelper = customFieldHelper;
    }

    public void setFetchServiceLocal(FetchServiceLocal fetchService) {
        this.fetchService = fetchService;
    }

    public void setMemberCustomFieldServiceLocal(MemberCustomFieldServiceLocal memberCustomFieldService) {
        this.memberCustomFieldService = memberCustomFieldService;
    }

    public void setPaymentRequestHandler(PaymentRequestHandler paymentRequestHandler) {
        this.paymentRequestHandler = paymentRequestHandler;
    }

    public void setSettingsServiceLocal(SettingsServiceLocal settingsService) {
        this.settingsService = settingsService;
    }

    @Override
    public void validate(Channel channel) throws ValidationException {
        Validator validator = new Validator("channel");
        validator.property("internalName").required().maxLength(50);
        validator.property("displayName").required().maxLength(100);
        validator.property("principals").required().add(new PropertyValidation(){
            private static final long serialVersionUID = -2500914238715839704L;

            @Override
            public ValidationError validate(Object object, Object property, Object value) {
                Collection principals = (Collection)value;
                if (CollectionUtils.isEmpty((Collection)principals)) {
                    return null;
                }
                for (ChannelPrincipal channelPrincipal : principals) {
                    if (channelPrincipal.getPrincipal() == null) {
                        return new RequiredError(new Object[0]);
                    }
                    if (channelPrincipal.getPrincipal() != Channel.Principal.CUSTOM_FIELD) continue;
                    MemberCustomField customField = ChannelServiceImpl.this.fetchService.fetch(channelPrincipal.getCustomField(), new Relationship[0]);
                    if (customField == null) {
                        return new RequiredError(new Object[0]);
                    }
                    if (customField.getType() != CustomField.Type.STRING) {
                        return new InvalidError();
                    }
                    if (customField.getValidation().isUnique()) continue;
                    return new InvalidError();
                }
                return null;
            }
        });
        Set<Channel.Credentials> possibleCredentials = this.getPossibleCredentials(channel);
        if (channel.getDefaultPrincipalType().getPrincipal() != Channel.Principal.CARD) {
            possibleCredentials.remove(Channel.Credentials.CARD_SECURITY_CODE);
        }
        if (possibleCredentials.size() > 1) {
            validator.property("credentials").required().anyOf(possibleCredentials);
        }
        validator.validate(channel);
    }

    private List<Channel> filterChannels(boolean builtin) {
        List<Channel> channels = this.list();
        Iterator<Channel> iterator = channels.iterator();
        while (iterator.hasNext()) {
            Channel channel = iterator.next();
            if ((!builtin || this.isBuiltin(channel.getInternalName())) && (builtin || !this.isBuiltin(channel.getInternalName()))) continue;
            iterator.remove();
        }
        return channels;
    }

    private Cache getCache() {
        return this.cacheManager.getCache("cyclos.Channels");
    }
}

