/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.services.access;

import java.util.List;
import java.util.Set;
import nl.strohalm.cyclos.access.AdminMemberPermission;
import nl.strohalm.cyclos.access.AdminSystemPermission;
import nl.strohalm.cyclos.access.BrokerPermission;
import nl.strohalm.cyclos.access.MemberPermission;
import nl.strohalm.cyclos.entities.access.Channel;
import nl.strohalm.cyclos.entities.access.PrincipalType;
import nl.strohalm.cyclos.entities.customization.fields.MemberCustomField;
import nl.strohalm.cyclos.entities.exceptions.EntityNotFoundException;
import nl.strohalm.cyclos.services.BaseServiceSecurity;
import nl.strohalm.cyclos.services.access.ChannelService;
import nl.strohalm.cyclos.services.access.ChannelServiceLocal;
import nl.strohalm.cyclos.utils.validation.ValidationException;

public class ChannelServiceSecurity
extends BaseServiceSecurity
implements ChannelService {
    private ChannelServiceLocal channelService;

    @Override
    public boolean allowsPaymentRequest(String channel) {
        this.permissionService.permission().admin(AdminSystemPermission.CHANNELS_VIEW).check();
        return this.channelService.allowsPaymentRequest(channel);
    }

    @Override
    public Set<Channel.Credentials> getPossibleCredentials(Channel channel) {
        this.permissionService.permission().admin(AdminSystemPermission.CHANNELS_VIEW).check();
        return this.channelService.getPossibleCredentials(channel);
    }

    @Override
    public Channel getSmsChannel() {
        this.permissionService.permission().admin(AdminSystemPermission.CHANNELS_VIEW, AdminMemberPermission.PREFERENCES_MANAGE_NOTIFICATIONS, AdminMemberPermission.ACCESS_CHANGE_CHANNELS_ACCESS).member(new MemberPermission[0]).broker(BrokerPermission.MEMBER_ACCESS_CHANGE_CHANNELS_ACCESS, BrokerPermission.PREFERENCES_MANAGE_NOTIFICATIONS).check();
        return this.channelService.getSmsChannel();
    }

    @Override
    public boolean isBuiltin(String channel) {
        this.permissionService.permission().admin(AdminSystemPermission.CHANNELS_VIEW).check();
        return this.channelService.isBuiltin(channel);
    }

    @Override
    public List<Channel> list() {
        this.permissionService.permission().admin(AdminMemberPermission.BULK_ACTIONS_CHANGE_CHANNELS, AdminSystemPermission.CHANNELS_VIEW, AdminSystemPermission.GROUPS_MANAGE_MEMBER, AdminSystemPermission.GROUPS_MANAGE_BROKER, AdminSystemPermission.ACCOUNTS_MANAGE).check();
        return this.channelService.list();
    }

    @Override
    public List<Channel> listBuiltin() {
        this.permissionService.permission().admin(AdminSystemPermission.CHANNELS_VIEW, AdminSystemPermission.SETTINGS_VIEW).check();
        return this.channelService.listBuiltin();
    }

    @Override
    public List<Channel> listNonBuiltin() {
        this.permissionService.permission().admin(AdminSystemPermission.CHANNELS_VIEW, AdminSystemPermission.SETTINGS_VIEW).check();
        return this.channelService.listNonBuiltin();
    }

    @Override
    public Channel load(Long id) throws EntityNotFoundException {
        this.permissionService.permission().admin(AdminSystemPermission.CHANNELS_VIEW).check();
        return this.channelService.load(id);
    }

    @Override
    public Channel loadByInternalName(String name) throws EntityNotFoundException {
        return this.channelService.loadByInternalName(name);
    }

    @Override
    public List<MemberCustomField> possibleCustomFieldsAsPrincipal() {
        this.permissionService.permission().admin(AdminSystemPermission.CHANNELS_VIEW, AdminSystemPermission.SETTINGS_VIEW).check();
        return this.channelService.possibleCustomFieldsAsPrincipal();
    }

    @Override
    public int remove(Long ... ids) {
        this.permissionService.permission().admin(AdminSystemPermission.CHANNELS_MANAGE).check();
        return this.channelService.remove(ids);
    }

    @Override
    public PrincipalType resolvePrincipalType(String principalType) {
        this.permissionService.permission().admin(AdminSystemPermission.CHANNELS_MANAGE).check();
        return this.channelService.resolvePrincipalType(principalType);
    }

    @Override
    public PrincipalType resolvePrincipalType(String channelName, String principalType) {
        return this.channelService.resolvePrincipalType(channelName, principalType);
    }

    @Override
    public Channel save(Channel channel) {
        this.permissionService.permission().admin(AdminSystemPermission.CHANNELS_MANAGE).check();
        return this.channelService.save(channel);
    }

    public void setChannelServiceLocal(ChannelServiceLocal channelService) {
        this.channelService = channelService;
    }

    @Override
    public void validate(Channel channel) throws ValidationException {
        this.channelService.validate(channel);
    }
}

