/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.services.accountfees;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import nl.strohalm.cyclos.dao.accounts.AccountDAO;
import nl.strohalm.cyclos.dao.accounts.AccountDailyDifference;
import nl.strohalm.cyclos.dao.accounts.fee.account.AccountFeeDAO;
import nl.strohalm.cyclos.dao.accounts.fee.account.AccountFeeLogDAO;
import nl.strohalm.cyclos.dao.accounts.fee.account.MemberAccountFeeLogDAO;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.accounts.AccountStatus;
import nl.strohalm.cyclos.entities.accounts.AccountType;
import nl.strohalm.cyclos.entities.accounts.MemberAccount;
import nl.strohalm.cyclos.entities.accounts.MemberAccountType;
import nl.strohalm.cyclos.entities.accounts.fees.account.AccountFee;
import nl.strohalm.cyclos.entities.accounts.fees.account.AccountFeeLog;
import nl.strohalm.cyclos.entities.accounts.fees.account.AccountFeeLogDetailsDTO;
import nl.strohalm.cyclos.entities.accounts.fees.account.AccountFeeLogQuery;
import nl.strohalm.cyclos.entities.accounts.fees.account.AccountFeeQuery;
import nl.strohalm.cyclos.entities.accounts.fees.account.MemberAccountFeeLog;
import nl.strohalm.cyclos.entities.accounts.fees.account.MemberAccountFeeLogQuery;
import nl.strohalm.cyclos.entities.accounts.transactions.Invoice;
import nl.strohalm.cyclos.entities.accounts.transactions.Transfer;
import nl.strohalm.cyclos.entities.exceptions.UnexpectedEntityException;
import nl.strohalm.cyclos.entities.groups.MemberGroup;
import nl.strohalm.cyclos.entities.members.Member;
import nl.strohalm.cyclos.entities.settings.LocalSettings;
import nl.strohalm.cyclos.scheduling.polling.ChargeAccountFeePollingTask;
import nl.strohalm.cyclos.services.InitializingService;
import nl.strohalm.cyclos.services.accountfees.AccountFeeServiceLocal;
import nl.strohalm.cyclos.services.accounts.AccountDTO;
import nl.strohalm.cyclos.services.accounts.AccountDateDTO;
import nl.strohalm.cyclos.services.accounts.AccountServiceLocal;
import nl.strohalm.cyclos.services.application.ApplicationServiceLocal;
import nl.strohalm.cyclos.services.fetch.FetchServiceLocal;
import nl.strohalm.cyclos.services.settings.SettingsServiceLocal;
import nl.strohalm.cyclos.services.transactions.PaymentServiceLocal;
import nl.strohalm.cyclos.services.transactions.TransactionSummaryVO;
import nl.strohalm.cyclos.utils.BigDecimalHelper;
import nl.strohalm.cyclos.utils.DataIteratorHelper;
import nl.strohalm.cyclos.utils.DateHelper;
import nl.strohalm.cyclos.utils.FormatObject;
import nl.strohalm.cyclos.utils.Pair;
import nl.strohalm.cyclos.utils.Period;
import nl.strohalm.cyclos.utils.RelationshipHelper;
import nl.strohalm.cyclos.utils.TimePeriod;
import nl.strohalm.cyclos.utils.cache.Cache;
import nl.strohalm.cyclos.utils.cache.CacheCallback;
import nl.strohalm.cyclos.utils.cache.CacheManager;
import nl.strohalm.cyclos.utils.query.IteratorList;
import nl.strohalm.cyclos.utils.query.PageHelper;
import nl.strohalm.cyclos.utils.query.QueryParameters;
import nl.strohalm.cyclos.utils.validation.ValidationException;
import nl.strohalm.cyclos.utils.validation.Validator;
import org.apache.commons.lang.time.DateUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AccountFeeServiceImpl
implements AccountFeeServiceLocal,
InitializingService {
    private static int ACCOUNT_FEE_CHARGE_BATCH_SIZE = 20;
    private static final Log LOG = LogFactory.getLog(AccountFeeServiceImpl.class);
    private AccountFeeDAO accountFeeDao;
    private AccountFeeLogDAO accountFeeLogDao;
    private AccountDAO accountDao;
    private FetchServiceLocal fetchService;
    private AccountServiceLocal accountService;
    private MemberAccountFeeLogDAO memberAccountFeeLogDao;
    private CacheManager cacheManager;
    private SettingsServiceLocal settingsService;
    private PaymentServiceLocal paymentService;
    private ApplicationServiceLocal applicationService;

    @Override
    public BigDecimal calculateAmount(AccountFeeLog feeLog, Member member) {
        AccountFee fee = feeLog.getAccountFee();
        if (!fee.getGroups().contains(member.getGroup())) {
            return null;
        }
        Period period = feeLog.getPeriod();
        MemberAccountType accountType = fee.getAccountType();
        AccountFee.ChargeMode chargeMode = fee.getChargeMode();
        BigDecimal freeBase = fee.getFreeBase();
        BigDecimal chargedAmount = BigDecimal.ZERO;
        BigDecimal amount = BigDecimal.ZERO;
        Calendar endDate = period != null ? period.getEnd() : null;
        AccountDateDTO balanceParams = new AccountDateDTO(member, accountType, endDate);
        if (chargeMode.isFixed()) {
            BigDecimal balance;
            boolean charge = true;
            if (freeBase != null && (balance = this.accountService.getBalance(balanceParams)).compareTo(freeBase) <= 0) {
                charge = false;
            }
            if (charge) {
                amount = feeLog.getAmount();
            }
        } else if (chargeMode.isBalance()) {
            boolean positiveBalance = !chargeMode.isNegative();
            BigDecimal balance = this.accountService.getBalance(balanceParams);
            boolean charge = true;
            if (freeBase != null) {
                balance = positiveBalance ? balance.subtract(freeBase) : balance.add(freeBase);
            }
            if (positiveBalance && balance.compareTo(BigDecimal.ZERO) <= 0 || !positiveBalance && balance.compareTo(BigDecimal.ZERO) >= 0) {
                charge = false;
            }
            if (charge) {
                chargedAmount = feeLog.getAmountValue().apply(balance.abs());
                amount = this.settingsService.getLocalSettings().round(chargedAmount);
            }
        } else if (chargeMode.isVolume()) {
            amount = this.calculateChargeOverTransactionedVolume(feeLog, member);
        }
        BigDecimal minPayment = this.paymentService.getMinimumPayment();
        if (amount.compareTo(minPayment) < 0) {
            amount = BigDecimal.ZERO;
        }
        return amount;
    }

    @Override
    public BigDecimal calculateReservedAmountForVolumeFee(MemberAccount account) {
        MemberGroup group = (MemberGroup)this.fetchService.fetch(account.getMember().getGroup(), new Relationship[0]);
        AccountFee volumeFee = this.getVolumeFee(account.getType(), group);
        if (volumeFee == null) {
            return BigDecimal.ZERO;
        }
        AccountFeeLog lastCharged = this.memberAccountFeeLogDao.getLastChargedLog(account.getMember(), volumeFee);
        Calendar fromDate = lastCharged == null || lastCharged.getDate().before(volumeFee.getEnabledSince()) ? (account.getCreationDate().after(volumeFee.getEnabledSince()) ? account.getCreationDate() : volumeFee.getEnabledSince()) : lastCharged.getPeriod().getEnd();
        fromDate = DateHelper.truncateNextDay(fromDate);
        TimePeriod recurrence = volumeFee.getRecurrence();
        BigDecimal result = BigDecimal.ZERO;
        Calendar now = Calendar.getInstance();
        boolean done = false;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Getting current status for " + account));
        }
        while (!done) {
            Period period = recurrence.currentPeriod(fromDate);
            if (!period.getEnd().after(now)) {
                period.setBegin(fromDate);
                fromDate = DateHelper.truncateNextDay(period.getEnd());
            } else {
                period = Period.between(fromDate, DateHelper.truncate(now));
                done = true;
            }
            BigDecimal chargeForPeriod = this.calculateVolumeCharge(account, volumeFee, period, result, done);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Charge for period " + FormatObject.formatObject(period.getBegin()) + "\t" + FormatObject.formatObject(period.getEnd()) + "\t" + chargeForPeriod));
            }
            result = result.add(chargeForPeriod);
        }
        return result;
    }

    @Override
    public void chargeManual(AccountFee fee) {
        if (fee == null || fee.isTransient()) {
            throw new UnexpectedEntityException();
        }
        if ((fee = this.fetchService.fetch(fee, RelationshipHelper.nested(AccountFee.Relationships.ACCOUNT_TYPE, AccountType.Relationships.CURRENCY), AccountFee.Relationships.TRANSFER_TYPE)).getRunMode() != AccountFee.RunMode.MANUAL) {
            throw new UnexpectedEntityException();
        }
        this.insertNextExecution(fee);
        this.applicationService.awakePollingTaskOnTransactionCommit(ChargeAccountFeePollingTask.class);
    }

    @Override
    public int chargeScheduledFees(Calendar time) {
        AccountFeeQuery query = new AccountFeeQuery();
        query.setReturnDisabled(false);
        query.setResultType(QueryParameters.ResultType.LIST);
        query.setHour((byte)time.get(11));
        query.setType(AccountFee.RunMode.SCHEDULED);
        query.fetch(AccountFee.Relationships.LOGS);
        query.setEnabledBefore(time);
        ArrayList<AccountFee> list = new ArrayList<AccountFee>();
        query.setRecurrence(TimePeriod.Field.DAYS);
        list.addAll(this.search(query));
        query.setRecurrence(TimePeriod.Field.WEEKS);
        query.setDay((byte)time.get(7));
        list.addAll(this.search(query));
        query.setRecurrence(TimePeriod.Field.MONTHS);
        query.setDay((byte)time.get(5));
        list.addAll(this.search(query));
        int count = 0;
        for (AccountFee fee : list) {
            boolean charge;
            AccountFeeLog lastExecution = fee.getLastExecution();
            if (lastExecution == null) {
                charge = true;
            } else {
                TimePeriod recurrence = fee.getRecurrence();
                if (recurrence.getNumber() == 1) {
                    charge = true;
                } else {
                    Calendar lastExecutionDate = lastExecution.getDate();
                    if (lastExecutionDate.after(time)) {
                        charge = false;
                    }
                    int number = 0;
                    Calendar cal = DateHelper.truncate(lastExecutionDate);
                    int calendarField = recurrence.getField().getCalendarValue();
                    Calendar date = DateHelper.truncate(time);
                    while (cal.before(date)) {
                        ++number;
                        cal.add(calendarField, 1);
                    }
                    boolean bl = charge = number % recurrence.getNumber() == 0;
                }
            }
            if (!charge) continue;
            this.insertNextExecution(fee);
            ++count;
        }
        return count;
    }

    @Override
    public AccountFeeLog getLastLog(AccountFee fee) {
        AccountFeeLogQuery query = new AccountFeeLogQuery();
        query.setAccountFee(fee);
        query.setUniqueResult();
        List<AccountFeeLog> list = this.accountFeeLogDao.search(query);
        if (list.isEmpty()) {
            return null;
        }
        return list.iterator().next();
    }

    @Override
    public AccountFeeLogDetailsDTO getLogDetails(Long id) {
        AccountFeeLog log = this.loadLog(id, AccountFeeLog.Relationships.ACCOUNT_FEE);
        AccountFee fee = log.getAccountFee();
        AccountFeeLogDetailsDTO dto = new AccountFeeLogDetailsDTO();
        dto.setAccountFeeLog(log);
        dto.setSkippedMembers(this.memberAccountFeeLogDao.countSkippedMembers(log));
        dto.setTransfers(fee.getInvoiceMode() == AccountFee.InvoiceMode.ALWAYS ? new TransactionSummaryVO() : this.memberAccountFeeLogDao.getTransfersSummary(log));
        dto.setInvoices(fee.getInvoiceMode() == AccountFee.InvoiceMode.NEVER ? new TransactionSummaryVO() : this.memberAccountFeeLogDao.getInvoicesSummary(log));
        dto.setAcceptedInvoices(fee.getInvoiceMode() == AccountFee.InvoiceMode.NEVER ? new TransactionSummaryVO() : this.memberAccountFeeLogDao.getAcceptedInvoicesSummary(log));
        dto.setOpenInvoices(dto.getInvoices().subtract(dto.getAcceptedInvoices()));
        return dto;
    }

    @Override
    public void initializeService() {
        this.insertMissingLogs();
    }

    @Override
    public AccountFee load(Long id, Relationship ... fetch) {
        return (AccountFee)this.accountFeeDao.load(id, fetch);
    }

    @Override
    public AccountFeeLog loadLog(Long id, Relationship ... fetch) {
        return (AccountFeeLog)this.accountFeeLogDao.load(id, fetch);
    }

    @Override
    public AccountFeeLog nextLogToCharge() {
        return this.accountFeeLogDao.nextToCharge();
    }

    @Override
    public List<Member> nextMembersToCharge(AccountFeeLog feeLog) {
        if (feeLog.isRechargingFailed()) {
            return this.memberAccountFeeLogDao.nextFailedToCharge(feeLog, ACCOUNT_FEE_CHARGE_BATCH_SIZE);
        }
        return this.memberAccountFeeLogDao.nextToCharge(feeLog, ACCOUNT_FEE_CHARGE_BATCH_SIZE);
    }

    @Override
    public boolean prepareCharge(AccountFeeLog feeLog) {
        if (feeLog.getTotalMembers() != null) {
            return false;
        }
        int totalMembers = this.memberAccountFeeLogDao.prepareCharge(feeLog);
        feeLog.setTotalMembers(totalMembers);
        this.accountFeeLogDao.update(feeLog);
        return true;
    }

    @Override
    public void rechargeFailed(AccountFeeLog accountFeeLog) {
        AccountFeeLog log = this.fetchService.fetch(accountFeeLog, new Relationship[0]);
        if (log.isRechargingFailed()) {
            return;
        }
        if (log.getFailedMembers() == 0) {
            return;
        }
        log.setRechargingFailed(true);
        log.setRechargeAttempt(log.getRechargeAttempt() + 1);
        this.accountFeeLogDao.update(log);
        this.applicationService.awakePollingTaskOnTransactionCommit(ChargeAccountFeePollingTask.class);
    }

    @Override
    public int remove(Long ... ids) {
        this.getVolumeFeeByAccountCache().clear();
        return this.accountFeeDao.delete(ids);
    }

    @Override
    public void removeFromPending(AccountFeeLog feeLog, Member member) {
        if (feeLog.isRechargingFailed()) {
            this.memberAccountFeeLogDao.remove(feeLog, member);
        } else {
            this.memberAccountFeeLogDao.removePendingCharge(feeLog, member);
        }
    }

    @Override
    public AccountFee save(AccountFee accountFee) {
        this.validate(accountFee);
        if (accountFee.getPaymentDirection() == AccountFee.PaymentDirection.TO_MEMBER) {
            accountFee.setInvoiceMode(null);
        }
        if (accountFee.getRunMode() == AccountFee.RunMode.MANUAL) {
            accountFee.setRecurrence(null);
            accountFee.setDay(null);
            accountFee.setHour(null);
        }
        this.getVolumeFeeByAccountCache().clear();
        if (accountFee.isTransient()) {
            if (accountFee.isEnabled() && accountFee.getEnabledSince() == null) {
                accountFee.setEnabledSince(Calendar.getInstance());
            }
            return this.accountFeeDao.insert(accountFee);
        }
        AccountFee current = this.load(accountFee.getId(), new Relationship[0]);
        if (accountFee.isEnabled() && current.getEnabledSince() == null) {
            if (accountFee.getEnabledSince() == null) {
                accountFee.setEnabledSince(Calendar.getInstance());
            }
        } else if (!accountFee.isEnabled() && current.isEnabled()) {
            accountFee.setEnabledSince(null);
        } else if (accountFee.getEnabledSince() == null) {
            accountFee.setEnabledSince(current.getEnabledSince());
        }
        return this.accountFeeDao.update(accountFee);
    }

    @Override
    public AccountFeeLog save(AccountFeeLog accountFeeLog) {
        if (accountFeeLog.isTransient()) {
            return this.accountFeeLogDao.insert(accountFeeLog);
        }
        return this.accountFeeLogDao.update(accountFeeLog);
    }

    @Override
    public List<AccountFee> search(AccountFeeQuery query) {
        return this.accountFeeDao.search(query);
    }

    @Override
    public List<AccountFeeLog> searchLogs(AccountFeeLogQuery query) {
        return this.accountFeeLogDao.search(query);
    }

    @Override
    public List<MemberAccountFeeLog> searchMembers(MemberAccountFeeLogQuery query) {
        LocalSettings localSettings = this.settingsService.getLocalSettings();
        return this.memberAccountFeeLogDao.search(query, localSettings.getMemberResultDisplay());
    }

    public void setAccountDao(AccountDAO accountDao) {
        this.accountDao = accountDao;
    }

    public void setAccountFeeDao(AccountFeeDAO dao) {
        this.accountFeeDao = dao;
    }

    public void setAccountFeeLogDao(AccountFeeLogDAO accountFeeLogDao) {
        this.accountFeeLogDao = accountFeeLogDao;
    }

    public void setAccountServiceLocal(AccountServiceLocal accountService) {
        this.accountService = accountService;
    }

    public void setApplicationServiceLocal(ApplicationServiceLocal applicationService) {
        this.applicationService = applicationService;
    }

    public void setCacheManager(CacheManager cacheManager) {
        this.cacheManager = cacheManager;
    }

    @Override
    public MemberAccountFeeLog setChargingError(AccountFeeLog feeLog, Member member, BigDecimal amount) {
        this.removeFromPending(feeLog, member);
        MemberAccountFeeLog mafl = new MemberAccountFeeLog();
        mafl.setDate(Calendar.getInstance());
        mafl.setAccountFeeLog(feeLog);
        mafl.setMember(member);
        mafl.setAmount(amount);
        mafl.setSuccess(false);
        mafl.setRechargeAttempt(feeLog.getRechargeAttempt());
        return this.memberAccountFeeLogDao.insert(mafl);
    }

    @Override
    public MemberAccountFeeLog setChargingSuccess(AccountFeeLog feeLog, Member member, BigDecimal amount, Transfer transfer, Invoice invoice) {
        this.removeFromPending(feeLog, member);
        MemberAccountFeeLog mafl = null;
        if (feeLog.isRechargingFailed() && (mafl = this.memberAccountFeeLogDao.load(feeLog, member)) != null && mafl.isSuccess()) {
            return null;
        }
        if (mafl == null) {
            mafl = new MemberAccountFeeLog();
            mafl.setAccountFeeLog(feeLog);
            mafl.setMember(member);
        }
        mafl.setDate(Calendar.getInstance());
        mafl.setAmount(amount);
        mafl.setSuccess(true);
        mafl.setTransfer(transfer);
        mafl.setInvoice(invoice);
        if (mafl.isTransient()) {
            return this.memberAccountFeeLogDao.insert(mafl);
        }
        return this.memberAccountFeeLogDao.update(mafl);
    }

    public void setFetchServiceLocal(FetchServiceLocal fetchService) {
        this.fetchService = fetchService;
    }

    public void setMemberAccountFeeLogDao(MemberAccountFeeLogDAO memberAccountFeeLogDao) {
        this.memberAccountFeeLogDao = memberAccountFeeLogDao;
    }

    public void setPaymentServiceLocal(PaymentServiceLocal paymentService) {
        this.paymentService = paymentService;
    }

    public void setSettingsServiceLocal(SettingsServiceLocal settingsService) {
        this.settingsService = settingsService;
    }

    @Override
    public void validate(AccountFee accountFee) {
        this.getValidator(accountFee).validate(accountFee);
    }

    private BigDecimal calculateChargeOverTransactionedVolume(AccountFeeLog feeLog, Member member) {
        Period period;
        AccountFee fee = feeLog.getAccountFee();
        if (!fee.isEnabled()) {
            return BigDecimal.ZERO;
        }
        MemberAccount account = (MemberAccount)this.accountService.getAccount(new AccountDTO(member, fee.getAccountType()), new Relationship[0]);
        Period logPeriod = feeLog.getPeriod();
        Calendar beginDate = logPeriod.getBegin();
        if (fee.getEnabledSince().after(beginDate)) {
            beginDate = fee.getEnabledSince();
        }
        if (account.getCreationDate().after(beginDate)) {
            beginDate = account.getCreationDate();
        }
        if ((period = Period.between(beginDate = DateHelper.truncateNextDay(beginDate), logPeriod.getEnd())).getBegin().after(period.getEnd())) {
            period.setEnd(period.getBegin());
        }
        return this.calculateVolumeCharge(account, fee, period, BigDecimal.ZERO, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BigDecimal calculateVolumeCharge(MemberAccount account, AccountFee volumeFee, Period period, BigDecimal additionalReserved, boolean currentPeriod) {
        BigDecimal toCharge;
        BigDecimal volume;
        Calendar fromDate = period.getBegin();
        AccountStatus status = this.accountService.getStatus(account, fromDate);
        status.setReservedAmount(status.getReservedAmount().add(additionalReserved));
        TimePeriod recurrence = volumeFee.getRecurrence();
        Period totalPeriod = recurrence.currentPeriod(period.getBegin());
        int totalDays = totalPeriod.getDays() + 1;
        Calendar lastDay = fromDate;
        Calendar lastChargedDay = fromDate;
        BigDecimal result = BigDecimal.ZERO;
        IteratorList<AccountDailyDifference> diffs = this.accountDao.iterateDailyDifferences(account, period);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"********************************");
            LOG.debug((Object)(FormatObject.formatObject(period.getBegin()) + "\t" + status.getBalance() + "\t" + status.getAvailableBalance()));
        }
        try {
            if (diffs.hasNext()) {
                for (AccountDailyDifference diff : diffs) {
                    Calendar day = diff.getDay();
                    int days = DateHelper.daysBetween(lastDay, day);
                    BigDecimal available = status.getAvailableBalanceWithoutCreditLimit();
                    if (volumeFee.getChargeMode().isNegative()) {
                        available = available.negate();
                    }
                    if (volumeFee.getFreeBase() != null) {
                        available = available.subtract(volumeFee.getFreeBase());
                    }
                    if (available.compareTo(BigDecimal.ZERO) > 0) {
                        volume = new BigDecimal(available.doubleValue() * (double)days / (double)totalDays);
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)(FormatObject.formatObject(day) + "\t" + diff.getBalance() + "\t" + status.getAvailableBalanceWithoutCreditLimit().add(diff.getBalance()) + "\t" + days + "\t" + totalDays + "\t" + volume));
                        }
                        toCharge = volume.multiply(volumeFee.getAmount()).divide(BigDecimalHelper.ONE_HUNDRED);
                        result = result.add(toCharge);
                        lastChargedDay = day;
                    }
                    lastDay = day;
                    status.setBalance(status.getBalance().add(diff.getBalance()));
                    status.setReservedAmount(status.getReservedAmount().add(diff.getReserved()));
                }
            }
        }
        finally {
            DataIteratorHelper.close(diffs);
        }
        Calendar toDate = period.getEnd();
        boolean lastPaymentInPeriodEnd = !toDate.before(lastChargedDay);
        LocalSettings settings = this.settingsService.getLocalSettings();
        if (DateHelper.daysBetween(lastChargedDay, Calendar.getInstance()) != 0) {
            BigDecimal resultSoFar = settings.round(result);
            status.setReservedAmount(status.getReservedAmount().add(resultSoFar));
        }
        BigDecimal finalAvailableBalance = status.getAvailableBalanceWithoutCreditLimit();
        if (volumeFee.getChargeMode().isNegative()) {
            finalAvailableBalance = finalAvailableBalance.negate();
        }
        if (volumeFee.getFreeBase() != null) {
            finalAvailableBalance = finalAvailableBalance.subtract(volumeFee.getFreeBase());
        }
        if (lastPaymentInPeriodEnd && finalAvailableBalance.compareTo(BigDecimal.ZERO) > 0) {
            int days = DateHelper.daysBetween(lastChargedDay, toDate) + (currentPeriod ? 0 : 1);
            volume = new BigDecimal(finalAvailableBalance.doubleValue() * (double)days / (double)totalDays);
            toCharge = volume.multiply(volumeFee.getAmount()).divide(BigDecimalHelper.ONE_HUNDRED);
            result = result.add(toCharge);
            if (LOG.isDebugEnabled()) {
                status.setReservedAmount(settings.round(status.getReservedAmount().add(toCharge)));
                LOG.debug((Object)(FormatObject.formatObject(lastChargedDay) + "\t0\t" + status.getAvailableBalanceWithoutCreditLimit() + "\t" + days + "\t" + totalDays + "\t" + volume));
            }
        }
        return settings.round(result);
    }

    private List<Period> getMissingPeriods(AccountFee fee) {
        TimePeriod recurrence = fee.getRecurrence();
        Calendar now = DateUtils.truncate((Calendar)Calendar.getInstance(), (int)11);
        AccountFeeLog lastLog = this.getLastLog(fee);
        Calendar since = lastLog == null || lastLog.getDate().before(fee.getEnabledSince()) ? fee.getEnabledSince() : lastLog.getDate();
        ArrayList<Period> periods = new ArrayList<Period>();
        Calendar date = DateHelper.truncate(since);
        Period period = recurrence.previousPeriod(date);
        while (true) {
            date = (Calendar)period.getEnd().clone();
            date.add(13, 1);
            period = recurrence.periodStartingAt(date);
            if (!period.getEnd().before(now)) break;
            periods.add(period);
        }
        if (!periods.isEmpty()) {
            byte thisDay = (byte)now.get(5);
            byte thisHour = (byte)now.get(11);
            boolean removeLast = false;
            Byte feeDay = fee.getDay();
            if (feeDay != null && thisDay < feeDay) {
                removeLast = true;
            } else if (feeDay == null || thisDay == feeDay) {
                boolean bl = removeLast = thisHour < fee.getHour();
            }
            if (removeLast) {
                periods.remove(periods.size() - 1);
            }
        }
        Iterator it = periods.iterator();
        while (it.hasNext()) {
            Period current = (Period)it.next();
            AccountFeeLogQuery logQuery = new AccountFeeLogQuery();
            logQuery.setPageForCount();
            logQuery.setAccountFee(fee);
            logQuery.setPeriodStartAt(current.getBegin());
            int count = PageHelper.getTotalCount(this.accountFeeLogDao.search(logQuery));
            if (count <= 0) continue;
            it.remove();
        }
        return periods;
    }

    private Validator getValidator(AccountFee fee) {
        Validator validator = new Validator("accountFee");
        validator.property("accountType").required();
        validator.property("transferType").required();
        validator.property("name").required().maxLength(100);
        validator.property("description").maxLength(1000);
        validator.property("amount").required().positiveNonZero();
        validator.property("chargeMode").required();
        validator.property("paymentDirection").required();
        Validator.Property runMode = validator.property("runMode").required();
        if (fee.getChargeMode() != null && fee.getChargeMode().isVolume()) {
            runMode.anyOf(AccountFee.RunMode.SCHEDULED);
        }
        if (fee.getRunMode() == AccountFee.RunMode.SCHEDULED) {
            TimePeriod.Field field;
            validator.property("recurrence.number").key("accountFee.recurrence").required().positiveNonZero().lessThan(28);
            validator.property("recurrence.field").key("accountFee.recurrence").required().anyOf(TimePeriod.Field.DAYS, TimePeriod.Field.WEEKS, TimePeriod.Field.MONTHS);
            Validator.Property day = validator.property("day");
            TimePeriod.Field field2 = field = fee.getRecurrence() == null ? null : fee.getRecurrence().getField();
            if (field != null && field != TimePeriod.Field.DAYS) {
                day.required();
                if (field == TimePeriod.Field.WEEKS) {
                    day.between(1, 7);
                } else {
                    day.between(1, 28);
                }
            }
            validator.property("hour").required().between(0, 23);
        }
        if (fee.isMemberToSystem()) {
            validator.property("invoiceMode").required();
        }
        if (fee.isTransient()) {
            validator.property("enabledSince").key("accountFee.firstPeriodAfter").futureOrToday();
        }
        return validator;
    }

    private AccountFee getVolumeFee(final AccountType accountType, final MemberGroup group) {
        Pair<Long, Long> key = new Pair<Long, Long>(accountType.getId(), group.getId());
        return (AccountFee)this.getVolumeFeeByAccountCache().get(key, new CacheCallback(){

            @Override
            public Object retrieve() {
                AccountFeeQuery query = new AccountFeeQuery();
                query.setAccountType(accountType);
                query.setGroups(Collections.singleton(group));
                query.setType(AccountFee.RunMode.SCHEDULED);
                List<AccountFee> fees = AccountFeeServiceImpl.this.search(query);
                Iterator<AccountFee> iterator = fees.iterator();
                while (iterator.hasNext()) {
                    if (iterator.next().getChargeMode().isVolume()) continue;
                    iterator.remove();
                }
                if (fees.size() > 1) {
                    throw new ValidationException("accountFee.error.multipleVolumeFees", new Object[0]);
                }
                return fees.isEmpty() ? null : fees.iterator().next();
            }
        });
    }

    private Cache getVolumeFeeByAccountCache() {
        return this.cacheManager.getCache("cyclos.VolumeFeeByAccount");
    }

    private void insertMissingLogs() {
        AccountFeeQuery query = new AccountFeeQuery();
        query.setReturnDisabled(false);
        query.setType(AccountFee.RunMode.SCHEDULED);
        Calendar thisHour = DateUtils.truncate((Calendar)Calendar.getInstance(), (int)11);
        List<AccountFee> accountFees = this.accountFeeDao.search(query);
        for (AccountFee fee : accountFees) {
            TimePeriod.Field recurrenceField = fee.getRecurrence().getField();
            List<Period> missingPeriods = this.getMissingPeriods(fee);
            if (missingPeriods.isEmpty()) continue;
            for (Period period : missingPeriods) {
                Calendar shouldHaveChargedAt = DateHelper.truncate(period.getEnd());
                shouldHaveChargedAt.add(5, 1);
                switch (recurrenceField) {
                    case WEEKS: {
                        for (int max = 7; max > 0 && shouldHaveChargedAt.get(7) < fee.getDay(); --max) {
                            shouldHaveChargedAt.add(5, 1);
                        }
                        break;
                    }
                    case MONTHS: {
                        shouldHaveChargedAt.set(5, fee.getDay().byteValue());
                    }
                }
                shouldHaveChargedAt.set(11, fee.getHour().byteValue());
                if (shouldHaveChargedAt.after(thisHour)) continue;
                AccountFeeLog log = new AccountFeeLog();
                log.setAccountFee(fee);
                log.setDate(shouldHaveChargedAt);
                log.setPeriod(period);
                log.setAmount(fee.getAmount());
                log.setFreeBase(fee.getFreeBase());
                this.accountFeeLogDao.insert(log);
            }
        }
    }

    private AccountFeeLog insertNextExecution(AccountFee fee) {
        if (!(fee = this.fetchService.fetch(fee, new Relationship[0])).isEnabled()) {
            return null;
        }
        Period period = null;
        Calendar executionDate = null;
        if (fee.getRunMode() == AccountFee.RunMode.MANUAL) {
            executionDate = Calendar.getInstance();
        } else {
            executionDate = fee.getNextExecutionDate();
            if (executionDate.after(Calendar.getInstance())) {
                return null;
            }
            period = fee.getRecurrence().previousPeriod(executionDate);
        }
        AccountFeeLog nextExecution = new AccountFeeLog();
        nextExecution.setAccountFee(fee);
        nextExecution.setDate(executionDate);
        nextExecution.setPeriod(period);
        nextExecution.setAmount(fee.getAmount());
        nextExecution.setFreeBase(fee.getFreeBase());
        return this.accountFeeLogDao.insert(nextExecution);
    }
}

