/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.services.accountfees;

import java.util.List;
import nl.strohalm.cyclos.access.AdminSystemPermission;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.accounts.MemberAccountType;
import nl.strohalm.cyclos.entities.accounts.fees.account.AccountFee;
import nl.strohalm.cyclos.entities.accounts.fees.account.AccountFeeLog;
import nl.strohalm.cyclos.entities.accounts.fees.account.AccountFeeLogDetailsDTO;
import nl.strohalm.cyclos.entities.accounts.fees.account.AccountFeeLogQuery;
import nl.strohalm.cyclos.entities.accounts.fees.account.AccountFeeQuery;
import nl.strohalm.cyclos.entities.accounts.fees.account.MemberAccountFeeLog;
import nl.strohalm.cyclos.entities.accounts.fees.account.MemberAccountFeeLogQuery;
import nl.strohalm.cyclos.services.BaseServiceSecurity;
import nl.strohalm.cyclos.services.accountfees.AccountFeeService;
import nl.strohalm.cyclos.services.accountfees.AccountFeeServiceLocal;
import nl.strohalm.cyclos.services.transfertypes.TransferTypeServiceLocal;
import nl.strohalm.cyclos.utils.access.PermissionHelper;

public class AccountFeeServiceSecurity
extends BaseServiceSecurity
implements AccountFeeService {
    private AccountFeeServiceLocal accountFeeService;
    private TransferTypeServiceLocal transferTypeService;

    @Override
    public void chargeManual(AccountFee accountFee) {
        this.permissionService.permission().admin(AdminSystemPermission.ACCOUNT_FEES_CHARGE).check();
        this.accountFeeService.chargeManual(accountFee);
    }

    @Override
    public AccountFeeLogDetailsDTO getLogDetails(Long id) {
        this.permissionService.permission().admin(AdminSystemPermission.ACCOUNT_FEES_VIEW).check();
        return this.accountFeeService.getLogDetails(id);
    }

    @Override
    public AccountFee load(Long id, Relationship ... fetch) {
        this.permissionService.permission().admin(AdminSystemPermission.ACCOUNTS_VIEW, AdminSystemPermission.ACCOUNT_FEES_VIEW).check();
        return this.accountFeeService.load(id, fetch);
    }

    @Override
    public AccountFeeLog loadLog(Long id, Relationship ... fetch) {
        this.permissionService.permission().admin(AdminSystemPermission.ACCOUNT_FEES_VIEW).check();
        return this.accountFeeService.loadLog(id, fetch);
    }

    @Override
    public void rechargeFailed(AccountFeeLog accountFeeLog) {
        this.permissionService.permission().admin(AdminSystemPermission.ACCOUNT_FEES_CHARGE).check();
        this.accountFeeService.rechargeFailed(accountFeeLog);
    }

    @Override
    public int remove(Long ... ids) {
        this.permissionService.permission().admin(AdminSystemPermission.ACCOUNTS_MANAGE).check();
        return this.accountFeeService.remove(ids);
    }

    @Override
    public AccountFee save(AccountFee accountFee) {
        this.permissionService.permission().admin(AdminSystemPermission.ACCOUNTS_MANAGE).check();
        this.checkReadOnlyValues(accountFee);
        this.checkGeneratedTransferType(accountFee);
        return this.accountFeeService.save(accountFee);
    }

    @Override
    public List<AccountFee> search(AccountFeeQuery query) {
        this.permissionService.permission().admin(AdminSystemPermission.ACCOUNTS_VIEW, AdminSystemPermission.ACCOUNT_FEES_VIEW).check();
        return this.accountFeeService.search(query);
    }

    @Override
    public List<AccountFeeLog> searchLogs(AccountFeeLogQuery query) {
        this.permissionService.permission().admin(AdminSystemPermission.ACCOUNT_FEES_VIEW).check();
        return this.accountFeeService.searchLogs(query);
    }

    @Override
    public List<MemberAccountFeeLog> searchMembers(MemberAccountFeeLogQuery query) {
        this.permissionService.permission().admin(AdminSystemPermission.ACCOUNT_FEES_VIEW).check();
        PermissionHelper.checkSelection(this.permissionService.getManagedMemberGroups(), query.getGroups());
        return this.accountFeeService.searchMembers(query);
    }

    public void setAccountFeeServiceLocal(AccountFeeServiceLocal accountFeeService) {
        this.accountFeeService = accountFeeService;
    }

    public void setTransferTypeServiceLocal(TransferTypeServiceLocal transferTypeService) {
        this.transferTypeService = transferTypeService;
    }

    @Override
    public void validate(AccountFee accountFee) {
        this.accountFeeService.validate(accountFee);
    }

    private void checkGeneratedTransferType(AccountFee accountFee) {
        MemberAccountType accountType = accountFee.getAccountType();
        AccountFee.PaymentDirection paymentDirection = accountFee.getPaymentDirection();
        PermissionHelper.checkContains(this.transferTypeService.getPosibleTTsForAccountFee(accountType, paymentDirection), accountFee.getTransferType());
    }

    private void checkReadOnlyValues(AccountFee modifiedAF) {
        if (!modifiedAF.isTransient()) {
            AccountFee savedAF = this.load(modifiedAF.getId(), new Relationship[0]);
            PermissionHelper.checkEquals(savedAF.getChargeMode(), modifiedAF.getChargeMode());
            PermissionHelper.checkEquals(savedAF.getRunMode(), modifiedAF.getRunMode());
            if (savedAF.getRunMode().equals(AccountFee.RunMode.SCHEDULED)) {
                PermissionHelper.checkEquals(savedAF.getRecurrence(), modifiedAF.getRecurrence());
            }
            if (modifiedAF.getAccountType() != null) {
                PermissionHelper.checkEquals(savedAF.getAccountType(), modifiedAF.getAccountType());
            }
        }
    }
}

