/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.services.accounts;

import nl.strohalm.cyclos.entities.accounts.Account;
import nl.strohalm.cyclos.entities.accounts.AccountOwner;
import nl.strohalm.cyclos.entities.accounts.AccountType;
import nl.strohalm.cyclos.utils.DataObject;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;

public class AccountDTO
extends DataObject {
    private static final long serialVersionUID = -2140469861803171920L;
    private Account account;
    private AccountOwner owner;
    private AccountType type;

    public AccountDTO() {
    }

    public AccountDTO(Account account) {
        this.setAccount(account);
    }

    public AccountDTO(AccountOwner owner, AccountType type) {
        this.owner = owner;
        this.type = type;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof AccountDTO)) {
            return false;
        }
        AccountDTO dto = (AccountDTO)obj;
        if (this.owner == null || this.type == null || dto.owner == null || dto.type == null) {
            return false;
        }
        return new EqualsBuilder().append((Object)this.owner, (Object)dto.owner).append((Object)this.type.getId(), (Object)dto.type.getId()).isEquals();
    }

    public Account getAccount() {
        return this.account;
    }

    public AccountOwner getOwner() {
        return this.owner;
    }

    public AccountType getType() {
        return this.type;
    }

    public int hashCode() {
        if (this.type == null) {
            return super.hashCode();
        }
        return new HashCodeBuilder().append((Object)this.owner).append((Object)this.type.getId()).toHashCode();
    }

    public void setAccount(Account account) {
        this.account = account;
        if (account != null) {
            this.setOwner(account.getOwner());
            this.setType(account.getType());
        }
    }

    public void setOwner(AccountOwner owner) {
        this.owner = owner;
    }

    public void setType(AccountType type) {
        this.type = type;
    }
}

