/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.services.accounts;

import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.accounts.Account;
import nl.strohalm.cyclos.entities.accounts.AccountOwner;
import nl.strohalm.cyclos.entities.accounts.AccountStatus;
import nl.strohalm.cyclos.entities.accounts.MemberAccount;
import nl.strohalm.cyclos.entities.accounts.transactions.TransferType;
import nl.strohalm.cyclos.entities.members.Member;
import nl.strohalm.cyclos.entities.members.MemberTransactionDetailsReportData;
import nl.strohalm.cyclos.entities.members.MemberTransactionSummaryReportData;
import nl.strohalm.cyclos.entities.members.MembersTransactionsReportParameters;
import nl.strohalm.cyclos.services.Service;
import nl.strohalm.cyclos.services.accounts.AccountDTO;
import nl.strohalm.cyclos.services.accounts.AccountDateDTO;
import nl.strohalm.cyclos.services.accounts.CreditLimitDTO;
import nl.strohalm.cyclos.webservices.model.AccountStatusVO;
import nl.strohalm.cyclos.webservices.model.MemberAccountVO;

public interface AccountService
extends Service {
    public boolean canView(Account var1);

    public boolean canViewAccountsOf(AccountOwner var1);

    public boolean canViewAuthorizedInformation(AccountOwner var1);

    public Account getAccount(AccountDTO var1, Relationship ... var2);

    public List<? extends Account> getAccounts(AccountOwner var1, Relationship ... var2);

    public Set<? extends Account> getAccountsFromTTs(Member var1, Collection<TransferType> var2, TransferType.Direction var3);

    public BigDecimal getBalance(AccountDateDTO var1);

    public BigDecimal getCreditLimit(AccountDTO var1);

    public CreditLimitDTO getCreditLimits(Member var1);

    public AccountStatusVO getCurrentAccountStatusVO(AccountDTO var1);

    public AccountStatus getCurrentStatus(AccountDTO var1);

    public MemberAccount getDefaultAccount();

    public Account getDefaultAccountFromList(Member var1, List<Account> var2);

    public MemberAccountVO getMemberAccountVO(Long var1);

    public AccountStatus getRatedStatus(Account var1, Calendar var2);

    public boolean hasAccounts(Member var1);

    public <T extends Account> T load(Long var1, Relationship ... var2);

    public Iterator<MemberTransactionDetailsReportData> membersTransactionsDetailsReport(MembersTransactionsReportParameters var1);

    public Iterator<MemberTransactionSummaryReportData> membersTransactionsSummaryReport(MembersTransactionsReportParameters var1);

    public void setCreditLimit(Member var1, CreditLimitDTO var2);

    public void validate(Member var1, CreditLimitDTO var2);
}

