/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.services.accounts;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import nl.strohalm.cyclos.access.AdminMemberPermission;
import nl.strohalm.cyclos.access.AdminSystemPermission;
import nl.strohalm.cyclos.access.BrokerPermission;
import nl.strohalm.cyclos.access.MemberPermission;
import nl.strohalm.cyclos.access.OperatorPermission;
import nl.strohalm.cyclos.dao.accounts.AccountDAO;
import nl.strohalm.cyclos.dao.accounts.AccountLimitLogDAO;
import nl.strohalm.cyclos.dao.accounts.AmountReservationDAO;
import nl.strohalm.cyclos.dao.accounts.ClosedAccountBalanceDAO;
import nl.strohalm.cyclos.dao.accounts.transactions.TransferDAO;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.accounts.Account;
import nl.strohalm.cyclos.entities.accounts.AccountLimitLog;
import nl.strohalm.cyclos.entities.accounts.AccountOwner;
import nl.strohalm.cyclos.entities.accounts.AccountQuery;
import nl.strohalm.cyclos.entities.accounts.AccountStatus;
import nl.strohalm.cyclos.entities.accounts.AccountType;
import nl.strohalm.cyclos.entities.accounts.AmountReservation;
import nl.strohalm.cyclos.entities.accounts.ClosedAccountBalance;
import nl.strohalm.cyclos.entities.accounts.InstallmentAmountReservation;
import nl.strohalm.cyclos.entities.accounts.MemberAccount;
import nl.strohalm.cyclos.entities.accounts.MemberAccountType;
import nl.strohalm.cyclos.entities.accounts.MemberGroupAccountSettings;
import nl.strohalm.cyclos.entities.accounts.PendingAuthorizationAmountReservation;
import nl.strohalm.cyclos.entities.accounts.ScheduledPaymentAmountReservation;
import nl.strohalm.cyclos.entities.accounts.SystemAccount;
import nl.strohalm.cyclos.entities.accounts.SystemAccountOwner;
import nl.strohalm.cyclos.entities.accounts.SystemAccountType;
import nl.strohalm.cyclos.entities.accounts.TransferAuthorizationAmountReservation;
import nl.strohalm.cyclos.entities.accounts.transactions.PaymentFilter;
import nl.strohalm.cyclos.entities.accounts.transactions.ScheduledPayment;
import nl.strohalm.cyclos.entities.accounts.transactions.Transfer;
import nl.strohalm.cyclos.entities.accounts.transactions.TransferAuthorization;
import nl.strohalm.cyclos.entities.accounts.transactions.TransferType;
import nl.strohalm.cyclos.entities.exceptions.EntityNotFoundException;
import nl.strohalm.cyclos.entities.groups.AdminGroup;
import nl.strohalm.cyclos.entities.groups.Group;
import nl.strohalm.cyclos.entities.groups.MemberGroup;
import nl.strohalm.cyclos.entities.members.Administrator;
import nl.strohalm.cyclos.entities.members.Element;
import nl.strohalm.cyclos.entities.members.Member;
import nl.strohalm.cyclos.entities.members.MemberQuery;
import nl.strohalm.cyclos.entities.members.MemberTransactionDetailsReportData;
import nl.strohalm.cyclos.entities.members.MemberTransactionSummaryReportData;
import nl.strohalm.cyclos.entities.members.MemberTransactionSummaryVO;
import nl.strohalm.cyclos.entities.members.MembersTransactionsReportParameters;
import nl.strohalm.cyclos.entities.settings.LocalSettings;
import nl.strohalm.cyclos.services.accountfees.AccountFeeServiceLocal;
import nl.strohalm.cyclos.services.accounts.AccountDTO;
import nl.strohalm.cyclos.services.accounts.AccountDateDTO;
import nl.strohalm.cyclos.services.accounts.AccountServiceLocal;
import nl.strohalm.cyclos.services.accounts.AccountTypeServiceLocal;
import nl.strohalm.cyclos.services.accounts.CreditLimitDTO;
import nl.strohalm.cyclos.services.accounts.GetTransactionsDTO;
import nl.strohalm.cyclos.services.accounts.rates.RateServiceLocal;
import nl.strohalm.cyclos.services.accounts.rates.RatesDTO;
import nl.strohalm.cyclos.services.accounts.rates.RatesResultDTO;
import nl.strohalm.cyclos.services.elements.ElementServiceLocal;
import nl.strohalm.cyclos.services.fetch.FetchServiceLocal;
import nl.strohalm.cyclos.services.groups.GroupServiceLocal;
import nl.strohalm.cyclos.services.permissions.PermissionServiceLocal;
import nl.strohalm.cyclos.services.settings.SettingsServiceLocal;
import nl.strohalm.cyclos.services.transactions.TransactionSummaryVO;
import nl.strohalm.cyclos.utils.CacheCleaner;
import nl.strohalm.cyclos.utils.CombinedIterator;
import nl.strohalm.cyclos.utils.DataIteratorHelper;
import nl.strohalm.cyclos.utils.DateHelper;
import nl.strohalm.cyclos.utils.Period;
import nl.strohalm.cyclos.utils.TransactionHelper;
import nl.strohalm.cyclos.utils.access.LoggedUser;
import nl.strohalm.cyclos.utils.query.IteratorList;
import nl.strohalm.cyclos.utils.query.QueryParameters;
import nl.strohalm.cyclos.utils.validation.ValidationException;
import nl.strohalm.cyclos.webservices.model.AccountStatusVO;
import nl.strohalm.cyclos.webservices.model.MemberAccountVO;
import nl.strohalm.cyclos.webservices.utils.AccountHelper;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.IteratorUtils;
import org.apache.commons.lang.ObjectUtils;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;

public class AccountServiceImpl
implements AccountServiceLocal {
    private static final float PRECISION_DELTA = 1.0E-4f;
    private static final int CLOSE_BATCH_SIZE = 30;
    private AccountDAO accountDao;
    private ClosedAccountBalanceDAO closedAccountBalanceDao;
    private TransferDAO transferDao;
    private AmountReservationDAO amountReservationDao;
    private AccountLimitLogDAO accountLimitLogDao;
    private SettingsServiceLocal settingsService;
    private FetchServiceLocal fetchService;
    private AccountTypeServiceLocal accountTypeService;
    private RateServiceLocal rateService;
    private GroupServiceLocal groupService;
    private ElementServiceLocal elementService;
    private PermissionServiceLocal permissionService;
    private AccountFeeServiceLocal accountFeeService;
    private TransactionHelper transactionHelper;
    private AccountHelper accountHelper;

    @Override
    public boolean canView(Account account) {
        if (LoggedUser.isSystem()) {
            return true;
        }
        if (account instanceof SystemAccount) {
            if (LoggedUser.isAdministrator()) {
                AdminGroup adminGroup = (AdminGroup)LoggedUser.group();
                Collection<SystemAccountType> visibleTypes = this.fetchService.fetch(adminGroup, AdminGroup.Relationships.VIEW_INFORMATION_OF).getViewInformationOf();
                return visibleTypes.contains(account.getType());
            }
            return false;
        }
        return this.canViewAccountsOf(account.getOwner());
    }

    @Override
    public boolean canViewAccountsOf(AccountOwner owner) {
        if (LoggedUser.isSystem()) {
            return true;
        }
        if (owner instanceof SystemAccountOwner) {
            return this.permissionService.hasPermission(AdminSystemPermission.ACCOUNTS_INFORMATION);
        }
        return this.permissionService.permission((Member)owner).admin(AdminMemberPermission.ACCOUNTS_INFORMATION).broker(BrokerPermission.ACCOUNTS_INFORMATION).member(new MemberPermission[0]).operator(OperatorPermission.ACCOUNT_ACCOUNT_INFORMATION).hasPermission();
    }

    @Override
    public boolean canViewAuthorizedInformation(AccountOwner owner) {
        if (owner instanceof SystemAccountOwner) {
            return this.permissionService.permission().admin(AdminSystemPermission.ACCOUNTS_AUTHORIZED_INFORMATION).hasPermission();
        }
        return this.permissionService.permission((Member)owner).admin(AdminMemberPermission.ACCOUNTS_AUTHORIZED_INFORMATION).broker(BrokerPermission.ACCOUNTS_AUTHORIZED_INFORMATION).member(MemberPermission.ACCOUNT_AUTHORIZED_INFORMATION).operator(OperatorPermission.ACCOUNT_AUTHORIZED_INFORMATION).hasPermission();
    }

    @Override
    public void closeBalances(Calendar time) {
        final Calendar day = DateHelper.truncate(time);
        final boolean[] hasMore = new boolean[]{true};
        while (hasMore[0]) {
            this.transactionHelper.runInCurrentThread(new TransactionCallbackWithoutResult(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                protected void doInTransactionWithoutResult(TransactionStatus txStatus) {
                    CacheCleaner cacheCleaner = new CacheCleaner(AccountServiceImpl.this.fetchService);
                    IteratorList<Account> accounts = AccountServiceImpl.this.accountDao.iterateUnclosedAccounts(day, 30);
                    hasMore[0] = accounts.hasNext();
                    try {
                        for (Account account : accounts) {
                            AccountServiceImpl.this.closeBalance(account, day);
                            cacheCleaner.clearCache();
                        }
                    }
                    finally {
                        DataIteratorHelper.close(accounts);
                    }
                }
            });
        }
    }

    @Override
    public int countPendingActivation(MemberGroup group, MemberAccountType accountType) {
        return this.accountDao.countAccounts(group, accountType, MemberAccount.Action.ACTIVATE);
    }

    @Override
    public Account getAccount(AccountDTO params, Relationship ... fetch) {
        AccountType type;
        AccountOwner owner;
        Account account = params.getAccount();
        if (account != null && account.isPersistent()) {
            account = (Account)this.accountDao.load(account.getId(), fetch);
            owner = account.getOwner();
            type = account.getType();
        } else {
            owner = params.getOwner();
            type = params.getType();
        }
        if (LoggedUser.hasUser() && LoggedUser.isAdministrator() && owner instanceof SystemAccountOwner) {
            AdminGroup group = (AdminGroup)LoggedUser.group();
            group = this.fetchService.fetch(group, AdminGroup.Relationships.VIEW_INFORMATION_OF);
            for (SystemAccountType current : group.getViewInformationOf()) {
                if (!current.equals(type)) continue;
                return this.fetchService.fetch(current.getAccount(), fetch);
            }
            throw new EntityNotFoundException(SystemAccount.class);
        }
        account = account == null ? this.accountDao.load(owner, type, fetch) : account;
        params.setAccount(account);
        return account;
    }

    @Override
    public List<? extends Account> getAccounts(AccountOwner owner, Relationship ... fetch) {
        return this.getAccounts(owner, false, fetch);
    }

    @Override
    public Set<? extends Account> getAccountsFromTTs(Member member, Collection<TransferType> allowedTTs, TransferType.Direction direction) {
        HashSet<MemberAccount> allowedAccounts = new HashSet<MemberAccount>(allowedTTs.size());
        List<? extends Account> accounts = this.getAccounts((AccountOwner)member, new Relationship[0]);
        for (TransferType currentTT : allowedTTs) {
            for (MemberAccount memberAccount : accounts) {
                if (direction.equals((Object)TransferType.Direction.BOTH)) {
                    if (!memberAccount.getType().equals(currentTT.getFrom()) && !memberAccount.getType().equals(currentTT.getTo())) continue;
                    allowedAccounts.add(memberAccount);
                    continue;
                }
                if (direction.equals((Object)TransferType.Direction.FROM) && memberAccount.getType().equals(currentTT.getFrom())) {
                    allowedAccounts.add(memberAccount);
                    continue;
                }
                if (!direction.equals((Object)TransferType.Direction.TO) || !memberAccount.getType().equals(currentTT.getTo())) continue;
                allowedAccounts.add(memberAccount);
            }
        }
        return allowedAccounts;
    }

    @Override
    public BigDecimal getBalance(AccountDateDTO params) {
        ClosedAccountBalance closedBalance;
        Account account = this.getAccount(params, new Relationship[0]);
        Calendar date = params.getDate();
        if (date == null) {
            date = Calendar.getInstance();
        }
        BigDecimal balance = (closedBalance = this.closedAccountBalanceDao.get(account, date)) == null ? BigDecimal.ZERO : closedBalance.getBalance();
        Calendar beginDate = closedBalance == null ? null : closedBalance.getDate();
        Period balanceDiffPeriod = Period.between(beginDate, date).useTime();
        BigDecimal diff = this.transferDao.balanceDiff(account, balanceDiffPeriod);
        balance = balance.add(diff);
        return balance;
    }

    @Override
    public BigDecimal getBalanceAtTimePoint(Account account, Calendar date, boolean inclusive, boolean compensateChargebacks) {
        BigDecimal balance;
        AccountDateDTO param = new AccountDateDTO(account, date);
        BigDecimal bigDecimal = balance = inclusive ? this.getBalance(param) : this.getExclusiveBalance(param);
        if (compensateChargebacks) {
            Period period = Period.endingAt(date).useTime();
            period.setInclusiveEnd(inclusive);
            BigDecimal chargebackBalance = this.transferDao.getChargebackBalance(account, period);
            balance = balance.add(chargebackBalance);
        }
        return balance;
    }

    @Override
    public BigDecimal getBalanceAtTransfer(Account account, Transfer transfer, boolean compensateChargebacks, boolean inclusive) {
        if (transfer.getProcessDate() == null) {
            throw new IllegalArgumentException("transfer must be processed.");
        }
        ClosedAccountBalance closedBalance = this.closedAccountBalanceDao.get(account, transfer.getProcessDate());
        BigDecimal balance = closedBalance == null ? BigDecimal.ZERO : closedBalance.getBalance();
        Period diffPeriod = Period.begginingAt(closedBalance == null ? null : closedBalance.getDate());
        diffPeriod.setInclusiveEnd(inclusive);
        BigDecimal diff = this.transferDao.balanceDiff(account, diffPeriod, transfer);
        balance = balance.add(diff);
        if (compensateChargebacks) {
            BigDecimal chargebackBalance = this.transferDao.getChargebackBalance(account, transfer, inclusive);
            balance = balance.add(chargebackBalance);
        }
        return balance;
    }

    @Override
    public TransactionSummaryVO getBrokerCommissions(GetTransactionsDTO params) {
        return this.accountDao.getBrokerCommissions(params);
    }

    @Override
    public BigDecimal getCreditLimit(AccountDTO params) {
        Account account = this.getAccount(params, new Relationship[0]);
        return account.getCreditLimit();
    }

    @Override
    public CreditLimitDTO getCreditLimits(Member owner) {
        HashMap<AccountType, BigDecimal> limits = new HashMap<AccountType, BigDecimal>();
        HashMap<AccountType, BigDecimal> upperLimits = new HashMap<AccountType, BigDecimal>();
        List<? extends Account> accts = this.getAccounts((AccountOwner)owner, true, new Relationship[0]);
        for (Account account : accts) {
            AccountType type = account.getType();
            limits.put(type, account.getCreditLimit());
            upperLimits.put(type, account.getUpperCreditLimit());
        }
        CreditLimitDTO dto = new CreditLimitDTO();
        dto.setLimitPerType(limits);
        dto.setUpperLimitPerType(upperLimits);
        return dto;
    }

    @Override
    public TransactionSummaryVO getCredits(GetTransactionsDTO params) {
        return this.accountDao.getCredits(params);
    }

    @Override
    public AccountStatusVO getCurrentAccountStatusVO(AccountDTO accountDTO) {
        AccountStatus accountStatus = this.getCurrentStatus(accountDTO);
        return this.accountHelper.toVO(accountStatus);
    }

    @Override
    public AccountStatus getCurrentStatus(AccountDTO params) {
        Account account = this.getAccount(params, new Relationship[0]);
        AccountStatus status = this.getStatus(account, null);
        if (account instanceof MemberAccount) {
            BigDecimal diff = this.accountFeeService.calculateReservedAmountForVolumeFee((MemberAccount)account);
            status.setReservedAmount(status.getReservedAmount().add(diff));
        }
        return status;
    }

    @Override
    public TransactionSummaryVO getDebits(GetTransactionsDTO params) {
        return this.accountDao.getDebits(params);
    }

    @Override
    public MemberAccount getDefaultAccount() {
        MemberGroup group;
        MemberAccountType defaultType;
        MemberAccount account = null;
        if (LoggedUser.hasUser() && (defaultType = this.accountTypeService.getDefault(group = (MemberGroup)LoggedUser.group(), new Relationship[0])) != null) {
            account = (MemberAccount)this.getAccount(new AccountDTO(LoggedUser.accountOwner(), defaultType), new Relationship[0]);
        }
        if (account == null) {
            throw new EntityNotFoundException(Account.class);
        }
        return account;
    }

    @Override
    public Account getDefaultAccountFromList(Member member, List<Account> allowedAccounts) {
        member = this.fetchService.fetch(member, Element.Relationships.GROUP);
        MemberAccountType defaultType = this.accountTypeService.getDefault(member.getMemberGroup(), new Relationship[0]);
        for (Account currentAccount : allowedAccounts) {
            if (!currentAccount.getType().equals(defaultType)) continue;
            return currentAccount;
        }
        if (allowedAccounts.size() > 0) {
            return allowedAccounts.get(0);
        }
        return null;
    }

    @Override
    public BigDecimal getExclusiveBalance(AccountDateDTO params) {
        BigDecimal balance;
        Calendar date;
        Account account = this.getAccount(params, new Relationship[0]);
        ClosedAccountBalance closedBalance = this.closedAccountBalanceDao.get(account, date = params.getDate());
        BigDecimal bigDecimal = balance = closedBalance == null ? BigDecimal.ZERO : closedBalance.getBalance();
        if (date == null || closedBalance == null || !date.equals(closedBalance.getDate())) {
            Calendar beginDate = closedBalance == null ? null : closedBalance.getDate();
            Period balanceDiffPeriod = Period.between(beginDate, date).useTime();
            balanceDiffPeriod.setInclusiveEnd(false);
            BigDecimal diff = this.transferDao.balanceDiff(account, balanceDiffPeriod);
            balance = balance.add(diff);
        }
        return balance;
    }

    @Override
    public MemberAccountVO getMemberAccountVO(Long memberAccountId) {
        if (memberAccountId == null) {
            return null;
        }
        MemberAccount memberAccount = (MemberAccount)this.load(memberAccountId, new Relationship[0]);
        return this.accountHelper.toVO(memberAccount);
    }

    @Override
    public AccountStatus getRatedStatus(Account account, Calendar date) {
        AccountStatus status = this.getStatusAt(account, date, false);
        RatesDTO dto = new RatesDTO();
        dto.setDate(date);
        dto.setAccount(account);
        dto.setAmount(status.getBalance());
        RatesResultDTO rates = this.rateService.getRates(dto);
        status.setRates(rates);
        return status;
    }

    @Override
    public AccountStatus getStatus(Account account, Calendar date) {
        return this.getStatusAt(account, date, false);
    }

    @Override
    public Map<PaymentFilter, TransactionSummaryVO> getTransactionsSummary(Member member, AccountType accountType, Period period, Collection<PaymentFilter> paymentFilters, boolean credits) {
        HashMap<PaymentFilter, TransactionSummaryVO> summary = new HashMap<PaymentFilter, TransactionSummaryVO>();
        GetTransactionsDTO params = new GetTransactionsDTO();
        params.setOwner(member);
        params.setType(accountType);
        params.setPeriod(period);
        for (PaymentFilter paymentFilter : paymentFilters) {
            params.setPaymentFilter(paymentFilter);
            TransactionSummaryVO vo = credits ? this.accountDao.getCredits(params) : this.accountDao.getDebits(params);
            summary.put(paymentFilter, vo);
        }
        return summary;
    }

    @Override
    public boolean hasAccounts(Member member) {
        return !this.getAccounts((AccountOwner)member, new Relationship[0]).isEmpty();
    }

    @Override
    public <T extends Account> T load(Long id, Relationship ... fetch) {
        return (T)((Account)this.accountDao.load(id, fetch));
    }

    @Override
    public Iterator<MemberTransactionDetailsReportData> membersTransactionsDetailsReport(MembersTransactionsReportParameters params) {
        if (!this.isValid(params)) {
            return IteratorUtils.EMPTY_ITERATOR;
        }
        return this.accountDao.membersTransactionsDetailsReport(params);
    }

    @Override
    public Iterator<MemberTransactionSummaryReportData> membersTransactionsSummaryReport(MembersTransactionsReportParameters params) {
        if (!this.isValid(params)) {
            return IteratorUtils.EMPTY_ITERATOR;
        }
        Iterator<Member> membersIterator = this.resolveMembersForTransactionsReport(params);
        return new MembersTransactionsSummaryIterator(membersIterator, params);
    }

    @Override
    public void removeClosedBalancesAfter(Account account, Calendar date) {
        this.closedAccountBalanceDao.removeClosedBalancesAfter(account, date);
    }

    @Override
    public ScheduledPaymentAmountReservation reserve(ScheduledPayment scheduledPayment) {
        ScheduledPaymentAmountReservation reservation = new ScheduledPaymentAmountReservation();
        reservation.setDate(Calendar.getInstance());
        reservation.setAccount(scheduledPayment.getFrom());
        reservation.setAmount(scheduledPayment.getAmount());
        reservation.setScheduledPayment(scheduledPayment);
        return this.insertReservation(reservation);
    }

    @Override
    public PendingAuthorizationAmountReservation reservePending(Transfer transfer) {
        PendingAuthorizationAmountReservation reservation = new PendingAuthorizationAmountReservation();
        reservation.setDate(Calendar.getInstance());
        reservation.setAccount(transfer.getFrom());
        reservation.setAmount(transfer.getAmount());
        reservation.setTransfer(transfer);
        return this.insertReservation(reservation);
    }

    @Override
    public TransferAuthorizationAmountReservation returnReservation(TransferAuthorization authorization, Transfer transfer) {
        TransferAuthorizationAmountReservation reservation = new TransferAuthorizationAmountReservation();
        reservation.setDate(Calendar.getInstance());
        reservation.setAccount(transfer.getFrom());
        reservation.setAmount(transfer.getAmount().negate());
        reservation.setTransferAuthorization(authorization);
        reservation.setTransfer(transfer);
        return this.insertReservation(reservation);
    }

    @Override
    public InstallmentAmountReservation returnReservationForInstallment(Transfer transfer) {
        InstallmentAmountReservation reservation = new InstallmentAmountReservation();
        reservation.setDate(Calendar.getInstance());
        reservation.setAccount(transfer.getFrom());
        reservation.setAmount(transfer.getAmount().negate());
        reservation.setTransfer(transfer);
        return this.insertReservation(reservation);
    }

    public void setAccountDao(AccountDAO accountDao) {
        this.accountDao = accountDao;
    }

    public void setAccountFeeServiceLocal(AccountFeeServiceLocal accountFeeService) {
        this.accountFeeService = accountFeeService;
    }

    public void setAccountHelper(AccountHelper accountHelper) {
        this.accountHelper = accountHelper;
    }

    public void setAccountLimitLogDao(AccountLimitLogDAO accountLimitLogDao) {
        this.accountLimitLogDao = accountLimitLogDao;
    }

    public void setAccountTypeServiceLocal(AccountTypeServiceLocal accountTypeService) {
        this.accountTypeService = accountTypeService;
    }

    public void setAmountReservationDao(AmountReservationDAO amountReservationDao) {
        this.amountReservationDao = amountReservationDao;
    }

    public void setClosedAccountBalanceDao(ClosedAccountBalanceDAO closedAccountBalanceDao) {
        this.closedAccountBalanceDao = closedAccountBalanceDao;
    }

    @Override
    public void setCreditLimit(Member owner, CreditLimitDTO limits) {
        this.validate(owner, limits);
        Map<? extends AccountType, BigDecimal> limitPerType = limits.getLimitPerType();
        HashMap<? extends AccountType, BigDecimal> newLimitPerType = new HashMap<AccountType, BigDecimal>();
        if (limitPerType != null) {
            for (AccountType accountType : limitPerType.keySet()) {
                BigDecimal limit = limitPerType.get(accountType);
                AccountType accountType2 = this.fetchService.fetch(accountType, new Relationship[0]);
                newLimitPerType.put(accountType2, limit);
            }
        }
        limitPerType = newLimitPerType;
        limits.setLimitPerType(limitPerType);
        Map<? extends AccountType, BigDecimal> upperLimitPerType = limits.getUpperLimitPerType();
        HashMap<? extends AccountType, BigDecimal> hashMap = new HashMap<AccountType, BigDecimal>();
        if (upperLimitPerType != null) {
            for (AccountType accountType : upperLimitPerType.keySet()) {
                BigDecimal limit = upperLimitPerType.get(accountType);
                AccountType accountType3 = this.fetchService.fetch(accountType, new Relationship[0]);
                hashMap.put(accountType3, limit);
            }
        }
        upperLimitPerType = hashMap;
        limits.setUpperLimitPerType(upperLimitPerType);
        List<CreditLimitDTO.Entry> entries = limits.getEntries();
        for (CreditLimitDTO.Entry entry : entries) {
            AccountType type = entry.getAccountType();
            BigDecimal limit = entry.getCreditLimit();
            BigDecimal upperLimit = entry.getUpperCreditLimit();
            if (limit == null && upperLimit == null) continue;
            List<? extends Account> accts = owner == null ? this.getAccounts(type) : Arrays.asList(this.getAccount(new AccountDTO(owner, type), new Relationship[0]));
            for (Account account : accts) {
                boolean limitHasChanged = false;
                if (limit != null && !account.getCreditLimit().equals(limit.abs())) {
                    account.setCreditLimit(limit.abs());
                    limitHasChanged = true;
                }
                if (!(upperLimit == null || account.getUpperCreditLimit() != null && account.getUpperCreditLimit().equals(upperLimit.abs()))) {
                    account.setUpperCreditLimit(upperLimit.abs());
                    limitHasChanged = true;
                }
                if (!limitHasChanged) continue;
                Account account2 = this.accountDao.update(account);
                AccountLimitLog log = new AccountLimitLog();
                log.setAccount(account2);
                log.setBy((Administrator)LoggedUser.element());
                log.setDate(Calendar.getInstance());
                log.setCreditLimit(limit);
                log.setUpperCreditLimit(upperLimit);
                this.accountLimitLogDao.insert(log);
            }
        }
    }

    public void setElementServiceLocal(ElementServiceLocal elementService) {
        this.elementService = elementService;
    }

    public void setFetchServiceLocal(FetchServiceLocal fetchService) {
        this.fetchService = fetchService;
    }

    public void setGroupServiceLocal(GroupServiceLocal groupService) {
        this.groupService = groupService;
    }

    public void setPermissionServiceLocal(PermissionServiceLocal permissionService) {
        this.permissionService = permissionService;
    }

    public void setRateServiceLocal(RateServiceLocal rateService) {
        this.rateService = rateService;
    }

    public void setSettingsServiceLocal(SettingsServiceLocal settingsService) {
        this.settingsService = settingsService;
    }

    public void setTransactionHelper(TransactionHelper transactionHelper) {
        this.transactionHelper = transactionHelper;
    }

    public void setTransferDao(TransferDAO transferDao) {
        this.transferDao = transferDao;
    }

    @Override
    public void validate(Member member, CreditLimitDTO creditLimit) {
        try {
            member = this.fetchService.fetch(member, new Relationship[0]);
        }
        catch (Exception e) {
            throw new ValidationException();
        }
        Map<? extends AccountType, BigDecimal> limitPerType = creditLimit.getLimitPerType();
        Map<? extends AccountType, BigDecimal> upperLimitPerType = creditLimit.getUpperLimitPerType();
        HashSet<AccountType> accountTypes = new HashSet<AccountType>();
        if (limitPerType != null) {
            for (AccountType accountType : limitPerType.keySet()) {
                accountTypes.add(accountType);
            }
        }
        if (upperLimitPerType != null) {
            for (AccountType accountType : upperLimitPerType.keySet()) {
                accountTypes.add(accountType);
            }
        }
        for (AccountType accountType : accountTypes) {
            try {
                this.getAccount(new AccountDTO(member, accountType), new Relationship[0]);
            }
            catch (EntityNotFoundException e) {
                throw new ValidationException();
            }
        }
    }

    private void closeBalance(Account account, Calendar day) {
        AccountStatus status = this.getStatusAt(account, day, true);
        if (status != null) {
            ClosedAccountBalance closedBalance = new ClosedAccountBalance();
            closedBalance.setDate(day);
            closedBalance.setAccount(account);
            closedBalance.setBalance(status.getBalance());
            closedBalance.setReserved(status.getReservedAmount());
            this.closedAccountBalanceDao.insert(closedBalance);
        }
        account.setLastClosingDate(day);
    }

    private List<? extends Account> getAccounts(AccountOwner owner, boolean forceAllAccounts, Relationship ... fetch) {
        AccountQuery query = new AccountQuery();
        query.setOwner(owner);
        query.fetch(fetch);
        List<? extends Account> accounts = this.accountDao.search(query);
        if (forceAllAccounts) {
            return accounts;
        }
        if (owner instanceof Member) {
            accounts = new ArrayList<Account>(accounts);
            Member member = this.fetchService.fetch((Member)owner, new Relationship[0]);
            Iterator<? extends Account> iterator = accounts.iterator();
            while (iterator.hasNext()) {
                MemberGroupAccountSettings accountSettings;
                Account account = iterator.next();
                boolean remove = false;
                Group group = member.getGroup();
                if (group.getStatus() == Group.Status.NORMAL) {
                    try {
                        accountSettings = this.groupService.loadAccountSettings(group.getId(), account.getType().getId(), new Relationship[0]);
                    }
                    catch (EntityNotFoundException e) {
                        accountSettings = null;
                        remove = true;
                    }
                } else {
                    accountSettings = null;
                }
                if (accountSettings != null && accountSettings.isHideWhenNoCreditLimit()) {
                    boolean hasCreditLimit;
                    boolean bl = hasCreditLimit = Math.abs(account.getCreditLimit().floatValue()) > 1.0E-4f;
                    if (!hasCreditLimit && !this.transferDao.hasTransfers(account)) {
                        remove = true;
                    }
                }
                if (!remove) continue;
                iterator.remove();
            }
        }
        return accounts;
    }

    private List<? extends Account> getAccounts(AccountType type) {
        AccountQuery query = new AccountQuery();
        query.setType(type);
        return this.accountDao.search(query);
    }

    private AccountStatus getStatusAt(Account account, Calendar date, boolean onlyIfThereAreDiffs) {
        AccountStatus status = new AccountStatus();
        status.setAccount(account);
        status.setCreditLimit(account.getCreditLimit());
        status.setUpperCreditLimit(account.getUpperCreditLimit());
        status.setDate(date);
        ClosedAccountBalance closedBalance = this.closedAccountBalanceDao.get(account, date);
        Calendar closedDate = closedBalance == null ? null : closedBalance.getDate();
        Calendar endDate = (Calendar)(date == null ? null : date.clone());
        if (endDate != null) {
            endDate.add(13, -1);
        }
        Period period = Period.between(closedDate, endDate);
        BigDecimal balanceDiff = this.transferDao.balanceDiff(account, period);
        status.setBalance(closedBalance == null ? balanceDiff : closedBalance.getBalance().add(balanceDiff));
        BigDecimal reservationDiff = this.amountReservationDao.reservationDiff(account, period);
        status.setReservedAmount(closedBalance == null ? reservationDiff : closedBalance.getReserved().add(reservationDiff));
        if (onlyIfThereAreDiffs && balanceDiff.equals(BigDecimal.ZERO) && reservationDiff.equals(BigDecimal.ZERO)) {
            return null;
        }
        return status;
    }

    private <R extends AmountReservation> R insertReservation(R reservation) {
        reservation = this.amountReservationDao.insert(reservation);
        this.removeClosedBalancesAfter(reservation.getAccount(), reservation.getDate());
        return reservation;
    }

    private boolean isValid(MembersTransactionsReportParameters params) {
        Collection<MemberGroup> memberGroups = params.getMemberGroups();
        if (CollectionUtils.isEmpty(memberGroups)) {
            return false;
        }
        return params.isDebits() || params.isCredits();
    }

    private Iterator<Member> resolveMembersForTransactionsReport(MembersTransactionsReportParameters params) {
        Collection<MemberGroup> groups = params.getMemberGroups();
        Period period = params.getPeriod();
        MemberQuery query = new MemberQuery();
        query.setPageParameters(params.getPageParameters());
        if (params.isFetchBroker()) {
            query.fetch(Member.Relationships.BROKER);
        }
        query.setGroups(groups);
        if (period != null && period.getEnd() != null) {
            query.setActivationPeriod(Period.endingAt(period.getEnd()));
        }
        query.setResultType(QueryParameters.ResultType.ITERATOR);
        List<? extends Element> members = this.elementService.search(query);
        Iterator<? extends Element> membersIterator = members.iterator();
        return membersIterator;
    }

    private static class TransactionSummaryReportKey {
        private final PaymentFilter paymentFilter;
        private final boolean credits;

        public TransactionSummaryReportKey(PaymentFilter paymentFilter, boolean credits) {
            this.paymentFilter = paymentFilter;
            this.credits = credits;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            TransactionSummaryReportKey other = (TransactionSummaryReportKey)obj;
            return ObjectUtils.equals((Object)this.paymentFilter, (Object)other.paymentFilter) && this.credits == other.credits;
        }

        public int hashCode() {
            return this.paymentFilter.hashCode() * (this.credits ? 1 : -1);
        }
    }

    private class MembersTransactionsSummaryIterator
    extends CombinedIterator<MemberTransactionSummaryReportData, Member, MemberTransactionSummaryVO, TransactionSummaryReportKey> {
        private final MembersTransactionsReportParameters params;
        private final List<Boolean> creditOrDebitToQuery;

        private MembersTransactionsSummaryIterator(Iterator<Member> masterIterator, MembersTransactionsReportParameters params) {
            super(masterIterator);
            this.params = params;
            this.creditOrDebitToQuery = new ArrayList<Boolean>();
            if (params.isCredits()) {
                this.creditOrDebitToQuery.add(true);
            }
            if (params.isDebits()) {
                this.creditOrDebitToQuery.add(false);
            }
        }

        @Override
        protected boolean belongsToMasterElement(Member member, TransactionSummaryReportKey key, MemberTransactionSummaryVO vo) {
            return vo.getMemberId().equals(member.getId());
        }

        @Override
        protected MemberTransactionSummaryReportData combine(Member member, Map<TransactionSummaryReportKey, MemberTransactionSummaryVO> elements) {
            MemberTransactionSummaryReportData data = new MemberTransactionSummaryReportData();
            data.setMember(member);
            for (Map.Entry<TransactionSummaryReportKey, MemberTransactionSummaryVO> entry : elements.entrySet()) {
                TransactionSummaryReportKey key = entry.getKey();
                MemberTransactionSummaryVO transactions = entry.getValue();
                if (key.credits) {
                    data.addCredits(key.paymentFilter, transactions);
                    continue;
                }
                data.addDebits(key.paymentFilter, transactions);
            }
            return data;
        }

        @Override
        protected void registerInnerIterators() {
            Collection<PaymentFilter> paymentFilters = this.params.getPaymentFilters();
            LocalSettings.MemberResultDisplay memberDisplay = AccountServiceImpl.this.settingsService.getLocalSettings().getMemberResultDisplay();
            for (PaymentFilter paymentFilter : paymentFilters) {
                for (Boolean isCredit : this.creditOrDebitToQuery) {
                    Iterator<MemberTransactionSummaryVO> iterator = AccountServiceImpl.this.accountDao.membersTransactionSummaryReport(this.params.getMemberGroups(), paymentFilter, this.params.getPeriod(), isCredit, memberDisplay);
                    TransactionSummaryReportKey key = new TransactionSummaryReportKey(paymentFilter, isCredit);
                    this.registerInnerIterator(key, iterator);
                }
            }
        }
    }
}

