/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.services.accounts;

import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Collection;
import java.util.Map;
import nl.strohalm.cyclos.entities.accounts.Account;
import nl.strohalm.cyclos.entities.accounts.AccountStatus;
import nl.strohalm.cyclos.entities.accounts.AccountType;
import nl.strohalm.cyclos.entities.accounts.InstallmentAmountReservation;
import nl.strohalm.cyclos.entities.accounts.MemberAccountType;
import nl.strohalm.cyclos.entities.accounts.PendingAuthorizationAmountReservation;
import nl.strohalm.cyclos.entities.accounts.ScheduledPaymentAmountReservation;
import nl.strohalm.cyclos.entities.accounts.TransferAuthorizationAmountReservation;
import nl.strohalm.cyclos.entities.accounts.transactions.PaymentFilter;
import nl.strohalm.cyclos.entities.accounts.transactions.ScheduledPayment;
import nl.strohalm.cyclos.entities.accounts.transactions.Transfer;
import nl.strohalm.cyclos.entities.accounts.transactions.TransferAuthorization;
import nl.strohalm.cyclos.entities.groups.MemberGroup;
import nl.strohalm.cyclos.entities.members.Member;
import nl.strohalm.cyclos.services.accounts.AccountDateDTO;
import nl.strohalm.cyclos.services.accounts.AccountService;
import nl.strohalm.cyclos.services.accounts.GetTransactionsDTO;
import nl.strohalm.cyclos.services.transactions.TransactionSummaryVO;
import nl.strohalm.cyclos.utils.Period;

public interface AccountServiceLocal
extends AccountService {
    public void closeBalances(Calendar var1);

    public int countPendingActivation(MemberGroup var1, MemberAccountType var2);

    public BigDecimal getBalanceAtTimePoint(Account var1, Calendar var2, boolean var3, boolean var4);

    public BigDecimal getBalanceAtTransfer(Account var1, Transfer var2, boolean var3, boolean var4);

    public TransactionSummaryVO getBrokerCommissions(GetTransactionsDTO var1);

    public TransactionSummaryVO getCredits(GetTransactionsDTO var1);

    public TransactionSummaryVO getDebits(GetTransactionsDTO var1);

    public BigDecimal getExclusiveBalance(AccountDateDTO var1);

    public AccountStatus getStatus(Account var1, Calendar var2);

    public Map<PaymentFilter, TransactionSummaryVO> getTransactionsSummary(Member var1, AccountType var2, Period var3, Collection<PaymentFilter> var4, boolean var5);

    public void removeClosedBalancesAfter(Account var1, Calendar var2);

    public ScheduledPaymentAmountReservation reserve(ScheduledPayment var1);

    public PendingAuthorizationAmountReservation reservePending(Transfer var1);

    public TransferAuthorizationAmountReservation returnReservation(TransferAuthorization var1, Transfer var2);

    public InstallmentAmountReservation returnReservationForInstallment(Transfer var1);
}

