/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.services.accounts;

import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import nl.strohalm.cyclos.access.AdminMemberPermission;
import nl.strohalm.cyclos.access.AdminSystemPermission;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.accounts.Account;
import nl.strohalm.cyclos.entities.accounts.AccountOwner;
import nl.strohalm.cyclos.entities.accounts.AccountStatus;
import nl.strohalm.cyclos.entities.accounts.MemberAccount;
import nl.strohalm.cyclos.entities.accounts.transactions.TransferType;
import nl.strohalm.cyclos.entities.members.Member;
import nl.strohalm.cyclos.entities.members.MemberTransactionDetailsReportData;
import nl.strohalm.cyclos.entities.members.MemberTransactionSummaryReportData;
import nl.strohalm.cyclos.entities.members.MembersTransactionsReportParameters;
import nl.strohalm.cyclos.exceptions.PermissionDeniedException;
import nl.strohalm.cyclos.services.BaseServiceSecurity;
import nl.strohalm.cyclos.services.accounts.AccountDTO;
import nl.strohalm.cyclos.services.accounts.AccountDateDTO;
import nl.strohalm.cyclos.services.accounts.AccountService;
import nl.strohalm.cyclos.services.accounts.AccountServiceLocal;
import nl.strohalm.cyclos.services.accounts.CreditLimitDTO;
import nl.strohalm.cyclos.utils.access.PermissionHelper;
import nl.strohalm.cyclos.webservices.model.AccountStatusVO;
import nl.strohalm.cyclos.webservices.model.MemberAccountVO;

public class AccountServiceSecurity
extends BaseServiceSecurity
implements AccountService {
    private AccountServiceLocal accountService;

    @Override
    public boolean canView(Account account) {
        return this.accountService.canView(account);
    }

    @Override
    public boolean canViewAccountsOf(AccountOwner owner) {
        return this.accountService.canViewAccountsOf(owner);
    }

    @Override
    public boolean canViewAuthorizedInformation(AccountOwner owner) {
        return this.accountService.canViewAuthorizedInformation(owner);
    }

    @Override
    public Account getAccount(AccountDTO params, Relationship ... fetch) {
        Account account = this.accountService.getAccount(params, fetch);
        this.checkAccess(account);
        return account;
    }

    @Override
    public List<? extends Account> getAccounts(AccountOwner owner, Relationship ... fetch) {
        List<? extends Account> accounts = this.accountService.getAccounts(owner, fetch);
        Iterator<? extends Account> iterator = accounts.iterator();
        while (iterator.hasNext()) {
            Account account = iterator.next();
            if (this.canView(account)) continue;
            iterator.remove();
        }
        return accounts;
    }

    @Override
    public Set<? extends Account> getAccountsFromTTs(Member member, Collection<TransferType> allowedTTs, TransferType.Direction direction) {
        this.checkAccess(member);
        return this.accountService.getAccountsFromTTs(member, allowedTTs, direction);
    }

    @Override
    public BigDecimal getBalance(AccountDateDTO params) {
        Account account = this.accountService.getAccount(params, new Relationship[0]);
        this.checkAccess(account);
        params.setAccount(account);
        return this.accountService.getBalance(params);
    }

    @Override
    public BigDecimal getCreditLimit(AccountDTO params) {
        this.checkAccess(this.accountService.getAccount(params, new Relationship[0]));
        return this.accountService.getCreditLimit(params);
    }

    @Override
    public CreditLimitDTO getCreditLimits(Member member) {
        this.permissionService.permission(member).admin(AdminMemberPermission.ACCOUNTS_CREDIT_LIMIT).check();
        return this.accountService.getCreditLimits(member);
    }

    @Override
    public AccountStatusVO getCurrentAccountStatusVO(AccountDTO accountDTO) {
        Account account = this.accountService.getAccount(accountDTO, new Relationship[0]);
        this.checkAccess(account);
        return this.accountService.getCurrentAccountStatusVO(accountDTO);
    }

    @Override
    public AccountStatus getCurrentStatus(AccountDTO params) {
        Account account = this.accountService.getAccount(params, new Relationship[0]);
        this.checkAccess(account);
        return this.accountService.getCurrentStatus(new AccountDTO(account));
    }

    @Override
    public MemberAccount getDefaultAccount() {
        MemberAccount memberAccount = this.accountService.getDefaultAccount();
        this.checkAccess(memberAccount);
        return memberAccount;
    }

    @Override
    public Account getDefaultAccountFromList(Member member, List<Account> allowedAccounts) {
        Account account = this.accountService.getDefaultAccountFromList(member, allowedAccounts);
        this.checkAccess(account);
        return account;
    }

    @Override
    public MemberAccountVO getMemberAccountVO(Long memberAccountId) {
        if (memberAccountId == null) {
            return null;
        }
        return this.accountService.getMemberAccountVO(memberAccountId);
    }

    @Override
    public AccountStatus getRatedStatus(Account account, Calendar date) {
        this.checkAccess(account);
        return this.accountService.getRatedStatus(account, date);
    }

    @Override
    public boolean hasAccounts(Member member) {
        if (!this.permissionService.relatesTo(member)) {
            throw new PermissionDeniedException();
        }
        return this.accountService.hasAccounts(member);
    }

    @Override
    public <T extends Account> T load(Long id, Relationship ... fetch) {
        Object account = this.accountService.load(id, fetch);
        this.checkAccess((Account)account);
        return account;
    }

    @Override
    public Iterator<MemberTransactionDetailsReportData> membersTransactionsDetailsReport(MembersTransactionsReportParameters params) {
        this.permissionService.permission().admin(AdminSystemPermission.REPORTS_MEMBER_LIST).check();
        params.setMemberGroups(PermissionHelper.checkSelection(this.permissionService.getVisibleMemberGroups(), params.getMemberGroups()));
        return this.accountService.membersTransactionsDetailsReport(params);
    }

    @Override
    public Iterator<MemberTransactionSummaryReportData> membersTransactionsSummaryReport(MembersTransactionsReportParameters params) {
        this.permissionService.permission().admin(AdminSystemPermission.REPORTS_MEMBER_LIST).check();
        params.setMemberGroups(PermissionHelper.checkSelection(this.permissionService.getVisibleMemberGroups(), params.getMemberGroups()));
        return this.accountService.membersTransactionsSummaryReport(params);
    }

    public void setAccountServiceLocal(AccountServiceLocal accountService) {
        this.accountService = accountService;
    }

    @Override
    public void setCreditLimit(Member member, CreditLimitDTO limits) {
        this.permissionService.permission(member).admin(AdminMemberPermission.ACCOUNTS_CREDIT_LIMIT).check();
        this.accountService.setCreditLimit(member, limits);
    }

    @Override
    public void validate(Member member, CreditLimitDTO limits) {
        this.permissionService.permission(member).admin(AdminMemberPermission.ACCOUNTS_CREDIT_LIMIT).check();
        this.accountService.validate(member, limits);
    }

    private void checkAccess(Account account) {
        if (!this.canView(account)) {
            throw new PermissionDeniedException();
        }
    }

    private void checkAccess(AccountOwner owner) {
        if (!this.canViewAccountsOf(owner)) {
            throw new PermissionDeniedException();
        }
    }
}

