/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.services.accounts;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import nl.strohalm.cyclos.access.AdminSystemPermission;
import nl.strohalm.cyclos.dao.accounts.AccountDAO;
import nl.strohalm.cyclos.dao.accounts.AccountLimitLogDAO;
import nl.strohalm.cyclos.dao.accounts.AccountTypeDAO;
import nl.strohalm.cyclos.dao.groups.GroupDAO;
import nl.strohalm.cyclos.entities.Entity;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.accounts.AccountLimitLog;
import nl.strohalm.cyclos.entities.accounts.AccountOwner;
import nl.strohalm.cyclos.entities.accounts.AccountType;
import nl.strohalm.cyclos.entities.accounts.AccountTypeQuery;
import nl.strohalm.cyclos.entities.accounts.MemberAccountType;
import nl.strohalm.cyclos.entities.accounts.MemberGroupAccountSettings;
import nl.strohalm.cyclos.entities.accounts.SystemAccount;
import nl.strohalm.cyclos.entities.accounts.SystemAccountOwner;
import nl.strohalm.cyclos.entities.accounts.SystemAccountType;
import nl.strohalm.cyclos.entities.accounts.transactions.TransferType;
import nl.strohalm.cyclos.entities.accounts.transactions.TransferTypeQuery;
import nl.strohalm.cyclos.entities.groups.AdminGroup;
import nl.strohalm.cyclos.entities.groups.Group;
import nl.strohalm.cyclos.entities.groups.MemberGroup;
import nl.strohalm.cyclos.entities.groups.OperatorGroup;
import nl.strohalm.cyclos.entities.members.Administrator;
import nl.strohalm.cyclos.entities.members.Element;
import nl.strohalm.cyclos.entities.members.Member;
import nl.strohalm.cyclos.services.accounts.AccountTypeServiceLocal;
import nl.strohalm.cyclos.services.accounts.MemberAccountTypeQuery;
import nl.strohalm.cyclos.services.fetch.FetchServiceLocal;
import nl.strohalm.cyclos.services.permissions.PermissionServiceLocal;
import nl.strohalm.cyclos.services.transactions.TransactionContext;
import nl.strohalm.cyclos.services.transfertypes.TransferTypeServiceLocal;
import nl.strohalm.cyclos.utils.access.LoggedUser;
import nl.strohalm.cyclos.utils.cache.Cache;
import nl.strohalm.cyclos.utils.cache.CacheCallback;
import nl.strohalm.cyclos.utils.cache.CacheManager;
import nl.strohalm.cyclos.utils.query.PageHelper;
import nl.strohalm.cyclos.utils.validation.Validator;
import org.apache.commons.collections.CollectionUtils;

public class AccountTypeServiceImpl
implements AccountTypeServiceLocal {
    private static final String ALL_KEY = "_ALL_";
    private TransferTypeServiceLocal transferTypeService;
    private AccountDAO accountDao;
    private AccountTypeDAO accountTypeDao;
    private AccountLimitLogDAO accountLimitLogDao;
    private GroupDAO groupDao;
    private FetchServiceLocal fetchService;
    private CacheManager cacheManager;
    private PermissionServiceLocal permissionService;

    @Override
    public void clearCache() {
        this.getCache().clear();
    }

    @Override
    public MemberAccountType getDefault(MemberGroup group, Relationship ... fetch) {
        group = this.fetchService.fetch(group, MemberGroup.Relationships.ACCOUNT_SETTINGS);
        Collection<MemberGroupAccountSettings> accountSettings = group.getAccountSettings();
        MemberGroupAccountSettings defaultAccount = null;
        if (CollectionUtils.isNotEmpty(accountSettings)) {
            accountSettings = this.fetchService.fetch(accountSettings, new Relationship[]{MemberGroupAccountSettings.Relationships.ACCOUNT_TYPE});
            for (MemberGroupAccountSettings current : accountSettings) {
                if (!current.isDefault()) continue;
                defaultAccount = current;
                break;
            }
            if (defaultAccount == null) {
                defaultAccount = accountSettings.iterator().next();
            }
        }
        return defaultAccount == null ? null : this.fetchService.fetch(defaultAccount.getAccountType(), fetch);
    }

    @Override
    public Map<MemberAccountType, BigDecimal> getMemberAccountTypesBalance(Collection<MemberAccountType> types, Collection<MemberGroup> groups, Calendar timePoint) {
        TreeMap<MemberAccountType, BigDecimal> balances = new TreeMap<MemberAccountType, BigDecimal>();
        for (MemberAccountType type : types) {
            BigDecimal balance = this.accountTypeDao.getBalance(type, groups, timePoint);
            balances.put(this.fetchService.fetch(type, AccountType.Relationships.CURRENCY), balance);
        }
        return balances;
    }

    @Override
    public Map<SystemAccountType, BigDecimal> getSystemAccountTypesBalance(Collection<SystemAccountType> types, Calendar timePoint) {
        TreeMap<SystemAccountType, BigDecimal> balances = new TreeMap<SystemAccountType, BigDecimal>();
        for (SystemAccountType type : types) {
            BigDecimal balance = this.accountTypeDao.getBalance(type, timePoint);
            balances.put(this.fetchService.fetch(type, AccountType.Relationships.CURRENCY), balance);
        }
        return balances;
    }

    @Override
    public Collection<AccountType> getVisibleAccountTypes() {
        if (LoggedUser.isSystem()) {
            return this.listAll();
        }
        if (!LoggedUser.hasUser()) {
            return Collections.emptyList();
        }
        Object group = LoggedUser.group();
        return (Collection)this.getCache().get((Serializable)((Object)("_VISIBLE_" + ((Entity)group).getId())), new CacheCallback(){

            @Override
            public Object retrieve() {
                Collection<AccountType> result;
                if (AccountTypeServiceImpl.this.permissionService.permission().admin(AdminSystemPermission.ACCOUNTS_VIEW).hasPermission()) {
                    result = AccountTypeServiceImpl.this.listAll();
                } else if (LoggedUser.isOperator()) {
                    OperatorGroup group = (OperatorGroup)LoggedUser.group();
                    result = AccountTypeServiceImpl.this.fetchService.fetch(group, OperatorGroup.Relationships.CAN_VIEW_INFORMATION_OF).getCanViewInformationOf();
                } else {
                    MemberAccountTypeQuery memberQuery = new MemberAccountTypeQuery();
                    memberQuery.setRelatedToGroups(AccountTypeServiceImpl.this.permissionService.getManagedMemberGroups());
                    result = AccountTypeServiceImpl.this.search(memberQuery);
                    if (LoggedUser.isAdministrator()) {
                        AdminGroup group = (AdminGroup)LoggedUser.group();
                        Collection<SystemAccountType> systemTypes = AccountTypeServiceImpl.this.fetchService.fetch(group, AdminGroup.Relationships.VIEW_INFORMATION_OF).getViewInformationOf();
                        result = CollectionUtils.union(result, systemTypes);
                    }
                }
                return AccountTypeServiceImpl.this.fetchService.fetch(result, new Relationship[]{AccountType.Relationships.CURRENCY});
            }
        });
    }

    @Override
    public boolean hasAuthorizedPayments(AccountType accountType) {
        accountType = this.fetchService.fetch(accountType, AccountType.Relationships.FROM_TRANSFER_TYPES);
        for (TransferType transferType : accountType.getFromTransferTypes()) {
            if (!transferType.isRequiresAuthorization()) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<? extends AccountType> listAll() {
        return (List)this.getCache().get((Serializable)((Object)ALL_KEY), new CacheCallback(){

            @Override
            public Object retrieve() {
                return AccountTypeServiceImpl.this.accountTypeDao.listAll();
            }
        });
    }

    @Override
    public Collection<AccountType> load(Collection<Long> ids) {
        ArrayList<AccountType> accountTypes = new ArrayList<AccountType>(ids.size());
        for (Long id : ids) {
            accountTypes.add(this.load(id));
        }
        return accountTypes;
    }

    @Override
    public AccountType load(final Long id) {
        return (AccountType)this.getCache().get(id, new CacheCallback(){

            @Override
            public Object retrieve() {
                AccountType accountType = (AccountType)AccountTypeServiceImpl.this.accountTypeDao.load(id, AccountType.Relationships.CURRENCY, SystemAccountType.Relationships.EXTERNAL_ACCOUNTS);
                AccountTypeServiceImpl.this.fillSystemLimits(accountType);
                return accountType;
            }
        });
    }

    @Override
    public int remove(Long ... ids) {
        for (Long id : ids) {
            AccountType accountType = (AccountType)this.accountTypeDao.load(id, new Relationship[0]);
            if (!(accountType instanceof SystemAccountType)) continue;
            SystemAccountType systemAccountType = (SystemAccountType)accountType;
            SystemAccount account = systemAccountType.getAccount();
            systemAccountType.setAccount(null);
            this.accountTypeDao.update(systemAccountType);
            this.accountDao.delete(account.getId());
        }
        this.getCache().clear();
        return this.accountTypeDao.delete(ids);
    }

    @Override
    public <AT extends AccountType> AT save(AT accountType) {
        AccountType saved = null;
        this.validate(accountType);
        SystemAccount systemAccount = null;
        if (accountType.isTransient()) {
            saved = this.accountTypeDao.insert(accountType);
            if (saved instanceof SystemAccountType) {
                SystemAccountType systemAccountType = (SystemAccountType)accountType;
                systemAccount = new SystemAccount();
                systemAccount.setCreationDate(Calendar.getInstance());
                systemAccount.setCreditLimit(systemAccountType.getCreditLimit());
                systemAccount.setUpperCreditLimit(systemAccountType.getUpperCreditLimit());
                systemAccount.setType(saved);
                systemAccount.setOwnerName(saved.getName());
                systemAccount = this.accountDao.insert(systemAccount);
                AdminGroup group = (AdminGroup)LoggedUser.group();
                group = (AdminGroup)this.groupDao.load(group.getId(), AdminGroup.Relationships.VIEW_INFORMATION_OF);
                Collection<SystemAccountType> systemAccountTypes = group.getViewInformationOf();
                systemAccountTypes.add(systemAccountType);
                this.groupDao.update(group);
            }
        } else {
            if (accountType instanceof SystemAccountType) {
                boolean updateLimit;
                SystemAccountType currentAccountType = (SystemAccountType)this.accountTypeDao.load(accountType.getId(), SystemAccountType.Relationships.VIEWED_BY_GROUPS);
                ArrayList<AdminGroup> viewedByGroups = new ArrayList<AdminGroup>();
                if (currentAccountType.getViewedByGroups() != null) {
                    viewedByGroups.addAll(currentAccountType.getViewedByGroups());
                }
                SystemAccountType systemAccountType = (SystemAccountType)accountType;
                systemAccountType.setViewedByGroups(viewedByGroups);
                systemAccount = (SystemAccount)this.accountDao.load(SystemAccountOwner.instance(), systemAccountType, new Relationship[0]);
                BigDecimal oldLimit = systemAccount.getCreditLimit() == null ? null : systemAccount.getCreditLimit().abs();
                BigDecimal oldUpperLimit = systemAccount.getUpperCreditLimit();
                BigDecimal newLimit = systemAccountType.getCreditLimit() == null ? null : systemAccountType.getCreditLimit().abs();
                BigDecimal newUpperLimit = systemAccountType.getUpperCreditLimit();
                boolean bl = updateLimit = newLimit != null && !newLimit.equals(oldLimit) || newUpperLimit != null && !newUpperLimit.equals(oldUpperLimit);
                if (updateLimit) {
                    systemAccount.setCreditLimit(newLimit);
                    systemAccount.setUpperCreditLimit(newUpperLimit);
                }
                systemAccount.setOwnerName(systemAccountType.getName());
                systemAccountType.setAccount(systemAccount);
                this.accountDao.update(systemAccount);
                if (updateLimit) {
                    AccountLimitLog log = new AccountLimitLog();
                    log.setAccount(systemAccount);
                    log.setBy((Administrator)LoggedUser.element());
                    log.setDate(Calendar.getInstance());
                    log.setCreditLimit(newLimit);
                    log.setUpperCreditLimit(newUpperLimit);
                    this.accountLimitLogDao.insert(log);
                }
            }
            saved = this.accountTypeDao.update(accountType);
        }
        if (systemAccount != null) {
            ((SystemAccountType)saved).setAccount(systemAccount);
            saved = this.accountTypeDao.update(saved);
        }
        this.getCache().clear();
        return (AT)saved;
    }

    @Override
    public List<? extends AccountType> search(AccountTypeQuery query) {
        MemberAccountTypeQuery memberQuery;
        AccountOwner canPay;
        if (query instanceof MemberAccountTypeQuery && (canPay = (memberQuery = (MemberAccountTypeQuery)query).getCanPay()) != null) {
            Member owner;
            Group group = null;
            if (canPay instanceof Member) {
                Member member = this.fetchService.fetch((Member)canPay, Element.Relationships.GROUP);
                group = member.getGroup();
            }
            if ((owner = memberQuery.getOwner()) == null && LoggedUser.hasUser() && LoggedUser.isMember()) {
                owner = (Member)LoggedUser.element();
            }
            ArrayList<MemberAccountType> accountTypes = new ArrayList<MemberAccountType>();
            for (MemberAccountType memberAccountType : this.accountTypeDao.search(new MemberAccountTypeQuery())) {
                TransferTypeQuery transferTypeQuery = new TransferTypeQuery();
                transferTypeQuery.setPageForCount();
                transferTypeQuery.setContext(TransactionContext.PAYMENT);
                transferTypeQuery.setChannel("web");
                transferTypeQuery.setUsePriority(true);
                transferTypeQuery.setToAccountType(memberAccountType);
                transferTypeQuery.setToOwner(owner);
                transferTypeQuery.setFromOwner(canPay);
                transferTypeQuery.setGroup(group);
                if (PageHelper.getTotalCount(this.transferTypeService.search(transferTypeQuery)) <= 0) continue;
                accountTypes.add(memberAccountType);
            }
            return accountTypes;
        }
        return this.accountTypeDao.search(query);
    }

    public void setAccountDao(AccountDAO accountDao) {
        this.accountDao = accountDao;
    }

    public void setAccountLimitLogDao(AccountLimitLogDAO accountLimitLogDao) {
        this.accountLimitLogDao = accountLimitLogDao;
    }

    public void setAccountTypeDao(AccountTypeDAO accountTypeDao) {
        this.accountTypeDao = accountTypeDao;
    }

    public void setCacheManager(CacheManager cacheManager) {
        this.cacheManager = cacheManager;
    }

    public void setFetchServiceLocal(FetchServiceLocal fetchService) {
        this.fetchService = fetchService;
    }

    public void setGroupDao(GroupDAO groupDao) {
        this.groupDao = groupDao;
    }

    public void setPermissionServiceLocal(PermissionServiceLocal permissionService) {
        this.permissionService = permissionService;
    }

    public void setTransferTypeServiceLocal(TransferTypeServiceLocal transferTypeService) {
        this.transferTypeService = transferTypeService;
    }

    @Override
    public void validate(AccountType accountType) {
        this.getValidator().validate(accountType);
    }

    private void fillSystemLimits(AccountType accountType) {
        SystemAccountType sat;
        SystemAccount account;
        if (accountType instanceof SystemAccountType && (account = (sat = (SystemAccountType)accountType).getAccount()) != null) {
            BigDecimal creditLimit = account.getCreditLimit();
            if (creditLimit != null) {
                sat.setCreditLimit(creditLimit.abs().negate());
            }
            sat.setUpperCreditLimit(account.getUpperCreditLimit());
        }
    }

    private Cache getCache() {
        return this.cacheManager.getCache("cyclos.AccountTypes");
    }

    private Validator getValidator() {
        Validator validator = new Validator("accountType");
        validator.property("name").required().maxLength(100);
        validator.property("description").maxLength(1000);
        validator.property("currency").required();
        return validator;
    }
}

