/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.services.accounts;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import nl.strohalm.cyclos.access.AdminSystemPermission;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.accounts.AccountType;
import nl.strohalm.cyclos.entities.accounts.AccountTypeQuery;
import nl.strohalm.cyclos.entities.accounts.MemberAccountType;
import nl.strohalm.cyclos.entities.accounts.MemberGroupAccountSettings;
import nl.strohalm.cyclos.entities.accounts.SystemAccountType;
import nl.strohalm.cyclos.entities.groups.AdminGroup;
import nl.strohalm.cyclos.entities.groups.MemberGroup;
import nl.strohalm.cyclos.services.BaseServiceSecurity;
import nl.strohalm.cyclos.services.accounts.AccountTypeService;
import nl.strohalm.cyclos.services.accounts.AccountTypeServiceLocal;
import nl.strohalm.cyclos.utils.access.LoggedUser;
import nl.strohalm.cyclos.utils.access.PermissionHelper;
import org.apache.commons.beanutils.BeanComparator;

public class AccountTypeServiceSecurity
extends BaseServiceSecurity
implements AccountTypeService {
    private AccountTypeServiceLocal accountTypeService;

    @Override
    public MemberAccountType getDefault(MemberGroup group, Relationship ... fetch) {
        PermissionHelper.checkContains(this.permissionService.getVisibleMemberGroups(), group);
        return this.accountTypeService.getDefault(group, fetch);
    }

    @Override
    public List<? extends AccountType> listAll() {
        ArrayList<AccountType> accountTypes = new ArrayList<AccountType>();
        accountTypes.addAll(this.accountTypeService.getVisibleAccountTypes());
        Collections.sort(accountTypes, new BeanComparator("name"));
        return accountTypes;
    }

    @Override
    public Collection<AccountType> load(Collection<Long> ids) {
        Collection<AccountType> accountTypes = this.accountTypeService.load(ids);
        for (AccountType accountType : accountTypes) {
            this.checkVisible(accountType);
        }
        return accountTypes;
    }

    @Override
    public AccountType load(Long id) {
        AccountType accountType = this.accountTypeService.load(id);
        this.checkVisible(accountType);
        return accountType;
    }

    @Override
    public int remove(Long ... ids) {
        this.permissionService.permission().admin(AdminSystemPermission.ACCOUNTS_MANAGE).check();
        return this.accountTypeService.remove(ids);
    }

    @Override
    public <AT extends AccountType> AT save(AT accountType) {
        this.permissionService.permission().admin(AdminSystemPermission.ACCOUNTS_MANAGE).check();
        return this.accountTypeService.save(accountType);
    }

    @Override
    public List<? extends AccountType> search(AccountTypeQuery query) {
        List<? extends AccountType> accountTypes = this.accountTypeService.search(query);
        accountTypes.retainAll(this.accountTypeService.getVisibleAccountTypes());
        return accountTypes;
    }

    public void setAccountTypeServiceLocal(AccountTypeServiceLocal accountTypeService) {
        this.accountTypeService = accountTypeService;
    }

    @Override
    public void validate(AccountType accountType) {
        this.accountTypeService.validate(accountType);
    }

    private boolean checkVisible(AccountType accountType) {
        if (this.permissionService.permission().admin(AdminSystemPermission.ACCOUNTS_VIEW).hasPermission()) {
            return true;
        }
        if (accountType instanceof SystemAccountType) {
            AdminGroup group = (AdminGroup)LoggedUser.group();
            Collection<SystemAccountType> systemTypes = this.fetchService.fetch(group, AdminGroup.Relationships.VIEW_INFORMATION_OF).getViewInformationOf();
            return systemTypes.contains(accountType);
        }
        Collection<MemberGroup> groups = this.permissionService.getManagedMemberGroups();
        MemberAccountType memberType = (MemberAccountType)this.fetchService.fetch(accountType, MemberAccountType.Relationships.SETTINGS);
        for (MemberGroupAccountSettings settings : memberType.getSettings()) {
            if (!groups.contains(settings.getGroup())) continue;
            return true;
        }
        return false;
    }
}

