/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.services.accounts;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import nl.strohalm.cyclos.entities.accounts.AccountType;
import nl.strohalm.cyclos.utils.DataObject;
import org.apache.commons.beanutils.BeanComparator;

public class CreditLimitDTO
extends DataObject {
    private static final long serialVersionUID = 1285604922318613946L;
    private Map<? extends AccountType, BigDecimal> limitPerType;
    private Map<? extends AccountType, BigDecimal> upperLimitPerType;

    public List<Entry> getEntries() {
        ArrayList<Entry> list = new ArrayList<Entry>();
        TreeSet<AccountType> accountTypes = new TreeSet<AccountType>((Comparator<AccountType>)new BeanComparator("name"));
        if (this.limitPerType != null) {
            for (AccountType accountType : this.limitPerType.keySet()) {
                accountTypes.add(accountType);
            }
        }
        if (this.upperLimitPerType != null) {
            for (AccountType accountType : this.upperLimitPerType.keySet()) {
                accountTypes.add(accountType);
            }
        }
        for (AccountType accountType : accountTypes) {
            BigDecimal limit = this.limitPerType == null ? null : this.limitPerType.get(accountType);
            BigDecimal upperLimit = this.upperLimitPerType == null ? null : this.upperLimitPerType.get(accountType);
            list.add(new Entry(accountType, limit, upperLimit));
        }
        return list;
    }

    public Map<? extends AccountType, BigDecimal> getLimitPerType() {
        return this.limitPerType;
    }

    public Map<? extends AccountType, BigDecimal> getUpperLimitPerType() {
        return this.upperLimitPerType;
    }

    public void setLimitPerType(Map<? extends AccountType, BigDecimal> limitPerType) {
        this.limitPerType = limitPerType;
    }

    public void setUpperLimitPerType(Map<? extends AccountType, BigDecimal> upperLimitPerType) {
        this.upperLimitPerType = upperLimitPerType;
    }

    public static class Entry {
        private final AccountType accountType;
        private final BigDecimal creditLimit;
        private final BigDecimal upperCreditLimit;

        public Entry(AccountType accountType, BigDecimal creditLimit, BigDecimal upperCreditLimit) {
            this.accountType = accountType;
            this.creditLimit = creditLimit;
            this.upperCreditLimit = upperCreditLimit;
        }

        public AccountType getAccountType() {
            return this.accountType;
        }

        public BigDecimal getCreditLimit() {
            return this.creditLimit;
        }

        public BigDecimal getUpperCreditLimit() {
            return this.upperCreditLimit;
        }
    }
}

