/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.services.accounts;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import nl.strohalm.cyclos.dao.accounts.ARateParametersDAO;
import nl.strohalm.cyclos.dao.accounts.CurrencyDAO;
import nl.strohalm.cyclos.dao.accounts.DRateParametersDAO;
import nl.strohalm.cyclos.dao.accounts.IRateParametersDAO;
import nl.strohalm.cyclos.dao.accounts.RateParametersDAO;
import nl.strohalm.cyclos.entities.Entity;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.accounts.ARateParameters;
import nl.strohalm.cyclos.entities.accounts.Account;
import nl.strohalm.cyclos.entities.accounts.AccountType;
import nl.strohalm.cyclos.entities.accounts.Currency;
import nl.strohalm.cyclos.entities.accounts.DRateParameters;
import nl.strohalm.cyclos.entities.accounts.IRateParameters;
import nl.strohalm.cyclos.entities.accounts.InitializableRateParameters;
import nl.strohalm.cyclos.entities.accounts.RateParameters;
import nl.strohalm.cyclos.entities.exceptions.EntityNotFoundException;
import nl.strohalm.cyclos.entities.groups.MemberGroup;
import nl.strohalm.cyclos.entities.members.Member;
import nl.strohalm.cyclos.entities.settings.LocalSettings;
import nl.strohalm.cyclos.services.accounts.AccountServiceLocal;
import nl.strohalm.cyclos.services.accounts.CurrencyServiceLocal;
import nl.strohalm.cyclos.services.accounts.rates.RateServiceLocal;
import nl.strohalm.cyclos.services.accounts.rates.ReinitializeRatesDTO;
import nl.strohalm.cyclos.services.accounts.rates.WhatRate;
import nl.strohalm.cyclos.services.fetch.FetchServiceLocal;
import nl.strohalm.cyclos.services.settings.SettingsServiceLocal;
import nl.strohalm.cyclos.utils.ClassHelper;
import nl.strohalm.cyclos.utils.RelationshipHelper;
import nl.strohalm.cyclos.utils.cache.Cache;
import nl.strohalm.cyclos.utils.cache.CacheCallback;
import nl.strohalm.cyclos.utils.cache.CacheManager;
import nl.strohalm.cyclos.utils.validation.GeneralValidation;
import nl.strohalm.cyclos.utils.validation.PropertyValidation;
import nl.strohalm.cyclos.utils.validation.ValidationError;
import nl.strohalm.cyclos.utils.validation.Validator;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.EqualsBuilder;

public class CurrencyServiceImpl
implements CurrencyServiceLocal {
    private static final String ALL_KEY = "_ALL_";
    private CurrencyDAO currencyDao;
    private ARateParametersDAO aRateParametersDao;
    private DRateParametersDAO dRateParametersDao;
    private IRateParametersDAO iRateParametersDao;
    private RateServiceLocal rateService;
    private FetchServiceLocal fetchService;
    private SettingsServiceLocal settingsService;
    private AccountServiceLocal accountService;
    private CacheManager cacheManager;

    @Override
    public List<Currency> listAll() {
        return (List)this.getCache().get((Serializable)((Object)ALL_KEY), new CacheCallback(){

            @Override
            public Object retrieve() {
                return CurrencyServiceImpl.this.currencyDao.listAll(Currency.Relationships.A_RATE_PARAMETERS, Currency.Relationships.D_RATE_PARAMETERS, Currency.Relationships.I_RATE_PARAMETERS);
            }
        });
    }

    @Override
    public List<Currency> listByMember(Member member) {
        ArrayList<Currency> currencies = new ArrayList<Currency>();
        List<? extends Account> accounts = this.accountService.getAccounts(member, RelationshipHelper.nested(Account.Relationships.TYPE, AccountType.Relationships.CURRENCY));
        for (Account account : accounts) {
            Currency currency = account.getType().getCurrency();
            if (currencies.contains(currency)) continue;
            currencies.add(currency);
        }
        return currencies;
    }

    @Override
    public List<Currency> listByMemberGroup(MemberGroup group) {
        List<Currency> currencies = this.currencyDao.listByMemberGroup(group);
        if (CollectionUtils.isEmpty(currencies)) {
            currencies = this.currencyDao.listAll(new Relationship[0]);
        }
        return currencies;
    }

    @Override
    public List<Currency> listDRatedCurrencies() {
        List<Currency> currencies = this.currencyDao.listAll(new Relationship[0]);
        ArrayList<Currency> ratedCurrencies = new ArrayList<Currency>(currencies.size());
        for (Currency currency : currencies) {
            if (!currency.isEnableDRate()) continue;
            ratedCurrencies.add(currency);
        }
        return ratedCurrencies;
    }

    @Override
    public Currency load(final Long id) {
        return (Currency)this.getCache().get(id, new CacheCallback(){

            @Override
            public Object retrieve() {
                return CurrencyServiceImpl.this.currencyDao.load(id, Currency.Relationships.A_RATE_PARAMETERS, Currency.Relationships.D_RATE_PARAMETERS);
            }
        });
    }

    @Override
    public Currency loadBySymbolOrId(final String symbolOrId) {
        return (Currency)this.getCache().get((Serializable)((Object)symbolOrId), new CacheCallback(){

            @Override
            public Object retrieve() {
                Long id;
                try {
                    id = Long.parseLong(symbolOrId);
                }
                catch (Exception e) {
                    id = null;
                }
                if (id != null) {
                    try {
                        return CurrencyServiceImpl.this.currencyDao.load(id, Currency.Relationships.A_RATE_PARAMETERS, Currency.Relationships.D_RATE_PARAMETERS);
                    }
                    catch (EntityNotFoundException entityNotFoundException) {
                        // empty catch block
                    }
                }
                return CurrencyServiceImpl.this.currencyDao.loadBySymbol(symbolOrId, Currency.Relationships.A_RATE_PARAMETERS, Currency.Relationships.D_RATE_PARAMETERS);
            }
        });
    }

    @Override
    public int remove(Long ... ids) {
        this.getCache().clear();
        return this.currencyDao.delete(ids);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Currency save(Currency currency, WhatRate whatRate) {
        RateParameterSaver aRateSaver = new RateParameterSaver(ARateParameters.class);
        RateParameterSaver dRateSaver = new RateParameterSaver(DRateParameters.class);
        RateParameterSaver iRateSaver = new RateParameterSaver(IRateParameters.class);
        Currency old = null;
        if (currency.isPersistent()) {
            old = (Currency)this.currencyDao.load(currency.getId(), Currency.Relationships.A_RATE_PARAMETERS, Currency.Relationships.D_RATE_PARAMETERS, Currency.Relationships.I_RATE_PARAMETERS);
        }
        Situation aRateSituation = aRateSaver.getSituation(whatRate.isaRate(), currency, old);
        Situation dRateSituation = dRateSaver.getSituation(whatRate.isdRate(), currency, old);
        Situation iRateSituation = iRateSaver.getSituation(whatRate.isiRate(), currency, old);
        this.validate(currency, aRateSituation, dRateSituation, iRateSituation);
        try {
            if (!whatRate.isaRate()) {
                currency.setaRateParameters(null);
            }
            if (!whatRate.isdRate()) {
                currency.setdRateParameters(null);
            }
            if (!whatRate.isiRate()) {
                currency.setiRateParameters(null);
            }
            if (currency.isTransient()) {
                ARateParameters aRate = currency.getaRateParameters();
                currency.setaRateParameters(null);
                DRateParameters dRate = currency.getdRateParameters();
                currency.setdRateParameters(null);
                IRateParameters iRate = currency.getiRateParameters();
                currency.setiRateParameters(null);
                currency = this.currencyDao.insert(currency, true);
                currency.setaRateParameters(aRate);
                aRateSaver.storeNewRate(aRateSituation, currency);
                currency.setdRateParameters(dRate);
                dRateSaver.storeNewRate(dRateSituation, currency);
                currency.setiRateParameters(iRate);
                iRateSaver.storeNewRate(iRateSituation, currency);
            } else {
                aRateSaver.disableOldRate(old, currency, aRateSituation);
                dRateSaver.disableOldRate(old, currency, dRateSituation);
                iRateSaver.disableOldRate(old, currency, iRateSituation);
                aRateSaver.storeNewRate(aRateSituation, currency);
                dRateSaver.storeNewRate(dRateSituation, currency);
                iRateSaver.storeNewRate(iRateSituation, currency);
            }
            this.currencyDao.update(currency, false);
            this.fetchService.clearCache();
            if (iRateSituation == Situation.NEW) {
                whatRate.setaRate(false);
                whatRate.setdRate(false);
                ReinitializeRatesDTO reinitDto = new ReinitializeRatesDTO();
                reinitDto.setCurrencyId(currency.getId());
                reinitDto.setWhatRate(whatRate);
                reinitDto.setMaintainPastSettings(true);
                reinitDto.setRequestURI("/cyclos/do/admin/editCurrency");
                this.rateService.reinitializeRate(reinitDto);
            }
        }
        finally {
            this.getCache().clear();
        }
        return currency;
    }

    public void setAccountServiceLocal(AccountServiceLocal accountService) {
        this.accountService = accountService;
    }

    public void setaRateParametersDao(ARateParametersDAO aRateParametersDao) {
        this.aRateParametersDao = aRateParametersDao;
    }

    public void setCacheManager(CacheManager cacheManager) {
        this.cacheManager = cacheManager;
    }

    public void setCurrencyDao(CurrencyDAO currencyDao) {
        this.currencyDao = currencyDao;
    }

    public void setdRateParametersDao(DRateParametersDAO dRateParametersDao) {
        this.dRateParametersDao = dRateParametersDao;
    }

    public void setFetchServiceLocal(FetchServiceLocal fetchService) {
        this.fetchService = fetchService;
    }

    public void setiRateParametersDao(IRateParametersDAO iRateParametersDao) {
        this.iRateParametersDao = iRateParametersDao;
    }

    public void setRateServiceLocal(RateServiceLocal rateService) {
        this.rateService = rateService;
    }

    public void setSettingsServiceLocal(SettingsServiceLocal settingsService) {
        this.settingsService = settingsService;
    }

    @Override
    public void validate(Currency currency, WhatRate whatRate) {
        this.getValidator(whatRate).validate(currency);
    }

    private Validator getBaseValidator() {
        Validator validator = new Validator("currency");
        validator.property("name").required().maxLength(100);
        validator.property("description").maxLength(2000);
        validator.property("symbol").required().maxLength(20);
        validator.property("pattern").required().maxLength(30).add(new PropertyValidation(){
            private static final long serialVersionUID = 455899399346626634L;

            @Override
            public ValidationError validate(Object object, Object name, Object value) {
                String pattern = (String)value;
                if (!StringUtils.isEmpty((String)pattern) && !pattern.contains("#amount#")) {
                    return new ValidationError("currency.error.pattern", new Object[0]);
                }
                return null;
            }
        });
        validator.general(new GeneralValidation(){
            private static final long serialVersionUID = 6441662788591991447L;

            @Override
            public ValidationError validate(Object object) {
                Currency currency = (Currency)object;
                if (CurrencyServiceImpl.this.rateService.checkPendingRateInitializations(currency) != null) {
                    return new ValidationError("rates.error.currency.noEditDuringRateReinit", new Object[0]);
                }
                return null;
            }
        });
        return validator;
    }

    private Cache getCache() {
        return this.cacheManager.getCache("cyclos.Currencies");
    }

    private Validator getValidator(WhatRate whatRate) {
        Validator validator = this.getBaseValidator();
        validator = this.rateService.getRateParametersValidator(validator, whatRate);
        return validator;
    }

    private void validate(Currency currency, Situation aRateSituation, Situation dRateSituation, Situation iRateSituation) {
        WhatRate whatRate = new WhatRate();
        whatRate.setaRate(aRateSituation == Situation.CHANGED || aRateSituation == Situation.NEW);
        whatRate.setdRate(dRateSituation == Situation.CHANGED || dRateSituation == Situation.NEW);
        whatRate.setiRate(iRateSituation == Situation.CHANGED || iRateSituation == Situation.NEW);
        this.getValidator(whatRate).validate(currency);
    }

    private static enum Situation {
        DISABLED,
        NEW,
        CHANGED,
        UNCHANGED;

    }

    private class RateParameterSaver<R extends RateParameters> {
        private final Class<R> rateParametersClass;
        private RateParametersDAO dao;

        private RateParameterSaver(Class<R> rateParametersClass) {
            this.rateParametersClass = rateParametersClass;
            if (rateParametersClass.equals(ARateParameters.class)) {
                this.dao = CurrencyServiceImpl.this.aRateParametersDao;
            }
            if (rateParametersClass.equals(DRateParameters.class)) {
                this.dao = CurrencyServiceImpl.this.dRateParametersDao;
            }
            if (rateParametersClass.equals(IRateParameters.class)) {
                this.dao = CurrencyServiceImpl.this.iRateParametersDao;
            }
        }

        private void disableOldRate(Currency oldCurrency, Currency newCurrency, Situation situation) {
            if (situation == Situation.DISABLED || situation == Situation.CHANGED) {
                R oldRate = this.getRateParameters(oldCurrency);
                ((RateParameters)oldRate).setDisabledSince(Calendar.getInstance());
                this.dao.update(oldRate);
                if (situation == Situation.DISABLED) {
                    this.setRateParameters(newCurrency, null);
                }
            }
        }

        private R getRateParameters(Currency currency) {
            if (this.rateParametersClass.equals(ARateParameters.class)) {
                return (R)currency.getaRateParameters();
            }
            if (this.rateParametersClass.equals(DRateParameters.class)) {
                return (R)currency.getdRateParameters();
            }
            if (this.rateParametersClass.equals(IRateParameters.class)) {
                return (R)currency.getiRateParameters();
            }
            return null;
        }

        private Situation getSituation(boolean enabled, Currency currency, Currency old) {
            if (currency.isTransient()) {
                if (enabled) {
                    return Situation.NEW;
                }
                return Situation.UNCHANGED;
            }
            R oldRate = this.getRateParameters(old);
            R newRate = enabled ? (R)this.getRateParameters(currency) : null;
            return this.hasChanged(oldRate, newRate);
        }

        private Situation hasChanged(R oldRate, R newRate) {
            if (newRate != null && oldRate == null) {
                return Situation.NEW;
            }
            if (newRate == null && oldRate != null) {
                return Situation.DISABLED;
            }
            if (newRate != null && oldRate != null && ClassHelper.isInstance(InitializableRateParameters.class, newRate) && ClassHelper.isInstance(InitializableRateParameters.class, oldRate)) {
                LocalSettings localSettings = CurrencyServiceImpl.this.settingsService.getLocalSettings();
                EqualsBuilder eb = new EqualsBuilder();
                InitializableRateParameters oldInitializableRate = (InitializableRateParameters)oldRate;
                InitializableRateParameters newInitializableRate = (InitializableRateParameters)newRate;
                eb.append((Object)localSettings.round(newInitializableRate.getInitValue()), (Object)localSettings.round(oldInitializableRate.getInitValue()));
                eb.append((Object)newInitializableRate.getInitDate(), (Object)oldInitializableRate.getInitDate());
                eb.append((Object)localSettings.round(((RateParameters)newRate).getCreationValue()), (Object)localSettings.round(((RateParameters)oldRate).getCreationValue()));
                if (oldRate instanceof DRateParameters && newRate instanceof DRateParameters) {
                    DRateParameters oldDRate = (DRateParameters)oldRate;
                    DRateParameters newDRate = (DRateParameters)newRate;
                    eb.append((Object)localSettings.roundHighPrecision(newDRate.getInterest()), (Object)localSettings.roundHighPrecision(oldDRate.getInterest()));
                    eb.append((Object)localSettings.round(newDRate.getBaseMalus()), (Object)localSettings.round(oldDRate.getBaseMalus()));
                    eb.append((Object)localSettings.round(newDRate.getMinimalD()), (Object)localSettings.round(oldDRate.getMinimalD()));
                }
                return eb.isEquals() ? Situation.UNCHANGED : Situation.CHANGED;
            }
            return Situation.UNCHANGED;
        }

        private void setRateParameters(Currency currency, R rateParameters) {
            if (this.rateParametersClass.equals(ARateParameters.class)) {
                currency.setaRateParameters((ARateParameters)rateParameters);
            }
            if (this.rateParametersClass.equals(DRateParameters.class)) {
                currency.setdRateParameters((DRateParameters)rateParameters);
            }
            if (this.rateParametersClass.equals(IRateParameters.class)) {
                currency.setiRateParameters((IRateParameters)rateParameters);
            }
        }

        private void storeNewRate(Situation situation, Currency currency) {
            if (situation == Situation.NEW || situation == Situation.CHANGED) {
                Object rate = this.getRateParameters(currency);
                if (situation == Situation.CHANGED) {
                    rate = (RateParameters)((Entity)rate).clone();
                }
                Calendar now = Calendar.getInstance();
                ((RateParameters)rate).setEnabledSince(now);
                ((RateParameters)rate).setDate(now);
                ((RateParameters)rate).setCurrency(currency);
                ((Entity)rate).setId(null);
                ((RateParameters)rate).setDisabledSince(null);
                rate = (RateParameters)this.dao.insert(rate);
                this.setRateParameters(currency, rate);
            }
        }
    }
}

