/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.services.accounts;

import java.util.Iterator;
import java.util.List;
import nl.strohalm.cyclos.access.AdminMemberPermission;
import nl.strohalm.cyclos.access.AdminSystemPermission;
import nl.strohalm.cyclos.access.BrokerPermission;
import nl.strohalm.cyclos.access.MemberPermission;
import nl.strohalm.cyclos.entities.accounts.AccountType;
import nl.strohalm.cyclos.entities.accounts.Currency;
import nl.strohalm.cyclos.entities.groups.MemberGroup;
import nl.strohalm.cyclos.entities.members.Member;
import nl.strohalm.cyclos.exceptions.PermissionDeniedException;
import nl.strohalm.cyclos.services.BaseServiceSecurity;
import nl.strohalm.cyclos.services.accounts.AccountTypeServiceLocal;
import nl.strohalm.cyclos.services.accounts.CurrencyService;
import nl.strohalm.cyclos.services.accounts.CurrencyServiceLocal;
import nl.strohalm.cyclos.services.accounts.rates.WhatRate;
import nl.strohalm.cyclos.utils.access.PermissionHelper;

public class CurrencyServiceSecurity
extends BaseServiceSecurity
implements CurrencyService {
    private CurrencyServiceLocal currencyService;
    private AccountTypeServiceLocal accountTypeService;

    @Override
    public List<Currency> listAll() {
        List<Currency> currencies = this.currencyService.listAll();
        Iterator<Currency> iterator = currencies.iterator();
        while (iterator.hasNext()) {
            if (this.isVisible(iterator.next())) continue;
            iterator.remove();
        }
        return currencies;
    }

    @Override
    public List<Currency> listByMember(Member member) {
        this.permissionService.permission(member).admin(AdminMemberPermission.ACCOUNTS_INFORMATION).broker(BrokerPermission.ACCOUNTS_INFORMATION).member(new MemberPermission[0]).operator().check();
        return this.currencyService.listByMember(member);
    }

    @Override
    public List<Currency> listByMemberGroup(MemberGroup group) {
        PermissionHelper.checkContains(this.permissionService.getVisibleMemberGroups(), group);
        return this.currencyService.listByMemberGroup(group);
    }

    @Override
    public List<Currency> listDRatedCurrencies() {
        return this.currencyService.listDRatedCurrencies();
    }

    @Override
    public Currency load(Long id) {
        Currency currency = this.currencyService.load(id);
        this.checkVisible(currency);
        return currency;
    }

    @Override
    public Currency loadBySymbolOrId(String symbolOrId) {
        Currency currency = this.currencyService.loadBySymbolOrId(symbolOrId);
        this.checkVisible(currency);
        return currency;
    }

    @Override
    public int remove(Long ... ids) {
        this.permissionService.permission().admin(AdminSystemPermission.CURRENCIES_MANAGE).check();
        return this.currencyService.remove(ids);
    }

    @Override
    public Currency save(Currency currency, WhatRate whatRate) {
        this.permissionService.permission().admin(AdminSystemPermission.CURRENCIES_MANAGE).check();
        return this.currencyService.save(currency, whatRate);
    }

    public void setAccountTypeServiceLocal(AccountTypeServiceLocal accountTypeService) {
        this.accountTypeService = accountTypeService;
    }

    public void setCurrencyServiceLocal(CurrencyServiceLocal currencyService) {
        this.currencyService = currencyService;
    }

    @Override
    public void validate(Currency currency, WhatRate whatRate) {
        this.currencyService.validate(currency, whatRate);
    }

    private void checkVisible(Currency currency) {
        if (!this.isVisible(currency)) {
            throw new PermissionDeniedException();
        }
    }

    private boolean isVisible(Currency currency) {
        if (this.permissionService.hasPermission(AdminSystemPermission.CURRENCIES_VIEW)) {
            return true;
        }
        for (AccountType type : this.accountTypeService.getVisibleAccountTypes()) {
            if (!(type = this.fetchService.fetch(type, AccountType.Relationships.CURRENCY)).getCurrency().equals(currency)) continue;
            return true;
        }
        return false;
    }
}

