/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.services.accounts;

import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import nl.strohalm.cyclos.entities.accounts.Account;
import nl.strohalm.cyclos.entities.accounts.AccountOwner;
import nl.strohalm.cyclos.entities.accounts.AccountType;
import nl.strohalm.cyclos.entities.accounts.transactions.PaymentFilter;
import nl.strohalm.cyclos.entities.members.Element;
import nl.strohalm.cyclos.entities.members.Member;
import nl.strohalm.cyclos.services.accounts.AccountDTO;
import nl.strohalm.cyclos.utils.Period;

public class GetTransactionsDTO
extends AccountDTO {
    private static final long serialVersionUID = -4431471525909266108L;
    private Member relatedToMember;
    private Element by;
    private Period period;
    private Collection<PaymentFilter> paymentFilters;
    private boolean rootOnly;

    public GetTransactionsDTO() {
    }

    public GetTransactionsDTO(Account account) {
        this(account, (Period)null);
    }

    public GetTransactionsDTO(Account account, Calendar date) {
        this(account, Period.endingAt(date));
    }

    public GetTransactionsDTO(Account account, Period period) {
        super(account);
        this.period = period;
    }

    public GetTransactionsDTO(AccountOwner owner, AccountType type) {
        this(owner, type, null, null);
    }

    public GetTransactionsDTO(AccountOwner owner, AccountType type, Calendar date) {
        this(owner, type, Period.endingAt(date), null);
    }

    public GetTransactionsDTO(AccountOwner owner, AccountType type, Period period) {
        this(owner, type, period, null);
    }

    public GetTransactionsDTO(AccountOwner owner, AccountType type, Period period, PaymentFilter paymentFilter) {
        super(owner, type);
        this.period = period;
        if (paymentFilter != null) {
            this.paymentFilters = Collections.singletonList(paymentFilter);
        }
    }

    public Element getBy() {
        return this.by;
    }

    public Collection<PaymentFilter> getPaymentFilters() {
        return this.paymentFilters;
    }

    public Period getPeriod() {
        return this.period;
    }

    public Member getRelatedToMember() {
        return this.relatedToMember;
    }

    public boolean isRootOnly() {
        return this.rootOnly;
    }

    public void setBy(Element by) {
        this.by = by;
    }

    public void setDate(Calendar cal) {
        this.setPeriod(Period.endingAt(cal));
    }

    public void setPaymentFilter(PaymentFilter paymentFilter) {
        this.paymentFilters = paymentFilter != null ? Collections.singletonList(paymentFilter) : null;
    }

    public void setPaymentFilters(Collection<PaymentFilter> paymentFilters) {
        this.paymentFilters = paymentFilters;
    }

    public void setPeriod(Period period) {
        this.period = period;
    }

    public void setRelatedToMember(Member relatedTomember) {
        this.relatedToMember = relatedTomember;
    }

    public void setRootOnly(boolean rootOnly) {
        this.rootOnly = rootOnly;
    }
}

