/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.services.accounts;

import java.math.BigDecimal;
import java.util.Calendar;
import nl.strohalm.cyclos.dao.accounts.AccountDAO;
import nl.strohalm.cyclos.dao.accounts.MemberGroupAccountSettingsDAO;
import nl.strohalm.cyclos.dao.accounts.transactions.TransferDAO;
import nl.strohalm.cyclos.dao.members.ElementDAO;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.accounts.MemberAccount;
import nl.strohalm.cyclos.entities.accounts.MemberAccountType;
import nl.strohalm.cyclos.entities.accounts.MemberGroupAccountSettings;
import nl.strohalm.cyclos.entities.accounts.SystemAccountOwner;
import nl.strohalm.cyclos.entities.accounts.transactions.TransferType;
import nl.strohalm.cyclos.entities.alerts.MemberAlert;
import nl.strohalm.cyclos.entities.exceptions.EntityNotFoundException;
import nl.strohalm.cyclos.entities.exceptions.UnexpectedEntityException;
import nl.strohalm.cyclos.entities.members.Element;
import nl.strohalm.cyclos.entities.members.Member;
import nl.strohalm.cyclos.services.accounts.AccountDateDTO;
import nl.strohalm.cyclos.services.accounts.AccountServiceLocal;
import nl.strohalm.cyclos.services.alerts.AlertServiceLocal;
import nl.strohalm.cyclos.services.fetch.FetchServiceLocal;
import nl.strohalm.cyclos.services.transactions.GrantSinglePaymentLoanDTO;
import nl.strohalm.cyclos.services.transactions.LoanServiceLocal;
import nl.strohalm.cyclos.services.transactions.PaymentServiceLocal;
import nl.strohalm.cyclos.services.transactions.TransactionContext;
import nl.strohalm.cyclos.services.transactions.TransferDTO;
import nl.strohalm.cyclos.utils.RelationshipHelper;
import nl.strohalm.cyclos.utils.TimePeriod;
import nl.strohalm.cyclos.utils.TransactionHelper;
import nl.strohalm.cyclos.utils.transaction.CurrentTransactionData;
import nl.strohalm.cyclos.utils.transaction.TransactionCommitListener;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;

public class MemberAccountHandler {
    private static final float PRECISION_DELTA = 1.0E-4f;
    private ElementDAO elementDao;
    private AccountDAO accountDao;
    private TransferDAO transferDao;
    private AccountServiceLocal accountService;
    private PaymentServiceLocal paymentService;
    private AlertServiceLocal alertService;
    private LoanServiceLocal loanService;
    private MemberGroupAccountSettingsDAO memberGroupAccountSettingsDao;
    private FetchServiceLocal fetchService;
    private TransactionHelper transactionHelper;

    public MemberAccount activate(Member member, MemberAccountType type) {
        MemberAccount account;
        if (member == null || member.isTransient() || type == null || type.isTransient()) {
            throw new UnexpectedEntityException();
        }
        try {
            account = (MemberAccount)this.accountDao.load(member, type, new Relationship[0]);
            account = this.activate(account);
        }
        catch (EntityNotFoundException e) {
            account = this.create(member, type);
        }
        return account;
    }

    public MemberAccount activate(MemberAccount account) {
        account.setStatus(MemberAccount.Status.ACTIVE);
        account.setAction(null);
        this.accountDao.update(account);
        this.activateMember(account.getMember());
        return account;
    }

    public void deactivate(Member member, MemberAccountType type, boolean enforceZeroBalance) {
        try {
            MemberAccount account = (MemberAccount)this.accountDao.load(member, type, new Relationship[0]);
            this.deactivate(account, enforceZeroBalance);
        }
        catch (EntityNotFoundException e) {
            // empty catch block
        }
    }

    public void deactivate(MemberAccount account, boolean enforceZeroBalance) {
        boolean hasCreditLimit;
        boolean hasTransfers = this.transferDao.hasTransfers(account);
        boolean bl = hasCreditLimit = Math.abs(account.getCreditLimit().floatValue()) > 1.0E-4f;
        if (hasTransfers || hasCreditLimit) {
            BigDecimal balance = this.accountService.getBalance(new AccountDateDTO(account));
            if (enforceZeroBalance && Math.abs(balance.floatValue()) > 1.0E-4f) {
                throw new UnexpectedEntityException();
            }
            account.setStatus(MemberAccount.Status.INACTIVE);
            account.setAction(null);
            this.accountDao.update(account);
        } else {
            this.accountDao.delete(account.getId());
        }
    }

    public void setAccountDao(AccountDAO accountDao) {
        this.accountDao = accountDao;
    }

    public void setAccountServiceLocal(AccountServiceLocal accountService) {
        this.accountService = accountService;
    }

    public void setAccountSettingsDao(MemberGroupAccountSettingsDAO accountSettingsDao) {
        this.memberGroupAccountSettingsDao = accountSettingsDao;
    }

    public void setAlertServiceLocal(AlertServiceLocal alertService) {
        this.alertService = alertService;
    }

    public void setElementDao(ElementDAO elementDao) {
        this.elementDao = elementDao;
    }

    public void setFetchServiceLocal(FetchServiceLocal fetchService) {
        this.fetchService = fetchService;
    }

    public void setLoanServiceLocal(LoanServiceLocal loanService) {
        this.loanService = loanService;
    }

    public void setMemberGroupAccountSettingsDao(MemberGroupAccountSettingsDAO memberGroupAccountSettingsDao) {
        this.memberGroupAccountSettingsDao = memberGroupAccountSettingsDao;
    }

    public void setPaymentServiceLocal(PaymentServiceLocal paymentService) {
        this.paymentService = paymentService;
    }

    public void setTransactionHelper(TransactionHelper transactionHelper) {
        this.transactionHelper = transactionHelper;
    }

    public void setTransferDao(TransferDAO transferDao) {
        this.transferDao = transferDao;
    }

    private void activateMember(Member member) {
        if (member.getActivationDate() == null) {
            member.setActivationDate(Calendar.getInstance());
            this.elementDao.update(member);
        }
    }

    private MemberAccount create(Member m, MemberAccountType at) {
        MemberGroupAccountSettings accountSettings;
        final Member member = this.fetchService.fetch(m, Element.Relationships.USER, Element.Relationships.GROUP);
        MemberAccountType accountType = this.fetchService.fetch(at, new Relationship[0]);
        try {
            accountSettings = this.memberGroupAccountSettingsDao.load((long)member.getMemberGroup().getId(), accountType.getId(), new Relationship[0]);
        }
        catch (EntityNotFoundException e) {
            return null;
        }
        final MemberAccount account = new MemberAccount();
        account.setCreationDate(Calendar.getInstance());
        account.setCreditLimit(accountSettings.getDefaultCreditLimit());
        account.setUpperCreditLimit(accountSettings.getDefaultUpperCreditLimit());
        account.setType(accountType);
        account.setMember(member);
        account.setOwnerName(member.getUsername());
        this.accountDao.insert(account);
        this.activateMember(member);
        final BigDecimal initialCredit = accountSettings.getInitialCredit();
        final TransferType initialCreditTransferType = accountSettings.getInitialCreditTransferType();
        BigDecimal minimumPayment = this.paymentService.getMinimumPayment();
        if (initialCredit != null && initialCredit.compareTo(minimumPayment) > 0 && initialCreditTransferType != null) {
            CurrentTransactionData.addTransactionCommitListener(new TransactionCommitListener(){

                @Override
                public void onTransactionCommit() {
                    try {
                        MemberAccountHandler.this.transactionHelper.runInCurrentThread(new TransactionCallbackWithoutResult(){

                            protected void doInTransactionWithoutResult(TransactionStatus status) {
                                MemberAccountHandler.this.grantInitialCredit(account, initialCredit, initialCreditTransferType);
                            }
                        });
                    }
                    catch (Exception e) {
                        MemberAccountHandler.this.transactionHelper.runInCurrentThread(new TransactionCallbackWithoutResult(){

                            protected void doInTransactionWithoutResult(TransactionStatus status) {
                                MemberAccountHandler.this.alertService.create(member, MemberAlert.Alerts.INITIAL_CREDIT_FAILED, account.getType().getName());
                            }
                        });
                    }
                }
            });
        }
        return account;
    }

    private void grantInitialCredit(MemberAccount account, BigDecimal amount, TransferType transferType) {
        account = this.fetchService.fetch(account, RelationshipHelper.nested(MemberAccount.Relationships.MEMBER, Element.Relationships.USER));
        if ((transferType = this.fetchService.fetch(transferType, new Relationship[0])).isLoanType()) {
            Integer repaymentDays = transferType.getLoan().getRepaymentDays();
            if (repaymentDays == null) {
                repaymentDays = 30;
            }
            GrantSinglePaymentLoanDTO dto = new GrantSinglePaymentLoanDTO();
            dto.setAutomatic(true);
            dto.setRepaymentDate(new TimePeriod(repaymentDays, TimePeriod.Field.DAYS).add(Calendar.getInstance()));
            dto.setMember(account.getMember());
            dto.setAmount(amount);
            dto.setTransferType(transferType);
            dto.setDescription(transferType.getDescription());
            this.loanService.insert(dto);
        } else {
            TransferDTO dto = new TransferDTO();
            dto.setContext(TransactionContext.AUTOMATIC);
            dto.setAmount(amount);
            dto.setTransferType(transferType);
            dto.setFromOwner(SystemAccountOwner.instance());
            dto.setTo(account);
            dto.setDescription(transferType.getDescription());
            this.paymentService.insertWithoutNotification(dto);
        }
    }
}

