/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.services.accounts.cards;

import java.math.BigInteger;
import java.util.Calendar;
import java.util.List;
import nl.strohalm.cyclos.dao.accounts.cards.CardDAO;
import nl.strohalm.cyclos.dao.accounts.cards.CardLogDAO;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.accounts.cards.Card;
import nl.strohalm.cyclos.entities.accounts.cards.CardLog;
import nl.strohalm.cyclos.entities.accounts.cards.CardQuery;
import nl.strohalm.cyclos.entities.accounts.cards.CardType;
import nl.strohalm.cyclos.entities.groups.BasicGroupSettings;
import nl.strohalm.cyclos.entities.members.Element;
import nl.strohalm.cyclos.entities.members.FullTextMemberQuery;
import nl.strohalm.cyclos.entities.members.Member;
import nl.strohalm.cyclos.exceptions.PermissionDeniedException;
import nl.strohalm.cyclos.services.InitializingService;
import nl.strohalm.cyclos.services.access.AccessServiceLocal;
import nl.strohalm.cyclos.services.accounts.cards.CardServiceLocal;
import nl.strohalm.cyclos.services.elements.BulkMemberActionResultVO;
import nl.strohalm.cyclos.services.elements.ElementServiceLocal;
import nl.strohalm.cyclos.services.fetch.FetchServiceLocal;
import nl.strohalm.cyclos.utils.CacheCleaner;
import nl.strohalm.cyclos.utils.DateHelper;
import nl.strohalm.cyclos.utils.HashHandler;
import nl.strohalm.cyclos.utils.RangeConstraint;
import nl.strohalm.cyclos.utils.RelationshipHelper;
import nl.strohalm.cyclos.utils.access.LoggedUser;
import nl.strohalm.cyclos.utils.validation.LengthValidation;
import nl.strohalm.cyclos.utils.validation.ValidationError;
import nl.strohalm.cyclos.utils.validation.ValidationException;
import org.apache.commons.lang.RandomStringUtils;
import org.apache.commons.lang.math.RandomUtils;

public class CardServiceImpl
implements CardServiceLocal,
InitializingService {
    private FetchServiceLocal fetchService;
    private CardDAO cardDao;
    private CardLogDAO cardLogDao;
    private ElementServiceLocal elementService;
    private AccessServiceLocal accessService;
    private static final char NUMERIC_CONSTANT = '#';
    private HashHandler hashHandler;

    @Override
    public Card activateCard(Card card, String cardCode) {
        if (card != null && card.getId() > 0L) {
            List<Card> activeCards = this.cardDao.searchActiveCards(card.getOwner().getId(), card.getId());
            if (activeCards != null) {
                for (Card activeCard : activeCards) {
                    this.cancelCard(activeCard);
                }
            }
            if ((card = this.fetchService.fetch(card, Card.Relationships.CARD_TYPE, RelationshipHelper.nested(Card.Relationships.OWNER, Element.Relationships.USER))).getCardType().getCardSecurityCode() == CardType.CardSecurityCode.MANUAL) {
                this.validateCardSecurityCode(card, cardCode);
                if (!card.getCardType().isShowCardSecurityCode()) {
                    cardCode = this.hashHandler.hash(card.getOwner().getUser().getSalt(), cardCode);
                }
                card.setCardSecurityCode(cardCode);
            }
            card.setStatus(Card.Status.ACTIVE);
            card.setActivationDate(Calendar.getInstance());
            this.cardDao.update(card, true);
            this.generateLog(card);
        }
        return card;
    }

    @Override
    public Card blockCard(Card card) {
        if (card != null && card.getId() > 0L) {
            card.setStatus(Card.Status.BLOCKED);
            this.cardDao.update(card, true);
            this.generateLog(card);
        }
        return card;
    }

    @Override
    public BulkMemberActionResultVO bulkGenerateNewCard(FullTextMemberQuery query, boolean generateForPending, boolean generateForActive) {
        int changed = 0;
        int unchanged = 0;
        boolean generateNewCard = true;
        query.setIterateAll();
        List<? extends Element> members = this.elementService.fullTextSearch(query);
        CacheCleaner cacheCleaner = new CacheCleaner(this.fetchService);
        for (Member member : members) {
            Member member2 = this.fetchService.fetch(member, Element.Relationships.GROUP);
            if (member2.getMemberGroup().getCardType() != null) {
                Card card = this.cardDao.getLastCard(member2.getId());
                if (card != null) {
                    if (card.getStatus().equals(Card.Status.PENDING) && !generateForPending) {
                        generateNewCard = false;
                    }
                    if (card.getStatus().equals(Card.Status.ACTIVE) && !generateForActive) {
                        generateNewCard = false;
                    }
                }
            } else {
                generateNewCard = false;
            }
            if (generateNewCard) {
                this.generateNewCard(member2);
                ++changed;
            } else {
                ++unchanged;
            }
            generateNewCard = true;
            cacheCleaner.clearCache();
        }
        return new BulkMemberActionResultVO(changed, unchanged);
    }

    @Override
    public void cancelAllMemberCards(Member member) {
        this.cardDao.cancelAllMemberCards(member);
    }

    @Override
    public Card cancelCard(Card card) {
        if (card != null && card.getId() > 0L) {
            card.setStatus(Card.Status.CANCELED);
            this.cardDao.update(card, true);
            this.generateLog(card);
        }
        return card;
    }

    @Override
    public Card changeCardCode(Card card, String code) {
        if ((card = this.fetchService.fetch(card, RelationshipHelper.nested(Card.Relationships.OWNER, Element.Relationships.USER), Card.Relationships.CARD_TYPE)).getCardType().getCardSecurityCode() != CardType.CardSecurityCode.MANUAL) {
            throw new PermissionDeniedException();
        }
        this.validateCardSecurityCode(card, code);
        if (!card.getCardType().isShowCardSecurityCode()) {
            code = this.hashHandler.hash(code, card.getOwner().getUser().getSalt());
        }
        card.setCardSecurityCode(code);
        this.cardDao.update(card);
        return card;
    }

    @Override
    public Card generateNewCard(Member member) {
        Card lastCard = this.cardDao.getLastCard(member.getId());
        if (lastCard != null && lastCard.getStatus() == Card.Status.PENDING) {
            this.cancelCard(lastCard);
        }
        Card newCard = this.buildNewCard(member);
        this.cardDao.insert(newCard, false);
        this.generateLog(newCard);
        return newCard;
    }

    @Override
    public Card getActiveCard(Member member) {
        for (Card card : this.getMemberCards(member.getId())) {
            if (card.getStatus() != Card.Status.ACTIVE) continue;
            return card;
        }
        return null;
    }

    public CardDAO getCardDao() {
        return this.cardDao;
    }

    public CardLogDAO getCardLogDao() {
        return this.cardLogDao;
    }

    @Override
    public void initializeService() {
        this.processCards(Calendar.getInstance());
    }

    @Override
    public Card load(long cardId, Relationship ... fetch) {
        return (Card)this.cardDao.load(cardId, fetch);
    }

    @Override
    public Card loadByNumber(BigInteger number, Relationship ... fetch) {
        return this.cardDao.loadByNumber(number, fetch);
    }

    @Override
    public List<Card> processCards(Calendar time) {
        return this.expireCards(time);
    }

    @Override
    public List<Card> search(CardQuery query) {
        return this.cardDao.search(query);
    }

    public void setAccessServiceLocal(AccessServiceLocal accessService) {
        this.accessService = accessService;
    }

    public void setCardDao(CardDAO cardDao) {
        this.cardDao = cardDao;
    }

    public void setCardLogDao(CardLogDAO cardLogDao) {
        this.cardLogDao = cardLogDao;
    }

    public void setElementServiceLocal(ElementServiceLocal elementService) {
        this.elementService = elementService;
    }

    public void setFetchServiceLocal(FetchServiceLocal fetchService) {
        this.fetchService = fetchService;
    }

    public void setHashHandler(HashHandler hashHandler) {
        this.hashHandler = hashHandler;
    }

    @Override
    public Card unblockCard(Card card) {
        if (card != null && card.getId() > 0L) {
            card.setStatus(Card.Status.ACTIVE);
            this.cardDao.update(card, true);
            this.generateLog(card);
        }
        return card;
    }

    @Override
    public void unblockSecurityCode(Card card) {
        this.accessService.unblockCardSecurityCode(card.getCardNumber());
    }

    private BigInteger buildCardNumber(String cardFormatNumber) {
        StringBuilder sb;
        BigInteger generatedNumber;
        boolean exists = false;
        do {
            sb = new StringBuilder();
            for (int i = 0; i < cardFormatNumber.length(); ++i) {
                char c = cardFormatNumber.charAt(i);
                if (Character.isDigit(c)) {
                    sb.append(c);
                    continue;
                }
                if (c != '#') continue;
                int next = i == 0 ? RandomUtils.nextInt((int)9) + 1 : RandomUtils.nextInt((int)10);
                sb.append(next);
            }
        } while (exists = this.cardDao.existsNumber(generatedNumber = new BigInteger(sb.toString())));
        return generatedNumber;
    }

    private String buildCardSecurityCode(Integer length) {
        return RandomStringUtils.randomNumeric((int)length);
    }

    private Card buildNewCard(Member member) {
        Calendar now = Calendar.getInstance();
        Card newCard = new Card();
        CardType cardType = member.getMemberGroup().getCardType();
        newCard.setCardType(cardType);
        newCard.setOwner(member);
        newCard.setCreationDate(now);
        newCard.setStatus(Card.Status.PENDING);
        Calendar expirationDate = (Calendar)now.clone();
        expirationDate.add(cardType.getDefaultExpiration().getField().getValue(), cardType.getDefaultExpiration().getNumber());
        if (cardType.isIgnoreDayInExpirationDate()) {
            expirationDate.set(5, expirationDate.getActualMaximum(5));
        }
        newCard.setExpirationDate(expirationDate);
        newCard.setCardNumber(this.buildCardNumber(cardType.getCardFormatNumber()));
        if (cardType.getCardSecurityCode() == CardType.CardSecurityCode.AUTOMATIC) {
            newCard.setCardSecurityCode(this.buildCardSecurityCode(cardType.getCardSecurityCodeLength().getMax()));
        }
        return newCard;
    }

    private List<Card> expireCards(Calendar taskTime) {
        List<Card> cards = this.cardDao.getCardsToExpire(DateHelper.truncate(taskTime));
        for (Card card : cards) {
            card.setStatus(Card.Status.EXPIRED);
            this.cardDao.update(card);
            this.generateLog(card);
        }
        return cards;
    }

    private void generateLog(Card card) {
        CardLog cardLog = new CardLog();
        if (LoggedUser.hasUser()) {
            cardLog.setBy((Element)LoggedUser.element());
        }
        cardLog.setCard(card);
        cardLog.setDate(Calendar.getInstance());
        cardLog.setStatus(card.getStatus());
        this.cardLogDao.insert(cardLog);
    }

    private List<Card> getMemberCards(long memberId) {
        return this.cardDao.getMemberCards(memberId);
    }

    private void validateCardSecurityCode(Card card, String code) throws ValidationException {
        boolean avoidObvious;
        CardType cardType = card.getCardType();
        if (cardType.getCardSecurityCode() != CardType.CardSecurityCode.MANUAL) {
            throw new ValidationException();
        }
        RangeConstraint length = cardType.getCardSecurityCodeLength();
        ValidationError lengthResult = new LengthValidation(length).validate(card, "securityCode", code);
        if (lengthResult != null) {
            throw new ValidationException("code1", "cardType.cardSecurityCode", lengthResult);
        }
        BasicGroupSettings.PasswordPolicy passwordPolicy = card.getOwner().getGroup().getBasicSettings().getPasswordPolicy();
        boolean bl = avoidObvious = passwordPolicy != null && passwordPolicy != BasicGroupSettings.PasswordPolicy.NONE;
        if (avoidObvious && this.accessService.isObviousCredential(card.getOwner(), code)) {
            throw new ValidationException("card.changeSecurityCode.error.obvious", new Object[0]);
        }
    }
}

