/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.services.accounts.cards;

import java.util.Collection;
import java.util.List;
import nl.strohalm.cyclos.access.AdminMemberPermission;
import nl.strohalm.cyclos.access.BrokerPermission;
import nl.strohalm.cyclos.access.MemberPermission;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.accounts.cards.Card;
import nl.strohalm.cyclos.entities.accounts.cards.CardQuery;
import nl.strohalm.cyclos.entities.groups.Group;
import nl.strohalm.cyclos.entities.members.FullTextMemberQuery;
import nl.strohalm.cyclos.entities.members.Member;
import nl.strohalm.cyclos.services.BaseServiceSecurity;
import nl.strohalm.cyclos.services.accounts.cards.CardService;
import nl.strohalm.cyclos.services.accounts.cards.CardServiceLocal;
import nl.strohalm.cyclos.services.elements.BulkMemberActionResultVO;
import nl.strohalm.cyclos.utils.access.LoggedUser;
import nl.strohalm.cyclos.utils.access.PermissionHelper;

public class CardServiceSecurity
extends BaseServiceSecurity
implements CardService {
    private CardServiceLocal cardService;

    @Override
    public Card activateCard(Card card, String cardCode) {
        card = this.fetchService.fetch(card, Card.Relationships.OWNER);
        this.permissionService.permission(card.getOwner()).admin(AdminMemberPermission.CARDS_UNBLOCK).broker(BrokerPermission.CARDS_UNBLOCK).member(MemberPermission.CARDS_UNBLOCK).check();
        return this.cardService.activateCard(card, cardCode);
    }

    @Override
    public Card blockCard(Card card) {
        card = this.fetchService.fetch(card, Card.Relationships.OWNER);
        this.permissionService.permission(card.getOwner()).admin(AdminMemberPermission.CARDS_BLOCK).broker(BrokerPermission.CARDS_BLOCK).member(MemberPermission.CARDS_BLOCK).check();
        return this.cardService.blockCard(card);
    }

    @Override
    public BulkMemberActionResultVO bulkGenerateNewCard(FullTextMemberQuery query, boolean generateForPending, boolean generateForActive) {
        if (query.getBroker() != null) {
            this.permissionService.checkRelatesTo(query.getBroker());
        }
        Collection<? extends Group> queryGroups = query.getGroups();
        query.setGroups(PermissionHelper.checkSelection(this.permissionService.getAllVisibleGroups(), queryGroups));
        this.permissionService.permission().admin(AdminMemberPermission.BULK_ACTIONS_GENERATE_CARD).check();
        return this.cardService.bulkGenerateNewCard(query, generateForPending, generateForActive);
    }

    @Override
    public Card cancelCard(Card card) {
        card = this.fetchService.fetch(card, Card.Relationships.OWNER);
        this.permissionService.permission(card.getOwner()).admin(AdminMemberPermission.CARDS_CANCEL).broker(BrokerPermission.CARDS_CANCEL).check();
        return this.cardService.cancelCard(card);
    }

    @Override
    public Card changeCardCode(Card card, String code) {
        card = this.fetchService.fetch(card, Card.Relationships.OWNER);
        this.permissionService.permission(card.getOwner()).admin(AdminMemberPermission.CARDS_CHANGE_CARD_SECURITY_CODE).broker(BrokerPermission.CARDS_CHANGE_CARD_SECURITY_CODE).member(MemberPermission.CARDS_CHANGE_CARD_SECURITY_CODE).check();
        return this.cardService.changeCardCode(card, code);
    }

    @Override
    public Card generateNewCard(Member member) {
        this.permissionService.permission(member).admin(AdminMemberPermission.CARDS_GENERATE).broker(BrokerPermission.CARDS_GENERATE).check();
        return this.cardService.generateNewCard(member);
    }

    @Override
    public Card getActiveCard(Member member) {
        this.checkView(member);
        return this.cardService.getActiveCard(member);
    }

    @Override
    public Card load(long cardId, Relationship ... fetch) {
        Relationship[] newFetch = this.addToFetch(fetch, Card.Relationships.OWNER);
        Card card = this.cardService.load(cardId, newFetch);
        this.checkView(card.getOwner());
        return card;
    }

    @Override
    public List<Card> search(CardQuery query) {
        Member member = query.getMember();
        if (member == null) {
            this.permissionService.permission().admin(AdminMemberPermission.CARDS_VIEW).broker(BrokerPermission.CARDS_VIEW).check();
            if (LoggedUser.isBroker()) {
                query.setBroker(LoggedUser.member());
            } else if (LoggedUser.isAdministrator()) {
                query.setGroups(this.permissionService.getVisibleMemberGroups());
            }
        } else {
            this.checkView(member);
        }
        return this.cardService.search(query);
    }

    public void setCardServiceLocal(CardServiceLocal cardService) {
        this.cardService = cardService;
    }

    @Override
    public Card unblockCard(Card card) {
        card = this.fetchService.fetch(card, Card.Relationships.OWNER);
        this.permissionService.permission(card.getOwner()).admin(AdminMemberPermission.CARDS_UNBLOCK).broker(BrokerPermission.CARDS_UNBLOCK).member(MemberPermission.CARDS_UNBLOCK).check();
        return this.cardService.unblockCard(card);
    }

    @Override
    public void unblockSecurityCode(Card card) {
        card = this.fetchService.fetch(card, Card.Relationships.OWNER);
        this.permissionService.permission(card.getOwner()).admin(AdminMemberPermission.CARDS_UNBLOCK_SECURITY_CODE).broker(BrokerPermission.CARDS_UNBLOCK_SECURITY_CODE).check();
        this.cardService.unblockSecurityCode(card);
    }

    private void checkView(Member member) {
        this.permissionService.permission(member).admin(AdminMemberPermission.CARDS_VIEW).broker(BrokerPermission.CARDS_VIEW).member(MemberPermission.CARDS_VIEW).check();
    }
}

