/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.services.accounts.cards;

import java.util.List;
import nl.strohalm.cyclos.dao.accounts.cards.CardTypeDAO;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.accounts.cards.CardType;
import nl.strohalm.cyclos.services.accounts.cards.CardTypeServiceLocal;
import nl.strohalm.cyclos.utils.MessageResolver;
import nl.strohalm.cyclos.utils.RangeConstraint;
import nl.strohalm.cyclos.utils.TimePeriod;
import nl.strohalm.cyclos.utils.validation.AnyOfValidation;
import nl.strohalm.cyclos.utils.validation.CardFormatValidation;
import nl.strohalm.cyclos.utils.validation.CompareToValidation;
import nl.strohalm.cyclos.utils.validation.InvalidError;
import nl.strohalm.cyclos.utils.validation.PositiveValidation;
import nl.strohalm.cyclos.utils.validation.PropertyValidation;
import nl.strohalm.cyclos.utils.validation.RequiredValidation;
import nl.strohalm.cyclos.utils.validation.ValidationError;
import nl.strohalm.cyclos.utils.validation.Validator;

public class CardTypeServiceImpl
implements CardTypeServiceLocal {
    private CardTypeDAO cardTypeDao;
    private MessageResolver messageResolver;

    public CardTypeDAO getCardTypeDao() {
        return this.cardTypeDao;
    }

    public Validator getValidator(CardType type) {
        Integer minValue;
        Validator validator = new Validator("cardType");
        validator.property("name").required().maxLength(100);
        Validator.Property cardFormat = validator.property("cardFormatNumber");
        cardFormat.required().maxLength(50);
        cardFormat.add(CardFormatValidation.instance());
        validator.property("defaultExpiration.number").key("cardType.defaultExpiration").add(RequiredValidation.instance()).add(PositiveValidation.instance()).add(CompareToValidation.lessEquals(Integer.valueOf(28)));
        validator.property("defaultExpiration.field").key("cardType.defaultExpiration").add(new AnyOfValidation(TimePeriod.Field.MONTHS, TimePeriod.Field.YEARS));
        validator.property("securityCodeBlockTime.number").key("cardType.securityCodeBlockTime").between(0, 999);
        validator.property("securityCodeBlockTime.field").key("cardType.securityCodeBlockTime").required();
        validator.property("securityCodeBlockTime.number").key("cardType.securityCodeBlockTime").add(new PasswordTrialsValidation());
        if (type.isTransient()) {
            validator.property("cardSecurityCode").required();
        }
        validator.property("cardSecurityCodeLength.min").required().between(1, 32).positiveNonZero();
        Validator.Property max = validator.property("cardSecurityCodeLength.max");
        max.required().between(1, 32).positiveNonZero();
        RangeConstraint securityCodeLength = type.getCardSecurityCodeLength();
        if (securityCodeLength != null && (minValue = type.getCardSecurityCodeLength().getMin()) != null) {
            max.comparable(minValue, ">=", new ValidationError("errors.greaterThan", this.messageResolver.message("cardType.cardSecurityCodeLength.min", new Object[0])));
        }
        return validator;
    }

    @Override
    public boolean hasCards(long cardTypeId) {
        return this.cardTypeDao.searchWithCardType(cardTypeId);
    }

    @Override
    public List<CardType> listAll() {
        return this.cardTypeDao.listAll();
    }

    @Override
    public CardType load(Long id, Relationship ... fetch) {
        return (CardType)this.cardTypeDao.load(id, fetch);
    }

    @Override
    public int remove(Long ... ids) {
        return this.cardTypeDao.delete(ids);
    }

    @Override
    public CardType save(CardType cardType) {
        this.validate(cardType);
        if (cardType.isTransient()) {
            if (cardType.getCardSecurityCode() == CardType.CardSecurityCode.AUTOMATIC) {
                cardType.setShowCardSecurityCode(true);
            }
            cardType = this.cardTypeDao.insert(cardType);
        } else {
            CardType oldCardType = this.load(cardType.getId(), new Relationship[0]);
            cardType.setCardSecurityCode(oldCardType.getCardSecurityCode());
            cardType.setShowCardSecurityCode(oldCardType.isShowCardSecurityCode());
            cardType = this.cardTypeDao.update(cardType, true);
        }
        return cardType;
    }

    public void setCardTypeDao(CardTypeDAO cardTypeDao) {
        this.cardTypeDao = cardTypeDao;
    }

    public void setMessageResolver(MessageResolver messageResolver) {
        this.messageResolver = messageResolver;
    }

    @Override
    public void validate(CardType cardType) {
        this.getValidator(cardType).validate(cardType);
    }

    private final class PasswordTrialsValidation
    implements PropertyValidation {
        private static final long serialVersionUID = -5445950747956604765L;

        private PasswordTrialsValidation() {
        }

        @Override
        public ValidationError validate(Object object, Object property, Object value) {
            CardType cardType = (CardType)object;
            if ((Integer)value == 0 && cardType.getMaxSecurityCodeTries() > 0) {
                return new InvalidError();
            }
            return null;
        }
    }
}

