/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.services.accounts.cards;

import java.util.ArrayList;
import java.util.List;
import nl.strohalm.cyclos.access.AdminSystemPermission;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.accounts.cards.CardType;
import nl.strohalm.cyclos.entities.groups.MemberGroup;
import nl.strohalm.cyclos.entities.members.Element;
import nl.strohalm.cyclos.entities.members.Member;
import nl.strohalm.cyclos.exceptions.PermissionDeniedException;
import nl.strohalm.cyclos.services.BaseServiceSecurity;
import nl.strohalm.cyclos.services.accounts.cards.CardTypeService;
import nl.strohalm.cyclos.services.accounts.cards.CardTypeServiceLocal;
import nl.strohalm.cyclos.utils.RelationshipHelper;
import nl.strohalm.cyclos.utils.access.LoggedUser;

public class CardTypeServiceSecurity
extends BaseServiceSecurity
implements CardTypeService {
    private CardTypeServiceLocal cardTypeService;

    @Override
    public boolean hasCards(long cardTypeId) {
        this.checkAdminView();
        return this.cardTypeService.hasCards(cardTypeId);
    }

    @Override
    public List<CardType> listAll() {
        List<CardType> result = this.cardTypeService.listAll();
        return this.filterVisible(result);
    }

    @Override
    public CardType load(Long id, Relationship ... fetch) {
        CardType cardType = this.cardTypeService.load(id, fetch);
        if (!this.permissionService.hasPermission(AdminSystemPermission.CARD_TYPES_VIEW)) {
            CardType associatedType;
            Member member = LoggedUser.member();
            if (member != null && (associatedType = ((MemberGroup)(member = (Member)this.fetchService.fetch(LoggedUser.element(), new Relationship[]{RelationshipHelper.nested(Element.Relationships.GROUP, MemberGroup.Relationships.CARD_TYPE)})).getGroup()).getCardType()) != null) {
                return this.fetchService.fetch(associatedType, fetch);
            }
            throw new PermissionDeniedException();
        }
        return cardType;
    }

    @Override
    public int remove(Long ... ids) {
        this.checkAdminManage();
        return this.cardTypeService.remove(ids);
    }

    @Override
    public CardType save(CardType cardType) {
        this.checkAdminManage();
        return this.cardTypeService.save(cardType);
    }

    public void setCardTypeServiceLocal(CardTypeServiceLocal cardTypeService) {
        this.cardTypeService = cardTypeService;
    }

    @Override
    public void validate(CardType cardType) {
        this.cardTypeService.validate(cardType);
    }

    private void checkAdminManage() {
        this.permissionService.permission().admin(AdminSystemPermission.CARD_TYPES_MANAGE).check();
    }

    private void checkAdminView() {
        this.permissionService.permission().admin(AdminSystemPermission.CARD_TYPES_VIEW).check();
    }

    private List<CardType> filterVisible(List<CardType> unfilteredList) {
        Member member;
        CardType cardType;
        if (this.permissionService.hasPermission(AdminSystemPermission.CARD_TYPES_VIEW)) {
            return unfilteredList;
        }
        ArrayList<CardType> result = new ArrayList<CardType>(1);
        if (LoggedUser.isMember() && unfilteredList.contains(cardType = ((MemberGroup)(member = (Member)this.fetchService.fetch(LoggedUser.element(), new Relationship[]{RelationshipHelper.nested(Element.Relationships.GROUP, MemberGroup.Relationships.CARD_TYPE)})).getGroup()).getCardType())) {
            result.add(cardType);
        }
        return result;
    }
}

