/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.services.accounts.external;

import java.util.Collections;
import java.util.List;
import nl.strohalm.cyclos.dao.accounts.external.ExternalAccountDAO;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.accounts.external.ExternalAccount;
import nl.strohalm.cyclos.entities.accounts.external.ExternalAccountDetailsVO;
import nl.strohalm.cyclos.entities.accounts.external.ExternalAccountQuery;
import nl.strohalm.cyclos.entities.groups.AdminGroup;
import nl.strohalm.cyclos.services.accounts.external.ExternalAccountServiceLocal;
import nl.strohalm.cyclos.services.fetch.FetchServiceLocal;
import nl.strohalm.cyclos.utils.access.LoggedUser;
import nl.strohalm.cyclos.utils.validation.Validator;
import org.apache.commons.collections.CollectionUtils;

public class ExternalAccountServiceImpl
implements ExternalAccountServiceLocal {
    private ExternalAccountDAO externalAccountDao;
    private FetchServiceLocal fetchService;

    @Override
    public List<ExternalAccountDetailsVO> externalAccountOverview() {
        AdminGroup group = (AdminGroup)LoggedUser.group();
        if (CollectionUtils.isEmpty((group = this.fetchService.fetch(group, AdminGroup.Relationships.VIEW_INFORMATION_OF)).getViewInformationOf())) {
            return Collections.emptyList();
        }
        ExternalAccountQuery query = new ExternalAccountQuery();
        query.setSystemAccountTypes(group.getViewInformationOf());
        return this.externalAccountDao.listExternalAccountOverview(query);
    }

    public List<ExternalAccount> listAll() {
        return this.externalAccountDao.listAll();
    }

    @Override
    public ExternalAccount load(Long id, Relationship ... fetch) {
        return (ExternalAccount)this.externalAccountDao.load(id, fetch);
    }

    @Override
    public int remove(Long ... ids) {
        return this.externalAccountDao.delete(ids);
    }

    @Override
    public ExternalAccount save(ExternalAccount externalAccount) {
        this.validate(externalAccount);
        if (externalAccount.isTransient()) {
            return this.externalAccountDao.insert(externalAccount);
        }
        ExternalAccount current = this.load(externalAccount.getId(), ExternalAccount.Relationships.FILE_MAPPING);
        externalAccount.setFileMapping(current.getFileMapping());
        return this.externalAccountDao.update(externalAccount);
    }

    @Override
    public List<ExternalAccount> search() {
        AdminGroup group = (AdminGroup)LoggedUser.group();
        if (CollectionUtils.isEmpty((group = this.fetchService.fetch(group, AdminGroup.Relationships.VIEW_INFORMATION_OF)).getViewInformationOf())) {
            return Collections.emptyList();
        }
        ExternalAccountQuery queryEA = new ExternalAccountQuery();
        queryEA.setSystemAccountTypes(group.getViewInformationOf());
        return this.externalAccountDao.search(queryEA);
    }

    public void setExternalAccountDao(ExternalAccountDAO externalAccountDao) {
        this.externalAccountDao = externalAccountDao;
    }

    public void setFetchServiceLocal(FetchServiceLocal fetchService) {
        this.fetchService = fetchService;
    }

    @Override
    public void validate(ExternalAccount externalAccount) {
        this.getValidator().validate(externalAccount);
    }

    private Validator getValidator() {
        Validator validator = new Validator("externalAccount");
        validator.property("name").required().maxLength(50);
        validator.property("systemAccountType").required();
        validator.property("memberAccountType").required();
        return validator;
    }
}

