/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.services.accounts.external;

import java.util.Collections;
import java.util.List;
import nl.strohalm.cyclos.access.AdminSystemPermission;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.accounts.external.ExternalAccount;
import nl.strohalm.cyclos.entities.accounts.external.ExternalAccountDetailsVO;
import nl.strohalm.cyclos.services.BaseServiceSecurity;
import nl.strohalm.cyclos.services.accounts.external.ExternalAccountService;
import nl.strohalm.cyclos.services.accounts.external.ExternalAccountServiceLocal;

public class ExternalAccountServiceSecurity
extends BaseServiceSecurity
implements ExternalAccountService {
    private ExternalAccountServiceLocal externalAccountService;

    @Override
    public List<ExternalAccountDetailsVO> externalAccountOverview() {
        this.permissionService.permission().admin(AdminSystemPermission.EXTERNAL_ACCOUNTS_DETAILS).check();
        return this.externalAccountService.externalAccountOverview();
    }

    @Override
    public ExternalAccount load(Long id, Relationship ... fetch) {
        this.permissionService.permission().admin(AdminSystemPermission.EXTERNAL_ACCOUNTS_DETAILS, AdminSystemPermission.EXTERNAL_ACCOUNTS_VIEW).check();
        return this.externalAccountService.load(id, fetch);
    }

    @Override
    public int remove(Long ... ids) {
        this.permissionService.permission().admin(AdminSystemPermission.EXTERNAL_ACCOUNTS_MANAGE).check();
        return this.externalAccountService.remove(ids);
    }

    @Override
    public ExternalAccount save(ExternalAccount externalAccount) {
        this.permissionService.permission().admin(AdminSystemPermission.EXTERNAL_ACCOUNTS_MANAGE).check();
        return this.externalAccountService.save(externalAccount);
    }

    @Override
    public List<ExternalAccount> search() {
        if (!this.permissionService.permission().admin(AdminSystemPermission.EXTERNAL_ACCOUNTS_VIEW).hasPermission()) {
            return Collections.emptyList();
        }
        return this.externalAccountService.search();
    }

    public void setExternalAccountServiceLocal(ExternalAccountServiceLocal externalAccountService) {
        this.externalAccountService = externalAccountService;
    }

    @Override
    public void validate(ExternalAccount externalAccount) {
        this.externalAccountService.validate(externalAccount);
    }
}

