/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.services.accounts.external;

import java.io.IOException;
import java.io.Reader;
import java.util.Calendar;
import java.util.List;
import nl.strohalm.cyclos.dao.accounts.external.ExternalTransferImportDAO;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.accounts.external.ExternalTransferImport;
import nl.strohalm.cyclos.entities.accounts.external.ExternalTransferImportQuery;
import nl.strohalm.cyclos.entities.accounts.external.filemapping.FileMapping;
import nl.strohalm.cyclos.entities.exceptions.UnexpectedEntityException;
import nl.strohalm.cyclos.entities.members.Element;
import nl.strohalm.cyclos.services.accounts.external.ExternalTransferImportServiceLocal;
import nl.strohalm.cyclos.services.accounts.external.ExternalTransferServiceLocal;
import nl.strohalm.cyclos.services.fetch.FetchServiceLocal;
import nl.strohalm.cyclos.utils.CustomObjectHandler;
import nl.strohalm.cyclos.utils.access.LoggedUser;
import nl.strohalm.cyclos.utils.transactionimport.IllegalTransactionFileFormatException;
import nl.strohalm.cyclos.utils.transactionimport.TransactionImportDTO;

public class ExternalTransferImportServiceImpl
implements ExternalTransferImportServiceLocal {
    private ExternalTransferServiceLocal externalTransferService;
    private ExternalTransferImportDAO externalTransferImportDao;
    private FetchServiceLocal fetchService;
    private CustomObjectHandler customObjectHandler;

    @Override
    public ExternalTransferImport importNew(FileMapping mapping, Reader in) throws IllegalTransactionFileFormatException, IOException {
        mapping = this.fetchService.fetch(mapping, ExternalTransferImport.Relationships.ACCOUNT);
        ExternalTransferImport transferImport = new ExternalTransferImport();
        transferImport.setAccount(mapping.getAccount());
        transferImport.setDate(Calendar.getInstance());
        transferImport.setBy((Element)LoggedUser.element());
        transferImport = this.externalTransferImportDao.insert(transferImport);
        List<TransactionImportDTO> transactions = mapping.getImport(this.customObjectHandler).readTransactions(in);
        for (TransactionImportDTO dto : transactions) {
            this.externalTransferService.importNew(transferImport, dto);
        }
        return transferImport;
    }

    @Override
    public ExternalTransferImport load(Long id, Relationship ... fetch) {
        return (ExternalTransferImport)this.externalTransferImportDao.load(id, fetch);
    }

    @Override
    public int remove(Long ... ids) {
        if (this.externalTransferImportDao.hasCheckedTransfers(ids)) {
            throw new UnexpectedEntityException();
        }
        return this.externalTransferImportDao.delete(ids);
    }

    @Override
    public List<ExternalTransferImport> search(ExternalTransferImportQuery query) {
        return this.externalTransferImportDao.search(query);
    }

    public void setCustomObjectHandler(CustomObjectHandler customObjectHandler) {
        this.customObjectHandler = customObjectHandler;
    }

    public void setExternalTransferImportDao(ExternalTransferImportDAO externalTransferImportDao) {
        this.externalTransferImportDao = externalTransferImportDao;
    }

    public void setExternalTransferServiceLocal(ExternalTransferServiceLocal externalTransferService) {
        this.externalTransferService = externalTransferService;
    }

    public void setFetchServiceLocal(FetchServiceLocal fetchService) {
        this.fetchService = fetchService;
    }
}

