/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.services.accounts.external;

import java.io.IOException;
import java.io.Reader;
import java.util.Collections;
import java.util.List;
import nl.strohalm.cyclos.access.AdminSystemPermission;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.accounts.external.ExternalTransferImport;
import nl.strohalm.cyclos.entities.accounts.external.ExternalTransferImportQuery;
import nl.strohalm.cyclos.entities.accounts.external.filemapping.FileMapping;
import nl.strohalm.cyclos.entities.exceptions.UnexpectedEntityException;
import nl.strohalm.cyclos.services.BaseServiceSecurity;
import nl.strohalm.cyclos.services.accounts.external.ExternalTransferImportService;
import nl.strohalm.cyclos.services.accounts.external.ExternalTransferImportServiceLocal;
import nl.strohalm.cyclos.utils.transactionimport.IllegalTransactionFileFormatException;

public class ExternalTransferImportServiceSecurity
extends BaseServiceSecurity
implements ExternalTransferImportService {
    private ExternalTransferImportServiceLocal externalTransferImportService;

    @Override
    public ExternalTransferImport importNew(FileMapping mapping, Reader in) throws IllegalTransactionFileFormatException, IOException {
        this.permissionService.permission().admin(AdminSystemPermission.EXTERNAL_ACCOUNTS_MANAGE_PAYMENT).check();
        return this.externalTransferImportService.importNew(mapping, in);
    }

    @Override
    public ExternalTransferImport load(Long id, Relationship ... fetch) {
        this.permissionService.permission().admin(AdminSystemPermission.EXTERNAL_ACCOUNTS_DETAILS).check();
        return this.externalTransferImportService.load(id, fetch);
    }

    @Override
    public int remove(Long ... ids) throws UnexpectedEntityException {
        this.permissionService.permission().admin(AdminSystemPermission.EXTERNAL_ACCOUNTS_MANAGE_PAYMENT).check();
        return this.externalTransferImportService.remove(ids);
    }

    @Override
    public List<ExternalTransferImport> search(ExternalTransferImportQuery query) {
        if (!this.permissionService.permission().admin(AdminSystemPermission.EXTERNAL_ACCOUNTS_DETAILS).hasPermission()) {
            return Collections.emptyList();
        }
        return this.externalTransferImportService.search(query);
    }

    public void setExternalTransferImportServiceLocal(ExternalTransferImportServiceLocal externalTransferImportService) {
        this.externalTransferImportService = externalTransferImportService;
    }
}

