/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.services.accounts.external;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import nl.strohalm.cyclos.dao.accounts.external.ExternalTransferDAO;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.access.User;
import nl.strohalm.cyclos.entities.accounts.AccountOwner;
import nl.strohalm.cyclos.entities.accounts.MemberAccount;
import nl.strohalm.cyclos.entities.accounts.SystemAccountOwner;
import nl.strohalm.cyclos.entities.accounts.external.ExternalTransfer;
import nl.strohalm.cyclos.entities.accounts.external.ExternalTransferAction;
import nl.strohalm.cyclos.entities.accounts.external.ExternalTransferImport;
import nl.strohalm.cyclos.entities.accounts.external.ExternalTransferQuery;
import nl.strohalm.cyclos.entities.accounts.external.ExternalTransferType;
import nl.strohalm.cyclos.entities.accounts.loans.Loan;
import nl.strohalm.cyclos.entities.accounts.transactions.Payment;
import nl.strohalm.cyclos.entities.customization.fields.MemberCustomFieldValue;
import nl.strohalm.cyclos.entities.exceptions.EntityNotFoundException;
import nl.strohalm.cyclos.entities.exceptions.UnexpectedEntityException;
import nl.strohalm.cyclos.entities.members.Element;
import nl.strohalm.cyclos.entities.members.Member;
import nl.strohalm.cyclos.entities.members.MemberQuery;
import nl.strohalm.cyclos.services.accounts.external.ExternalTransferServiceLocal;
import nl.strohalm.cyclos.services.accounts.external.ExternalTransferTypeServiceLocal;
import nl.strohalm.cyclos.services.accounts.external.ProcessExternalTransferDTO;
import nl.strohalm.cyclos.services.accounts.external.exceptions.CannotDeleteExternalTransferException;
import nl.strohalm.cyclos.services.accounts.external.exceptions.CannotMarkExternalTransferAsCheckedException;
import nl.strohalm.cyclos.services.accounts.external.exceptions.CannotMarkExternalTransferAsUncheckedException;
import nl.strohalm.cyclos.services.customization.MemberCustomFieldServiceLocal;
import nl.strohalm.cyclos.services.elements.ElementServiceLocal;
import nl.strohalm.cyclos.services.fetch.FetchServiceLocal;
import nl.strohalm.cyclos.services.permissions.PermissionServiceLocal;
import nl.strohalm.cyclos.services.transactions.LoanServiceLocal;
import nl.strohalm.cyclos.services.transactions.PaymentServiceLocal;
import nl.strohalm.cyclos.services.transactions.TransferDTO;
import nl.strohalm.cyclos.utils.CustomFieldHelper;
import nl.strohalm.cyclos.utils.MessageResolver;
import nl.strohalm.cyclos.utils.RelationshipHelper;
import nl.strohalm.cyclos.utils.query.PageParameters;
import nl.strohalm.cyclos.utils.transactionimport.TransactionImportDTO;
import nl.strohalm.cyclos.utils.validation.PropertyValidation;
import nl.strohalm.cyclos.utils.validation.RequiredValidation;
import nl.strohalm.cyclos.utils.validation.ValidationError;
import nl.strohalm.cyclos.utils.validation.Validator;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;

public class ExternalTransferServiceImpl
implements ExternalTransferServiceLocal {
    private static final Relationship[] EXTERNAL_TRANSFER_FETCH = new Relationship[]{RelationshipHelper.nested(ExternalTransfer.Relationships.TYPE, ExternalTransferType.Relationships.ACCOUNT), RelationshipHelper.nested(ExternalTransfer.Relationships.TYPE, ExternalTransferType.Relationships.TRANSFER_TYPE)};
    private static final Relationship[] LOAN_FETCH = new Relationship[]{RelationshipHelper.nested(Loan.Relationships.TRANSFER, Payment.Relationships.TO, MemberAccount.Relationships.MEMBER), RelationshipHelper.nested(ExternalTransfer.Relationships.TYPE, ExternalTransferType.Relationships.TRANSFER_TYPE)};
    private static final Relationship[] TRANSFER_FETCH = new Relationship[]{RelationshipHelper.nested(Payment.Relationships.FROM, MemberAccount.Relationships.MEMBER), RelationshipHelper.nested(Payment.Relationships.TO)};
    private LoanServiceLocal loanService;
    private FetchServiceLocal fetchService;
    private PaymentServiceLocal paymentService;
    private ElementServiceLocal elementService;
    private MemberCustomFieldServiceLocal memberCustomFieldService;
    private ExternalTransferTypeServiceLocal externalTransferTypeService;
    private ExternalTransferDAO externalTransferDao;
    private CustomFieldHelper customFieldHelper;
    private PermissionServiceLocal permissionService;
    private MessageResolver messageResolver;

    @Override
    public ExternalTransfer importNew(ExternalTransferImport transferImport, TransactionImportDTO dto) {
        Member member = this.resolveMember(dto);
        if (member != null && !this.permissionService.manages(member)) {
            member = null;
        }
        ExternalTransfer transfer = new ExternalTransfer();
        transfer.setLineNumber(dto.getLineNumber());
        transfer.setAccount(transferImport.getAccount());
        transfer.setMember(this.resolveMember(dto));
        transfer.setDate(dto.getDate());
        transfer.setAmount(dto.getAmount());
        transfer.setStatus(ExternalTransfer.Status.PENDING);
        transfer.setTransferImport(transferImport);
        transfer.setType(this.resolveType(transferImport, dto));
        transfer.setDescription(dto.getDescription());
        String comments = dto.getComments();
        if (member == null) {
            Long id = dto.getMemberId();
            String username = dto.getMemberUsername();
            Map.Entry<String, String> fieldValue = MapUtils.isEmpty(dto.getMemberFieldValues()) ? null : dto.getMemberFieldValues().entrySet().iterator().next();
            String newComments = null;
            if (id != null) {
                newComments = this.messageResolver.message("externalTransferImport.error.importing.invalidMemberId", id);
            } else if (StringUtils.isNotEmpty((String)username)) {
                newComments = this.messageResolver.message("externalTransferImport.error.importing.invalidMemberUsername", username);
            } else if (fieldValue != null) {
                newComments = this.messageResolver.message("externalTransferImport.error.importing.invalidMemberField", fieldValue.getKey(), fieldValue.getValue());
            }
            comments = comments != null ? newComments + "\n" + comments : newComments;
        }
        if (transfer.getType() == null && StringUtils.isNotEmpty((String)dto.getTypeCode())) {
            String newComments = this.messageResolver.message("externalTransferImport.error.importing.invalidTypeCode", dto.getTypeCode());
            comments = comments != null ? newComments + "\n" + comments : newComments;
        }
        transfer.setComments(comments);
        return this.externalTransferDao.insert(transfer);
    }

    @Override
    public ExternalTransfer load(Long id, Relationship ... fetch) {
        return (ExternalTransfer)this.externalTransferDao.load(id, fetch);
    }

    @Override
    public void performAction(ExternalTransferAction action, Long ... ids) {
        for (Long id : ids) {
            ExternalTransfer externalTransfer = (ExternalTransfer)this.externalTransferDao.load(id, ExternalTransfer.Relationships.TYPE);
            ExternalTransfer.Status status = externalTransfer.getStatus();
            if (action == ExternalTransferAction.DELETE) {
                if (status != ExternalTransfer.Status.PENDING) {
                    throw new CannotDeleteExternalTransferException();
                }
                this.externalTransferDao.delete(id);
                continue;
            }
            if (action == ExternalTransferAction.MARK_AS_CHECKED) {
                if (status != ExternalTransfer.Status.PENDING || !externalTransfer.isComplete()) {
                    throw new CannotMarkExternalTransferAsCheckedException();
                }
                ExternalTransferType type = externalTransfer.getType();
                if (type != null && type.getAction() == ExternalTransferType.Action.IGNORE) {
                    externalTransfer.setStatus(ExternalTransfer.Status.PROCESSED);
                } else {
                    externalTransfer.setStatus(ExternalTransfer.Status.CHECKED);
                }
                this.externalTransferDao.update(externalTransfer);
                continue;
            }
            if (status != ExternalTransfer.Status.CHECKED) {
                throw new CannotMarkExternalTransferAsUncheckedException();
            }
            externalTransfer.setStatus(ExternalTransfer.Status.PENDING);
            this.externalTransferDao.update(externalTransfer);
        }
    }

    @Override
    public int process(Collection<ProcessExternalTransferDTO> dtos) throws UnexpectedEntityException {
        if (CollectionUtils.isEmpty(dtos)) {
            return 0;
        }
        int count = 0;
        for (ProcessExternalTransferDTO dto : dtos) {
            ExternalTransfer externalTransfer = this.fetchService.fetch(dto.getExternalTransfer(), EXTERNAL_TRANSFER_FETCH);
            if (externalTransfer.getStatus() != ExternalTransfer.Status.CHECKED) {
                throw new UnexpectedEntityException();
            }
            dto.setExternalTransfer(externalTransfer);
            dto.setLoan(this.fetchService.fetch(dto.getLoan(), LOAN_FETCH));
            dto.setTransfer(this.fetchService.fetch(dto.getTransfer(), TRANSFER_FETCH));
            this.process(dto);
            ++count;
        }
        return count;
    }

    @Override
    public Member resolveMember(TransactionImportDTO dto) {
        Long id = dto.getMemberId();
        String username = dto.getMemberUsername();
        Map<String, String> fieldValues = dto.getMemberFieldValues();
        Element member = null;
        if (id != null) {
            try {
                member = (Member)this.elementService.load(id, Element.Relationships.GROUP);
            }
            catch (EntityNotFoundException e) {
                // empty catch block
            }
        }
        if (member == null && StringUtils.isNotEmpty((String)username)) {
            try {
                member = (Member)((User)this.elementService.loadUser(username, RelationshipHelper.nested(User.Relationships.ELEMENT, Element.Relationships.GROUP))).getElement();
            }
            catch (EntityNotFoundException e) {
                // empty catch block
            }
        }
        if (member == null && MapUtils.isNotEmpty(fieldValues)) {
            List allMemberFields = this.memberCustomFieldService.list();
            Collection<MemberCustomFieldValue> values = this.customFieldHelper.buildValues(MemberCustomFieldValue.class, allMemberFields, fieldValues);
            MemberQuery query = new MemberQuery();
            query.setPageParameters(new PageParameters(2, 0));
            query.setCustomValues(values);
            Iterator<? extends Element> members = this.elementService.search(query).iterator();
            if (members.hasNext()) {
                member = (Member)members.next();
                if (members.hasNext()) {
                    member = null;
                }
            }
        }
        if (member != null && !member.getGroup().getStatus().isEnabled()) {
            member = null;
        }
        return member;
    }

    @Override
    public ExternalTransfer save(ExternalTransfer externalTransfer) {
        this.validate(externalTransfer);
        if (externalTransfer.isTransient()) {
            externalTransfer.setStatus(ExternalTransfer.Status.PENDING);
            return this.externalTransferDao.insert(externalTransfer);
        }
        return this.externalTransferDao.update(externalTransfer);
    }

    @Override
    public List<ExternalTransfer> search(ExternalTransferQuery query) {
        return this.externalTransferDao.search(query);
    }

    public void setCustomFieldHelper(CustomFieldHelper customFieldHelper) {
        this.customFieldHelper = customFieldHelper;
    }

    public void setElementServiceLocal(ElementServiceLocal elementService) {
        this.elementService = elementService;
    }

    public void setExternalTransferDao(ExternalTransferDAO externalTransferDao) {
        this.externalTransferDao = externalTransferDao;
    }

    public void setExternalTransferTypeServiceLocal(ExternalTransferTypeServiceLocal externalTransferTypeService) {
        this.externalTransferTypeService = externalTransferTypeService;
    }

    public void setFetchServiceLocal(FetchServiceLocal fetchService) {
        this.fetchService = fetchService;
    }

    public void setLoanServiceLocal(LoanServiceLocal loanService) {
        this.loanService = loanService;
    }

    public void setMemberCustomFieldServiceLocal(MemberCustomFieldServiceLocal memberCustomFieldService) {
        this.memberCustomFieldService = memberCustomFieldService;
    }

    public void setMessageResolver(MessageResolver messageResolver) {
        this.messageResolver = messageResolver;
    }

    public void setPaymentServiceLocal(PaymentServiceLocal paymentService) {
        this.paymentService = paymentService;
    }

    public void setPermissionServiceLocal(PermissionServiceLocal permissionService) {
        this.permissionService = permissionService;
    }

    @Override
    public void validate(ExternalTransfer externalTransfer) {
        this.getValidator().validate(externalTransfer);
    }

    private Validator getValidator() {
        Validator validator = new Validator("externalTransfer");
        validator.property("account").required();
        validator.property("type").required();
        validator.property("date").required();
        validator.property("amount").required();
        validator.property("member").add(new RequiredWhenNotIgnoreValidation());
        return validator;
    }

    private void process(ProcessExternalTransferDTO dto) {
        ExternalTransfer externalTransfer = dto.getExternalTransfer();
        ExternalTransferType type = externalTransfer.getType();
        switch (type.getAction()) {
            case GENERATE_SYSTEM_PAYMENT: 
            case GENERATE_MEMBER_PAYMENT: {
                boolean toMember = type.getAction() == ExternalTransferType.Action.GENERATE_MEMBER_PAYMENT;
                TransferDTO payment = new TransferDTO();
                payment.setAutomatic(true);
                payment.setDate(dto.getDate());
                payment.setFromOwner((AccountOwner)((Object)(toMember ? SystemAccountOwner.instance() : externalTransfer.getMember())));
                payment.setToOwner(toMember ? externalTransfer.getMember() : SystemAccountOwner.instance());
                payment.setTransferType(type.getTransferType());
                payment.setAmount(dto.getAmount());
                payment.setDescription(externalTransfer.getDescription() != null ? externalTransfer.getDescription() : type.getName());
                payment.setExternalTransfer(externalTransfer);
                this.paymentService.insertWithNotification(payment);
                break;
            }
            case DISCARD_LOAN: {
                this.loanService.discardByExternalTransfer(dto.getLoan(), externalTransfer);
                break;
            }
            case CONCILIATE_PAYMENT: {
                this.paymentService.conciliate(dto.getTransfer(), externalTransfer);
            }
        }
        externalTransfer.setStatus(ExternalTransfer.Status.PROCESSED);
        this.externalTransferDao.update(externalTransfer);
    }

    private ExternalTransferType resolveType(ExternalTransferImport transferImport, TransactionImportDTO dto) {
        try {
            return this.externalTransferTypeService.load(transferImport.getAccount(), dto.getTypeCode(), new Relationship[0]);
        }
        catch (Exception e) {
            return null;
        }
    }

    private class RequiredWhenNotIgnoreValidation
    implements PropertyValidation {
        private static final long serialVersionUID = -2629175142234917511L;

        private RequiredWhenNotIgnoreValidation() {
        }

        @Override
        public ValidationError validate(Object object, Object property, Object value) {
            ExternalTransfer transfer = (ExternalTransfer)object;
            ExternalTransferType type = ExternalTransferServiceImpl.this.fetchService.fetch(transfer.getType(), new Relationship[0]);
            if (type == null) {
                return null;
            }
            if (type.getAction() == ExternalTransferType.Action.IGNORE) {
                return null;
            }
            return RequiredValidation.instance().validate(object, property, value);
        }
    }
}

