/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.services.accounts.external;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import nl.strohalm.cyclos.access.AdminSystemPermission;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.accounts.external.ExternalTransfer;
import nl.strohalm.cyclos.entities.accounts.external.ExternalTransferAction;
import nl.strohalm.cyclos.entities.accounts.external.ExternalTransferQuery;
import nl.strohalm.cyclos.entities.exceptions.UnexpectedEntityException;
import nl.strohalm.cyclos.services.BaseServiceSecurity;
import nl.strohalm.cyclos.services.accounts.external.ExternalTransferService;
import nl.strohalm.cyclos.services.accounts.external.ExternalTransferServiceLocal;
import nl.strohalm.cyclos.services.accounts.external.ProcessExternalTransferDTO;

public class ExternalTransferServiceSecurity
extends BaseServiceSecurity
implements ExternalTransferService {
    private ExternalTransferServiceLocal externalTransferService;

    @Override
    public ExternalTransfer load(Long id, Relationship ... fetch) {
        Relationship[] newFetch = this.addToFetch(fetch, ExternalTransfer.Relationships.MEMBER);
        ExternalTransfer et = this.externalTransferService.load(id, newFetch);
        if (et.getMember() != null) {
            this.permissionService.checkManages(et.getMember());
        }
        this.permissionService.permission().admin(AdminSystemPermission.EXTERNAL_ACCOUNTS_DETAILS).check();
        return et;
    }

    @Override
    public void performAction(ExternalTransferAction action, Long ... ids) {
        switch (action) {
            case DELETE: {
                this.permissionService.permission().admin(AdminSystemPermission.EXTERNAL_ACCOUNTS_MANAGE_PAYMENT).check();
                break;
            }
            case MARK_AS_CHECKED: {
                this.permissionService.permission().admin(AdminSystemPermission.EXTERNAL_ACCOUNTS_CHECK_PAYMENT).check();
                break;
            }
            case MARK_AS_UNCHECKED: {
                this.permissionService.permission().admin(AdminSystemPermission.EXTERNAL_ACCOUNTS_CHECK_PAYMENT).check();
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected action " + (Object)((Object)action));
            }
        }
        for (Long id : ids) {
            ExternalTransfer externalTransfer = this.externalTransferService.load(id, ExternalTransfer.Relationships.MEMBER);
            if (externalTransfer.getMember() == null) continue;
            this.permissionService.checkManages(externalTransfer.getMember());
        }
        this.externalTransferService.performAction(action, ids);
    }

    @Override
    public int process(Collection<ProcessExternalTransferDTO> dtos) throws UnexpectedEntityException {
        this.permissionService.permission().admin(AdminSystemPermission.EXTERNAL_ACCOUNTS_PROCESS_PAYMENT).check();
        return this.externalTransferService.process(dtos);
    }

    @Override
    public ExternalTransfer save(ExternalTransfer externalTransfer) {
        if (externalTransfer.getMember() != null) {
            this.permissionService.checkManages(externalTransfer.getMember());
        }
        this.permissionService.permission().admin(AdminSystemPermission.EXTERNAL_ACCOUNTS_MANAGE_PAYMENT).check();
        return this.externalTransferService.save(externalTransfer);
    }

    @Override
    public List<ExternalTransfer> search(ExternalTransferQuery query) {
        if (!this.permissionService.permission().admin(AdminSystemPermission.EXTERNAL_ACCOUNTS_DETAILS).hasPermission()) {
            return Collections.emptyList();
        }
        if (query.getMember() != null && !this.permissionService.manages(query.getMember())) {
            return Collections.emptyList();
        }
        return this.externalTransferService.search(query);
    }

    public void setExternalTransferServiceLocal(ExternalTransferServiceLocal externalTransferService) {
        this.externalTransferService = externalTransferService;
    }

    @Override
    public void validate(ExternalTransfer externalTransfer) {
        this.externalTransferService.validate(externalTransfer);
    }
}

