/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.services.accounts.external;

import java.util.List;
import nl.strohalm.cyclos.dao.accounts.external.ExternalTransferTypeDAO;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.accounts.external.ExternalAccount;
import nl.strohalm.cyclos.entities.accounts.external.ExternalTransferType;
import nl.strohalm.cyclos.entities.exceptions.EntityNotFoundException;
import nl.strohalm.cyclos.services.accounts.external.ExternalTransferTypeServiceLocal;
import nl.strohalm.cyclos.utils.validation.Validator;

public class ExternalTransferTypeServiceImpl
implements ExternalTransferTypeServiceLocal {
    private ExternalTransferTypeDAO externalTransferTypeDao;

    public List<ExternalTransferType> listAll() {
        return this.externalTransferTypeDao.listAll();
    }

    @Override
    public List<ExternalTransferType> listByAccount(ExternalAccount account) {
        return this.externalTransferTypeDao.listByAccount(account);
    }

    @Override
    public ExternalTransferType load(ExternalAccount account, String code, Relationship ... fetch) throws EntityNotFoundException {
        return this.externalTransferTypeDao.load(account, code, fetch);
    }

    @Override
    public ExternalTransferType load(Long id, Relationship ... fetch) throws EntityNotFoundException {
        return (ExternalTransferType)this.externalTransferTypeDao.load(id, fetch);
    }

    @Override
    public int remove(Long ... ids) {
        return this.externalTransferTypeDao.delete(ids);
    }

    @Override
    public ExternalTransferType save(ExternalTransferType externalTransferType) {
        this.validate(externalTransferType);
        if (externalTransferType.isTransient()) {
            return this.externalTransferTypeDao.insert(externalTransferType);
        }
        return this.externalTransferTypeDao.update(externalTransferType);
    }

    public void setExternalTransferTypeDao(ExternalTransferTypeDAO externalTransferTypeDao) {
        this.externalTransferTypeDao = externalTransferTypeDao;
    }

    @Override
    public void validate(ExternalTransferType externalTransferType) {
        this.getValidator().validate(externalTransferType);
    }

    private Validator getValidator() {
        Validator validator = new Validator("externalTransferType");
        validator.property("name").required().maxLength(50);
        validator.property("account").required();
        validator.property("action").required();
        validator.property("code").required().maxLength(20);
        return validator;
    }
}

