/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.services.accounts.external;

import java.util.List;
import nl.strohalm.cyclos.access.AdminSystemPermission;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.accounts.external.ExternalAccount;
import nl.strohalm.cyclos.entities.accounts.external.ExternalTransferType;
import nl.strohalm.cyclos.entities.exceptions.EntityNotFoundException;
import nl.strohalm.cyclos.services.BaseServiceSecurity;
import nl.strohalm.cyclos.services.accounts.external.ExternalTransferTypeService;
import nl.strohalm.cyclos.services.accounts.external.ExternalTransferTypeServiceLocal;

public class ExternalTransferTypeServiceSecurity
extends BaseServiceSecurity
implements ExternalTransferTypeService {
    private ExternalTransferTypeServiceLocal externalTransferTypeService;

    @Override
    public List<ExternalTransferType> listByAccount(ExternalAccount account) {
        this.permissionService.permission().admin(AdminSystemPermission.EXTERNAL_ACCOUNTS_VIEW).check();
        return this.externalTransferTypeService.listByAccount(account);
    }

    @Override
    public ExternalTransferType load(Long id, Relationship ... fetch) throws EntityNotFoundException {
        this.permissionService.permission().admin(AdminSystemPermission.EXTERNAL_ACCOUNTS_VIEW).check();
        return this.externalTransferTypeService.load(id, fetch);
    }

    @Override
    public int remove(Long ... ids) {
        this.permissionService.permission().admin(AdminSystemPermission.EXTERNAL_ACCOUNTS_MANAGE).check();
        return this.externalTransferTypeService.remove(ids);
    }

    @Override
    public ExternalTransferType save(ExternalTransferType externalTransferType) {
        this.permissionService.permission().admin(AdminSystemPermission.EXTERNAL_ACCOUNTS_MANAGE).check();
        return this.externalTransferTypeService.save(externalTransferType);
    }

    public void setExternalTransferTypeServiceLocal(ExternalTransferTypeServiceLocal externalTransferTypeService) {
        this.externalTransferTypeService = externalTransferTypeService;
    }

    @Override
    public void validate(ExternalTransferType externalTransferType) {
        this.externalTransferTypeService.validate(externalTransferType);
    }
}

