/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.services.accounts.external.filemapping;

import nl.strohalm.cyclos.dao.FetchDAO;
import nl.strohalm.cyclos.dao.accounts.external.filemapping.FieldMappingDAO;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.accounts.external.filemapping.FieldMapping;
import nl.strohalm.cyclos.entities.accounts.external.filemapping.FileMapping;
import nl.strohalm.cyclos.entities.accounts.external.filemapping.FileMappingWithFields;
import nl.strohalm.cyclos.services.accounts.external.filemapping.FieldMappingServiceLocal;
import nl.strohalm.cyclos.services.accounts.external.filemapping.FileMappingServiceLocal;
import nl.strohalm.cyclos.utils.MessageResolver;
import nl.strohalm.cyclos.utils.validation.GeneralValidation;
import nl.strohalm.cyclos.utils.validation.RequiredError;
import nl.strohalm.cyclos.utils.validation.ValidationError;
import nl.strohalm.cyclos.utils.validation.Validator;

public class FieldMappingServiceImpl
implements FieldMappingServiceLocal {
    private FetchDAO fetchDao;
    private FileMappingServiceLocal fileMappingService;
    private FieldMappingDAO fieldMappingDao;
    private MessageResolver messageResolver;

    @Override
    public FieldMapping load(Long id, Relationship ... fetch) {
        return (FieldMapping)this.fieldMappingDao.load(id, fetch);
    }

    @Override
    public int remove(Long ... ids) {
        for (Long id : ids) {
            FieldMapping field = (FieldMapping)this.fieldMappingDao.load(id, FieldMapping.Relationships.FILE_MAPPING);
            FileMappingWithFields fileMapping = (FileMappingWithFields)this.fileMappingService.load(field.getFileMapping().getId(), FileMappingWithFields.Relationships.FIELDS);
            boolean toEnumerate = false;
            for (FieldMapping enumerate : fileMapping.getFields()) {
                if (enumerate.equals(field)) {
                    toEnumerate = true;
                    continue;
                }
                if (!toEnumerate) continue;
                enumerate.setOrder(enumerate.getOrder() - 1);
                this.fieldMappingDao.update(enumerate);
            }
        }
        return this.fieldMappingDao.delete(ids);
    }

    @Override
    public FieldMapping save(FieldMapping fieldMapping) {
        this.validate(fieldMapping);
        if (fieldMapping.isTransient()) {
            FileMapping fileMapping = fieldMapping.getFileMapping();
            fileMapping = this.fetchDao.fetch(fileMapping, FileMappingWithFields.Relationships.FIELDS);
            FileMappingWithFields fileMappingWithFields = (FileMappingWithFields)fileMapping;
            int order = fileMappingWithFields.getFields().size() + 1;
            fieldMapping.setOrder(order);
            return this.fieldMappingDao.insert(fieldMapping);
        }
        return this.fieldMappingDao.update(fieldMapping);
    }

    public void setFetchDao(FetchDAO fetchDao) {
        this.fetchDao = fetchDao;
    }

    public void setFieldMappingDao(FieldMappingDAO fieldMappingDao) {
        this.fieldMappingDao = fieldMappingDao;
    }

    public void setFileMappingServiceLocal(FileMappingServiceLocal fileMappingService) {
        this.fileMappingService = fileMappingService;
    }

    public void setMessageResolver(MessageResolver messageResolver) {
        this.messageResolver = messageResolver;
    }

    @Override
    public void setOrder(Long[] fieldMappingsIds) {
        int index = 0;
        for (Long fieldMappingId : fieldMappingsIds) {
            FieldMapping fieldMapping = this.load(fieldMappingId, new Relationship[0]);
            fieldMapping.setOrder(++index);
            this.fieldMappingDao.update(fieldMapping);
        }
    }

    @Override
    public void validate(FieldMapping fieldMapping) {
        this.getValidator().validate(fieldMapping);
    }

    private Validator getValidator() {
        Validator validator = new Validator("fieldMapping");
        validator.property("fileMapping").required();
        validator.property("name").required();
        validator.property("field").required();
        validator.general(new OrderValidation(), new MemberFieldValidation());
        return validator;
    }

    public class OrderValidation
    implements GeneralValidation {
        private static final long serialVersionUID = -1936877851448398480L;

        @Override
        public ValidationError validate(Object object) {
            FieldMapping fieldMapping = (FieldMapping)object;
            if (fieldMapping.isPersistent() && fieldMapping.getOrder() <= 0) {
                return new ValidationError("fieldMapping.order.error.required", new Object[0]);
            }
            return null;
        }
    }

    public class MemberFieldValidation
    implements GeneralValidation {
        private static final long serialVersionUID = -6340054946112781001L;

        @Override
        public ValidationError validate(Object object) {
            FieldMapping fieldMapping = (FieldMapping)object;
            if (fieldMapping.getField() == FieldMapping.Field.MEMBER_CUSTOM_FIELD && fieldMapping.getMemberField() == null) {
                String field = FieldMappingServiceImpl.this.messageResolver.message("fieldMapping.memberField", new Object[0]);
                return new RequiredError(field);
            }
            return null;
        }
    }
}

