/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.services.accounts.external.filemapping;

import nl.strohalm.cyclos.dao.FetchDAO;
import nl.strohalm.cyclos.dao.accounts.external.ExternalAccountDAO;
import nl.strohalm.cyclos.dao.accounts.external.filemapping.FileMappingDAO;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.accounts.external.ExternalAccount;
import nl.strohalm.cyclos.entities.accounts.external.filemapping.CSVFileMapping;
import nl.strohalm.cyclos.entities.accounts.external.filemapping.FileMapping;
import nl.strohalm.cyclos.entities.accounts.external.filemapping.FileMappingWithFields;
import nl.strohalm.cyclos.services.accounts.external.filemapping.FileMappingServiceLocal;
import nl.strohalm.cyclos.utils.transactionimport.TransactionFileImport;
import nl.strohalm.cyclos.utils.validation.GeneralValidation;
import nl.strohalm.cyclos.utils.validation.ValidationError;
import nl.strohalm.cyclos.utils.validation.Validator;

public class FileMappingServiceImpl
implements FileMappingServiceLocal {
    private ExternalAccountDAO externalAccountDao;
    private FetchDAO fetchDao;
    private FileMappingDAO fileMappingDao;

    @Override
    public FileMapping load(Long id, Relationship ... fetch) {
        return (FileMapping)this.fileMappingDao.load(id, fetch);
    }

    @Override
    public int remove(Long ... ids) {
        return this.fileMappingDao.delete(ids);
    }

    @Override
    public void reset(FileMapping fileMapping) {
        ExternalAccount externalAccount = fileMapping.getAccount();
        externalAccount.setFileMapping(null);
        this.externalAccountDao.update(externalAccount);
        this.remove(fileMapping.getId());
    }

    @Override
    public FileMapping save(FileMapping fileMapping) {
        this.validate(fileMapping);
        if (fileMapping.isTransient()) {
            fileMapping = this.fileMappingDao.insert(fileMapping);
            ExternalAccount externalAccount = this.fetchDao.fetch(fileMapping.getAccount(), new Relationship[0]);
            externalAccount.setFileMapping(fileMapping);
            this.externalAccountDao.update(externalAccount);
        } else {
            fileMapping = this.fileMappingDao.update(fileMapping);
        }
        return fileMapping;
    }

    public void setExternalAccountDao(ExternalAccountDAO externalAccountDao) {
        this.externalAccountDao = externalAccountDao;
    }

    public void setFetchDao(FetchDAO fetchDao) {
        this.fetchDao = fetchDao;
    }

    public void setFileMappingDao(FileMappingDAO fileMappingDao) {
        this.fileMappingDao = fileMappingDao;
    }

    @Override
    public void validate(FileMapping fileMapping) {
        Validator validator = null;
        validator = fileMapping.getNature() == FileMapping.Nature.CSV ? this.getCSVValidator() : this.getCustomValidator();
        validator.validate(fileMapping);
    }

    private Validator getCSVValidator() {
        Validator csvValidator = new Validator("fileMapping");
        csvValidator.property("account").required();
        csvValidator.property("numberFormat").required();
        csvValidator.general(new DecimalFormatValidation());
        csvValidator.property("negativeAmountValue").required().maxLength(50);
        csvValidator.property("dateFormat").required();
        csvValidator.property("stringQuote").required().maxLength(1);
        csvValidator.property("columnSeparator").required().maxLength(1);
        csvValidator.property("headerLines").required().positive();
        return csvValidator;
    }

    private Validator getCustomValidator() {
        Validator customValidator = new Validator("fileMapping");
        customValidator.property("account").required();
        customValidator.property("className").required().instanceOf(TransactionFileImport.class);
        return customValidator;
    }

    public class DecimalFormatValidation
    implements GeneralValidation {
        private static final long serialVersionUID = 7246850448052192489L;

        @Override
        public ValidationError validate(Object object) {
            CSVFileMapping fileMapping = (CSVFileMapping)object;
            if (fileMapping.getNumberFormat() == FileMappingWithFields.NumberFormat.FIXED_POSITION) {
                if (fileMapping.getDecimalPlaces() == null) {
                    return new ValidationError("fileMapping.decimalPlaces.error.required", new Object[0]);
                }
            } else if (fileMapping.getDecimalSeparator() == null) {
                return new ValidationError("fileMapping.decimalSeparator.error.required", new Object[0]);
            }
            return null;
        }
    }
}

