/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.services.accounts.guarantees;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import nl.strohalm.cyclos.access.AdminMemberPermission;
import nl.strohalm.cyclos.dao.accounts.guarantees.CertificationDAO;
import nl.strohalm.cyclos.dao.accounts.guarantees.CertificationLogDAO;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.access.User;
import nl.strohalm.cyclos.entities.accounts.Currency;
import nl.strohalm.cyclos.entities.accounts.guarantees.Certification;
import nl.strohalm.cyclos.entities.accounts.guarantees.CertificationLog;
import nl.strohalm.cyclos.entities.accounts.guarantees.CertificationQuery;
import nl.strohalm.cyclos.entities.accounts.guarantees.Guarantee;
import nl.strohalm.cyclos.entities.accounts.guarantees.GuaranteeType;
import nl.strohalm.cyclos.entities.accounts.guarantees.PaymentObligation;
import nl.strohalm.cyclos.entities.members.Member;
import nl.strohalm.cyclos.services.InitializingService;
import nl.strohalm.cyclos.services.accounts.guarantees.CertificationDTO;
import nl.strohalm.cyclos.services.accounts.guarantees.CertificationServiceLocal;
import nl.strohalm.cyclos.services.accounts.guarantees.GuaranteeServiceLocal;
import nl.strohalm.cyclos.services.accounts.guarantees.exceptions.CertificationStatusChangeException;
import nl.strohalm.cyclos.services.fetch.FetchServiceLocal;
import nl.strohalm.cyclos.services.permissions.PermissionServiceLocal;
import nl.strohalm.cyclos.utils.DateHelper;
import nl.strohalm.cyclos.utils.Period;
import nl.strohalm.cyclos.utils.access.LoggedUser;
import nl.strohalm.cyclos.utils.notifications.MemberNotificationHandler;
import nl.strohalm.cyclos.utils.query.Page;
import nl.strohalm.cyclos.utils.query.PageImpl;
import nl.strohalm.cyclos.utils.query.PageParameters;
import nl.strohalm.cyclos.utils.query.QueryParameters;
import nl.strohalm.cyclos.utils.validation.GeneralValidation;
import nl.strohalm.cyclos.utils.validation.PeriodValidation;
import nl.strohalm.cyclos.utils.validation.ValidationError;
import nl.strohalm.cyclos.utils.validation.ValidationException;
import nl.strohalm.cyclos.utils.validation.Validator;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Transformer;

public class CertificationServiceImpl
implements CertificationServiceLocal,
InitializingService {
    private PermissionServiceLocal permissionService;
    private GuaranteeServiceLocal guaranteeService;
    private CertificationDAO certificationDao;
    private CertificationLogDAO certificationLogDao;
    private MemberNotificationHandler memberNotificationHandler;
    private FetchServiceLocal fetchService;

    @Override
    public boolean canChangeStatus(Certification certification, Certification.Status newStatus) {
        switch (newStatus) {
            case ACTIVE: {
                Certification activeCert = this.getActiveCertification(certification.getGuaranteeType().getCurrency(), certification.getBuyer(), certification.getIssuer());
                boolean isIssuer = this.guaranteeService.isIssuer() && certification.getIssuer().equals(LoggedUser.accountOwner());
                return isIssuer && this.isInSomeStatus(certification, Certification.Status.SUSPENDED) && (activeCert == null || Certification.Status.SCHEDULED == this.calculateInitialStatus(certification));
            }
            case CANCELLED: {
                boolean hasPermission = this.permissionService.hasPermission(AdminMemberPermission.GUARANTEES_CANCEL_CERTIFICATIONS_AS_MEMBER);
                return hasPermission && this.isInSomeStatus(certification, Certification.Status.ACTIVE, Certification.Status.SUSPENDED, Certification.Status.SCHEDULED);
            }
            case SUSPENDED: {
                boolean isIssuer = this.guaranteeService.isIssuer() && certification.getIssuer().equals(LoggedUser.accountOwner());
                return isIssuer && this.isInSomeStatus(certification, Certification.Status.ACTIVE, Certification.Status.SCHEDULED);
            }
        }
        throw new CertificationStatusChangeException(newStatus, "Can't change certification's status, unsupported target status: " + newStatus);
    }

    @Override
    public boolean canDelete(Certification certification) {
        boolean hasPermision = this.permissionService.manages((certification = this.fetchService.fetch(certification, Certification.Relationships.ISSUER)).getIssuer()) && this.permissionService.hasPermission(AdminMemberPermission.GUARANTEES_CANCEL_CERTIFICATIONS_AS_MEMBER);
        return hasPermision && this.isInSomeStatus(certification, Certification.Status.CANCELLED);
    }

    @Override
    public void changeStatus(Long certificationId, Certification.Status newStatus) {
        Certification certification = this.load(certificationId, new Relationship[0]);
        boolean changeAllowed = this.canChangeStatus(certification, newStatus);
        if (!changeAllowed) {
            throw new CertificationStatusChangeException(newStatus);
        }
        if (newStatus == Certification.Status.ACTIVE) {
            newStatus = this.calculateInitialStatus(certification);
        }
        CertificationLog log = certification.changeStatus(newStatus, ((User)LoggedUser.user()).getElement());
        this.saveLog(log);
        certification = this.save(certification, false);
        switch (newStatus) {
            case CANCELLED: {
                this.memberNotificationHandler.certificationCanceledNotification(certificationId);
                break;
            }
            default: {
                this.memberNotificationHandler.certificationStatusChangedNotification(certification);
            }
        }
    }

    @Override
    public Certification getActiveCertification(Currency currency, Member buyer, Member issuer) {
        List<Certification> activeCertifications = this.certificationDao.getActiveCertificationsForBuyer(buyer, currency);
        for (Certification cert : activeCertifications) {
            if (!issuer.equals(cert.getIssuer())) continue;
            return cert;
        }
        return null;
    }

    @Override
    public List<Member> getCertificationIssuers(PaymentObligation paymentObligation) {
        List<Certification> activeCertifications = this.certificationDao.getActiveCertificationsForBuyer(paymentObligation.getBuyer(), paymentObligation.getCurrency());
        ArrayList<Member> issuers = new ArrayList<Member>();
        for (Certification cert : activeCertifications) {
            issuers.add(cert.getIssuer());
        }
        return issuers;
    }

    @Override
    public BigDecimal getUsedAmount(Certification certification, boolean includePendingGuarantees) {
        ArrayList<Guarantee.Status> statusList = new ArrayList<Guarantee.Status>();
        statusList.add(Guarantee.Status.ACCEPTED);
        if (includePendingGuarantees) {
            statusList.add(Guarantee.Status.PENDING_ADMIN);
            statusList.add(Guarantee.Status.PENDING_ISSUER);
        }
        List<Guarantee> guarantees = this.guaranteeService.getGuarantees(certification, PageParameters.all(), statusList);
        BigDecimal notPaidAmount = BigDecimal.ZERO;
        for (Guarantee g : guarantees) {
            if (g.getStatus() == Guarantee.Status.ACCEPTED && g.getLoan() != null) {
                notPaidAmount = notPaidAmount.add(g.getLoan().getRemainingAmount());
                continue;
            }
            notPaidAmount = notPaidAmount.add(g.getAmount());
        }
        return notPaidAmount;
    }

    @Override
    public void initializeService() {
        this.processCertifications(Calendar.getInstance());
    }

    @Override
    public Certification load(Long id, Relationship ... fetch) {
        return (Certification)this.certificationDao.load(id, fetch);
    }

    @Override
    public void processCertifications(Calendar taskTime) {
        this.processCertifications(taskTime, Certification.Status.ACTIVE);
        this.processCertifications(taskTime, Certification.Status.EXPIRED);
    }

    @Override
    public int remove(Long certificationId) {
        return this.certificationDao.delete(certificationId);
    }

    @Override
    public Certification save(Certification certification) {
        return this.save(certification, true);
    }

    @Override
    public List<Certification> search(CertificationQuery queryParameters) {
        return this.certificationDao.seach(queryParameters);
    }

    @Override
    public List<CertificationDTO> searchWithUsedAmount(CertificationQuery queryParameters) {
        List<Certification> certifications = this.certificationDao.seach(queryParameters);
        Transformer transformer = new Transformer(){

            public Object transform(Object input) {
                Certification certification = (Certification)input;
                return new CertificationDTO(certification, CertificationServiceImpl.this.getUsedAmount(certification, false));
            }
        };
        PageImpl result = (PageImpl)CollectionUtils.collect(certifications, (Transformer)transformer, new ArrayList());
        if (certifications instanceof Page) {
            Page original = (Page)certifications;
            PageParameters pageParameters = new PageParameters(original.getPageSize(), original.getCurrentPage());
            result = new PageImpl(pageParameters, original.getTotalCount(), result);
        }
        return result;
    }

    public void setCertificationDao(CertificationDAO certificationDao) {
        this.certificationDao = certificationDao;
    }

    public void setCertificationLogDao(CertificationLogDAO certificationLogDao) {
        this.certificationLogDao = certificationLogDao;
    }

    public void setFetchServiceLocal(FetchServiceLocal fetchService) {
        this.fetchService = fetchService;
    }

    public void setGuaranteeServiceLocal(GuaranteeServiceLocal guaranteeService) {
        this.guaranteeService = guaranteeService;
    }

    public void setMemberNotificationHandler(MemberNotificationHandler memberNotificationHandler) {
        this.memberNotificationHandler = memberNotificationHandler;
    }

    public void setPermissionServiceLocal(PermissionServiceLocal permissionService) {
        this.permissionService = permissionService;
    }

    @Override
    public void validate(Certification certification) {
        ExistingActiveCertificationValidation val = new ExistingActiveCertificationValidation();
        ValidationError error = val.validate(certification);
        if (error != null) {
            ValidationException vex = new ValidationException();
            vex.addGeneralError(error);
            vex.throwIfHasErrors();
        } else {
            this.getValidator().validate(certification);
        }
    }

    private Certification.Status calculateInitialStatus(Certification certification) {
        Calendar currentDate = DateHelper.truncate(Calendar.getInstance());
        return DateHelper.truncate(certification.getValidity().getBegin()).after(currentDate) ? Certification.Status.SCHEDULED : Certification.Status.ACTIVE;
    }

    private Certification getActiveCertification(GuaranteeType guaranteeType, Member buyer, Member issuer) {
        guaranteeType = this.fetchService.fetch(guaranteeType, GuaranteeType.Relationships.CURRENCY);
        return this.getActiveCertification(guaranteeType.getCurrency(), buyer, issuer);
    }

    private Validator getValidator() {
        Validator validator = new Validator("certification");
        validator.property("amount").required().positiveNonZero();
        validator.property("guaranteeType").required().key("certification.guaranteeType");
        validator.property("buyer").required().key("certification.buyerUsername");
        validator.property("issuer").required().key("certification.issuerUsername");
        validator.property("validity").add(new PeriodValidation(PeriodValidation.ValidationType.BOTH_REQUIRED_AND_NOT_EXPIRED)).key("certification.validity");
        return validator;
    }

    private void initialize(Certification certification) {
        Certification.Status status = this.calculateInitialStatus(certification);
        certification.setStatus(status);
    }

    private boolean isInSomeStatus(Certification certification, Certification.Status ... status) {
        for (Certification.Status s : status) {
            if (certification.getStatus() != s) continue;
            return true;
        }
        return false;
    }

    private void processCertifications(Calendar time, Certification.Status newStatus) {
        time = DateHelper.truncate(time);
        HashSet<Relationship> fetch = new HashSet<Relationship>();
        fetch.add(Certification.Relationships.BUYER);
        fetch.add(Certification.Relationships.ISSUER);
        fetch.add(Certification.Relationships.LOGS);
        CertificationQuery query = new CertificationQuery();
        query.setResultType(QueryParameters.ResultType.ITERATOR);
        query.setFetch(fetch);
        if (newStatus == Certification.Status.ACTIVE) {
            query.setStartIn(Period.endingAt(time));
            query.setStatusList(Collections.singletonList(Certification.Status.SCHEDULED));
        } else {
            time.add(5, -1);
            query.setEndIn(Period.endingAt(time));
            query.setStatusList(Arrays.asList(Certification.Status.ACTIVE, Certification.Status.SUSPENDED));
        }
        List<Certification> certifications = this.search(query);
        for (Certification certification : certifications) {
            Certification alreadyActiveCertification;
            if (newStatus == Certification.Status.ACTIVE && (alreadyActiveCertification = this.getActiveCertification(certification.getGuaranteeType(), certification.getBuyer(), certification.getIssuer())) != null) {
                newStatus = Certification.Status.SUSPENDED;
            }
            certification.setStatus(newStatus);
            CertificationLog log = certification.changeStatus(newStatus, null);
            this.saveLog(log);
            this.save(certification, false);
            this.memberNotificationHandler.certificationStatusChangedNotification(certification);
        }
    }

    private Certification save(Certification certification, boolean validate) {
        if (validate) {
            this.validate(certification);
        }
        if (certification.isTransient()) {
            this.initialize(certification);
            certification = this.certificationDao.insert(certification);
            CertificationLog log = certification.getNewLog(certification.getStatus(), ((User)LoggedUser.user()).getElement());
            this.saveLog(log);
            this.memberNotificationHandler.certificationIssuedNotification(certification);
            return certification;
        }
        return this.certificationDao.update(certification);
    }

    private CertificationLog saveLog(CertificationLog certificationLog) {
        if (certificationLog.isTransient()) {
            return this.certificationLogDao.insert(certificationLog);
        }
        return this.certificationLogDao.update(certificationLog);
    }

    private class ExistingActiveCertificationValidation
    implements GeneralValidation {
        private static final long serialVersionUID = 840449718151754491L;

        private ExistingActiveCertificationValidation() {
        }

        @Override
        public ValidationError validate(Object object) {
            Certification certification = (Certification)object;
            GuaranteeType guaranteeType = certification.getGuaranteeType();
            Member buyer = certification.getBuyer();
            Member issuer = certification.getIssuer();
            if (guaranteeType == null || buyer == null || issuer == null) {
                return null;
            }
            if (this.willBeActive(certification) && CertificationServiceImpl.this.getActiveCertification(guaranteeType, buyer, issuer) != null) {
                return new ValidationError("certification.error.certificationActiveExists", new Object[0]);
            }
            return null;
        }

        private boolean willBeActive(Certification certification) {
            Calendar end;
            Calendar begin = certification.getValidity() == null ? null : certification.getValidity().getBegin();
            Calendar calendar = end = certification.getValidity() == null ? null : certification.getValidity().getEnd();
            if (begin == null || end == null) {
                return false;
            }
            Calendar currentDate = DateHelper.truncate(Calendar.getInstance());
            begin = DateHelper.truncate(begin);
            end = DateHelper.truncate(end);
            return !(!begin.before(currentDate) && !begin.equals(currentDate) || !end.after(currentDate) && !end.equals(currentDate));
        }
    }
}

