/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.services.accounts.guarantees;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import nl.strohalm.cyclos.access.AdminMemberPermission;
import nl.strohalm.cyclos.access.MemberPermission;
import nl.strohalm.cyclos.access.OperatorPermission;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.accounts.Currency;
import nl.strohalm.cyclos.entities.accounts.guarantees.Certification;
import nl.strohalm.cyclos.entities.accounts.guarantees.CertificationQuery;
import nl.strohalm.cyclos.entities.accounts.guarantees.GuaranteeType;
import nl.strohalm.cyclos.entities.accounts.guarantees.PaymentObligation;
import nl.strohalm.cyclos.entities.groups.Group;
import nl.strohalm.cyclos.entities.groups.MemberGroup;
import nl.strohalm.cyclos.entities.members.Element;
import nl.strohalm.cyclos.entities.members.Member;
import nl.strohalm.cyclos.exceptions.PermissionDeniedException;
import nl.strohalm.cyclos.services.BaseServiceSecurity;
import nl.strohalm.cyclos.services.accounts.guarantees.CertificationDTO;
import nl.strohalm.cyclos.services.accounts.guarantees.CertificationService;
import nl.strohalm.cyclos.services.accounts.guarantees.CertificationServiceLocal;
import nl.strohalm.cyclos.services.accounts.guarantees.GuaranteeServiceLocal;
import nl.strohalm.cyclos.utils.access.LoggedUser;
import nl.strohalm.cyclos.utils.access.PermissionHelper;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;

public class CertificationServiceSecurity
extends BaseServiceSecurity
implements CertificationService {
    private CertificationServiceLocal certificationService;
    private GuaranteeServiceLocal guaranteeService;

    @Override
    public boolean canChangeStatus(Certification certification, Certification.Status newStatus) {
        this.checkHasUser();
        return this.certificationService.canChangeStatus(certification, newStatus);
    }

    @Override
    public boolean canDelete(Certification certification) {
        this.checkHasUser();
        return this.certificationService.canDelete(certification);
    }

    @Override
    public void changeStatus(Long certificationId, Certification.Status newStatus) {
        Certification certification = this.certificationService.load(certificationId, new Relationship[0]);
        switch (newStatus) {
            case CANCELLED: {
                this.permissionService.permission(certification.getIssuer()).admin(AdminMemberPermission.GUARANTEES_CANCEL_CERTIFICATIONS_AS_MEMBER).check();
                break;
            }
            default: {
                this.permissionService.permission(certification.getIssuer()).member(MemberPermission.GUARANTEES_ISSUE_CERTIFICATIONS).operator(OperatorPermission.GUARANTEES_ISSUE_CERTIFICATIONS).check();
            }
        }
        this.certificationService.changeStatus(certificationId, newStatus);
    }

    @Override
    public Certification getActiveCertification(Currency currency, Member buyer, Member issuer) {
        boolean hasPermission = false;
        if (this.permissionService.relatesTo(buyer) && this.guaranteeService.isSeller()) {
            hasPermission = this.permissionService.permission().member(MemberPermission.GUARANTEES_SELL_WITH_PAYMENT_OBLIGATIONS).operator(OperatorPermission.GUARANTEES_SELL_WITH_PAYMENT_OBLIGATIONS).hasPermission();
        }
        if (!hasPermission) {
            throw new PermissionDeniedException();
        }
        return this.certificationService.getActiveCertification(currency, buyer, issuer);
    }

    @Override
    public List<Member> getCertificationIssuers(PaymentObligation paymentObligation) {
        boolean hasPermission = false;
        if (this.guaranteeService.isSeller()) {
            hasPermission = this.permissionService.permission(paymentObligation.getSeller()).member(MemberPermission.GUARANTEES_SELL_WITH_PAYMENT_OBLIGATIONS).operator(OperatorPermission.GUARANTEES_SELL_WITH_PAYMENT_OBLIGATIONS).hasPermission();
        }
        if (!hasPermission) {
            throw new PermissionDeniedException();
        }
        return this.certificationService.getCertificationIssuers(paymentObligation);
    }

    @Override
    public BigDecimal getUsedAmount(Certification certification, boolean includePendingGuarantees) {
        this.checkView(certification);
        return this.certificationService.getUsedAmount(certification, includePendingGuarantees);
    }

    @Override
    public Certification load(Long id, Relationship ... fetch) {
        Certification certification = this.certificationService.load(id, fetch);
        this.checkView(certification);
        return certification;
    }

    @Override
    public int remove(Long certificationId) {
        Certification certification = this.certificationService.load(certificationId, new Relationship[0]);
        if (this.canDelete(certification)) {
            return this.certificationService.remove(certificationId);
        }
        throw new PermissionDeniedException();
    }

    @Override
    public Certification save(Certification certification) {
        this.permissionService.permission(certification.getIssuer()).member(MemberPermission.GUARANTEES_ISSUE_CERTIFICATIONS).check();
        if (!certification.isTransient()) {
            throw new PermissionDeniedException();
        }
        this.checkGuaranteeType(certification);
        MemberGroup buyerGroup = (MemberGroup)this.fetchService.fetch(certification.getBuyer(), Element.Relationships.GROUP).getGroup();
        Collection<? extends MemberGroup> allowedBuyerGroups = this.guaranteeService.getBuyers();
        PermissionHelper.checkContains(allowedBuyerGroups, buyerGroup);
        return this.certificationService.save(certification);
    }

    @Override
    public List<Certification> search(CertificationQuery queryParameters) {
        this.checkSearch(queryParameters);
        return this.certificationService.search(queryParameters);
    }

    @Override
    public List<CertificationDTO> searchWithUsedAmount(CertificationQuery queryParameters) {
        this.checkSearch(queryParameters);
        return this.certificationService.searchWithUsedAmount(queryParameters);
    }

    public void setCertificationServiceLocal(CertificationServiceLocal certificationService) {
        this.certificationService = certificationService;
    }

    public void setGuaranteeServiceLocal(GuaranteeServiceLocal guaranteeService) {
        this.guaranteeService = guaranteeService;
    }

    @Override
    public void validate(Certification certification) {
        this.certificationService.validate(certification);
    }

    private void checkGuaranteeType(Certification certification) {
        Collection<GuaranteeType> allowedGuaranteeTypes = ((Group)this.fetchService.fetch(LoggedUser.group(), new Relationship[]{Group.Relationships.GUARANTEE_TYPES})).getGuaranteeTypes();
        CollectionUtils.filter(allowedGuaranteeTypes, (Predicate)new Predicate(){

            public boolean evaluate(Object object) {
                return GuaranteeType.Model.WITH_PAYMENT_OBLIGATION == ((GuaranteeType)object).getModel();
            }
        });
        PermissionHelper.checkContains(allowedGuaranteeTypes, certification.getGuaranteeType());
    }

    private void checkSearch(CertificationQuery queryParameters) {
        this.permissionService.permission().admin(AdminMemberPermission.GUARANTEES_VIEW_CERTIFICATIONS).member(MemberPermission.GUARANTEES_ISSUE_CERTIFICATIONS, MemberPermission.GUARANTEES_BUY_WITH_PAYMENT_OBLIGATIONS).operator(OperatorPermission.GUARANTEES_ISSUE_CERTIFICATIONS, OperatorPermission.GUARANTEES_BUY_WITH_PAYMENT_OBLIGATIONS).check();
        if (LoggedUser.isAdministrator()) {
            queryParameters.setManagedMemberGroups(this.permissionService.getManagedMemberGroups());
        } else {
            queryParameters.setViewer((Member)LoggedUser.accountOwner());
        }
    }

    private void checkView(Certification certification) {
        boolean manages;
        boolean bl = manages = this.permissionService.manages((certification = this.fetchService.fetch(certification, Certification.Relationships.BUYER, Certification.Relationships.ISSUER)).getIssuer()) || this.permissionService.manages(certification.getBuyer());
        if (!manages) {
            throw new PermissionDeniedException();
        }
        this.permissionService.permission().admin(AdminMemberPermission.GUARANTEES_VIEW_CERTIFICATIONS).member(MemberPermission.GUARANTEES_ISSUE_CERTIFICATIONS, MemberPermission.GUARANTEES_BUY_WITH_PAYMENT_OBLIGATIONS).operator(OperatorPermission.GUARANTEES_ISSUE_CERTIFICATIONS, OperatorPermission.GUARANTEES_BUY_WITH_PAYMENT_OBLIGATIONS).check();
    }
}

