/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.services.accounts.guarantees;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.Callable;
import nl.strohalm.cyclos.access.AdminMemberPermission;
import nl.strohalm.cyclos.access.MemberPermission;
import nl.strohalm.cyclos.access.OperatorPermission;
import nl.strohalm.cyclos.dao.accounts.guarantees.GuaranteeDAO;
import nl.strohalm.cyclos.dao.accounts.guarantees.GuaranteeLogDAO;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.access.User;
import nl.strohalm.cyclos.entities.accounts.AccountOwner;
import nl.strohalm.cyclos.entities.accounts.SystemAccountOwner;
import nl.strohalm.cyclos.entities.accounts.guarantees.Certification;
import nl.strohalm.cyclos.entities.accounts.guarantees.Guarantee;
import nl.strohalm.cyclos.entities.accounts.guarantees.GuaranteeLog;
import nl.strohalm.cyclos.entities.accounts.guarantees.GuaranteeQuery;
import nl.strohalm.cyclos.entities.accounts.guarantees.GuaranteeType;
import nl.strohalm.cyclos.entities.accounts.guarantees.PaymentObligation;
import nl.strohalm.cyclos.entities.accounts.guarantees.PaymentObligationLog;
import nl.strohalm.cyclos.entities.accounts.loans.Loan;
import nl.strohalm.cyclos.entities.accounts.transactions.Transfer;
import nl.strohalm.cyclos.entities.accounts.transactions.TransferType;
import nl.strohalm.cyclos.entities.customization.fields.PaymentCustomField;
import nl.strohalm.cyclos.entities.customization.fields.PaymentCustomFieldValue;
import nl.strohalm.cyclos.entities.groups.Group;
import nl.strohalm.cyclos.entities.groups.GroupQuery;
import nl.strohalm.cyclos.entities.groups.MemberGroup;
import nl.strohalm.cyclos.entities.members.Element;
import nl.strohalm.cyclos.entities.members.Member;
import nl.strohalm.cyclos.entities.settings.LocalSettings;
import nl.strohalm.cyclos.exceptions.PermissionDeniedException;
import nl.strohalm.cyclos.services.InitializingService;
import nl.strohalm.cyclos.services.accounts.guarantees.CertificationServiceLocal;
import nl.strohalm.cyclos.services.accounts.guarantees.GuaranteeFeeCalculationDTO;
import nl.strohalm.cyclos.services.accounts.guarantees.GuaranteeFeeVO;
import nl.strohalm.cyclos.services.accounts.guarantees.GuaranteeServiceLocal;
import nl.strohalm.cyclos.services.accounts.guarantees.GuaranteeTypeServiceLocal;
import nl.strohalm.cyclos.services.accounts.guarantees.PaymentObligationPackDTO;
import nl.strohalm.cyclos.services.accounts.guarantees.PaymentObligationServiceLocal;
import nl.strohalm.cyclos.services.accounts.guarantees.exceptions.ActiveCertificationNotFoundException;
import nl.strohalm.cyclos.services.accounts.guarantees.exceptions.CertificationAmountExceededException;
import nl.strohalm.cyclos.services.accounts.guarantees.exceptions.CertificationValidityExceededException;
import nl.strohalm.cyclos.services.accounts.guarantees.exceptions.GuaranteeStatusChangeException;
import nl.strohalm.cyclos.services.customization.PaymentCustomFieldServiceLocal;
import nl.strohalm.cyclos.services.fetch.FetchServiceLocal;
import nl.strohalm.cyclos.services.groups.GroupServiceLocal;
import nl.strohalm.cyclos.services.permissions.PermissionServiceLocal;
import nl.strohalm.cyclos.services.settings.SettingsServiceLocal;
import nl.strohalm.cyclos.services.transactions.GrantSinglePaymentLoanDTO;
import nl.strohalm.cyclos.services.transactions.LoanServiceLocal;
import nl.strohalm.cyclos.services.transactions.PaymentServiceLocal;
import nl.strohalm.cyclos.services.transactions.TransactionContext;
import nl.strohalm.cyclos.services.transactions.TransferDTO;
import nl.strohalm.cyclos.utils.CustomFieldHelper;
import nl.strohalm.cyclos.utils.CustomFieldsContainer;
import nl.strohalm.cyclos.utils.DateHelper;
import nl.strohalm.cyclos.utils.MessageProcessingHelper;
import nl.strohalm.cyclos.utils.MessageResolver;
import nl.strohalm.cyclos.utils.Period;
import nl.strohalm.cyclos.utils.RelationshipHelper;
import nl.strohalm.cyclos.utils.TimePeriod;
import nl.strohalm.cyclos.utils.TransactionHelper;
import nl.strohalm.cyclos.utils.access.LoggedUser;
import nl.strohalm.cyclos.utils.conversion.NumberConverter;
import nl.strohalm.cyclos.utils.conversion.UnitsConverter;
import nl.strohalm.cyclos.utils.guarantees.GuaranteesHelper;
import nl.strohalm.cyclos.utils.notifications.AdminNotificationHandler;
import nl.strohalm.cyclos.utils.notifications.MemberNotificationHandler;
import nl.strohalm.cyclos.utils.query.PageParameters;
import nl.strohalm.cyclos.utils.query.QueryParameters;
import nl.strohalm.cyclos.utils.validation.DelegatingValidator;
import nl.strohalm.cyclos.utils.validation.GeneralValidation;
import nl.strohalm.cyclos.utils.validation.PeriodValidation;
import nl.strohalm.cyclos.utils.validation.ValidationError;
import nl.strohalm.cyclos.utils.validation.Validator;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.apache.commons.collections.functors.AndPredicate;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;

public class GuaranteeServiceImpl
implements GuaranteeServiceLocal,
InitializingService,
ApplicationContextAware {
    private GuaranteeDAO guaranteeDao;
    private GuaranteeLogDAO guaranteeLogDao;
    private PermissionServiceLocal permissionService;
    private GuaranteeTypeServiceLocal guaranteeTypeService;
    private GroupServiceLocal groupService;
    private PaymentObligationServiceLocal paymentObligationService;
    private CertificationServiceLocal certificationService;
    private FetchServiceLocal fetchService;
    private LoanServiceLocal loanService;
    private PaymentServiceLocal paymentService;
    private SettingsServiceLocal settingsService;
    private PaymentCustomFieldServiceLocal paymentCustomFieldService;
    private ApplicationContext applicationContext;
    private MessageResolver messageResolver = new MessageResolver.NoOpMessageResolver();
    private MemberNotificationHandler memberNotificationHandler;
    private AdminNotificationHandler adminNotificationHandler;
    private TransactionHelper transactionHelper;
    private CustomFieldHelper customFieldHelper;

    @Override
    public Guarantee acceptGuarantee(Guarantee guarantee, boolean automaticLoanAuthorization) {
        this.validate(guarantee, LoggedUser.isAdministrator() ? automaticLoanAuthorization : false);
        if (LoggedUser.isAdministrator()) {
            guarantee = this.doChangeStatus(guarantee, Guarantee.Status.ACCEPTED, automaticLoanAuthorization);
            this.memberNotificationHandler.guaranteeAcceptedNotification(guarantee);
        } else {
            Guarantee.Status currentStatus = this.load(guarantee.getId(), new Relationship[0]).getStatus();
            guarantee = this.doChangeStatus(guarantee, Guarantee.Status.ACCEPTED, false);
            this.memberNotificationHandler.guaranteeStatusChangedNotification(guarantee, currentStatus);
            this.adminNotificationHandler.notifyPendingGuarantee(guarantee);
        }
        return guarantee;
    }

    @Override
    public BigDecimal calculateFee(GuaranteeFeeCalculationDTO dto) {
        return GuaranteesHelper.calculateFee(dto.getValidity(), dto.getAmount(), dto.getFeeSpec());
    }

    @Override
    public boolean canChangeStatus(Guarantee guarantee, Guarantee.Status newStatus) {
        switch (newStatus) {
            case ACCEPTED: 
            case REJECTED: {
                if (this.isInSomeStatus(guarantee, Guarantee.Status.PENDING_ADMIN)) {
                    AdminMemberPermission permission = Guarantee.Status.ACCEPTED == newStatus ? AdminMemberPermission.GUARANTEES_ACCEPT_GUARANTEES_AS_MEMBER : AdminMemberPermission.GUARANTEES_CANCEL_GUARANTEES_AS_MEMBER;
                    boolean hasPermission = this.permissionService.hasPermission(permission);
                    return hasPermission;
                }
                if (this.isInSomeStatus(guarantee, Guarantee.Status.PENDING_ISSUER)) {
                    return this.isIssuer() && guarantee.getIssuer().equals(LoggedUser.accountOwner());
                }
                return false;
            }
            case CANCELLED: {
                boolean hasPermission = this.permissionService.hasPermission(AdminMemberPermission.GUARANTEES_CANCEL_GUARANTEES_AS_MEMBER);
                return hasPermission && this.isInSomeStatus(guarantee, Guarantee.Status.ACCEPTED, Guarantee.Status.PENDING_ADMIN, Guarantee.Status.PENDING_ISSUER) && guarantee.getLoan() == null;
            }
        }
        throw new GuaranteeStatusChangeException(newStatus, "Can't change guarantee's status, unsupported target status: " + newStatus);
    }

    @Override
    public boolean canRemoveGuarantee(Guarantee guarantee) {
        boolean currentStatusIsPendingByAdmin = (guarantee = this.fetchService.fetch(guarantee, Guarantee.Relationships.LOGS, Guarantee.Relationships.GUARANTEE_TYPE)).getStatus() == Guarantee.Status.PENDING_ADMIN;
        GuaranteeLog log = guarantee.getLogs().iterator().next();
        boolean isOnlyPendingByAdmin = guarantee.getLogs().size() == 1 && log.getStatus() == Guarantee.Status.PENDING_ADMIN;
        return LoggedUser.isAdministrator() && currentStatusIsPendingByAdmin && isOnlyPendingByAdmin && log.getBy().equals(LoggedUser.element()) && guarantee.getGuaranteeType().getModel() != GuaranteeType.Model.WITH_PAYMENT_OBLIGATION;
    }

    @Override
    public Guarantee changeStatus(Long guaranteeId, Guarantee.Status newStatus) {
        Guarantee current = this.load(guaranteeId, new Relationship[0]);
        Guarantee.Status currentStatus = current.getStatus();
        current = this.doChangeStatus(current, newStatus, false);
        switch (newStatus) {
            case CANCELLED: {
                this.memberNotificationHandler.guaranteeCancelledNotification(current);
                break;
            }
            case REJECTED: {
                this.memberNotificationHandler.guaranteeDeniedNotification(current);
                break;
            }
            default: {
                this.memberNotificationHandler.guaranteeStatusChangedNotification(current, currentStatus);
                this.adminNotificationHandler.notifyPendingGuarantee(current);
            }
        }
        return current;
    }

    @Override
    public Collection<? extends MemberGroup> getBuyers() {
        if (LoggedUser.isAdministrator()) {
            return this.filterBuyers();
        }
        if (this.isIssuer()) {
            MemberGroup group = this.fetchService.fetch((MemberGroup)((Member)LoggedUser.accountOwner()).getGroup(), MemberGroup.Relationships.CAN_ISSUE_CERTIFICATION_TO_GROUPS);
            return group.getCanIssueCertificationToGroups();
        }
        return this.guaranteeDao.getBuyers(((Member)LoggedUser.accountOwner()).getGroup());
    }

    @Override
    public List<Guarantee> getGuarantees(Certification certification, PageParameters pageParameters, List<Guarantee.Status> statusList) {
        GuaranteeQuery guaranteeQuery = new GuaranteeQuery();
        guaranteeQuery.setResultType(QueryParameters.ResultType.PAGE);
        guaranteeQuery.setPageParameters(pageParameters);
        guaranteeQuery.setCertification(certification);
        guaranteeQuery.setStatusList(statusList);
        guaranteeQuery.fetch(RelationshipHelper.nested(Guarantee.Relationships.LOAN, Loan.Relationships.PAYMENTS));
        return this.guaranteeDao.search(guaranteeQuery);
    }

    @Override
    public Collection<? extends MemberGroup> getIssuers() {
        return this.filterIssuers();
    }

    @Override
    public Collection<? extends MemberGroup> getIssuers(GuaranteeType guaranteeType) {
        Collection<MemberGroup> groups = this.guaranteeDao.getIssuers(guaranteeType);
        return this.filterMemberGroups(null, groups);
    }

    public MessageResolver getMessageResolver(MessageResolver messageResolver) {
        return messageResolver;
    }

    @Override
    public Collection<GuaranteeType.Model> getRelatedGuaranteeModels() {
        return this.guaranteeDao.getRelatedGuaranteeModels((Member)LoggedUser.accountOwner());
    }

    @Override
    public Collection<? extends MemberGroup> getSellers() {
        if (LoggedUser.isAdministrator()) {
            return this.filterSellers();
        }
        if (this.isBuyer()) {
            MemberGroup group = this.fetchService.fetch((MemberGroup)((Member)LoggedUser.accountOwner()).getGroup(), MemberGroup.Relationships.CAN_BUY_WITH_PAYMENT_OBLIGATIONS_FROM_GROUPS);
            return group.getCanBuyWithPaymentObligationsFromGroups();
        }
        return this.guaranteeDao.getSellers(((Member)LoggedUser.accountOwner()).getGroup());
    }

    @Override
    public List<Guarantee> guaranteesToProcess(Calendar time) {
        time = DateHelper.truncate(time);
        GuaranteeQuery query = new GuaranteeQuery();
        query.setResultType(QueryParameters.ResultType.ITERATOR);
        HashSet<Relationship> fetch = new HashSet<Relationship>();
        fetch.add(Guarantee.Relationships.GUARANTEE_TYPE);
        fetch.add(Guarantee.Relationships.LOGS);
        query.setFetch(fetch);
        query.setStatusList(Arrays.asList(Guarantee.Status.PENDING_ADMIN, Guarantee.Status.PENDING_ISSUER));
        ArrayList<Guarantee> result = new ArrayList<Guarantee>();
        List<Guarantee> guarantees = this.guaranteeDao.search(query);
        for (Guarantee guarantee : guarantees) {
            TimePeriod period = guarantee.getGuaranteeType().getPendingGuaranteeExpiration();
            Calendar lowerBound = period.remove(time);
            Calendar registrationDate = DateHelper.truncate(guarantee.getRegistrationDate());
            if (!registrationDate.before(lowerBound)) continue;
            result.add(guarantee);
        }
        return result;
    }

    @Override
    public void initializeService() {
        this.processGuaranteeLoans(Calendar.getInstance());
        GuaranteeServiceLocal proxy = (GuaranteeServiceLocal)this.applicationContext.getBean(GuaranteeServiceLocal.class);
        Calendar time = Calendar.getInstance();
        List<Guarantee> guarantees = this.guaranteesToProcess(time);
        for (Guarantee guarantee : guarantees) {
            proxy.processGuarantee(guarantee, time);
        }
    }

    @Override
    public boolean isBuyer() {
        return this.permissionService.permission().member(MemberPermission.GUARANTEES_BUY_WITH_PAYMENT_OBLIGATIONS).operator(OperatorPermission.GUARANTEES_BUY_WITH_PAYMENT_OBLIGATIONS).hasPermission();
    }

    @Override
    public boolean isIssuer() {
        return this.permissionService.permission().member(MemberPermission.GUARANTEES_ISSUE_GUARANTEES).operator(OperatorPermission.GUARANTEES_ISSUE_GUARANTEES).hasPermission();
    }

    @Override
    public boolean isSeller() {
        return this.permissionService.permission().member(MemberPermission.GUARANTEES_SELL_WITH_PAYMENT_OBLIGATIONS).operator(OperatorPermission.GUARANTEES_SELL_WITH_PAYMENT_OBLIGATIONS).hasPermission();
    }

    @Override
    public Guarantee load(Long id, Relationship ... fetch) {
        Guarantee guarantee = (Guarantee)this.guaranteeDao.load(id, fetch);
        guarantee = this.fetchService.fetch(guarantee, Guarantee.Relationships.GUARANTEE_TYPE, Guarantee.Relationships.ISSUER, RelationshipHelper.nested(Guarantee.Relationships.BUYER, Element.Relationships.GROUP), RelationshipHelper.nested(Guarantee.Relationships.SELLER, Element.Relationships.GROUP));
        return guarantee;
    }

    @Override
    public Guarantee loadFromTransfer(Transfer transfer) {
        Transfer root = transfer.getRootTransfer();
        return this.guaranteeDao.loadFromTransfer(root);
    }

    @Override
    public Guarantee processGuarantee(Guarantee guarantee, Calendar time) {
        guarantee.setStatus(Guarantee.Status.WITHOUT_ACTION);
        GuaranteeLog log = guarantee.changeStatus(Guarantee.Status.WITHOUT_ACTION, null);
        this.saveLog(log);
        this.save(guarantee, true);
        return guarantee;
    }

    @Override
    public void processGuaranteeLoans(Calendar time) {
        GuaranteeQuery query = new GuaranteeQuery();
        query.fetch(Guarantee.Relationships.GUARANTEE_TYPE, Guarantee.Relationships.SELLER, Guarantee.Relationships.BUYER);
        query.setStatusList(Collections.singletonList(Guarantee.Status.ACCEPTED));
        query.setStartIn(Period.endingAt(time));
        query.setLoanFilter(GuaranteeQuery.LoanFilter.WITHOUT_LOAN);
        List<Guarantee> guarantees = this.guaranteeDao.search(query);
        for (Guarantee guarantee : guarantees) {
            this.grantLoan(time, guarantee, false);
            this.save(guarantee, true);
        }
    }

    @Override
    public Guarantee registerGuarantee(Guarantee guarantee) {
        this.validate(guarantee, false);
        guarantee = this.save(guarantee, true);
        this.grantLoan(Calendar.getInstance(), guarantee, false);
        this.memberNotificationHandler.guaranteePendingIssuerNotification(guarantee);
        this.adminNotificationHandler.notifyPendingGuarantee(guarantee);
        return guarantee;
    }

    @Override
    public int remove(Long guaranteeId) {
        return this.guaranteeDao.delete(guaranteeId);
    }

    @Override
    public Guarantee requestGuarantee(PaymentObligationPackDTO pack) {
        Long[] poIds = pack.getPaymentObligations();
        if (pack.getIssuer() == null) {
            throw new IllegalArgumentException("Invalid guarantee request: Issuer is null");
        }
        if (poIds == null || poIds.length == 0) {
            throw new IllegalArgumentException("Invalid guarantee request: payment obligations pack is empty");
        }
        PaymentObligation firstPaymentObligation = this.paymentObligationService.load(poIds[0], new Relationship[0]);
        Member buyer = firstPaymentObligation.getBuyer();
        Member seller = firstPaymentObligation.getSeller();
        Member issuer = pack.getIssuer();
        AccountOwner accOwner = LoggedUser.accountOwner();
        if (!accOwner.equals(seller)) {
            throw new PermissionDeniedException();
        }
        Certification certification = this.certificationService.getActiveCertification(firstPaymentObligation.getCurrency(), buyer, issuer);
        if (certification == null) {
            throw new ActiveCertificationNotFoundException(buyer, issuer, firstPaymentObligation.getCurrency());
        }
        BigDecimal amount = firstPaymentObligation.getAmount();
        ArrayList<PaymentObligation> paymentObligations = new ArrayList<PaymentObligation>();
        paymentObligations.add(firstPaymentObligation);
        Calendar lastExpirationdate = firstPaymentObligation.getExpirationDate();
        for (int i = 1; i < poIds.length; ++i) {
            PaymentObligation po = this.paymentObligationService.load(poIds[i], new Relationship[0]);
            if (!accOwner.equals(po.getSeller())) {
                throw new PermissionDeniedException();
            }
            amount = amount.add(po.getAmount());
            if (po.getExpirationDate().after(lastExpirationdate)) {
                lastExpirationdate = po.getExpirationDate();
            }
            paymentObligations.add(po);
        }
        BigDecimal usedCertificationAmount = this.certificationService.getUsedAmount(certification, true);
        BigDecimal remainingAmount = certification.getAmount().subtract(usedCertificationAmount);
        if (amount.compareTo(remainingAmount) > 0) {
            throw new CertificationAmountExceededException(certification, remainingAmount, amount);
        }
        if (lastExpirationdate.after(certification.getValidity().getEnd())) {
            throw new CertificationValidityExceededException(certification);
        }
        GuaranteeType guaranteeType = certification.getGuaranteeType();
        Guarantee guarantee = new Guarantee();
        guarantee.setBuyer(buyer);
        guarantee.setSeller(seller);
        guarantee.setIssuer(pack.getIssuer());
        guarantee.setCertification(certification);
        guarantee.setGuaranteeType(guaranteeType);
        guarantee.setAmount(amount);
        guarantee.setValidity(new Period(null, lastExpirationdate));
        guarantee.setPaymentObligations(paymentObligations);
        guarantee.setCreditFeeSpec((GuaranteeFeeVO)guaranteeType.getCreditFee().clone());
        guarantee.setIssueFeeSpec((GuaranteeFeeVO)guaranteeType.getIssueFee().clone());
        guarantee = this.save(guarantee, false);
        for (int i = 0; i < poIds.length; ++i) {
            PaymentObligation po = paymentObligations.get(i);
            po.setGuarantee(guarantee);
            this.paymentObligationService.changeStatus(po.getId(), PaymentObligation.Status.ACCEPTED);
        }
        this.memberNotificationHandler.guaranteePendingIssuerNotification(guarantee);
        return guarantee;
    }

    public GuaranteeLog saveLog(GuaranteeLog guaranteeLog) {
        if (guaranteeLog.isTransient()) {
            return this.guaranteeLogDao.insert(guaranteeLog);
        }
        return this.guaranteeLogDao.update(guaranteeLog);
    }

    @Override
    public List<Guarantee> search(GuaranteeQuery queryParameters) {
        return this.guaranteeDao.search(queryParameters);
    }

    public void setAdminNotificationHandler(AdminNotificationHandler adminNotificationHandler) {
        this.adminNotificationHandler = adminNotificationHandler;
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public void setCertificationServiceLocal(CertificationServiceLocal certificationService) {
        this.certificationService = certificationService;
    }

    public void setCustomFieldHelper(CustomFieldHelper customFieldHelper) {
        this.customFieldHelper = customFieldHelper;
    }

    public void setFetchServiceLocal(FetchServiceLocal fetchService) {
        this.fetchService = fetchService;
    }

    public void setGroupServiceLocal(GroupServiceLocal groupService) {
        this.groupService = groupService;
    }

    public void setGuaranteeDao(GuaranteeDAO guaranteeDao) {
        this.guaranteeDao = guaranteeDao;
    }

    public void setGuaranteeLogDao(GuaranteeLogDAO guaranteeLogDao) {
        this.guaranteeLogDao = guaranteeLogDao;
    }

    public void setGuaranteeTypeServiceLocal(GuaranteeTypeServiceLocal guaranteeTypeService) {
        this.guaranteeTypeService = guaranteeTypeService;
    }

    public void setLoanServiceLocal(LoanServiceLocal loanService) {
        this.loanService = loanService;
    }

    public void setMemberNotificationHandler(MemberNotificationHandler memberNotificationHandler) {
        this.memberNotificationHandler = memberNotificationHandler;
    }

    public void setMessageResolver(MessageResolver messageResolver) {
        this.messageResolver = messageResolver;
    }

    public void setPaymentCustomFieldServiceLocal(PaymentCustomFieldServiceLocal paymentCustomFieldService) {
        this.paymentCustomFieldService = paymentCustomFieldService;
    }

    public void setPaymentObligationServiceLocal(PaymentObligationServiceLocal paymentObligationService) {
        this.paymentObligationService = paymentObligationService;
    }

    public void setPaymentServiceLocal(PaymentServiceLocal paymentService) {
        this.paymentService = paymentService;
    }

    public void setPermissionServiceLocal(PermissionServiceLocal permissionService) {
        this.permissionService = permissionService;
    }

    public void setSettingsServiceLocal(SettingsServiceLocal settingsService) {
        this.settingsService = settingsService;
    }

    public void setTransactionHelper(TransactionHelper transactionHelper) {
        this.transactionHelper = transactionHelper;
    }

    @Override
    public void validate(Guarantee guarantee, boolean isAuthorization) {
        Validator validator = isAuthorization ? this.getValidatorForAuthorization(guarantee) : this.getValidator(guarantee);
        validator.validate(guarantee);
    }

    private BigDecimal addFeeToLoanAmount(BigDecimal loanAmount, AccountOwner feePayer, BigDecimal fee, Guarantee guarantee) {
        LocalSettings localSettings = this.settingsService.getLocalSettings();
        boolean hasFee = BigDecimal.ZERO.compareTo(localSettings.round(fee)) == -1;
        GuaranteeType.Model model = guarantee.getGuaranteeType().getModel();
        if (model != GuaranteeType.Model.WITH_BUYER_ONLY && feePayer == guarantee.getBuyer().getAccountOwner() && hasFee) {
            loanAmount = loanAmount.add(localSettings.round(fee));
        }
        return loanAmount;
    }

    private Guarantee.Status calcInitialStatus(Guarantee guarantee) {
        GuaranteeType guaranteeType = this.guaranteeTypeService.load(guarantee.getGuaranteeType().getId(), new Relationship[0]);
        if (guaranteeType.getModel() == GuaranteeType.Model.WITH_PAYMENT_OBLIGATION) {
            return Guarantee.Status.PENDING_ISSUER;
        }
        switch (guaranteeType.getAuthorizedBy()) {
            case ISSUER: 
            case BOTH: {
                return Guarantee.Status.PENDING_ISSUER;
            }
            case ADMIN: {
                return Guarantee.Status.PENDING_ADMIN;
            }
            case NONE: {
                return Guarantee.Status.ACCEPTED;
            }
        }
        throw new IllegalArgumentException("Unsupported authorizer value: " + guaranteeType.getAuthorizedBy());
    }

    private String convertFee(boolean isCreditFee, Guarantee guarantee) {
        GuaranteeFeeVO feeSpec;
        LocalSettings localSettings = this.settingsService.getLocalSettings();
        GuaranteeType guaranteeType = guarantee.getGuaranteeType();
        GuaranteeFeeVO guaranteeFeeVO = feeSpec = isCreditFee ? guarantee.getCreditFeeSpec() : guarantee.getIssueFeeSpec();
        if (feeSpec.getType() == GuaranteeType.FeeType.FIXED) {
            UnitsConverter numberConverter = localSettings.getUnitsConverter(guaranteeType.getCurrency().getPattern());
            return ((NumberConverter)numberConverter).toString(feeSpec.getFee());
        }
        NumberConverter<BigDecimal> numberConverter = localSettings.getNumberConverter();
        return numberConverter.toString(feeSpec.getFee()) + " " + this.messageResolver.message("guaranteeType.feeType." + feeSpec.getType(), new Object[0]);
    }

    private Guarantee doChangeStatus(Guarantee guarantee, Guarantee.Status newStatus, boolean automaticLoanAuthorization) {
        boolean changeAllowed = this.canChangeStatus(guarantee = this.fetchService.fetch(guarantee, Guarantee.Relationships.PAYMENT_OBLIGATIONS), newStatus);
        if (!changeAllowed) {
            throw new GuaranteeStatusChangeException(newStatus);
        }
        if (newStatus == Guarantee.Status.ACCEPTED && this.isInSomeStatus(guarantee, Guarantee.Status.PENDING_ISSUER) && guarantee.getGuaranteeType().getAuthorizedBy() == GuaranteeType.AuthorizedBy.BOTH) {
            newStatus = Guarantee.Status.PENDING_ADMIN;
        }
        GuaranteeLog log = guarantee.changeStatus(newStatus, ((User)LoggedUser.user()).getElement());
        this.saveLog(log);
        this.grantLoan(Calendar.getInstance(), guarantee, automaticLoanAuthorization);
        this.save(guarantee, true);
        if (newStatus == Guarantee.Status.CANCELLED) {
            this.updateAssociatedPaymentObligations(guarantee);
        }
        return guarantee;
    }

    private void doGrantLoan(Calendar time, final Guarantee guarantee, final boolean automaticLoanAuthorization) {
        if (guarantee.getStatus() != Guarantee.Status.ACCEPTED || guarantee.getValidity().getBegin().after(time)) {
            return;
        }
        this.transactionHelper.maybeRunInNewTransaction(new TransactionCallbackWithoutResult(){

            protected void doInTransactionWithoutResult(TransactionStatus status) {
                GuaranteeServiceImpl.this.performGrantLoan(guarantee, automaticLoanAuthorization);
            }
        });
    }

    private Collection<? extends MemberGroup> filterBuyers() {
        return this.filterMemberGroups(new Predicate(){

            public boolean evaluate(Object object) {
                return GuaranteeServiceImpl.this.isBuyerMember((Group)object);
            }
        });
    }

    private Collection<? extends MemberGroup> filterIssuers() {
        return this.filterMemberGroups(new Predicate(){

            public boolean evaluate(Object object) {
                return GuaranteeServiceImpl.this.isIssuerMember((Group)object);
            }
        });
    }

    private Collection<? extends MemberGroup> filterMemberGroups(Predicate predicate) {
        return this.filterMemberGroups(predicate, null);
    }

    private Collection<? extends MemberGroup> filterMemberGroups(Predicate predicate, Collection<? extends Group> groups) {
        Predicate predicateToApply = predicate;
        if (groups == null) {
            GroupQuery query = new GroupQuery();
            query.setStatus(Group.Status.NORMAL);
            query.setNatures(Group.Nature.MEMBER, Group.Nature.BROKER);
            groups = this.groupService.search(query);
        } else {
            if (groups.isEmpty()) {
                return groups;
            }
            Predicate memberGroupPredicate = new Predicate(){

                public boolean evaluate(Object object) {
                    Group grp = (Group)object;
                    return Group.Status.NORMAL == grp.getStatus() && (Group.Nature.MEMBER == grp.getNature() || Group.Nature.BROKER == grp.getNature());
                }
            };
            predicateToApply = predicate == null ? memberGroupPredicate : new AndPredicate(memberGroupPredicate, predicate);
        }
        CollectionUtils.filter(groups, (Predicate)predicateToApply);
        return groups;
    }

    private Collection<? extends MemberGroup> filterSellers() {
        return this.filterMemberGroups(new Predicate(){

            public boolean evaluate(Object object) {
                return GuaranteeServiceImpl.this.isSellerMember((Group)object);
            }
        });
    }

    private AccountOwner getFeePayer(boolean isCreditFee, Guarantee guarantee) {
        Member payer = null;
        GuaranteeType guaranteeType = guarantee.getGuaranteeType();
        payer = isCreditFee ? (guaranteeType.getCreditFeePayer() == GuaranteeType.FeePayer.BUYER ? guarantee.getBuyer() : guarantee.getSeller()) : (guaranteeType.getIssueFeePayer() == GuaranteeType.FeePayer.BUYER ? guarantee.getBuyer() : guarantee.getSeller());
        return payer.getAccountOwner();
    }

    private Validator getValidator(Guarantee guarantee) {
        Validator validator = new Validator("guarantee");
        validator.property("guaranteeType").required();
        final GuaranteeType guaranteeType = this.fetchService.fetch(guarantee.getGuaranteeType(), new Relationship[0]);
        if (guaranteeType != null) {
            if (guaranteeType.getModel() != GuaranteeType.Model.WITH_BUYER_ONLY) {
                validator.property("seller").required().key("guarantee.sellerUsername");
            }
            validator.chained(new DelegatingValidator(new DelegatingValidator.DelegateSource(){

                @Override
                public Validator getValidator() {
                    TransferType transferType = guaranteeType.getLoanTransferType();
                    return GuaranteeServiceImpl.this.paymentCustomFieldService.getValueValidator(transferType);
                }
            }));
        }
        validator.property("buyer").required().key("guarantee.buyerUsername");
        validator.property("issuer").required().key("guarantee.issuerUsername");
        validator.property("amount").required().positiveNonZero();
        validator.property("validity").add(new PeriodValidation(PeriodValidation.ValidationType.BOTH_REQUIRED_AND_NOT_EXPIRED)).key("guarantee.validity");
        return validator;
    }

    private Validator getValidatorForAuthorization(Guarantee guarantee) {
        final Guarantee loaded = this.load(guarantee.getId(), Guarantee.Relationships.GUARANTEE_TYPE);
        Validator validator = new Validator("guarantee");
        GuaranteeFeeValidation guaranteeFeValidation = new GuaranteeFeeValidation();
        validator.general(guaranteeFeValidation);
        validator.property("validity").add(new PeriodValidation(PeriodValidation.ValidationType.BOTH_REQUIRED_AND_NOT_EXPIRED)).key("guarantee.validity");
        validator.chained(new DelegatingValidator(new DelegatingValidator.DelegateSource(){

            @Override
            public Validator getValidator() {
                TransferType transferType = loaded.getGuaranteeType().getLoanTransferType();
                return GuaranteeServiceImpl.this.paymentCustomFieldService.getValueValidator(transferType);
            }
        }));
        return validator;
    }

    private void grantLoan(final Calendar time, final Guarantee guarantee, final boolean automaticLoanAuthorization) {
        if (automaticLoanAuthorization) {
            this.doGrantLoan(time, guarantee, automaticLoanAuthorization);
        } else {
            LoggedUser.runAsSystem(new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    GuaranteeServiceImpl.this.doGrantLoan(time, guarantee, automaticLoanAuthorization);
                    return null;
                }
            });
        }
    }

    private void initialize(Guarantee guarantee) {
        Guarantee.Status status = this.calcInitialStatus(guarantee);
        guarantee.setStatus(status);
        guarantee.setRegistrationDate(Calendar.getInstance());
        GuaranteeType guaranteeType = this.fetchService.fetch(guarantee.getGuaranteeType(), new Relationship[0]);
        if (guaranteeType.getCreditFee().isReadonly()) {
            guarantee.setCreditFeeSpec((GuaranteeFeeVO)guaranteeType.getCreditFee().clone());
        }
        if (guaranteeType.getIssueFee().isReadonly()) {
            guarantee.setIssueFeeSpec((GuaranteeFeeVO)guaranteeType.getIssueFee().clone());
        }
    }

    private boolean isBuyerMember(Group group) {
        return this.permissionService.hasPermission(group, MemberPermission.GUARANTEES_BUY_WITH_PAYMENT_OBLIGATIONS);
    }

    private boolean isInSomeStatus(Guarantee guarantee, Guarantee.Status ... status) {
        for (Guarantee.Status s : status) {
            if (guarantee.getStatus() != s) continue;
            return true;
        }
        return false;
    }

    private boolean isIssuerMember(Group group) {
        return this.permissionService.hasPermission(group, MemberPermission.GUARANTEES_ISSUE_GUARANTEES);
    }

    private boolean isSellerMember(Group group) {
        return this.permissionService.hasPermission(group, MemberPermission.GUARANTEES_SELL_WITH_PAYMENT_OBLIGATIONS);
    }

    private void performGrantLoan(Guarantee guarantee, boolean automaticLoanAuthorization) {
        HashMap<String, String> valuesMap;
        GuaranteeType guaranteeType = guarantee.getGuaranteeType();
        LocalSettings localSettings = this.settingsService.getLocalSettings();
        BigDecimal creditFee = guarantee.getCreditFee();
        BigDecimal issueFee = guarantee.getIssueFee();
        AccountOwner creditFeePayer = null;
        AccountOwner issueFeePayer = null;
        if (guaranteeType.getModel() != GuaranteeType.Model.WITH_BUYER_ONLY) {
            creditFeePayer = this.getFeePayer(true, guarantee);
            issueFeePayer = this.getFeePayer(false, guarantee);
        } else {
            issueFeePayer = creditFeePayer = guarantee.getBuyer().getAccountOwner();
        }
        BigDecimal loanAmount = this.addFeeToLoanAmount(guarantee.getAmount(), creditFeePayer, creditFee, guarantee);
        loanAmount = this.addFeeToLoanAmount(loanAmount, issueFeePayer, issueFee, guarantee);
        final GrantSinglePaymentLoanDTO loanDto = new GrantSinglePaymentLoanDTO();
        loanDto.setAutomatic(true);
        loanDto.setMember(guarantee.getBuyer());
        loanDto.setAmount(loanAmount);
        loanDto.setDescription(guaranteeType.getLoanTransferType().getDescription());
        loanDto.setTransferType(guaranteeType.getLoanTransferType());
        loanDto.setRepaymentDate(guarantee.getValidity().getEnd());
        this.customFieldHelper.cloneFieldValues(guarantee, new CustomFieldsContainer<PaymentCustomField, PaymentCustomFieldValue>(){

            @Override
            public Class<PaymentCustomField> getCustomFieldClass() {
                return loanDto.getCustomFieldClass();
            }

            @Override
            public Class<PaymentCustomFieldValue> getCustomFieldValueClass() {
                return loanDto.getCustomFieldValueClass();
            }

            @Override
            public Collection<PaymentCustomFieldValue> getCustomValues() {
                return loanDto.getCustomValues();
            }

            @Override
            public void setCustomValues(Collection<PaymentCustomFieldValue> values) {
                loanDto.setCustomValues(values);
            }
        }, true);
        Loan loan = this.loanService.grantForGuarantee(loanDto, automaticLoanAuthorization);
        TransferDTO transferDto = null;
        if (guaranteeType.getModel() != GuaranteeType.Model.WITH_BUYER_ONLY) {
            transferDto = new TransferDTO();
            transferDto.setForced(true);
            transferDto.setContext(TransactionContext.AUTOMATIC);
            transferDto.setFromOwner(guarantee.getBuyer().getAccountOwner());
            transferDto.setToOwner(guarantee.getSeller().getAccountOwner());
            transferDto.setTransferType(guaranteeType.getForwardTransferType());
            transferDto.setAmount(guarantee.getAmount());
            transferDto.setDescription(guaranteeType.getForwardTransferType().getDescription());
            transferDto.setParent(loan.getTransfer());
            this.paymentService.insertWithoutNotification(transferDto);
        }
        if (BigDecimal.ZERO.compareTo(localSettings.round(creditFee)) == -1) {
            valuesMap = new HashMap<String, String>();
            valuesMap.put("creditFee", this.convertFee(true, guarantee));
            transferDto = new TransferDTO();
            transferDto.setForced(true);
            transferDto.setFromOwner(creditFeePayer);
            transferDto.setToOwner(SystemAccountOwner.instance());
            transferDto.setTransferType(guaranteeType.getCreditFeeTransferType());
            transferDto.setAmount(creditFee);
            transferDto.setContext(TransactionContext.AUTOMATIC);
            transferDto.setDescription(MessageProcessingHelper.processVariables(guaranteeType.getCreditFeeTransferType().getDescription(), valuesMap));
            transferDto.setParent(loan.getTransfer());
            this.paymentService.insertWithoutNotification(transferDto);
        }
        if (BigDecimal.ZERO.compareTo(localSettings.round(issueFee)) == -1) {
            valuesMap = new HashMap();
            valuesMap.put("emissionFee", this.convertFee(false, guarantee));
            transferDto = new TransferDTO();
            transferDto.setForced(true);
            transferDto.setFromOwner(issueFeePayer);
            transferDto.setToOwner(guarantee.getIssuer().getAccountOwner());
            transferDto.setTransferType(guaranteeType.getIssueFeeTransferType());
            transferDto.setAmount(issueFee);
            transferDto.setContext(TransactionContext.AUTOMATIC);
            transferDto.setDescription(MessageProcessingHelper.processVariables(guaranteeType.getIssueFeeTransferType().getDescription(), valuesMap));
            transferDto.setParent(loan.getTransfer());
            this.paymentService.insertWithoutNotification(transferDto);
        }
        guarantee.setLoan(loan);
    }

    private Guarantee save(Guarantee guarantee, boolean validateCustomFields) {
        Collection<PaymentCustomFieldValue> customValues = guarantee.getCustomValues();
        if (guarantee.isTransient()) {
            this.initialize(guarantee);
            guarantee = this.guaranteeDao.insert(guarantee);
            GuaranteeLog log = guarantee.getNewLog(guarantee.getStatus(), ((User)LoggedUser.user()).getElement());
            this.saveLog(log);
        } else {
            guarantee = this.guaranteeDao.update(guarantee);
        }
        guarantee.setCustomValues(customValues);
        this.paymentCustomFieldService.saveValues(guarantee, validateCustomFields);
        return guarantee;
    }

    private void updateAssociatedPaymentObligations(Guarantee guarantee) {
        Calendar today = DateHelper.truncateNextDay(Calendar.getInstance());
        for (PaymentObligation paymentObligation : guarantee.getPaymentObligations()) {
            Calendar expirationDate = paymentObligation.getExpirationDate();
            Calendar maxPublishDate = paymentObligation.getMaxPublishDate();
            Object by = LoggedUser.element();
            PaymentObligationLog log = null;
            if (today.after(expirationDate)) {
                log = paymentObligation.changeStatus(PaymentObligation.Status.EXPIRED, (Element)by);
            } else if (today.after(maxPublishDate)) {
                log = paymentObligation.changeStatus(PaymentObligation.Status.REGISTERED, (Element)by);
                paymentObligation.setMaxPublishDate(null);
            } else {
                log = paymentObligation.changeStatus(PaymentObligation.Status.PUBLISHED, (Element)by);
            }
            paymentObligation.setGuarantee(null);
            this.paymentObligationService.saveLog(log);
            this.paymentObligationService.save(paymentObligation, false);
        }
    }

    private class GuaranteeFeeValidation
    implements GeneralValidation {
        private static final long serialVersionUID = 840449718151754491L;

        private GuaranteeFeeValidation() {
        }

        @Override
        public ValidationError validate(Object object) {
            Guarantee guarantee = (Guarantee)object;
            BigDecimal fees = null;
            fees = guarantee.getCreditFee() != null ? guarantee.getCreditFee() : new BigDecimal(0);
            BigDecimal bigDecimal = fees = guarantee.getIssueFee() != null ? fees.add(guarantee.getIssueFee()) : fees;
            if (fees.compareTo(guarantee.getAmount()) == 1) {
                return new ValidationError("guarantee.error.invalidGuarantee", new Object[0]);
            }
            return null;
        }
    }
}

